/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.servlet;

import java.io.IOException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.mortbay.log.LogFactory;

public class Forward
extends HttpServlet {
    private static Log log = LogFactory.getLog(Forward.class);
    Map _forwardMap = new HashMap();

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        Enumeration enm = config.getInitParameterNames();
        while (enm.hasMoreElements()) {
            String path = (String)enm.nextElement();
            String forward = config.getInitParameter(path);
            this._forwardMap.put(path, forward);
        }
    }

    public void doPost(HttpServletRequest sreq, HttpServletResponse sres) throws ServletException, IOException {
        this.doGet(sreq, sres);
    }

    public void doGet(HttpServletRequest sreq, HttpServletResponse sres) throws ServletException, IOException {
        String path = (String)sreq.getAttribute("javax.servlet.include.servlet_path");
        if (path == null) {
            path = sreq.getServletPath();
        }
        if (path.length() == 0 && (path = (String)sreq.getAttribute("javax.servlet.include.path_info")) == null) {
            path = sreq.getPathInfo();
        }
        String forward = (String)this._forwardMap.get(path);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Forward " + path + " to " + forward));
        }
        if (forward != null) {
            RequestDispatcher dispatch;
            ServletContext context = this.getServletContext().getContext(forward);
            String contextPath = sreq.getContextPath();
            if (contextPath.length() > 1) {
                forward = forward.substring(contextPath.length());
            }
            if ((dispatch = context.getRequestDispatcher(forward)) != null) {
                dispatch.forward((ServletRequest)sreq, (ServletResponse)sres);
                return;
            }
        }
        sres.sendError(404);
    }

    public String getServletInfo() {
        return "Forward Servlet";
    }

    public synchronized void destroy() {
        log.debug((Object)"Destroyed");
    }
}

