/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.uml;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.ocl.types.CollectionType;
import org.eclipse.ocl.types.PrimitiveType;
import org.eclipse.ocl.uml.ExpressionInOCL;
import org.eclipse.ocl.uml.UMLEnvironment;
import org.eclipse.ocl.uml.UMLFactory;
import org.eclipse.ocl.uml.internal.OCLFactoryImpl;
import org.eclipse.ocl.uml.internal.OCLStandardLibraryImpl;
import org.eclipse.ocl.uml.options.UMLParsingOptions;
import org.eclipse.ocl.uml.util.OCLUMLUtil;
import org.eclipse.ocl.util.ObjectUtil;
import org.eclipse.ocl.utilities.OCLFactory;
import org.eclipse.ocl.utilities.UMLReflection;
import org.eclipse.uml2.uml.Association;
import org.eclipse.uml2.uml.BehavioredClassifier;
import org.eclipse.uml2.uml.CallOperationAction;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.Constraint;
import org.eclipse.uml2.uml.DataType;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Enumeration;
import org.eclipse.uml2.uml.EnumerationLiteral;
import org.eclipse.uml2.uml.Feature;
import org.eclipse.uml2.uml.Interface;
import org.eclipse.uml2.uml.MultiplicityElement;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Operation;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.Parameter;
import org.eclipse.uml2.uml.ParameterDirectionKind;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Reception;
import org.eclipse.uml2.uml.SendSignalAction;
import org.eclipse.uml2.uml.Signal;
import org.eclipse.uml2.uml.State;
import org.eclipse.uml2.uml.Stereotype;
import org.eclipse.uml2.uml.Type;
import org.eclipse.uml2.uml.TypedElement;
import org.eclipse.uml2.uml.ValueSpecification;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class UMLReflectionImpl
implements UMLReflection<Package, Classifier, Operation, Property, EnumerationLiteral, Parameter, State, CallOperationAction, SendSignalAction, Constraint> {
    private final UMLEnvironment env;

    UMLReflectionImpl(UMLEnvironment env) {
        this.env = env;
    }

    final java.lang.Class<? extends Association> getAssociationClassType() {
        return (java.lang.Class)this.env.getValue(UMLParsingOptions.ASSOCIATION_CLASS_TYPE);
    }

    public String getDescription(Object namedElement) {
        if (namedElement instanceof TypedElement) {
            Type type = ((TypedElement)namedElement).getType();
            return type == null ? OCLStandardLibraryImpl.INSTANCE.getOclVoid().getName() : type.getName();
        }
        if (namedElement instanceof EnumerationLiteral) {
            return ((EnumerationLiteral)namedElement).getEnumeration().getName();
        }
        if (namedElement == null) {
            return null;
        }
        return ((EObject)namedElement).eClass().getName();
    }

    public String getName(Object namedElement) {
        return namedElement instanceof NamedElement ? ((NamedElement)namedElement).getName() : null;
    }

    public String getQualifiedName(Object namedElement) {
        return namedElement instanceof NamedElement ? ((NamedElement)namedElement).getQualifiedName() : null;
    }

    public Classifier getOCLType(Object metaElement) {
        Classifier result = null;
        if (metaElement instanceof TypedElement) {
            TypedElement typedElement = (TypedElement)metaElement;
            result = (Classifier)typedElement.getType();
            if (result == null) {
                result = OCLStandardLibraryImpl.INSTANCE.getOclVoid();
            }
            result = this.isMany(typedElement) ? this.getOCLCollectionType(result, this.isOrdered(typedElement), this.isUnique(typedElement)) : this.getOCLType(result);
        } else if (metaElement instanceof Operation) {
            Operation operation = (Operation)metaElement;
            result = (Classifier)operation.getType();
            if (result == null) {
                result = OCLStandardLibraryImpl.INSTANCE.getOclVoid();
            }
            result = this.isMany(operation) ? this.getOCLCollectionType(result, this.isOrdered(operation), this.isUnique(operation)) : this.getOCLType(result);
        } else if (metaElement instanceof Classifier) {
            result = this.getOCLType((Classifier)metaElement);
        }
        return result;
    }

    public boolean isMany(Object metaElement) {
        if (metaElement instanceof MultiplicityElement) {
            return ((MultiplicityElement)metaElement).isMultivalued();
        }
        if (metaElement instanceof Operation) {
            int upper = ((Operation)metaElement).getUpper();
            return upper > 1 || upper < 0;
        }
        return false;
    }

    protected boolean isUnique(Object metaElement) {
        if (metaElement instanceof MultiplicityElement) {
            return ((MultiplicityElement)metaElement).isUnique();
        }
        if (metaElement instanceof Operation) {
            return ((Operation)metaElement).isUnique();
        }
        return false;
    }

    protected boolean isOrdered(Object metaElement) {
        if (metaElement instanceof MultiplicityElement) {
            return ((MultiplicityElement)metaElement).isOrdered();
        }
        if (metaElement instanceof Operation) {
            return ((Operation)metaElement).isOrdered();
        }
        return false;
    }

    public Classifier asOCLType(Classifier modelType) {
        return this.getOCLType(modelType);
    }

    public Package getNestingPackage(Package pkg) {
        return pkg.getNestingPackage();
    }

    public List<Package> getNestedPackages(Package pkg) {
        return pkg.getNestedPackages();
    }

    public Package getPackage(Classifier classifier) {
        return classifier.getNearestPackage();
    }

    public List<Classifier> getClassifiers(Package pkg) {
        EList types = pkg.getOwnedTypes();
        ArrayList<Classifier> result = new ArrayList<Classifier>(types.size());
        for (Type t : types) {
            if (!(t instanceof Classifier)) continue;
            result.add((Classifier)t);
        }
        return result;
    }

    public Classifier getOwningClassifier(Object feature) {
        Classifier shadowed;
        Classifier result = null;
        if (feature instanceof Feature) {
            result = (Classifier)((Feature)feature).getOwner();
        }
        if (result instanceof Class && (shadowed = OCLStandardLibraryImpl.getRealClassifier((Class)result)) != null) {
            result = shadowed;
        }
        return result;
    }

    public List<Parameter> getParameters(Operation operation) {
        ArrayList<Parameter> result = new ArrayList<Parameter>(operation.getOwnedParameters().size());
        for (Parameter p : operation.getOwnedParameters()) {
            if (p.getDirection() == ParameterDirectionKind.RETURN_LITERAL) continue;
            result.add(p);
        }
        return result;
    }

    public Operation createOperation(String name, Classifier resultType, List<String> paramNames, List<Classifier> paramTypes) {
        Operation result = org.eclipse.uml2.uml.UMLFactory.eINSTANCE.createOperation();
        result.setName(name);
        result.setIsQuery(true);
        if (resultType != null) {
            result.setType((Type)resultType);
        }
        int i = 0;
        for (String pname : paramNames) {
            result.createOwnedParameter(pname, (Type)paramTypes.get(i++));
        }
        return result;
    }

    public List<Operation> getOperations(Classifier classifier) {
        return classifier.getAllOperations();
    }

    public Property createProperty(String name, Classifier resultType) {
        Property result = org.eclipse.uml2.uml.UMLFactory.eINSTANCE.createProperty();
        result.setName(name);
        result.setType((Type)resultType);
        return result;
    }

    public List<Property> getAttributes(Classifier classifier) {
        return classifier.getAllAttributes();
    }

    public Collection<? extends Classifier> getAllSupertypes(Classifier classifier) {
        return classifier.allParents();
    }

    public boolean isQuery(Operation operation) {
        return operation.isQuery();
    }

    public boolean isStatic(Object feature) {
        return feature instanceof Feature && ((Feature)feature).isStatic();
    }

    public boolean isAssociationClass(Classifier classifier) {
        return this.getAssociationClassType().isInstance(classifier);
    }

    public Classifier getAssociationClass(Property property) {
        return this.getAssociationClassType().isInstance(property.getAssociation()) ? property.getAssociation() : null;
    }

    public List<Property> getMemberEnds(Classifier associationClass) {
        if (this.getAssociationClassType().isInstance(associationClass)) {
            return ((Association)associationClass).getMemberEnds();
        }
        return Collections.emptyList();
    }

    public boolean isOperation(Object metaElement) {
        return metaElement instanceof Operation;
    }

    public boolean isProperty(Object metaElement) {
        return metaElement instanceof Property;
    }

    public boolean isClassifier(Object metaElement) {
        return metaElement instanceof Classifier;
    }

    public boolean isClass(Object metaElement) {
        return metaElement instanceof Class;
    }

    public boolean isDataType(Object metaElement) {
        return metaElement instanceof DataType;
    }

    public boolean isStereotype(Classifier type) {
        return type instanceof Stereotype;
    }

    public Object getStereotypeApplication(Object baseElement, Classifier stereotype) {
        Stereotype stereo;
        Element element;
        EObject result = null;
        if (baseElement instanceof Element && (element = (Element)baseElement).isStereotypeApplied(stereo = (Stereotype)stereotype)) {
            result = element.getStereotypeApplication(stereo);
        }
        return result;
    }

    public boolean isEnumeration(Classifier type) {
        return type instanceof Enumeration;
    }

    public Classifier getEnumeration(EnumerationLiteral enumerationLiteral) {
        return enumerationLiteral.getEnumeration();
    }

    public List<EnumerationLiteral> getEnumerationLiterals(Classifier enumerationType) {
        return ((Enumeration)enumerationType).getOwnedLiterals();
    }

    public EnumerationLiteral getEnumerationLiteral(Classifier enumerationType, String literalName) {
        return ((Enumeration)enumerationType).getOwnedLiteral(literalName);
    }

    public boolean isComparable(Classifier type) {
        if (type instanceof PrimitiveType || type.getOperation("<", null, null) != null) {
            return true;
        }
        EClassifier eclassifier = OCLUMLUtil.getEClassifier(type, null, this.env.getEPackageRegistry());
        return eclassifier != null && Comparable.class.isAssignableFrom(eclassifier.getInstanceClass());
    }

    public Operation getOperation(CallOperationAction callOperationAction) {
        return callOperationAction.getOperation();
    }

    public Classifier getSignal(SendSignalAction sendSignalAction) {
        return sendSignalAction.getSignal();
    }

    public String getStereotype(Constraint constraint) {
        EList keywords = constraint.getKeywords();
        return keywords.isEmpty() ? null : (String)keywords.get(0);
    }

    public void setStereotype(Constraint constraint, String stereotype) {
        for (String keyword : constraint.getKeywords()) {
            constraint.removeKeyword(keyword);
        }
        constraint.addKeyword(stereotype);
    }

    public String getConstraintName(Constraint constraint) {
        return constraint.getName();
    }

    public void setConstraintName(Constraint constraint, String name) {
        constraint.setName(name);
    }

    public org.eclipse.ocl.utilities.ExpressionInOCL<Classifier, Parameter> getSpecification(Constraint constraint) {
        if (constraint.getSpecification() instanceof org.eclipse.ocl.utilities.ExpressionInOCL) {
            return (ExpressionInOCL)constraint.getSpecification();
        }
        return null;
    }

    public void setSpecification(Constraint constraint, org.eclipse.ocl.utilities.ExpressionInOCL<Classifier, Parameter> specification) {
        constraint.setSpecification((ValueSpecification)((ExpressionInOCL)specification));
    }

    public Constraint getConstraint(org.eclipse.ocl.utilities.ExpressionInOCL<Classifier, Parameter> specification) {
        EObject container = specification.eContainer();
        if (container instanceof Constraint) {
            return (Constraint)container;
        }
        return null;
    }

    public List<EObject> getConstrainedElements(Constraint constraint) {
        return constraint.getConstrainedElements();
    }

    public List<Property> getQualifiers(Property property) {
        return property.getQualifiers();
    }

    public Classifier getCommonSuperType(Classifier type1, Classifier type2) {
        if (ObjectUtil.equal((Object)type1, (Object)type2)) {
            return type2;
        }
        if (type1.conformsTo(type2)) {
            return type2;
        }
        if (type2.conformsTo(type1)) {
            return type1;
        }
        ArrayList type1Ancestors = new ArrayList(type1.allParents());
        ArrayList type2Ancestors = new ArrayList(type2.allParents());
        type1Ancestors.retainAll(type2Ancestors);
        if (!type1Ancestors.isEmpty()) {
            return (Classifier)type1Ancestors.get(0);
        }
        return null;
    }

    public int getRelationship(Classifier type1, Classifier type2) {
        block6: {
            block5: {
                if (ObjectUtil.equal((Object)type1, (Object)type2)) {
                    return 1;
                }
                if (type2.conformsTo(type1)) {
                    return 4;
                }
                if (type1.conformsTo(type2)) {
                    return 2;
                }
                if (!(type2 instanceof BehavioredClassifier) || !(type1 instanceof Interface)) break block5;
                for (Interface i : ((BehavioredClassifier)type2).getAllImplementedInterfaces()) {
                    if (!i.conformsTo(type1)) continue;
                    return 4;
                }
                break block6;
            }
            if (!(type1 instanceof BehavioredClassifier) || !(type2 instanceof Interface)) break block6;
            for (Interface i : ((BehavioredClassifier)type1).getAllImplementedInterfaces()) {
                if (!i.conformsTo(type2)) continue;
                return 2;
            }
        }
        return 8;
    }

    private Classifier getOCLTypeFor(DataType dataType) {
        if (dataType instanceof Enumeration) {
            return dataType;
        }
        if (dataType instanceof CollectionType) {
            return dataType;
        }
        if (dataType instanceof PrimitiveType) {
            return dataType;
        }
        if (dataType instanceof org.eclipse.uml2.uml.PrimitiveType) {
            if ("Boolean".equals(dataType.getName())) {
                return OCLStandardLibraryImpl.INSTANCE.getBoolean();
            }
            if ("Real".equals(dataType.getName())) {
                return OCLStandardLibraryImpl.INSTANCE.getReal();
            }
            if ("String".equals(dataType.getName())) {
                return OCLStandardLibraryImpl.INSTANCE.getString();
            }
            if ("Integer".equals(dataType.getName())) {
                return OCLStandardLibraryImpl.INSTANCE.getInteger();
            }
            if ("UnlimitedNatural".equals(dataType.getName())) {
                return OCLStandardLibraryImpl.INSTANCE.getUnlimitedNatural();
            }
            if ("Sequence".equals(dataType.getName())) {
                return OCLStandardLibraryImpl.INSTANCE.getSequence();
            }
            if ("Set".equals(dataType.getName())) {
                return OCLStandardLibraryImpl.INSTANCE.getSet();
            }
            if ("Bag".equals(dataType.getName())) {
                return OCLStandardLibraryImpl.INSTANCE.getBag();
            }
            if ("OrderedSet".equals(dataType.getName())) {
                return OCLStandardLibraryImpl.INSTANCE.getOrderedSet();
            }
            if ("Collection".equals(dataType.getName())) {
                return OCLStandardLibraryImpl.INSTANCE.getCollection();
            }
            if ("Object".equals(dataType.getName())) {
                return OCLStandardLibraryImpl.INSTANCE.getOclAny();
            }
        }
        return dataType;
    }

    Classifier getOCLType(Classifier type) {
        Classifier resultType = type;
        if (resultType instanceof DataType) {
            resultType = this.getOCLTypeFor((DataType)resultType);
        }
        return resultType;
    }

    Classifier getOCLCollectionType(Classifier type, boolean isOrdered, boolean isUnique) {
        Classifier resultType = type;
        if (resultType instanceof DataType) {
            resultType = this.getOCLTypeFor((DataType)resultType);
        }
        OCLFactory oclFactory = OCLFactoryImpl.INSTANCE;
        resultType = isOrdered ? (isUnique ? (Classifier)oclFactory.createOrderedSetType((Object)resultType) : (Classifier)oclFactory.createSequenceType((Object)resultType)) : (isUnique ? (Classifier)oclFactory.createSetType((Object)resultType) : (Classifier)oclFactory.createBagType((Object)resultType));
        return resultType;
    }

    public List<Classifier> getSignals(Classifier owner) {
        List<Reception> receptions;
        if (owner instanceof Class && !(receptions = OCLUMLUtil.getAllReceptions((Class)owner)).isEmpty()) {
            ArrayList<Classifier> result = new ArrayList<Classifier>(receptions.size());
            for (Reception r : receptions) {
                if (r.getSignal() == null) continue;
                result.add((Classifier)r.getSignal());
            }
            return result;
        }
        return Collections.emptyList();
    }

    public CallOperationAction createCallOperationAction(Operation operation) {
        CallOperationAction result = org.eclipse.uml2.uml.UMLFactory.eINSTANCE.createCallOperationAction();
        result.setOperation(operation);
        return result;
    }

    public SendSignalAction createSendSignalAction(Classifier signal) {
        SendSignalAction result = org.eclipse.uml2.uml.UMLFactory.eINSTANCE.createSendSignalAction();
        result.setSignal((Signal)signal);
        return result;
    }

    public Constraint createConstraint() {
        return org.eclipse.uml2.uml.UMLFactory.eINSTANCE.createConstraint();
    }

    public org.eclipse.ocl.utilities.ExpressionInOCL<Classifier, Parameter> createExpressionInOCL() {
        return UMLFactory.eINSTANCE.createExpressionInOCL();
    }

    public void setName(org.eclipse.ocl.utilities.TypedElement<Classifier> element, String name) {
        element.setName(name);
    }

    public void setType(org.eclipse.ocl.utilities.TypedElement<Classifier> element, Classifier type) {
        element.setType((Object)type);
    }
}

