/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.uml.impl;

import java.util.Collection;
import java.util.List;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.DelegatingEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.ocl.Environment;
import org.eclipse.ocl.expressions.CollectionKind;
import org.eclipse.ocl.types.VoidType;
import org.eclipse.ocl.uml.CollectionType;
import org.eclipse.ocl.uml.UMLPackage;
import org.eclipse.ocl.util.OCLStandardLibraryUtil;
import org.eclipse.ocl.utilities.ASTNode;
import org.eclipse.ocl.utilities.PredefinedType;
import org.eclipse.ocl.utilities.TypedASTNode;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.Operation;
import org.eclipse.uml2.uml.internal.impl.DataTypeImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CollectionTypeImpl
extends DataTypeImpl
implements CollectionType {
    protected static final int START_POSITION_EDEFAULT = -1;
    protected int startPosition = -1;
    protected static final int END_POSITION_EDEFAULT = -1;
    protected int endPosition = -1;
    protected static final int TYPE_START_POSITION_EDEFAULT = -1;
    protected int typeStartPosition = -1;
    protected static final int TYPE_END_POSITION_EDEFAULT = -1;
    protected int typeEndPosition = -1;
    protected Classifier elementType;
    protected static final CollectionKind KIND_EDEFAULT = CollectionKind.SET_LITERAL;
    private EList<Operation> operations;
    private EList<Operation> iterators;

    protected CollectionTypeImpl() {
    }

    protected CollectionTypeImpl(Classifier elementType) {
        this();
        this.elementType = elementType;
    }

    protected EClass eStaticClass() {
        return UMLPackage.Literals.COLLECTION_TYPE;
    }

    public int getStartPosition() {
        return this.startPosition;
    }

    public void setStartPosition(int newStartPosition) {
        int oldStartPosition = this.startPosition;
        this.startPosition = newStartPosition;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 39, oldStartPosition, this.startPosition));
        }
    }

    public int getEndPosition() {
        return this.endPosition;
    }

    public void setEndPosition(int newEndPosition) {
        int oldEndPosition = this.endPosition;
        this.endPosition = newEndPosition;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 40, oldEndPosition, this.endPosition));
        }
    }

    public int getTypeStartPosition() {
        return this.typeStartPosition;
    }

    public void setTypeStartPosition(int newTypeStartPosition) {
        int oldTypeStartPosition = this.typeStartPosition;
        this.typeStartPosition = newTypeStartPosition;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 41, oldTypeStartPosition, this.typeStartPosition));
        }
    }

    public int getTypeEndPosition() {
        return this.typeEndPosition;
    }

    public void setTypeEndPosition(int newTypeEndPosition) {
        int oldTypeEndPosition = this.typeEndPosition;
        this.typeEndPosition = newTypeEndPosition;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 42, oldTypeEndPosition, this.typeEndPosition));
        }
    }

    public Classifier getElementType() {
        if (this.elementType != null && this.elementType.eIsProxy()) {
            InternalEObject oldElementType = (InternalEObject)this.elementType;
            this.elementType = (Classifier)this.eResolveProxy(oldElementType);
            if (this.elementType != oldElementType && this.eNotificationRequired()) {
                this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 9, 43, (Object)oldElementType, (Object)this.elementType));
            }
        }
        return this.elementType;
    }

    public Classifier basicGetElementType() {
        return this.elementType;
    }

    public void setElementType(Classifier newElementType) {
        Classifier oldElementType = this.elementType;
        this.elementType = newElementType;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 43, (Object)oldElementType, (Object)this.elementType));
        }
    }

    public CollectionKind getKind() {
        return CollectionKind.COLLECTION_LITERAL;
    }

    public String getName() {
        if (this.name == null) {
            StringBuffer myName = new StringBuffer();
            switch (this.getKind()) {
                case SET_LITERAL: {
                    myName.append("Set");
                    break;
                }
                case ORDERED_SET_LITERAL: {
                    myName.append("OrderedSet");
                    break;
                }
                case BAG_LITERAL: {
                    myName.append("Bag");
                    break;
                }
                case SEQUENCE_LITERAL: {
                    myName.append("Sequence");
                    break;
                }
                default: {
                    myName.append("Collection");
                }
            }
            myName.append('(');
            Classifier elementType = this.getElementType();
            String elementTypeName = elementType instanceof VoidType ? "T" : (elementType != null ? elementType.getName() : "");
            myName.append(elementTypeName);
            myName.append(')');
            this.name = myName.toString();
        }
        return this.name;
    }

    public EList<Operation> oclIterators() {
        if (this.iterators == null) {
            List myIterators;
            Environment env = Environment.Registry.INSTANCE.getEnvironmentFor((Object)this);
            switch (this.getKind()) {
                case SET_LITERAL: {
                    myIterators = OCLStandardLibraryUtil.createSetIterators((Environment)env);
                    break;
                }
                case ORDERED_SET_LITERAL: {
                    myIterators = OCLStandardLibraryUtil.createOrderedSetIterators((Environment)env);
                    break;
                }
                case BAG_LITERAL: {
                    myIterators = OCLStandardLibraryUtil.createBagIterators((Environment)env);
                    break;
                }
                case SEQUENCE_LITERAL: {
                    myIterators = OCLStandardLibraryUtil.createSequenceIterators((Environment)env);
                    break;
                }
                default: {
                    myIterators = OCLStandardLibraryUtil.createCollectionIterators((Environment)env);
                }
            }
            this.iterators = new BasicEList((Collection)myIterators);
        }
        return this.iterators;
    }

    public EList<Operation> oclOperations() {
        if (this.operations == null) {
            this.operations = new DelegatingEList<Operation>(){
                private static final long serialVersionUID = -4735888938397681302L;

                protected List<Operation> delegateList() {
                    return CollectionTypeImpl.this.getOwnedOperations();
                }
            };
            EList features = this.getOwnedOperations();
            if (features.isEmpty()) {
                List myOperations;
                Environment env = Environment.Registry.INSTANCE.getEnvironmentFor((Object)this);
                switch (this.getKind()) {
                    case SET_LITERAL: {
                        myOperations = OCLStandardLibraryUtil.createSetOperations((Environment)env);
                        break;
                    }
                    case ORDERED_SET_LITERAL: {
                        myOperations = OCLStandardLibraryUtil.createOrderedSetOperations((Environment)env);
                        break;
                    }
                    case BAG_LITERAL: {
                        myOperations = OCLStandardLibraryUtil.createBagOperations((Environment)env);
                        break;
                    }
                    case SEQUENCE_LITERAL: {
                        myOperations = OCLStandardLibraryUtil.createSequenceOperations((Environment)env);
                        break;
                    }
                    default: {
                        myOperations = OCLStandardLibraryUtil.createCollectionOperations((Environment)env);
                    }
                }
                features.addAll((Collection)myOperations);
            }
            this.operations = new BasicEList((Collection)this.getOperations());
        }
        return this.operations;
    }

    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 39: {
                return new Integer(this.getStartPosition());
            }
            case 40: {
                return new Integer(this.getEndPosition());
            }
            case 41: {
                return new Integer(this.getTypeStartPosition());
            }
            case 42: {
                return new Integer(this.getTypeEndPosition());
            }
            case 43: {
                if (resolve) {
                    return this.getElementType();
                }
                return this.basicGetElementType();
            }
            case 44: {
                return this.getKind();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 39: {
                this.setStartPosition((Integer)newValue);
                return;
            }
            case 40: {
                this.setEndPosition((Integer)newValue);
                return;
            }
            case 41: {
                this.setTypeStartPosition((Integer)newValue);
                return;
            }
            case 42: {
                this.setTypeEndPosition((Integer)newValue);
                return;
            }
            case 43: {
                this.setElementType((Classifier)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    public void eUnset(int featureID) {
        switch (featureID) {
            case 39: {
                this.setStartPosition(-1);
                return;
            }
            case 40: {
                this.setEndPosition(-1);
                return;
            }
            case 41: {
                this.setTypeStartPosition(-1);
                return;
            }
            case 42: {
                this.setTypeEndPosition(-1);
                return;
            }
            case 43: {
                this.setElementType(null);
                return;
            }
        }
        super.eUnset(featureID);
    }

    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 39: {
                return this.startPosition != -1;
            }
            case 40: {
                return this.endPosition != -1;
            }
            case 41: {
                return this.typeStartPosition != -1;
            }
            case 42: {
                return this.typeEndPosition != -1;
            }
            case 43: {
                return this.elementType != null;
            }
            case 44: {
                return this.getKind() != KIND_EDEFAULT;
            }
        }
        return super.eIsSet(featureID);
    }

    public int eBaseStructuralFeatureID(int derivedFeatureID, Class<?> baseClass) {
        if (baseClass == PredefinedType.class) {
            return -1;
        }
        if (baseClass == ASTNode.class) {
            switch (derivedFeatureID) {
                case 39: {
                    return 0;
                }
                case 40: {
                    return 1;
                }
            }
            return -1;
        }
        if (baseClass == TypedASTNode.class) {
            switch (derivedFeatureID) {
                case 41: {
                    return 2;
                }
                case 42: {
                    return 3;
                }
            }
            return -1;
        }
        if (baseClass == org.eclipse.ocl.types.CollectionType.class) {
            switch (derivedFeatureID) {
                case 43: {
                    return 4;
                }
                case 44: {
                    return 5;
                }
            }
            return -1;
        }
        return super.eBaseStructuralFeatureID(derivedFeatureID, baseClass);
    }

    public int eDerivedStructuralFeatureID(int baseFeatureID, Class<?> baseClass) {
        if (baseClass == PredefinedType.class) {
            return -1;
        }
        if (baseClass == ASTNode.class) {
            switch (baseFeatureID) {
                case 0: {
                    return 39;
                }
                case 1: {
                    return 40;
                }
            }
            return -1;
        }
        if (baseClass == TypedASTNode.class) {
            switch (baseFeatureID) {
                case 2: {
                    return 41;
                }
                case 3: {
                    return 42;
                }
            }
            return -1;
        }
        if (baseClass == org.eclipse.ocl.types.CollectionType.class) {
            switch (baseFeatureID) {
                case 4: {
                    return 43;
                }
                case 5: {
                    return 44;
                }
            }
            return -1;
        }
        return super.eDerivedStructuralFeatureID(baseFeatureID, baseClass);
    }

    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (startPosition: ");
        result.append(this.startPosition);
        result.append(", endPosition: ");
        result.append(this.endPosition);
        result.append(", typeStartPosition: ");
        result.append(this.typeStartPosition);
        result.append(", typeEndPosition: ");
        result.append(this.typeEndPosition);
        result.append(')');
        return result.toString();
    }
}

