/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.internet.monitor.ui.internal;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.GZIPInputStream;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.eclipse.wst.internet.monitor.core.internal.provisional.IMonitor;
import org.eclipse.wst.internet.monitor.core.internal.provisional.IMonitorListener;
import org.eclipse.wst.internet.monitor.core.internal.provisional.IRequestListener;
import org.eclipse.wst.internet.monitor.core.internal.provisional.MonitorCore;
import org.eclipse.wst.internet.monitor.core.internal.provisional.Request;
import org.eclipse.wst.internet.monitor.ui.internal.Trace;
import org.eclipse.wst.internet.monitor.ui.internal.view.MonitorView;
import org.osgi.framework.BundleContext;

public class MonitorUIPlugin
extends AbstractUIPlugin {
    public static final String PLUGIN_ID = "org.eclipse.wst.internet.monitor.ui";
    private static final byte[] BUFFER = new byte[4096];
    private static MonitorUIPlugin singleton;
    protected Map<String, ImageDescriptor> imageDescriptors = new HashMap<String, ImageDescriptor>();
    private static final String lineSeparator;
    private static URL ICON_BASE_URL;
    private static final String URL_CLCL = "clcl16/";
    private static final String URL_ELCL = "elcl16/";
    private static final String URL_DLCL = "dlcl16/";
    private static final String URL_OBJ = "obj16/";
    public static final String IMG_ELCL_SORT_RESPONSE_TIME = "IMG_ELCL_SORT_RESPONSE_TIME";
    public static final String IMG_ELCL_CLEAR = "IMG_ELCL_CLEAR";
    public static final String IMG_ELCL_HTTP_HEADER = "IMG_ELCL_HTTP_HEADER";
    public static final String IMG_CLCL_SORT_RESPONSE_TIME = "IMG_CLCL_SORT_RESPONSE_TIME";
    public static final String IMG_CLCL_CLEAR = "IMG_CLCL_CLEAR";
    public static final String IMG_CLCL_HTTP_HEADER = "IMG_CLCL_HTTP_HEADER";
    public static final String IMG_DLCL_SORT_RESPONSE_TIME = "IMG_DLCL_SORT_RESPONSE_TIME";
    public static final String IMG_DLCL_CLEAR = "IMG_DLCL_CLEAR";
    public static final String IMG_DLCL_HTTP_HEADER = "IMG_DLCL_HTTP_HEADER";
    public static final String IMG_REQUEST_RESPONSE = "requestResponse";
    public static final String IMG_RESEND_REQUEST_RESPONSE = "resendRequestResponse";
    public static final String IMG_HOST = "host";
    public static final String IMG_MONITOR_ON = "monitorOn";
    public static final String IMG_MONITOR_OFF = "monitorOff";
    private static final String SHOW_VIEW_ON_ACTIVITY = "show-view";
    private static final String SHOW_HEADER = "show-header";
    protected List<Request> requests = new ArrayList<Request>();
    protected IMonitorListener monitorListener = new IMonitorListener(){

        public void monitorAdded(IMonitor monitor) {
            monitor.addRequestListener(MonitorUIPlugin.this.requestListener);
        }

        public void monitorChanged(IMonitor monitor) {
        }

        public void monitorRemoved(IMonitor monitor) {
            monitor.removeRequestListener(MonitorUIPlugin.this.requestListener);
        }
    };
    protected IRequestListener requestListener = new IRequestListener(){

        public void requestAdded(IMonitor monitor, Request request) {
            MonitorUIPlugin.this.addRequest(request);
            if (MonitorView.view != null) {
                MonitorView.view.doRequestAdded(request);
            } else if (MonitorUIPlugin.getShowOnActivityPreference()) {
                MonitorView.open(request);
            }
        }

        public void requestChanged(IMonitor monitor, Request request) {
            if (MonitorView.view != null) {
                MonitorView.view.doRequestChanged(request);
            }
        }
    };

    static {
        lineSeparator = System.getProperty("line.separator");
    }

    public MonitorUIPlugin() {
        singleton = this;
    }

    protected ImageRegistry createImageRegistry() {
        ImageRegistry registry = super.createImageRegistry();
        this.registerImage(registry, IMG_REQUEST_RESPONSE, "obj16/tcp.gif");
        this.registerImage(registry, IMG_RESEND_REQUEST_RESPONSE, "elcl16/resendRequest.gif");
        this.registerImage(registry, IMG_HOST, "obj16/host.gif");
        this.registerImage(registry, IMG_MONITOR_ON, "obj16/monitorOn.gif");
        this.registerImage(registry, IMG_MONITOR_OFF, "obj16/monitorOff.gif");
        this.registerImage(registry, IMG_CLCL_CLEAR, "clcl16/clear.gif");
        this.registerImage(registry, IMG_CLCL_SORT_RESPONSE_TIME, "clcl16/sortResponseTime.gif");
        this.registerImage(registry, IMG_CLCL_HTTP_HEADER, "clcl16/httpHeader.gif");
        this.registerImage(registry, IMG_ELCL_CLEAR, "elcl16/clear.gif");
        this.registerImage(registry, IMG_ELCL_SORT_RESPONSE_TIME, "elcl16/sortResponseTime.gif");
        this.registerImage(registry, IMG_ELCL_HTTP_HEADER, "elcl16/httpHeader.gif");
        this.registerImage(registry, IMG_DLCL_CLEAR, "dlcl16/clear.gif");
        this.registerImage(registry, IMG_DLCL_SORT_RESPONSE_TIME, "dlcl16/sortResponseTime.gif");
        this.registerImage(registry, IMG_DLCL_HTTP_HEADER, "dlcl16/httpHeader.gif");
        return registry;
    }

    public static Image getImage(String key) {
        return MonitorUIPlugin.getInstance().getImageRegistry().get(key);
    }

    public static ImageDescriptor getImageDescriptor(String key) {
        try {
            MonitorUIPlugin.getInstance().getImageRegistry();
            return MonitorUIPlugin.getInstance().imageDescriptors.get(key);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static MonitorUIPlugin getInstance() {
        return singleton;
    }

    private void registerImage(ImageRegistry registry, String key, String partialURL) {
        if (ICON_BASE_URL == null) {
            String pathSuffix = "icons/";
            ICON_BASE_URL = singleton.getBundle().getEntry(pathSuffix);
        }
        try {
            ImageDescriptor id = ImageDescriptor.createFromURL((URL)new URL(ICON_BASE_URL, partialURL));
            registry.put(key, id);
            this.imageDescriptors.put(key, id);
        }
        catch (Exception e) {
            Trace.trace((byte)2, "Error registering image", e);
        }
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        this.getPreferenceStore().setDefault(SHOW_VIEW_ON_ACTIVITY, true);
        MonitorCore.addMonitorListener((IMonitorListener)this.monitorListener);
        IMonitor[] monitors = MonitorCore.getMonitors();
        if (monitors != null) {
            int size = monitors.length;
            int i = 0;
            while (i < size) {
                monitors[i].addRequestListener(this.requestListener);
                ++i;
            }
        }
    }

    public void stop(BundleContext context) throws Exception {
        super.stop(context);
        IMonitor[] monitors = MonitorCore.getMonitors();
        if (monitors != null) {
            int size = monitors.length;
            int i = 0;
            while (i < size) {
                monitors[i].removeRequestListener(this.requestListener);
                ++i;
            }
        }
        MonitorCore.removeMonitorListener((IMonitorListener)this.monitorListener);
    }

    public static boolean getDefaultShowOnActivityPreference() {
        return MonitorUIPlugin.getInstance().getPreferenceStore().getDefaultBoolean(SHOW_VIEW_ON_ACTIVITY);
    }

    public static boolean getShowOnActivityPreference() {
        return MonitorUIPlugin.getInstance().getPreferenceStore().getBoolean(SHOW_VIEW_ON_ACTIVITY);
    }

    public static void setShowOnActivityPreference(boolean b) {
        MonitorUIPlugin.getInstance().getPreferenceStore().setValue(SHOW_VIEW_ON_ACTIVITY, b);
        MonitorUIPlugin.getInstance().savePluginPreferences();
    }

    public static boolean getShowHeaderPreference() {
        return MonitorUIPlugin.getInstance().getPreferenceStore().getBoolean(SHOW_HEADER);
    }

    public static void setShowHeaderPreference(boolean b) {
        MonitorUIPlugin.getInstance().getPreferenceStore().setValue(SHOW_HEADER, b);
        MonitorUIPlugin.getInstance().savePluginPreferences();
    }

    public static synchronized byte[] unzip(byte[] b) {
        if (b == null) {
            throw new IllegalArgumentException();
        }
        try {
            GZIPInputStream gin = new GZIPInputStream(new ByteArrayInputStream(b));
            byte[] t = new byte[]{};
            while (gin.available() > 0) {
                int n = gin.read(BUFFER);
                if (n <= 0) continue;
                byte[] temp = new byte[t.length + n];
                System.arraycopy(t, 0, temp, 0, t.length);
                System.arraycopy(BUFFER, 0, temp, t.length, n);
                t = temp;
            }
            return t;
        }
        catch (Exception exception) {
            Trace.trace((byte)3, "Could not unzip byte array");
            return b;
        }
    }

    public static String parse(byte[] b) {
        if (b == null) {
            throw new IllegalArgumentException();
        }
        ByteArrayInputStream bin = new ByteArrayInputStream(b);
        BufferedReader br = new BufferedReader(new InputStreamReader(bin));
        StringBuffer sb = new StringBuffer();
        try {
            String s = br.readLine();
            while (s != null) {
                sb.append(s);
                s = br.readLine();
                if (s == null) continue;
                sb.append(lineSeparator);
            }
        }
        catch (Exception e) {
            Trace.trace((byte)2, "Error parsing input", e);
        }
        return sb.toString();
    }

    public void addRequest(Request request) {
        if (!this.requests.contains(request)) {
            this.requests.add(request);
        }
    }

    public Request[] getRequests() {
        Request[] r = new Request[this.requests.size()];
        this.requests.toArray(r);
        return r;
    }

    public void clearRequests() {
        this.requests = new ArrayList<Request>();
    }
}

