/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.validation.internal.util;

import com.ibm.icu.lang.UCharacter;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.validation.internal.EMFModelValidationDebugOptions;
import org.eclipse.emf.validation.internal.EMFModelValidationPlugin;
import org.eclipse.emf.validation.internal.EMFModelValidationStatusCodes;
import org.eclipse.emf.validation.internal.util.DisabledConstraint;
import org.eclipse.emf.validation.internal.util.Log;
import org.eclipse.emf.validation.internal.util.Trace;
import org.eclipse.emf.validation.model.IModelConstraint;
import org.eclipse.emf.validation.service.ConstraintFactory;
import org.eclipse.emf.validation.service.IConstraintDescriptor;
import org.eclipse.emf.validation.service.IConstraintParser;
import org.eclipse.emf.validation.service.IParameterizedConstraintDescriptor;
import org.eclipse.emf.validation.service.IParameterizedConstraintParser;
import org.eclipse.emf.validation.xml.ConstraintParserException;
import org.eclipse.emf.validation.xml.IXmlConstraintDescriptor;
import org.eclipse.emf.validation.xml.IXmlConstraintParser;

public class XmlConstraintFactory
extends ConstraintFactory {
    private static final String CONSTRAINT_PARSERS_EXT_P_NAME = "constraintParsers";
    private final Map<String, IConstraintParser> parserMap = new HashMap<String, IConstraintParser>();

    public XmlConstraintFactory() {
        this.initializeParsers();
    }

    protected IModelConstraint createConstraint(IXmlConstraintDescriptor desc) {
        IConfigurationElement config = desc.getConfig();
        String lang = config.getAttribute("lang");
        IConstraintParser parser = this.getParser(lang);
        IXmlConstraintParser xmlParser = null;
        if (parser instanceof IXmlConstraintParser) {
            xmlParser = (IXmlConstraintParser)parser;
        } else if (parser instanceof IParameterizedConstraintParser && desc instanceof IParameterizedConstraintDescriptor) {
            return this.createConstraint((IParameterizedConstraintDescriptor)((Object)desc));
        }
        try {
            if (xmlParser != null) {
                return xmlParser.parseConstraint(desc);
            }
            Trace.trace(EMFModelValidationDebugOptions.CONSTRAINTS_DISABLED, "Constraint is disabled: " + desc.getId() + ".  See log for details.");
            ConstraintParserException e = new ConstraintParserException(EMFModelValidationPlugin.getMessage(EMFModelValidationStatusCodes.CONSTRAINT_PARSER_MISSING_MSG, lang));
            Log.warning(73, e.getMessage());
            return new DisabledConstraint(desc, e);
        }
        catch (ConstraintParserException e) {
            return new DisabledConstraint(desc, e);
        }
    }

    protected IModelConstraint createConstraint(IConstraintDescriptor descriptor) {
        if (descriptor instanceof IXmlConstraintDescriptor) {
            return this.createConstraint((IXmlConstraintDescriptor)descriptor);
        }
        if (descriptor instanceof IParameterizedConstraintDescriptor) {
            return this.createConstraint((IParameterizedConstraintDescriptor)descriptor);
        }
        return new DisabledConstraint(descriptor, new IllegalArgumentException("unsupported constraint descriptor"));
    }

    protected IModelConstraint createConstraint(IParameterizedConstraintDescriptor descriptor) {
        String lang = descriptor.getLanguage();
        IConstraintParser parser = this.getParser(lang);
        IParameterizedConstraintParser parmParser = null;
        if (parser instanceof IParameterizedConstraintParser) {
            parmParser = (IParameterizedConstraintParser)parser;
        } else if (parser instanceof IXmlConstraintParser && descriptor instanceof IXmlConstraintDescriptor) {
            return this.createConstraint((IXmlConstraintDescriptor)((Object)descriptor));
        }
        try {
            if (parmParser != null) {
                return parmParser.parseConstraint(descriptor);
            }
            Trace.trace(EMFModelValidationDebugOptions.CONSTRAINTS_DISABLED, "Constraint is disabled: " + descriptor.getId() + ".  See log for details.");
            ConstraintParserException e = new ConstraintParserException(EMFModelValidationPlugin.getMessage(EMFModelValidationStatusCodes.CONSTRAINT_PARSER_MISSING_MSG, lang));
            Log.warning(73, e.getMessage());
            return new DisabledConstraint(descriptor, e);
        }
        catch (ConstraintParserException e) {
            return new DisabledConstraint(descriptor, e);
        }
    }

    void registerParser(IConfigurationElement config) {
        assert (config != null);
        String language = config.getAttribute("lang");
        String className = config.getAttribute("class");
        try {
            Object parser = config.createExecutableExtension("class");
            if (parser instanceof IXmlConstraintParser || parser instanceof IParameterizedConstraintParser) {
                this.parserMap.put(UCharacter.toLowerCase((String)language), (IConstraintParser)parser);
                Trace.trace(EMFModelValidationDebugOptions.PARSERS, "Initialized parser for constraint language: " + language);
            } else {
                Trace.trace(EMFModelValidationDebugOptions.PARSERS, "Parser could not be initialized for constraint language: " + language);
                Log.warningMessage(72, EMFModelValidationStatusCodes.CONSTRAINT_PARSER_TYPE_MSG, new Object[]{className, language});
            }
        }
        catch (Exception e) {
            Trace.catching(this.getClass(), "registerParser", e);
            Log.warningMessage(71, EMFModelValidationStatusCodes.CONSTRAINT_PARSER_NOT_INITED_MSG, new Object[]{className, language}, e);
        }
    }

    private IConstraintParser getParser(String language) {
        return this.parserMap.get(UCharacter.toLowerCase((String)language));
    }

    private void initializeParsers() {
        IConfigurationElement[] configs;
        IConfigurationElement[] iConfigurationElementArray = configs = Platform.getExtensionRegistry().getConfigurationElementsFor(EMFModelValidationPlugin.getPluginId(), CONSTRAINT_PARSERS_EXT_P_NAME);
        int n = configs.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement config = iConfigurationElementArray[n2];
            this.registerParser(config);
            ++n2;
        }
    }
}

