/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.sse.ui;

import java.io.IOException;
import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Method;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.ResourceBundle;
import java.util.Timer;
import java.util.TimerTask;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.command.Command;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DefaultInformationControl;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.jface.text.IInformationControl;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ISelectionValidator;
import org.eclipse.jface.text.ITextHover;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.ITextViewerExtension;
import org.eclipse.jface.text.ITextViewerExtension2;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.text.contentassist.ContentAssistant;
import org.eclipse.jface.text.contentassist.IContentAssistant;
import org.eclipse.jface.text.information.InformationPresenter;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.DefaultCharacterPairMatcher;
import org.eclipse.jface.text.source.ICharacterPairMatcher;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.IVerticalRuler;
import org.eclipse.jface.text.source.IVerticalRulerInfo;
import org.eclipse.jface.text.source.LineChangeHover;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.jface.text.source.projection.ProjectionSupport;
import org.eclipse.jface.text.source.projection.ProjectionViewer;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IPostSelectionProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorActionBarContributor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IStorageEditorInput;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.editors.text.EditorsUI;
import org.eclipse.ui.editors.text.TextEditor;
import org.eclipse.ui.help.IWorkbenchHelpSystem;
import org.eclipse.ui.part.IShowInTargetList;
import org.eclipse.ui.progress.UIJob;
import org.eclipse.ui.texteditor.ChainedPreferenceStore;
import org.eclipse.ui.texteditor.DefaultRangeIndicator;
import org.eclipse.ui.texteditor.IAbstractTextEditorHelpContextIds;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.IStatusField;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.ITextEditorActionConstants;
import org.eclipse.ui.texteditor.IUpdate;
import org.eclipse.ui.texteditor.SourceViewerDecorationSupport;
import org.eclipse.ui.texteditor.TextOperationAction;
import org.eclipse.ui.views.contentoutline.IContentOutlinePage;
import org.eclipse.ui.views.properties.IPropertySheetPage;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.IExecutionDelegate;
import org.eclipse.wst.sse.core.internal.document.IDocumentCharsetDetector;
import org.eclipse.wst.sse.core.internal.encoding.EncodingMemento;
import org.eclipse.wst.sse.core.internal.provisional.IModelStateListener;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.sse.core.internal.provisional.IndexedRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegion;
import org.eclipse.wst.sse.core.internal.text.IExecutionDelegatable;
import org.eclipse.wst.sse.core.internal.undo.IStructuredTextUndoManager;
import org.eclipse.wst.sse.core.utils.StringUtils;
import org.eclipse.wst.sse.ui.EditorExecutionContext;
import org.eclipse.wst.sse.ui.FoldingActionGroup;
import org.eclipse.wst.sse.ui.StructuredSourceViewerDecorationSupport;
import org.eclipse.wst.sse.ui.StructuredTextViewerConfiguration;
import org.eclipse.wst.sse.ui.internal.ExtendedConfigurationBuilder;
import org.eclipse.wst.sse.ui.internal.ExtendedEditorActionBuilder;
import org.eclipse.wst.sse.ui.internal.ExtendedEditorDropTargetAdapter;
import org.eclipse.wst.sse.ui.internal.IExtendedContributor;
import org.eclipse.wst.sse.ui.internal.IModelProvider;
import org.eclipse.wst.sse.ui.internal.IPopupMenuContributor;
import org.eclipse.wst.sse.ui.internal.Logger;
import org.eclipse.wst.sse.ui.internal.ReadOnlyAwareDropTargetAdapter;
import org.eclipse.wst.sse.ui.internal.SSEUIMessages;
import org.eclipse.wst.sse.ui.internal.SSEUIPlugin;
import org.eclipse.wst.sse.ui.internal.StorageModelProvider;
import org.eclipse.wst.sse.ui.internal.StructuredLineChangeHover;
import org.eclipse.wst.sse.ui.internal.StructuredTextViewer;
import org.eclipse.wst.sse.ui.internal.UnknownContentTypeDialog;
import org.eclipse.wst.sse.ui.internal.contentoutline.ConfigurableContentOutlinePage;
import org.eclipse.wst.sse.ui.internal.debug.BreakpointRulerAction;
import org.eclipse.wst.sse.ui.internal.debug.EditBreakpointAction;
import org.eclipse.wst.sse.ui.internal.debug.ManageBreakpointAction;
import org.eclipse.wst.sse.ui.internal.debug.ToggleBreakpointAction;
import org.eclipse.wst.sse.ui.internal.debug.ToggleBreakpointsTarget;
import org.eclipse.wst.sse.ui.internal.derived.HTMLTextPresenter;
import org.eclipse.wst.sse.ui.internal.editor.EditorModelUtil;
import org.eclipse.wst.sse.ui.internal.editor.StructuredModelDocumentProvider;
import org.eclipse.wst.sse.ui.internal.extension.BreakpointProviderBuilder;
import org.eclipse.wst.sse.ui.internal.hyperlink.OpenHyperlinkAction;
import org.eclipse.wst.sse.ui.internal.preferences.EditorPreferenceNames;
import org.eclipse.wst.sse.ui.internal.projection.IStructuredTextFoldingProvider;
import org.eclipse.wst.sse.ui.internal.properties.ConfigurablePropertySheetPage;
import org.eclipse.wst.sse.ui.internal.properties.ShowPropertiesAction;
import org.eclipse.wst.sse.ui.internal.provisional.extensions.ConfigurationPointCalculator;
import org.eclipse.wst.sse.ui.internal.provisional.extensions.ISourceEditingTextTools;
import org.eclipse.wst.sse.ui.internal.provisional.extensions.breakpoint.NullSourceEditingTextTools;
import org.eclipse.wst.sse.ui.internal.selection.SelectionHistory;
import org.eclipse.wst.sse.ui.internal.util.Assert;
import org.eclipse.wst.sse.ui.internal.util.EditorUtility;
import org.eclipse.wst.sse.ui.views.contentoutline.ContentOutlineConfiguration;
import org.eclipse.wst.sse.ui.views.properties.PropertySheetConfiguration;

public class StructuredTextEditor
extends TextEditor {
    protected static final char[] BRACKETS = new char[]{'{', '}', '(', ')', '[', ']'};
    private static final long BUSY_STATE_DELAY = 1000L;
    protected static final String DOT = ".";
    private static final String EDITOR_CONTEXT_MENU_ID = "org.eclipse.wst.sse.ui.StructuredTextEditor.EditorContext";
    private static final String EDITOR_CONTEXT_MENU_SUFFIX = ".source.EditorContext";
    private static final String EDITOR_KEYBINDING_SCOPE_ID = "org.eclipse.wst.sse.ui.structuredTextEditorScope";
    public static final String GROUP_NAME_ADDITIONS = "additions";
    private static final String REDO_ACTION_DESC = SSEUIMessages.Redo___0___UI_;
    private static final String REDO_ACTION_DESC_DEFAULT = SSEUIMessages.Redo_Text_Change__UI_;
    private static final String REDO_ACTION_TEXT = SSEUIMessages._Redo__0___Ctrl_Y_UI_;
    private static final String REDO_ACTION_TEXT_DEFAULT = SSEUIMessages._Redo_Text_Change__Ctrl_Y_UI_;
    private static final String RULER_CONTEXT_MENU_ID = "org.eclipse.wst.sse.ui.StructuredTextEditor.RulerContext";
    private static final String RULER_CONTEXT_MENU_SUFFIX = ".source.RulerContext";
    private static final String UNDERSCORE = "_";
    private static final String UNDO_ACTION_DESC = SSEUIMessages.Undo___0___UI_;
    private static final String UNDO_ACTION_DESC_DEFAULT = SSEUIMessages.Undo_Text_Change__UI_;
    private static final String UNDO_ACTION_TEXT = SSEUIMessages._Undo__0___Ctrl_Z_UI_;
    private static final String UNDO_ACTION_TEXT_DEFAULT = SSEUIMessages._Undo_Text_Change__Ctrl_Z_UI_;
    private int adapterRequests;
    private long adapterTime;
    private boolean fBackgroundJobEnded;
    private boolean fBusyState;
    private Timer fBusyTimer;
    Runnable fCurrentRunnable = null;
    boolean fDirtyBeforeDocumentEvent = false;
    private ExtendedEditorDropTargetAdapter fDropAdapter;
    private DropTarget fDropTarget;
    boolean fEditorDisposed = false;
    private IEditorPart fEditorPart;
    private IDocumentListener fInternalDocumentListener;
    private InternalModelStateListener fInternalModelStateListener;
    private IContentOutlinePage fOutlinePage;
    private OutlinePageListener fOutlinePageListener = null;
    private IStructuredTextFoldingProvider fProjectionModelUpdater;
    private ProjectionSupport fProjectionSupport;
    private IPropertySheetPage fPropertySheetPage;
    private String fRememberTitle;
    private Menu fRulerContextMenu;
    private MenuManager fRulerContextMenuManager;
    String[] fShowInTargetIds = new String[]{"org.eclipse.ui.views.ResourceNavigator"};
    private IAction fShowPropertiesAction = null;
    private IStructuredModel fStructuredModel;
    StructuredSelectionProvider fStructuredSelectionProvider = null;
    private Menu fTextContextMenu;
    private MenuManager fTextContextMenuManager;
    private String fViewerConfigurationTargetId;
    private SelectionHistory fSelectionHistory;
    private InformationPresenter fInformationPresenter;
    private boolean fUpdateMenuTextPending;
    private boolean shouldClose = false;
    private long startPerfTime;
    private boolean fisReleased;
    private FoldingActionGroup fFoldingGroup;
    private ILabelProvider fStatusLineLabelProvider;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;
    static /* synthetic */ Class class$4;
    static /* synthetic */ Class class$5;
    static /* synthetic */ Class class$6;
    static /* synthetic */ Class class$7;
    static /* synthetic */ Class class$8;
    static /* synthetic */ Class class$9;
    static /* synthetic */ Class class$10;

    public StructuredTextEditor() {
        this.initializeDocumentProvider(null);
    }

    private void aboutToSaveModel() {
        if (this.getInternalModel() != null) {
            this.getInternalModel().aboutToChangeModel();
        }
    }

    private void abstractTextEditorContextMenuAboutToShow(IMenuManager menu) {
        menu.add((IContributionItem)new Separator("group.undo"));
        menu.add((IContributionItem)new GroupMarker("group.save"));
        menu.add((IContributionItem)new Separator("group.copy"));
        menu.add((IContributionItem)new Separator("group.print"));
        menu.add((IContributionItem)new Separator("group.edit"));
        menu.add((IContributionItem)new Separator("group.find"));
        menu.add((IContributionItem)new Separator("group.add"));
        menu.add((IContributionItem)new Separator("group.rest"));
        menu.add((IContributionItem)new Separator(GROUP_NAME_ADDITIONS));
        if (this.isEditable()) {
            this.addAction(menu, "group.undo", ITextEditorActionConstants.UNDO);
            this.addAction(menu, "group.undo", ITextEditorActionConstants.REVERT_TO_SAVED);
            this.addAction(menu, "group.save", ITextEditorActionConstants.SAVE);
            this.addAction(menu, "group.copy", ITextEditorActionConstants.CUT);
            this.addAction(menu, "group.copy", ITextEditorActionConstants.COPY);
            this.addAction(menu, "group.copy", ITextEditorActionConstants.PASTE);
        } else {
            this.addAction(menu, "group.copy", ITextEditorActionConstants.COPY);
        }
        IAction preferencesAction = this.getAction("Preferences.ContextAction");
        menu.appendToGroup(GROUP_NAME_ADDITIONS, (IContributionItem)new Separator("settings"));
        menu.appendToGroup("settings", preferencesAction);
    }

    protected void addContextMenuActions(IMenuManager menu) {
        boolean enableFormatMenu;
        IAction formatAll = this.getAction("FormatDocument");
        IAction formatSelection = this.getAction("FormatActiveElements");
        IAction cleanupAll = this.getAction("CleanupDocument");
        boolean bl = enableFormatMenu = formatAll != null && formatAll.isEnabled() || formatSelection != null && formatSelection.isEnabled() || cleanupAll != null && cleanupAll.isEnabled();
        if (this.getSourceViewer().isEditable() && enableFormatMenu) {
            this.addAction(menu, "group.edit", "FormatDocument");
            this.addAction(menu, "group.edit", "FormatActiveElements");
            this.addAction(menu, "group.edit", "CleanupDocument");
        }
        menu.appendToGroup("group.add", this.fShowPropertiesAction);
    }

    private void addExtendedContextMenuActions(IMenuManager menu) {
        IEditorActionBarContributor c = this.getEditorSite().getActionBarContributor();
        if (c instanceof IPopupMenuContributor) {
            ((IPopupMenuContributor)c).contributeToPopupMenu(menu);
        } else {
            ExtendedEditorActionBuilder builder = new ExtendedEditorActionBuilder();
            IExtendedContributor pmc = builder.readActionExtensions(this.getConfigurationPoints());
            if (pmc != null) {
                pmc.setActiveEditor((IEditorPart)this);
                pmc.contributeToPopupMenu(menu);
            }
        }
    }

    protected void addExtendedRulerContextMenuActions(IMenuManager menu) {
    }

    void beginBackgroundOperation() {
        this.fBackgroundJobEnded = false;
        if (!this.inBusyState()) {
            this.beginBusyStateInternal();
        }
    }

    private void beginBusyStateInternal() {
        this.fBusyState = true;
        this.startBusyTimer();
        ISourceViewer viewer = this.getSourceViewer();
        if (viewer instanceof StructuredTextViewer) {
            ((StructuredTextViewer)viewer).beginBackgroundUpdate();
        }
        this.showBusy(true);
    }

    public void close(final boolean save) {
        if (this.getSite() == null) {
            this.shouldClose = true;
        } else if (this.getEditorPart() != null) {
            Display display = this.getSite().getShell().getDisplay();
            display.asyncExec(new Runnable(){

                public void run() {
                    StructuredTextEditor.this.getSite().getPage().closeEditor(StructuredTextEditor.this.getEditorPart(), save);
                }
            });
        } else {
            super.close(save);
        }
    }

    protected String[] collectContextMenuPreferencePages() {
        ArrayList<String> allIds = new ArrayList<String>(0);
        ExtendedConfigurationBuilder builder = ExtendedConfigurationBuilder.getInstance();
        String[] configurationIds = this.getConfigurationPoints();
        int i = 0;
        while (i < configurationIds.length) {
            String[] definitions = builder.getDefinitions("preferencepages", configurationIds[i]);
            int j = 0;
            while (j < definitions.length) {
                String someIds = definitions[j];
                if (someIds != null && someIds.length() > 0) {
                    String[] ids = StringUtils.unpack((String)someIds);
                    int k = 0;
                    while (k < ids.length) {
                        String id = ids[k].trim();
                        if (!allIds.contains(id)) {
                            allIds.add(id);
                        }
                        ++k;
                    }
                }
                ++j;
            }
            ++i;
        }
        String[] superPages = super.collectContextMenuPreferencePages();
        int m = 0;
        while (m < superPages.length) {
            String id = superPages[m].trim();
            if (!allIds.contains(id)) {
                allIds.add(id);
            }
            ++m;
        }
        return allIds.toArray(new String[0]);
    }

    private void computeAndSetDoubleClickAction() {
        this.setAction("RulerDoubleClick", (IAction)new ToggleBreakpointAction((ITextEditor)this, (IVerticalRulerInfo)this.getVerticalRuler(), this.getAction("RulerDoubleClick")));
    }

    protected void configureSourceViewerDecorationSupport(SourceViewerDecorationSupport support) {
        support.setCharacterPairMatcher(this.createCharacterPairMatcher());
        support.setMatchingCharacterPainterPreferenceKeys(EditorPreferenceNames.MATCHING_BRACKETS, EditorPreferenceNames.MATCHING_BRACKETS_COLOR);
        super.configureSourceViewerDecorationSupport(support);
    }

    protected void createActions() {
        super.createActions();
        ResourceBundle resourceBundle = SSEUIMessages.getResourceBundle();
        IWorkbenchHelpSystem helpSystem = SSEUIPlugin.getDefault().getWorkbench().getHelpSystem();
        Object action = new TextOperationAction(resourceBundle, "Editor_Cut_", (ITextEditor)this, 3, true);
        action.setActionDefinitionId("org.eclipse.ui.edit.cut");
        this.setAction(ITextEditorActionConstants.CUT, (IAction)action);
        helpSystem.setHelp((IAction)action, IAbstractTextEditorHelpContextIds.CUT_ACTION);
        action = new TextOperationAction(resourceBundle, "Editor_Paste_", (ITextEditor)this, 5, true);
        action.setActionDefinitionId("org.eclipse.ui.edit.paste");
        this.setAction(ITextEditorActionConstants.PASTE, (IAction)action);
        helpSystem.setHelp((IAction)action, IAbstractTextEditorHelpContextIds.PASTE_ACTION);
        action = new TextOperationAction(resourceBundle, "Editor_Delete_", (ITextEditor)this, 6, true);
        action.setActionDefinitionId("org.eclipse.ui.edit.delete");
        this.setAction(ITextEditorActionConstants.DELETE, (IAction)action);
        helpSystem.setHelp((IAction)action, IAbstractTextEditorHelpContextIds.DELETE_ACTION);
        action = new TextOperationAction(resourceBundle, "ContentAssistProposals_", (ITextEditor)this, 13, true);
        helpSystem.setHelp((IAction)action, "org.eclipse.wst.sse.ui.xmlm1010");
        action.setActionDefinitionId("org.eclipse.ui.edit.text.contentAssist.proposals");
        this.setAction("ContentAssistProposals", (IAction)action);
        this.markAsStateDependentAction("ContentAssistProposals", true);
        action = new TextOperationAction(SSEUIMessages.getResourceBundle(), "ContentAssistContextInformation_", (ITextEditor)this, 14);
        action.setActionDefinitionId("org.eclipse.ui.edit.text.contentAssist.contextInformation");
        this.setAction("ContentAssistContextInformation", (IAction)action);
        this.markAsStateDependentAction("ContentAssistContextInformation", true);
        action = new TextOperationAction(resourceBundle, "FormatDocument_", (ITextEditor)this, 23);
        helpSystem.setHelp((IAction)action, "org.eclipse.wst.sse.ui.xmlm1030");
        action.setActionDefinitionId("org.eclipse.wst.sse.ui.format.document");
        this.setAction("FormatDocument", (IAction)action);
        this.markAsStateDependentAction("FormatDocument", true);
        this.markAsSelectionDependentAction("FormatDocument", true);
        action = new TextOperationAction(resourceBundle, "FormatActiveElements_", (ITextEditor)this, 24);
        helpSystem.setHelp((IAction)action, "org.eclipse.wst.sse.ui.xmlm1040");
        action.setActionDefinitionId("org.eclipse.wst.sse.ui.format.active.elements");
        this.setAction("FormatActiveElements", (IAction)action);
        this.markAsStateDependentAction("FormatActiveElements", true);
        this.markAsSelectionDependentAction("FormatActiveElements", true);
        action = new ToggleBreakpointAction((ITextEditor)this, (IVerticalRulerInfo)this.getVerticalRuler());
        this.setAction("org.eclipse.wst.sse.ui.breakpoints.toggle", (IAction)action);
        action = new ManageBreakpointAction((ITextEditor)this, this.getVerticalRuler());
        this.setAction("org.eclipse.wst.sse.ui.breakpoints.manage", (IAction)action);
        action = new EditBreakpointAction((ITextEditor)this, this.getVerticalRuler());
        this.setAction("org.eclipse.wst.sse.ui.breakpoints.edit", (IAction)action);
        action = new OpenHyperlinkAction(resourceBundle, "OpenFileFromSource_", (ITextEditor)this, (ITextViewer)this.getSourceViewer());
        action.setActionDefinitionId("org.eclipse.wst.sse.ui.open.file.from.source");
        this.setAction("OpenFileFromSource", (IAction)action);
        this.computeAndSetDoubleClickAction();
        this.fShowPropertiesAction = new ShowPropertiesAction();
        this.fFoldingGroup = new FoldingActionGroup((ITextEditor)this, (ITextViewer)this.getSourceViewer());
    }

    protected LineChangeHover createChangeHover() {
        return new StructuredLineChangeHover();
    }

    protected ICharacterPairMatcher createCharacterPairMatcher() {
        ICharacterPairMatcher matcher = null;
        ExtendedConfigurationBuilder builder = ExtendedConfigurationBuilder.getInstance();
        String[] ids = this.getConfigurationPoints();
        int i = 0;
        while (matcher == null && i < ids.length) {
            matcher = (ICharacterPairMatcher)builder.getConfiguration("characterpairmatcher", ids[i]);
            ++i;
        }
        if (matcher == null) {
            matcher = new DefaultCharacterPairMatcher(new char[]{'(', ')', '{', '}', '[', ']', '<', '>'});
        }
        return matcher;
    }

    private IPreferenceStore createCombinedPreferenceStore() {
        IPreferenceStore sseEditorPrefs = SSEUIPlugin.getDefault().getPreferenceStore();
        IPreferenceStore baseEditorPrefs = EditorsUI.getPreferenceStore();
        return new ChainedPreferenceStore(new IPreferenceStore[]{sseEditorPrefs, baseEditorPrefs});
    }

    private ContentOutlineConfiguration createContentOutlineConfiguration() {
        ContentOutlineConfiguration cfg = null;
        ExtendedConfigurationBuilder builder = ExtendedConfigurationBuilder.getInstance();
        String[] ids = this.getConfigurationPoints();
        int i = 0;
        while (cfg == null && i < ids.length) {
            cfg = (ContentOutlineConfiguration)builder.getConfiguration("contentOutlineConfiguration", ids[i]);
            ++i;
        }
        return cfg;
    }

    protected void createModelDependentFields() {
    }

    public void createPartControl(Composite parent) {
        if (this.getSourceViewerConfiguration() == null) {
            ConfigurationAndTarget cat = this.createSourceViewerConfiguration();
            this.fViewerConfigurationTargetId = cat.getTargetId();
            StructuredTextViewerConfiguration newViewerConfiguration = cat.getConfiguration();
            this.setSourceViewerConfiguration((SourceViewerConfiguration)newViewerConfiguration);
        }
        super.createPartControl(parent);
        this.initializeSourceViewer();
        if (this.getInternalModel() != null) {
            this.updateEditorControlsForContentType(this.getInternalModel().getContentTypeIdentifier());
        } else {
            this.updateEditorControlsForContentType(null);
        }
        IInformationControlCreator informationControlCreator = new IInformationControlCreator(){

            public IInformationControl createInformationControl(Shell shell) {
                boolean cutDown = false;
                int style = cutDown ? 0 : 768;
                return new DefaultInformationControl(shell, 20, style, (DefaultInformationControl.IInformationPresenter)new HTMLTextPresenter(cutDown));
            }
        };
        this.fInformationPresenter = new InformationPresenter(informationControlCreator);
        this.fInformationPresenter.setSizeConstraints(60, 10, true, true);
        this.fInformationPresenter.install((ITextViewer)this.getSourceViewer());
    }

    protected PropertySheetConfiguration createPropertySheetConfiguration() {
        PropertySheetConfiguration cfg = null;
        ExtendedConfigurationBuilder builder = ExtendedConfigurationBuilder.getInstance();
        String[] ids = this.getConfigurationPoints();
        int i = 0;
        while (cfg == null && i < ids.length) {
            cfg = (PropertySheetConfiguration)builder.getConfiguration("propertySheetConfiguration", ids[i]);
            ++i;
        }
        return cfg;
    }

    private String[] createShowInTargetIds() {
        ArrayList<String> allIds = new ArrayList<String>(0);
        ExtendedConfigurationBuilder builder = ExtendedConfigurationBuilder.getInstance();
        String[] configurationIds = this.getConfigurationPoints();
        int i = 0;
        while (i < configurationIds.length) {
            String[] definitions = builder.getDefinitions("showintarget", configurationIds[i]);
            int j = 0;
            while (j < definitions.length) {
                String someIds = definitions[j];
                if (someIds != null && someIds.length() > 0) {
                    String[] ids = StringUtils.unpack((String)someIds);
                    int k = 0;
                    while (k < ids.length) {
                        String id = ids[k].trim();
                        if (!allIds.contains(id)) {
                            allIds.add(id);
                        }
                        ++k;
                    }
                }
                ++j;
            }
            ++i;
        }
        if (!allIds.contains("org.eclipse.ui.views.ResourceNavigator")) {
            allIds.add("org.eclipse.ui.views.ResourceNavigator");
        }
        if (!allIds.contains("org.eclipse.ui.views.ContentOutline")) {
            allIds.add("org.eclipse.ui.views.ContentOutline");
        }
        return allIds.toArray(new String[0]);
    }

    private ISourceEditingTextTools createSourceEditingTextTools() {
        ISourceEditingTextTools tools = null;
        ExtendedConfigurationBuilder builder = ExtendedConfigurationBuilder.getInstance();
        String[] ids = this.getConfigurationPoints();
        int i = 0;
        while (tools == null && i < ids.length) {
            tools = (ISourceEditingTextTools)builder.getConfiguration("sourceeditingtexttools", ids[i]);
            ++i;
        }
        if (tools == null) {
            tools = NullSourceEditingTextTools.getInstance();
            ((NullSourceEditingTextTools)tools).setTextEditor((ITextEditor)this);
        }
        AccessibleObject method = null;
        try {
            Class<?> clazz = tools.getClass();
            Class[] classArray = new Class[1];
            Class<?> clazz2 = class$0;
            if (clazz2 == null) {
                try {
                    clazz2 = class$0 = Class.forName("org.eclipse.wst.sse.ui.StructuredTextEditor");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            classArray[0] = clazz2;
            method = clazz.getMethod("setTextEditor", classArray);
        }
        catch (NoSuchMethodException noSuchMethodException) {}
        if (method == null) {
            try {
                Class<?> clazz = tools.getClass();
                Class[] classArray = new Class[1];
                Class<?> clazz3 = class$1;
                if (clazz3 == null) {
                    try {
                        clazz3 = class$1 = Class.forName("org.eclipse.ui.texteditor.ITextEditor");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                classArray[0] = clazz3;
                method = clazz.getMethod("setTextEditor", classArray);
            }
            catch (NoSuchMethodException noSuchMethodException) {}
        }
        if (method == null) {
            try {
                Class<?> clazz = tools.getClass();
                Class[] classArray = new Class[1];
                Class<?> clazz4 = class$2;
                if (clazz4 == null) {
                    try {
                        clazz4 = class$2 = Class.forName("org.eclipse.ui.IEditorPart");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                classArray[0] = clazz4;
                method = clazz.getMethod("setTextEditor", classArray);
            }
            catch (NoSuchMethodException noSuchMethodException) {}
        }
        if (method != null) {
            if (!method.isAccessible()) {
                ((Method)method).setAccessible(true);
            }
            try {
                ((Method)method).invoke(tools, new Object[]{this});
            }
            catch (Exception e) {
                Logger.logException("Problem creating ISourceEditingTextTools implementation", e);
            }
        }
        return tools;
    }

    protected ISourceViewer createSourceViewer(Composite parent, IVerticalRuler verticalRuler, int styles) {
        this.fAnnotationAccess = this.createAnnotationAccess();
        this.fOverviewRuler = this.createOverviewRuler(this.getSharedColors());
        StructuredTextViewer sourceViewer = this.createStructedTextViewer(parent, verticalRuler, styles);
        this.initSourceViewer(sourceViewer);
        return sourceViewer;
    }

    private ConfigurationAndTarget createSourceViewerConfiguration() {
        ConfigurationAndTarget cat = null;
        StructuredTextViewerConfiguration cfg = null;
        ExtendedConfigurationBuilder builder = ExtendedConfigurationBuilder.getInstance();
        String[] ids = this.getConfigurationPoints();
        int i = 0;
        while (cfg == null && i < ids.length) {
            cfg = (StructuredTextViewerConfiguration)((Object)builder.getConfiguration("sourceViewerConfiguration", ids[i]));
            cat = new ConfigurationAndTarget(ids[i], cfg);
            ++i;
        }
        if (cfg == null) {
            cfg = new StructuredTextViewerConfiguration();
            String targetid = String.valueOf(((Object)((Object)this)).getClass().getName()) + "#default";
            cat = new ConfigurationAndTarget(targetid, cfg);
        }
        return cat;
    }

    protected StructuredTextViewer createStructedTextViewer(Composite parent, IVerticalRuler verticalRuler, int styles) {
        return new StructuredTextViewer(parent, verticalRuler, this.getOverviewRuler(), this.isOverviewRulerVisible(), styles);
    }

    protected void createUndoRedoActions() {
        super.createUndoRedoActions();
        IAction action = this.getAction(ITextEditorActionConstants.UNDO);
        if (action != null) {
            action.setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_TOOL_UNDO"));
        }
        if ((action = this.getAction(ITextEditorActionConstants.REDO)) != null) {
            action.setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_TOOL_REDO"));
        }
    }

    public void dispose() {
        IDocument doc;
        Logger.trace("Source Editor", "StructuredTextEditor::dispose entry");
        if (this.fInformationPresenter != null) {
            this.fInformationPresenter.dispose();
            this.fInformationPresenter = null;
        }
        if (this.fSelectionHistory != null) {
            this.fSelectionHistory.dispose();
            this.fSelectionHistory = null;
        }
        if (this.fProjectionModelUpdater != null) {
            this.fProjectionModelUpdater.uninstall();
            this.fProjectionModelUpdater = null;
        }
        if (this.fProjectionSupport != null) {
            this.fProjectionSupport.dispose();
            this.fProjectionSupport = null;
        }
        if (this.fFoldingGroup != null) {
            this.fFoldingGroup.dispose();
            this.fFoldingGroup = null;
        }
        if (this.fTextContextMenu != null) {
            this.fTextContextMenu.dispose();
        }
        if (this.fRulerContextMenu != null) {
            this.fRulerContextMenu.dispose();
        }
        if (this.fTextContextMenuManager != null) {
            this.fTextContextMenuManager.removeMenuListener(this.getContextMenuListener());
            this.fTextContextMenuManager.removeAll();
            this.fTextContextMenuManager.dispose();
        }
        if (this.fRulerContextMenuManager != null) {
            this.fRulerContextMenuManager.removeMenuListener(this.getContextMenuListener());
            this.fRulerContextMenuManager.removeAll();
            this.fRulerContextMenuManager.dispose();
        }
        if (this.fStructuredModel != null) {
            if (this.fStructuredModel.getStructuredDocument() != null) {
                this.fStructuredModel.getStructuredDocument().removeDocumentListener(this.getInternalDocumentListener());
            }
            this.fStructuredModel.removeModelStateListener((IModelStateListener)this.getInternalModelStateListener());
        }
        if (this.getDocumentProvider() != null && (doc = this.getDocumentProvider().getDocument((Object)this.getEditorInput())) != null) {
            doc.removeDocumentListener(this.getInternalDocumentListener());
            if (doc instanceof IExecutionDelegatable) {
                ((IExecutionDelegatable)doc).setExecutionDelegate(null);
            }
        }
        if (this.fOutlinePage != null) {
            if (this.fOutlinePage instanceof ConfigurableContentOutlinePage && this.fOutlinePageListener != null) {
                ((ConfigurableContentOutlinePage)this.fOutlinePage).removeDoubleClickListener(this.fOutlinePageListener);
            }
            if (this.fOutlinePageListener != null) {
                this.fOutlinePage.removeSelectionChangedListener((ISelectionChangedListener)this.fOutlinePageListener);
            }
        }
        this.fEditorDisposed = true;
        this.disposeModelDependentFields();
        if (this.fDropTarget != null) {
            this.fDropTarget.dispose();
        }
        this.setPreferenceStore(null);
        this.fDropAdapter = null;
        this.fDropTarget = null;
        super.dispose();
        Logger.trace("Source Editor", "StructuredTextEditor::dispose exit");
    }

    protected void disposeDocumentProvider() {
        if (this.fStructuredModel != null && !this.fisReleased && !(this.getDocumentProvider() instanceof IModelProvider)) {
            this.fStructuredModel.releaseFromEdit();
            this.fisReleased = true;
        }
        super.disposeDocumentProvider();
    }

    private void disposeModelDependentFields() {
    }

    public void doRevertToSaved() {
        IDocument doc;
        super.doRevertToSaved();
        if (this.fOutlinePage != null && this.fOutlinePage instanceof IUpdate) {
            ((IUpdate)this.fOutlinePage).update();
        }
        if ((doc = this.getDocumentProvider().getDocument((Object)this.getEditorInput())) instanceof IStructuredDocument) {
            ((IStructuredDocument)doc).getUndoManager().getCommandStack().flush();
        }
        this.updateMenuText();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void doSave(IProgressMonitor progressMonitor) {
        try {
            this.aboutToSaveModel();
            this.updateEncodingMemento();
            super.doSave(progressMonitor);
        }
        catch (Throwable throwable) {
            Object var2_3 = null;
            this.savedModel();
            throw throwable;
        }
        {
            Object var2_4 = null;
            this.savedModel();
            return;
        }
    }

    protected void doSetInput(IEditorInput input) throws CoreException {
        IDocument olddoc;
        IEditorInput oldInput = this.getEditorInput();
        if (oldInput != null && (olddoc = this.getDocumentProvider().getDocument((Object)oldInput)) != null && olddoc instanceof IExecutionDelegatable) {
            ((IExecutionDelegatable)olddoc).setExecutionDelegate(null);
        }
        if (this.fStructuredModel != null && !(this.getDocumentProvider() instanceof IModelProvider)) {
            this.fStructuredModel.releaseFromEdit();
        }
        super.doSetInput(input);
        IDocument newDocument = this.getDocumentProvider().getDocument((Object)input);
        if (newDocument instanceof IExecutionDelegatable) {
            ((IExecutionDelegatable)newDocument).setExecutionDelegate((IExecutionDelegate)new EditorExecutionContext(this));
        }
        IStructuredModel model = null;
        if (this.getDocumentProvider() instanceof IModelProvider) {
            model = ((IModelProvider)this.getDocumentProvider()).getModel(this.getEditorInput());
            if (!model.isShared()) {
                EditorModelUtil.addFactoriesTo(model);
            }
        } else if (newDocument instanceof IStructuredDocument) {
            model = StructuredModelManager.getModelManager().getModelForEdit((IStructuredDocument)newDocument);
            EditorModelUtil.addFactoriesTo(model);
        } else {
            this.logUnexpectedDocumentKind(input);
        }
        if (this.fStructuredModel != null || model != null) {
            this.setModel(model);
        }
        if (this.getInternalModel() != null) {
            this.updateEditorControlsForContentType(this.getInternalModel().getContentTypeIdentifier());
        } else {
            this.updateEditorControlsForContentType(null);
        }
        if (this.fProjectionModelUpdater != null) {
            this.updateProjectionSupport();
        }
        this.setInsertMode(SMART_INSERT);
    }

    public void editorContextMenuAboutToShow(IMenuManager menu) {
        this.abstractTextEditorContextMenuAboutToShow(menu);
        this.addContextMenuActions(menu);
        this.addExtendedContextMenuActions(menu);
    }

    void endBackgroundOperation() {
        this.fBackgroundJobEnded = true;
        this.resetBusyState();
    }

    private void endBusyStateInternal() {
        if (this.fBackgroundJobEnded) {
            this.fBusyTimer.cancel();
            this.showBusy(false);
            ISourceViewer viewer = this.getSourceViewer();
            if (viewer instanceof StructuredTextViewer) {
                ((StructuredTextViewer)viewer).endBackgroundUpdate();
            }
            this.fBusyState = false;
        }
    }

    public Object getAdapter(Class required) {
        Object result = null;
        IStructuredModel internalModel = this.getInternalModel();
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.ui.texteditor.ITextEditor");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (clazz.equals(required)) {
            result = this;
        } else {
            Class<?> clazz2 = class$3;
            if (clazz2 == null) {
                try {
                    clazz2 = class$3 = Class.forName("org.eclipse.ui.progress.IWorkbenchSiteProgressService");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (clazz2.equals(required)) {
                IWorkbenchPartSite iWorkbenchPartSite = this.getEditorPart().getSite();
                Class<?> clazz3 = class$3;
                if (clazz3 == null) {
                    try {
                        clazz3 = class$3 = Class.forName("org.eclipse.ui.progress.IWorkbenchSiteProgressService");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                return iWorkbenchPartSite.getAdapter((Class)clazz3);
            }
            Class<?> clazz4 = class$4;
            if (clazz4 == null) {
                try {
                    clazz4 = class$4 = Class.forName("org.eclipse.ui.views.contentoutline.IContentOutlinePage");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (clazz4.equals(required)) {
                ContentOutlineConfiguration cfg;
                if ((this.fOutlinePage == null || this.fOutlinePage.getControl() == null || this.fOutlinePage.getControl().isDisposed()) && (cfg = this.createContentOutlineConfiguration()) != null) {
                    ConfigurableContentOutlinePage outlinePage = new ConfigurableContentOutlinePage();
                    outlinePage.setConfiguration(cfg);
                    if (internalModel != null) {
                        outlinePage.setInputContentTypeIdentifier(internalModel.getContentTypeIdentifier());
                        outlinePage.setInput(internalModel);
                    }
                    if (this.fOutlinePageListener == null) {
                        this.fOutlinePageListener = new OutlinePageListener();
                    }
                    outlinePage.addSelectionChangedListener(this.fOutlinePageListener);
                    outlinePage.addDoubleClickListener(this.fOutlinePageListener);
                    this.fOutlinePage = outlinePage;
                }
                result = this.fOutlinePage;
            } else {
                Class<?> clazz5 = class$5;
                if (clazz5 == null) {
                    try {
                        clazz5 = class$5 = Class.forName("org.eclipse.ui.views.properties.IPropertySheetPage");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (clazz5.equals(required) && this.isEditable()) {
                    PropertySheetConfiguration cfg;
                    if ((this.fPropertySheetPage == null || this.fPropertySheetPage.getControl() == null || this.fPropertySheetPage.getControl().isDisposed()) && (cfg = this.createPropertySheetConfiguration()) != null) {
                        ConfigurablePropertySheetPage propertySheetPage = new ConfigurablePropertySheetPage();
                        propertySheetPage.setConfiguration(cfg);
                        this.fPropertySheetPage = propertySheetPage;
                    }
                    result = this.fPropertySheetPage;
                } else {
                    Class<?> clazz6 = class$6;
                    if (clazz6 == null) {
                        try {
                            clazz6 = class$6 = Class.forName("org.eclipse.jface.text.IDocument");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    if (clazz6.equals(required)) {
                        result = this.getDocumentProvider().getDocument((Object)this.getEditorInput());
                    } else {
                        Class<?> clazz7 = class$7;
                        if (clazz7 == null) {
                            try {
                                clazz7 = class$7 = Class.forName("org.eclipse.wst.sse.ui.internal.provisional.extensions.ISourceEditingTextTools");
                            }
                            catch (ClassNotFoundException classNotFoundException) {
                                throw new NoClassDefFoundError(classNotFoundException.getMessage());
                            }
                        }
                        if (clazz7.equals(required)) {
                            result = this.createSourceEditingTextTools();
                        } else {
                            Class<?> clazz8 = class$8;
                            if (clazz8 == null) {
                                try {
                                    clazz8 = class$8 = Class.forName("org.eclipse.debug.ui.actions.IToggleBreakpointsTarget");
                                }
                                catch (ClassNotFoundException classNotFoundException) {
                                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                }
                            }
                            if (clazz8.equals(required)) {
                                result = ToggleBreakpointsTarget.getInstance();
                            } else {
                                Class<?> clazz9 = class$9;
                                if (clazz9 == null) {
                                    try {
                                        clazz9 = class$9 = Class.forName("org.eclipse.ui.part.IShowInTargetList");
                                    }
                                    catch (ClassNotFoundException classNotFoundException) {
                                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                    }
                                }
                                if (clazz9.equals(required)) {
                                    return new ShowInTargetListAdapter();
                                }
                                Class<?> clazz10 = class$10;
                                if (clazz10 == null) {
                                    try {
                                        clazz10 = class$10 = Class.forName("org.eclipse.wst.sse.ui.internal.selection.SelectionHistory");
                                    }
                                    catch (ClassNotFoundException classNotFoundException) {
                                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                    }
                                }
                                if (clazz10.equals(required)) {
                                    if (this.fSelectionHistory == null) {
                                        this.fSelectionHistory = new SelectionHistory((ITextEditor)this);
                                    }
                                    return this.fSelectionHistory;
                                }
                                if (result == null && internalModel != null) {
                                    result = internalModel.getAdapter(required);
                                }
                                if (result == null) {
                                    result = super.getAdapter(required);
                                }
                            }
                        }
                    }
                }
            }
        }
        return result;
    }

    private String[] getConfigurationPoints() {
        Class<?> clazz;
        String contentTypeIdentifierID = null;
        if (this.getInternalModel() != null) {
            contentTypeIdentifierID = this.getInternalModel().getContentTypeIdentifier();
        }
        if ((clazz = class$0) == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.wst.sse.ui.StructuredTextEditor");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return ConfigurationPointCalculator.getConfigurationPoints((IEditorPart)this, contentTypeIdentifierID, ".source", clazz);
    }

    protected String getCursorPosition() {
        String result = null;
        result = this.getSourceViewer() != null && this.getSourceViewer().getTextWidget() != null && !this.getSourceViewer().getTextWidget().isDisposed() ? super.getCursorPosition() : "0:0";
        return result;
    }

    Display getDisplay() {
        return PlatformUI.getWorkbench().getDisplay();
    }

    public IEditorPart getEditorPart() {
        if (this.fEditorPart == null) {
            return this;
        }
        return this.fEditorPart;
    }

    private IDocumentListener getInternalDocumentListener() {
        if (this.fInternalDocumentListener == null) {
            this.fInternalDocumentListener = new InternalDocumentListener();
        }
        return this.fInternalDocumentListener;
    }

    IStructuredModel getInternalModel() {
        return this.fStructuredModel;
    }

    private InternalModelStateListener getInternalModelStateListener() {
        if (this.fInternalModelStateListener == null) {
            this.fInternalModelStateListener = new InternalModelStateListener();
        }
        return this.fInternalModelStateListener;
    }

    public IStructuredModel getModel() {
        boolean initialModelNull;
        IDocumentProvider documentProvider = this.getDocumentProvider();
        if (documentProvider == null) {
            Logger.trace(((Object)((Object)this)).getClass().getName(), "Program Info Only: document provider was null when model requested");
        }
        boolean bl = initialModelNull = this.fStructuredModel == null;
        if (this.fStructuredModel == null && documentProvider != null) {
            if (documentProvider instanceof IModelProvider) {
                this.fStructuredModel = ((IModelProvider)documentProvider).getModel(this.getEditorInput());
                this.fisReleased = false;
            } else {
                IDocument doc = documentProvider.getDocument((Object)this.getEditorInput());
                if (doc instanceof IStructuredDocument) {
                    IStructuredModel model = StructuredModelManager.getModelManager().getExistingModelForEdit(doc);
                    if (model == null) {
                        model = StructuredModelManager.getModelManager().getModelForEdit((IStructuredDocument)doc);
                    }
                    this.fStructuredModel = model;
                    this.fisReleased = false;
                }
            }
            EditorModelUtil.addFactoriesTo(this.fStructuredModel);
            if (initialModelNull && this.fStructuredModel != null) {
                this.update();
            }
        }
        return this.fStructuredModel;
    }

    public int getOrientation() {
        return 0x2000000;
    }

    public ISelectionProvider getSelectionProvider() {
        ISelectionProvider parentProvider;
        if (this.fStructuredSelectionProvider == null && (parentProvider = super.getSelectionProvider()) != null) {
            this.fStructuredSelectionProvider = new StructuredSelectionProvider(parentProvider, this);
            this.fStructuredSelectionProvider.addPostSelectionChangedListener(new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent event) {
                    StructuredTextEditor.this.updateStatusLine(event.getSelection());
                }
            });
        }
        if (this.fStructuredSelectionProvider == null) {
            return super.getSelectionProvider();
        }
        return this.fStructuredSelectionProvider;
    }

    public StructuredTextViewer getTextViewer() {
        return (StructuredTextViewer)this.getSourceViewer();
    }

    protected void handleCursorPositionChanged() {
        super.handleCursorPositionChanged();
        this.updateStatusField("Offset");
    }

    protected void handlePreferenceStoreChanged(PropertyChangeEvent event) {
        Color color;
        RGB rgb;
        ContentAssistant assistant;
        IContentAssistant contentAssistant;
        SourceViewerConfiguration configuration;
        ISourceViewer sourceViewer;
        String property = event.getProperty();
        if (EditorPreferenceNames.EDITOR_TEXT_HOVER_MODIFIERS.equals(property)) {
            this.updateHoverBehavior();
        }
        if ("foldingEnabled".equals(property)) {
            if (this.getSourceViewer() instanceof ProjectionViewer) {
                ProjectionViewer pv;
                if (this.isFoldingEnabled() && this.fProjectionSupport == null && this.fProjectionModelUpdater == null) {
                    this.installProjectionSupport();
                }
                if ((pv = (ProjectionViewer)this.getSourceViewer()).isProjectionMode() != this.isFoldingEnabled() && pv.canDoOperation(19)) {
                    pv.doOperation(19);
                }
            }
            return;
        }
        if ("content_assist_proposals_background".equals(property) && (sourceViewer = this.getSourceViewer()) != null && (configuration = this.getSourceViewerConfiguration()) != null && (contentAssistant = configuration.getContentAssistant(sourceViewer)) instanceof ContentAssistant) {
            assistant = (ContentAssistant)contentAssistant;
            rgb = PreferenceConverter.getColor((IPreferenceStore)this.getPreferenceStore(), (String)"content_assist_proposals_background");
            color = EditorUtility.getColor(rgb);
            assistant.setProposalSelectorBackground(color);
        }
        if ("content_assist_proposals_foreground".equals(property) && (sourceViewer = this.getSourceViewer()) != null && (configuration = this.getSourceViewerConfiguration()) != null && (contentAssistant = configuration.getContentAssistant(sourceViewer)) instanceof ContentAssistant) {
            assistant = (ContentAssistant)contentAssistant;
            rgb = PreferenceConverter.getColor((IPreferenceStore)this.getPreferenceStore(), (String)"content_assist_proposals_foreground");
            color = EditorUtility.getColor(rgb);
            assistant.setProposalSelectorForeground(color);
        }
        if ("content_assist_parameters_background".equals(property) && (sourceViewer = this.getSourceViewer()) != null && (configuration = this.getSourceViewerConfiguration()) != null && (contentAssistant = configuration.getContentAssistant(sourceViewer)) instanceof ContentAssistant) {
            assistant = (ContentAssistant)contentAssistant;
            rgb = PreferenceConverter.getColor((IPreferenceStore)this.getPreferenceStore(), (String)"content_assist_parameters_background");
            color = EditorUtility.getColor(rgb);
            assistant.setContextInformationPopupBackground(color);
            assistant.setContextSelectorBackground(color);
        }
        if ("content_assist_parameters_foreground".equals(property) && (sourceViewer = this.getSourceViewer()) != null && (configuration = this.getSourceViewerConfiguration()) != null && (contentAssistant = configuration.getContentAssistant(sourceViewer)) instanceof ContentAssistant) {
            assistant = (ContentAssistant)contentAssistant;
            rgb = PreferenceConverter.getColor((IPreferenceStore)this.getPreferenceStore(), (String)"content_assist_parameters_foreground");
            color = EditorUtility.getColor(rgb);
            assistant.setContextInformationPopupForeground(color);
            assistant.setContextSelectorForeground(color);
        }
        super.handlePreferenceStoreChanged(event);
    }

    private boolean inBusyState() {
        return this.fBusyState;
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        if (this.shouldClose) {
            this.setSite((IWorkbenchPartSite)site);
            this.close(false);
        } else {
            super.init(site, input);
        }
    }

    public void initializeDocumentProvider(IDocumentProvider documentProvider) {
        if (documentProvider != null) {
            this.setDocumentProvider(documentProvider);
        }
    }

    protected void initializeDragAndDrop(ISourceViewer viewer) {
        IPreferenceStore store = this.getPreferenceStore();
        if (store != null && store.getBoolean("textDragAndDropEnabled")) {
            this.initializeDrop((ITextViewer)viewer);
        }
    }

    protected void initializeDrop(ITextViewer textViewer) {
        int operations = 3;
        this.fDropTarget = new DropTarget((Control)textViewer.getTextWidget(), operations);
        this.fDropAdapter = new ReadOnlyAwareDropTargetAdapter(true);
        this.fDropAdapter.setTargetEditor((IEditorPart)this);
        this.fDropAdapter.setTargetIDs(this.getConfigurationPoints());
        this.fDropAdapter.setTextViewer(textViewer);
        this.fDropTarget.setTransfer(this.fDropAdapter.getTransfers());
        this.fDropTarget.addDropListener((DropTargetListener)this.fDropAdapter);
    }

    protected void initializeEditor() {
        super.initializeEditor();
        this.fEncodingSupport = null;
        this.setPreferenceStore(this.createCombinedPreferenceStore());
        this.setRangeIndicator((Annotation)new DefaultRangeIndicator());
        this.setEditorContextMenuId(EDITOR_CONTEXT_MENU_ID);
        this.initializeDocumentProvider(null);
        String helpId = this.getHelpContextId();
        if (helpId == null || "org.eclipse.ui.text_editor_context".equals(helpId)) {
            helpId = "org.eclipse.wst.sse.ui.xmlm2000";
        }
        this.setHelpContextId(helpId);
        this.configureInsertMode(SMART_INSERT, true);
    }

    protected void initializeKeyBindingScopes() {
        this.setKeyBindingScopes(new String[]{EDITOR_KEYBINDING_SCOPE_ID});
    }

    private void initializeSourceViewer() {
        IAction openHyperlinkAction;
        IAction contentAssistAction = this.getAction("ContentAssistProposals");
        if (contentAssistAction instanceof IUpdate) {
            ((IUpdate)contentAssistAction).update();
        }
        if ((openHyperlinkAction = this.getAction("OpenFileFromSource")) instanceof OpenHyperlinkAction) {
            ((OpenHyperlinkAction)openHyperlinkAction).setHyperlinkDetectors(this.getSourceViewerConfiguration().getHyperlinkDetectors(this.getSourceViewer()));
        }
        if (this.isFoldingEnabled()) {
            this.installProjectionSupport();
        }
    }

    protected void initSourceViewer(StructuredTextViewer sourceViewer) {
        this.getSourceViewerDecorationSupport((ISourceViewer)sourceViewer);
    }

    protected void installTextDragAndDrop(ISourceViewer viewer) {
    }

    protected void installEncodingSupport() {
    }

    private void installProjectionSupport() {
        ProjectionViewer projectionViewer = (ProjectionViewer)this.getSourceViewer();
        this.fProjectionSupport = new ProjectionSupport(projectionViewer, this.getAnnotationAccess(), this.getSharedColors());
        this.fProjectionSupport.addSummarizableAnnotationType("org.eclipse.ui.workbench.texteditor.error");
        this.fProjectionSupport.addSummarizableAnnotationType("org.eclipse.ui.workbench.texteditor.warning");
        this.fProjectionSupport.setHoverControlCreator(new IInformationControlCreator(){

            public IInformationControl createInformationControl(Shell parent) {
                return new DefaultInformationControl(parent);
            }
        });
        this.fProjectionSupport.install();
        IStructuredTextFoldingProvider updater = null;
        ExtendedConfigurationBuilder builder = ExtendedConfigurationBuilder.getInstance();
        String[] ids = this.getConfigurationPoints();
        int i = 0;
        while (updater == null && i < ids.length) {
            updater = (IStructuredTextFoldingProvider)builder.getConfiguration("structuredtextfoldingprovider", ids[i]);
            ++i;
        }
        this.fProjectionModelUpdater = updater;
        if (this.fProjectionModelUpdater != null) {
            this.fProjectionModelUpdater.install(projectionViewer);
        }
        if (this.isFoldingEnabled()) {
            projectionViewer.doOperation(19);
        }
    }

    private void updateProjectionSupport() {
        if (this.fProjectionModelUpdater != null) {
            this.fProjectionModelUpdater.uninstall();
            this.fProjectionModelUpdater = null;
        }
        ProjectionViewer projectionViewer = (ProjectionViewer)this.getSourceViewer();
        IStructuredTextFoldingProvider updater = null;
        ExtendedConfigurationBuilder builder = ExtendedConfigurationBuilder.getInstance();
        String[] ids = this.getConfigurationPoints();
        int i = 0;
        while (updater == null && i < ids.length) {
            updater = (IStructuredTextFoldingProvider)builder.getConfiguration("structuredtextfoldingprovider", ids[i]);
            ++i;
        }
        this.fProjectionModelUpdater = updater;
        if (this.fProjectionModelUpdater != null) {
            this.fProjectionModelUpdater.install(projectionViewer);
        }
        if (this.fProjectionModelUpdater != null) {
            this.fProjectionModelUpdater.initialize();
        }
    }

    private boolean isFoldingEnabled() {
        IPreferenceStore store = this.getPreferenceStore();
        return store.getBoolean("foldingEnabled");
    }

    private void logUnexpectedDocumentKind(IEditorInput input) {
        if (SSEUIPlugin.getDefault().getPreferenceStore().getBoolean("showUnknownContentTypeMsg")) {
            UIJob job = new UIJob(SSEUIMessages.StructuredTextEditor_0){

                public IStatus runInUIThread(IProgressMonitor monitor) {
                    UnknownContentTypeDialog dialog = new UnknownContentTypeDialog(StructuredTextEditor.this.getSite().getShell(), SSEUIPlugin.getDefault().getPreferenceStore(), "showUnknownContentTypeMsg");
                    dialog.open();
                    return Status.OK_STATUS;
                }
            };
            job.schedule();
        }
        Logger.log(2, "StructuredTextEditor being used without StructuredDocument");
        String name = null;
        name = input != null ? input.getName() : "input was null";
        Logger.log(2, "         Input Name: " + name);
        String implClass = null;
        IDocument document = this.getDocumentProvider().getDocument((Object)input);
        implClass = document != null ? document.getClass().getName() : "document was null";
        Logger.log(2, "        Unexpected IDocumentProvider implementation: " + this.getDocumentProvider().getClass().getName());
        Logger.log(2, "        Unexpected IDocument implementation: " + implClass);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void performRevert() {
        ProjectionViewer projectionViewer = (ProjectionViewer)this.getSourceViewer();
        projectionViewer.setRedraw(false);
        try {
            boolean projectionMode = projectionViewer.isProjectionMode();
            if (projectionMode) {
                projectionViewer.disableProjection();
                if (this.fProjectionModelUpdater != null) {
                    this.fProjectionModelUpdater.uninstall();
                }
            }
            super.performRevert();
            if (projectionMode) {
                if (this.fProjectionModelUpdater != null) {
                    this.fProjectionModelUpdater.install(projectionViewer);
                }
                projectionViewer.enableProjection();
            }
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            projectionViewer.setRedraw(true);
            throw throwable;
        }
        {
            Object var3_5 = null;
        }
        projectionViewer.setRedraw(true);
    }

    public void rememberSelection() {
        super.rememberSelection();
    }

    private void resetBusyState() {
        if (this.fBusyTimer != null) {
            this.fBusyTimer.cancel();
        }
        this.startBusyTimer();
    }

    public void restoreSelection() {
        if (this.getSourceViewer() != null && this.getSourceViewer().getTextWidget() != null) {
            super.restoreSelection();
        }
    }

    protected void rulerContextMenuAboutToShow(IMenuManager menu) {
        super.rulerContextMenuAboutToShow(menu);
        MenuManager foldingMenu = new MenuManager(SSEUIMessages.Folding, "projection");
        menu.appendToGroup("rulers", (IContributionItem)foldingMenu);
        IAction action = this.getAction("FoldingToggle");
        foldingMenu.add(action);
        action = this.getAction("FoldingExpandAll");
        foldingMenu.add(action);
        action = this.getAction("FoldingCollapseAll");
        foldingMenu.add(action);
        IStructuredModel internalModel = this.getInternalModel();
        if (internalModel != null) {
            boolean debuggingAvailable = BreakpointProviderBuilder.getInstance().isAvailable(internalModel.getContentTypeIdentifier(), BreakpointRulerAction.getFileExtension(this.getEditorInput()));
            if (debuggingAvailable) {
                menu.appendToGroup("debug", this.getAction("org.eclipse.wst.sse.ui.breakpoints.toggle"));
                menu.appendToGroup("debug", this.getAction("org.eclipse.wst.sse.ui.breakpoints.manage"));
                menu.appendToGroup("debug", this.getAction("org.eclipse.wst.sse.ui.breakpoints.edit"));
            }
            this.addExtendedRulerContextMenuActions(menu);
        }
    }

    public void safelySanityCheckState(IEditorInput input) {
        super.safelySanityCheckState(input);
    }

    private void savedModel() {
        if (this.getInternalModel() != null) {
            this.getInternalModel().changedModel();
        }
    }

    protected void setDocumentProvider(IEditorInput input) {
        if (input instanceof IStructuredModel) {
            this.setDocumentProvider(StructuredModelDocumentProvider.getInstance());
        } else if (input instanceof IStorageEditorInput && !(input instanceof IFileEditorInput)) {
            this.setDocumentProvider(StorageModelProvider.getInstance());
        } else {
            super.setDocumentProvider(input);
        }
    }

    public void setEditorPart(IEditorPart editorPart) {
        this.fEditorPart = editorPart;
    }

    private void setModel(IStructuredModel newModel) {
        Assert.isNotNull(this.getDocumentProvider(), "document provider can not be null when setting model");
        if (this.fStructuredModel != null) {
            if (this.fStructuredModel.getStructuredDocument() != null) {
                this.fStructuredModel.getStructuredDocument().removeDocumentListener(this.getInternalDocumentListener());
            }
            this.fStructuredModel.removeModelStateListener((IModelStateListener)this.getInternalModelStateListener());
        }
        this.fStructuredModel = newModel;
        if (this.fStructuredModel != null) {
            if (this.fStructuredModel.getStructuredDocument() != null) {
                this.fStructuredModel.getStructuredDocument().addDocumentListener(this.getInternalDocumentListener());
            }
            this.fStructuredModel.addModelStateListener((IModelStateListener)this.getInternalModelStateListener());
        }
        this.update();
    }

    protected void setSourceViewerConfiguration(SourceViewerConfiguration config) {
        super.setSourceViewerConfiguration(config);
        StructuredTextViewer stv = this.getTextViewer();
        if (stv != null) {
            stv.unconfigure();
            stv.configure(config);
        }
    }

    public void showBusy(boolean busy) {
        if (busy) {
            this.fRememberTitle = this.getPartName();
            this.setPartName(SSEUIMessages.busy);
        } else {
            this.setPartName(this.fRememberTitle);
        }
    }

    private void startBusyTimer() {
        this.fBusyTimer = new Timer(true);
        this.fBusyTimer.schedule((TimerTask)new TimeOutExpired(), 1000L);
    }

    protected void uninstallTextDragAndDrop(ISourceViewer viewer) {
    }

    public void update() {
        Object cfg;
        if (this.fOutlinePage != null && this.fOutlinePage instanceof ConfigurableContentOutlinePage) {
            cfg = this.createContentOutlineConfiguration();
            ((ConfigurableContentOutlinePage)this.fOutlinePage).setConfiguration((ContentOutlineConfiguration)cfg);
            IStructuredModel internalModel = this.getInternalModel();
            ((ConfigurableContentOutlinePage)this.fOutlinePage).setInputContentTypeIdentifier(internalModel.getContentTypeIdentifier());
            ((ConfigurableContentOutlinePage)this.fOutlinePage).setInput(internalModel);
        }
        if (this.fPropertySheetPage != null && this.fPropertySheetPage instanceof ConfigurablePropertySheetPage) {
            cfg = this.createPropertySheetConfiguration();
            ((ConfigurablePropertySheetPage)this.fPropertySheetPage).setConfiguration((PropertySheetConfiguration)cfg);
        }
        this.disposeModelDependentFields();
        this.fShowInTargetIds = this.createShowInTargetIds();
        if (this.getSourceViewerConfiguration() instanceof StructuredTextViewerConfiguration && this.fStatusLineLabelProvider != null) {
            this.fStatusLineLabelProvider.dispose();
        }
        this.updateSourceViewerConfiguration();
        if (this.getSourceViewerConfiguration() instanceof StructuredTextViewerConfiguration) {
            this.fStatusLineLabelProvider = ((StructuredTextViewerConfiguration)this.getSourceViewerConfiguration()).getStatusLineLabelProvider(this.getSourceViewer());
            this.updateStatusLine(null);
        }
        if (this.fStructuredSelectionProvider != null) {
            this.fStructuredSelectionProvider.setDocument((IDocument)this.getInternalModel().getStructuredDocument());
        }
        this.createModelDependentFields();
    }

    protected void updateContentDependentActions() {
        super.updateContentDependentActions();
        if (!this.fEditorDisposed) {
            this.updateMenuText();
        }
    }

    private void updateEditorContextMenuId(String contextMenuId) {
        if (!contextMenuId.equals(this.getEditorContextMenuId()) || this.fTextContextMenu == null) {
            StyledText styledText;
            this.setEditorContextMenuId(contextMenuId);
            if (this.getSourceViewer() != null && (styledText = this.getSourceViewer().getTextWidget()) != null) {
                if (this.fTextContextMenu != null) {
                    this.fTextContextMenu.dispose();
                }
                if (this.fTextContextMenuManager != null) {
                    this.fTextContextMenuManager.removeMenuListener(this.getContextMenuListener());
                    this.fTextContextMenuManager.removeAll();
                    this.fTextContextMenuManager.dispose();
                }
                this.fTextContextMenuManager = new MenuManager(this.getEditorContextMenuId(), this.getEditorContextMenuId());
                this.fTextContextMenuManager.setRemoveAllWhenShown(true);
                this.fTextContextMenuManager.addMenuListener(this.getContextMenuListener());
                this.fTextContextMenu = this.fTextContextMenuManager.createContextMenu((Control)styledText);
                styledText.setMenu(this.fTextContextMenu);
                this.getSite().registerContextMenu(this.getEditorContextMenuId(), this.fTextContextMenuManager, this.getSelectionProvider());
                String partId = this.getSite().getId();
                if (partId != null) {
                    this.getSite().registerContextMenu(String.valueOf(partId) + EDITOR_CONTEXT_MENU_SUFFIX, this.fTextContextMenuManager, this.getSelectionProvider());
                }
                this.getSite().registerContextMenu(EDITOR_CONTEXT_MENU_ID, this.fTextContextMenuManager, this.getSelectionProvider());
            }
        }
    }

    private void updateEditorControlsForContentType(String contentType) {
        if (contentType == null) {
            this.updateEditorContextMenuId(EDITOR_CONTEXT_MENU_ID);
            this.updateRulerContextMenuId(RULER_CONTEXT_MENU_ID);
            this.updateHelpContextId("org.eclipse.ui.text_editor_context");
        } else {
            this.updateEditorContextMenuId(String.valueOf(contentType) + EDITOR_CONTEXT_MENU_SUFFIX);
            this.updateRulerContextMenuId(String.valueOf(contentType) + RULER_CONTEXT_MENU_SUFFIX);
            this.updateHelpContextId(String.valueOf(contentType) + "_source_HelpId");
        }
    }

    private void updateEncodingMemento() {
        boolean failed = false;
        IStructuredModel internalModel = this.getInternalModel();
        if (internalModel != null) {
            IStructuredDocument doc = internalModel.getStructuredDocument();
            EncodingMemento memento = doc.getEncodingMemento();
            IDocumentCharsetDetector detector = internalModel.getModelHandler().getEncodingDetector();
            if (memento != null && detector != null) {
                detector.set((IDocument)doc);
            }
            try {
                detector.getEncoding();
            }
            catch (IOException iOException) {
                failed = true;
            }
            if (!failed) {
                doc.setEncodingMemento(memento);
            }
        }
    }

    private void updateHelpContextId(String helpContextId) {
        if (!helpContextId.equals(this.getHelpContextId())) {
            StyledText styledText;
            this.setHelpContextId(helpContextId);
            if (this.getSourceViewer() != null && (styledText = this.getSourceViewer().getTextWidget()) != null) {
                IWorkbenchHelpSystem helpSystem = PlatformUI.getWorkbench().getHelpSystem();
                helpSystem.setHelp((Control)styledText, this.getHelpContextId());
            }
        }
    }

    private void updateHoverBehavior() {
        SourceViewerConfiguration configuration = this.getSourceViewerConfiguration();
        String[] types = configuration.getConfiguredContentTypes(this.getSourceViewer());
        int i = 0;
        while (i < types.length) {
            String t = types[i];
            ISourceViewer sourceViewer = this.getSourceViewer();
            if (sourceViewer instanceof ITextViewerExtension2) {
                ((ITextViewerExtension2)sourceViewer).removeTextHovers(t);
                int[] stateMasks = configuration.getConfiguredTextHoverStateMasks(this.getSourceViewer(), t);
                if (stateMasks != null) {
                    int j = 0;
                    while (j < stateMasks.length) {
                        int stateMask = stateMasks[j];
                        ITextHover textHover = configuration.getTextHover(sourceViewer, t, stateMask);
                        ((ITextViewerExtension2)sourceViewer).setTextHover(textHover, t, stateMask);
                        ++j;
                    }
                } else {
                    ITextHover textHover = configuration.getTextHover(sourceViewer, t);
                    ((ITextViewerExtension2)sourceViewer).setTextHover(textHover, t, 255);
                }
            } else {
                sourceViewer.setTextHover(configuration.getTextHover(sourceViewer, t), t);
            }
            ++i;
        }
    }

    private void updateMenuText() {
        if (this.fStructuredModel != null && !this.fStructuredModel.isModelStateChanging() && this.getTextViewer().getTextWidget() != null) {
            String previousUndoText = null;
            String previousUndoDesc = null;
            String previousRedoText = null;
            String previousRedoDesc = null;
            boolean updateActions = false;
            IAction undoAction = this.getAction(ITextEditorActionConstants.UNDO);
            IAction redoAction = this.getAction(ITextEditorActionConstants.REDO);
            if (undoAction != null) {
                previousUndoText = undoAction.getText();
                previousUndoDesc = undoAction.getDescription();
                updateActions = updateActions || previousUndoText == null || previousUndoDesc == null;
                undoAction.setText(UNDO_ACTION_TEXT_DEFAULT);
                undoAction.setDescription(UNDO_ACTION_DESC_DEFAULT);
            }
            if (redoAction != null) {
                previousRedoText = redoAction.getText();
                previousRedoDesc = redoAction.getDescription();
                updateActions = updateActions || previousRedoText == null || previousRedoDesc == null;
                redoAction.setText(REDO_ACTION_TEXT_DEFAULT);
                redoAction.setDescription(REDO_ACTION_DESC_DEFAULT);
            }
            if (this.fStructuredModel.getUndoManager() != null) {
                IStructuredTextUndoManager undoManager = this.fStructuredModel.getUndoManager();
                Command undoCommand = undoManager.getUndoCommand();
                undoAction.setEnabled(undoManager.undoable());
                if (undoCommand != null) {
                    String desc;
                    String label = undoCommand.getLabel();
                    if (label != null) {
                        String customText = MessageFormat.format(UNDO_ACTION_TEXT, label);
                        updateActions = updateActions || customText == null || previousUndoText == null || !customText.equals(previousUndoText);
                        undoAction.setText(customText);
                    }
                    if ((desc = undoCommand.getDescription()) != null) {
                        String customDesc = MessageFormat.format(UNDO_ACTION_DESC, desc);
                        updateActions = updateActions || customDesc == null || previousRedoDesc == null || !customDesc.equals(previousUndoDesc);
                        undoAction.setDescription(customDesc);
                    }
                }
                Command redoCommand = undoManager.getRedoCommand();
                redoAction.setEnabled(undoManager.redoable());
                if (redoCommand != null) {
                    String desc;
                    String label = redoCommand.getLabel();
                    if (label != null) {
                        String customText = MessageFormat.format(REDO_ACTION_TEXT, label);
                        updateActions = updateActions || customText == null || previousRedoText == null || !customText.equals(previousRedoText);
                        redoAction.setText(customText);
                    }
                    if ((desc = redoCommand.getDescription()) != null) {
                        String customDesc = MessageFormat.format(REDO_ACTION_DESC, desc);
                        updateActions = updateActions || customDesc == null || previousRedoDesc == null || !customDesc.equals(previousRedoDesc);
                        redoAction.setDescription(customDesc);
                    }
                }
            }
            if (updateActions) {
                if (this.getEditorSite().getActionBars() != null) {
                    this.getEditorSite().getActionBars().updateActionBars();
                } else if (this.getEditorPart() != null && this.getEditorPart().getEditorSite().getActionBars() != null) {
                    this.getEditorPart().getEditorSite().getActionBars().updateActionBars();
                }
            }
        }
    }

    void updateRangeIndication(ISelection selection) {
        Object[] objects;
        boolean rangeUpdated = false;
        if (selection instanceof IStructuredSelection && !((IStructuredSelection)selection).isEmpty() && (objects = ((IStructuredSelection)selection).toArray()).length > 0 && objects[0] instanceof IndexedRegion) {
            int start = ((IndexedRegion)objects[0]).getStartOffset();
            int end = ((IndexedRegion)objects[0]).getEndOffset();
            if (objects.length > 1) {
                int i = 1;
                while (i < objects.length) {
                    start = Math.min(start, ((IndexedRegion)objects[i]).getStartOffset());
                    end = Math.max(end, ((IndexedRegion)objects[i]).getEndOffset());
                    ++i;
                }
            }
            this.getSourceViewer().setRangeIndication(start, end - start, false);
            rangeUpdated = true;
        }
        if (!rangeUpdated) {
            if (selection instanceof ITextSelection) {
                this.getSourceViewer().setRangeIndication(((ITextSelection)selection).getOffset(), ((ITextSelection)selection).getLength(), false);
            } else {
                this.getSourceViewer().removeRangeIndication();
            }
        }
    }

    private void updateRulerContextMenuId(String rulerMenuId) {
        if (!rulerMenuId.equals(this.getRulerContextMenuId()) || this.fRulerContextMenu == null) {
            this.setRulerContextMenuId(rulerMenuId);
            if (this.getVerticalRuler() != null) {
                if (this.fRulerContextMenu != null) {
                    this.fRulerContextMenu.dispose();
                }
                if (this.fRulerContextMenuManager != null) {
                    this.fRulerContextMenuManager.removeMenuListener(this.getContextMenuListener());
                    this.fRulerContextMenuManager.removeAll();
                    this.fRulerContextMenuManager.dispose();
                }
                this.fRulerContextMenuManager = new MenuManager(this.getRulerContextMenuId(), this.getRulerContextMenuId());
                this.fRulerContextMenuManager.setRemoveAllWhenShown(true);
                this.fRulerContextMenuManager.addMenuListener(this.getContextMenuListener());
                Control rulerControl = this.getVerticalRuler().getControl();
                this.fRulerContextMenu = this.fRulerContextMenuManager.createContextMenu(rulerControl);
                rulerControl.setMenu(this.fRulerContextMenu);
                this.getSite().registerContextMenu(this.getRulerContextMenuId(), this.fRulerContextMenuManager, this.getSelectionProvider());
                String partId = this.getSite().getId();
                if (partId != null) {
                    this.getSite().registerContextMenu(String.valueOf(partId) + RULER_CONTEXT_MENU_SUFFIX, this.fRulerContextMenuManager, this.getSelectionProvider());
                }
                this.getSite().registerContextMenu(RULER_CONTEXT_MENU_ID, this.fRulerContextMenuManager, this.getSelectionProvider());
            }
        }
    }

    private void updateSourceViewerConfiguration() {
        ConfigurationAndTarget cat;
        Object configuration = this.getSourceViewerConfiguration();
        if (configuration == null) {
            return;
        }
        boolean configured = false;
        if (!(configuration instanceof StructuredTextViewerConfiguration)) {
            cat = this.createSourceViewerConfiguration();
            this.fViewerConfigurationTargetId = cat.getTargetId();
            configuration = cat.getConfiguration();
            this.setSourceViewerConfiguration((SourceViewerConfiguration)configuration);
            configured = true;
        } else {
            cat = this.createSourceViewerConfiguration();
            StructuredTextViewerConfiguration newViewerConfiguration = cat.getConfiguration();
            if (!cat.getTargetId().equals(this.fViewerConfigurationTargetId)) {
                this.fViewerConfigurationTargetId = cat.getTargetId();
                configuration = newViewerConfiguration;
                this.setSourceViewerConfiguration((SourceViewerConfiguration)configuration);
                configured = true;
            }
        }
        if (this.getSourceViewer() != null) {
            IAction openHyperlinkAction;
            IAction contentAssistAction;
            if (!configured) {
                this.getSourceViewer().configure(configuration);
            }
            if ((contentAssistAction = this.getAction("ContentAssistProposals")) instanceof IUpdate) {
                ((IUpdate)contentAssistAction).update();
            }
            if ((openHyperlinkAction = this.getAction("OpenFileFromSource")) instanceof OpenHyperlinkAction) {
                ((OpenHyperlinkAction)openHyperlinkAction).setHyperlinkDetectors(this.getSourceViewerConfiguration().getHyperlinkDetectors(this.getSourceViewer()));
            }
        }
    }

    protected void updateStatusField(String category) {
        IStatusField field;
        super.updateStatusField(category);
        if (category == null) {
            return;
        }
        if ("Offset".equals(category) && (field = this.getStatusField(category)) != null) {
            Point selection = this.getTextViewer().getTextWidget().getSelection();
            int offset1 = StructuredTextEditor.widgetOffset2ModelOffset((ISourceViewer)this.getSourceViewer(), (int)selection.x);
            int offset2 = StructuredTextEditor.widgetOffset2ModelOffset((ISourceViewer)this.getSourceViewer(), (int)selection.y);
            String text = null;
            text = offset1 != offset2 ? "[" + offset1 + "-" + offset2 + "]" : "[ " + offset1 + " ]";
            field.setText(text == null ? this.fErrorLabel : text);
        }
    }

    void updateStatusLine(ISelection selection) {
        IStatusLineManager statusLineManager = this.getEditorSite().getActionBars().getStatusLineManager();
        if (this.fStatusLineLabelProvider != null && statusLineManager != null) {
            Object firstElement;
            String text = null;
            Image image = null;
            if (selection instanceof IStructuredSelection && !selection.isEmpty() && (firstElement = ((IStructuredSelection)selection).getFirstElement()) != null) {
                text = this.fStatusLineLabelProvider.getText(firstElement);
                image = this.fStatusLineLabelProvider.getImage(firstElement);
            }
            if (image == null) {
                statusLineManager.setMessage(text);
            } else {
                statusLineManager.setMessage(image, text);
            }
        }
    }

    protected SourceViewerDecorationSupport getSourceViewerDecorationSupport(ISourceViewer viewer) {
        if (this.fSourceViewerDecorationSupport == null) {
            this.fSourceViewerDecorationSupport = new StructuredSourceViewerDecorationSupport(viewer, this.getOverviewRuler(), this.getAnnotationAccess(), this.getSharedColors());
            this.configureSourceViewerDecorationSupport(this.fSourceViewerDecorationSupport);
        }
        return this.fSourceViewerDecorationSupport;
    }

    static /* synthetic */ void access$2(StructuredTextEditor structuredTextEditor) {
        structuredTextEditor.updateMenuText();
    }

    static /* synthetic */ void access$3(StructuredTextEditor structuredTextEditor, boolean bl) {
        structuredTextEditor.fUpdateMenuTextPending = bl;
    }

    static /* synthetic */ void access$5(StructuredTextEditor structuredTextEditor) {
        structuredTextEditor.endBusyStateInternal();
    }

    private class ConfigurationAndTarget {
        private String fTargetId;
        private StructuredTextViewerConfiguration fConfiguration;

        public ConfigurationAndTarget(String targetId, StructuredTextViewerConfiguration config) {
            this.fTargetId = targetId;
            this.fConfiguration = config;
        }

        public String getTargetId() {
            return this.fTargetId;
        }

        public StructuredTextViewerConfiguration getConfiguration() {
            return this.fConfiguration;
        }
    }

    class InternalDocumentListener
    implements IDocumentListener {
        InternalDocumentListener() {
        }

        public void documentAboutToBeChanged(DocumentEvent event) {
            StructuredTextEditor.this.fDirtyBeforeDocumentEvent = StructuredTextEditor.this.isDirty();
        }

        public void documentChanged(DocumentEvent event) {
            if (StructuredTextEditor.this.isEditorInputReadOnly()) {
                int offset = event.getOffset() + event.getLength();
                IStructuredModel internalModel = StructuredTextEditor.this.getInternalModel();
                StructuredTextEditor.this.fCurrentRunnable = new Runnable(this, internalModel, offset){
                    final /* synthetic */ InternalDocumentListener this$1;
                    private final /* synthetic */ IStructuredModel val$internalModel;
                    private final /* synthetic */ int val$offset;
                    {
                        this.this$1 = internalDocumentListener;
                        this.val$internalModel = iStructuredModel;
                        this.val$offset = n;
                    }

                    public void run() {
                        boolean status;
                        if (!InternalDocumentListener.access$0((InternalDocumentListener)this.this$1).fEditorDisposed && !(status = InternalDocumentListener.access$0(this.this$1).validateEditorInputState()) && this.val$internalModel != null) {
                            this.val$internalModel.getUndoManager().undo();
                            StructuredTextEditor.access$0(InternalDocumentListener.access$0(this.this$1)).setSelectedRange(this.val$offset, 0);
                            if (!InternalDocumentListener.access$0((InternalDocumentListener)this.this$1).fDirtyBeforeDocumentEvent) {
                                this.val$internalModel.setDirtyState(false);
                            }
                        }
                        InternalDocumentListener.access$0((InternalDocumentListener)this.this$1).fCurrentRunnable = null;
                    }
                };
                Display display = StructuredTextEditor.this.getDisplay();
                if (display != null) {
                    if (Thread.currentThread() != display.getThread()) {
                        display.asyncExec(StructuredTextEditor.this.fCurrentRunnable);
                    } else {
                        StructuredTextEditor.this.fCurrentRunnable.run();
                    }
                }
            }
        }

        static /* synthetic */ StructuredTextEditor access$0(InternalDocumentListener internalDocumentListener) {
            return internalDocumentListener.StructuredTextEditor.this;
        }
    }

    private class InternalModelStateListener
    implements IModelStateListener {
        private InternalModelStateListener() {
        }

        public void modelAboutToBeChanged(IStructuredModel model) {
            StructuredTextEditor.this.getTextViewer();
        }

        public void modelAboutToBeReinitialized(IStructuredModel structuredModel) {
            if (StructuredTextEditor.this.getTextViewer() != null) {
                StructuredTextEditor.this.getTextViewer().unconfigure();
            }
        }

        public void modelChanged(IStructuredModel model) {
            if (StructuredTextEditor.this.getTextViewer() != null && !StructuredTextEditor.this.fUpdateMenuTextPending) {
                this.runOnDisplayThreadIfNeededed(new Runnable(this){
                    final /* synthetic */ InternalModelStateListener this$1;
                    {
                        this.this$1 = internalModelStateListener;
                    }

                    public void run() {
                        StructuredTextEditor.access$2(InternalModelStateListener.access$1(this.this$1));
                        StructuredTextEditor.access$3(InternalModelStateListener.access$1(this.this$1), false);
                    }
                });
            }
        }

        public void modelDirtyStateChanged(IStructuredModel model, boolean isDirty) {
        }

        /*
         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void modelReinitialized(IStructuredModel structuredModel) {
            try {
                try {
                    if (StructuredTextEditor.this.getSourceViewer() != null) {
                        SourceViewerConfiguration cfg = StructuredTextEditor.this.getSourceViewerConfiguration();
                        StructuredTextEditor.this.getSourceViewer().configure(cfg);
                    }
                }
                catch (Exception e) {
                    Logger.logException("problem trying to configure after model change", e);
                }
            }
            catch (Throwable throwable) {
                Object var3_5 = null;
                ((ITextViewerExtension)StructuredTextEditor.this.getSourceViewer()).setRedraw(true);
                throw throwable;
            }
            {
                Object var3_6 = null;
            }
            ((ITextViewerExtension)StructuredTextEditor.this.getSourceViewer()).setRedraw(true);
        }

        public void modelResourceDeleted(IStructuredModel model) {
        }

        public void modelResourceMoved(IStructuredModel originalmodel, IStructuredModel movedmodel) {
        }

        private void runOnDisplayThreadIfNeededed(Runnable r) {
            if (StructuredTextEditor.this.getDisplay() == null || Thread.currentThread() == StructuredTextEditor.this.getDisplay().getThread()) {
                r.run();
            } else {
                StructuredTextEditor.this.getDisplay().asyncExec(r);
            }
        }

        static /* synthetic */ StructuredTextEditor access$1(InternalModelStateListener internalModelStateListener) {
            return internalModelStateListener.StructuredTextEditor.this;
        }
    }

    private class OutlinePageListener
    implements IDoubleClickListener,
    ISelectionChangedListener {
        private OutlinePageListener() {
        }

        public void doubleClick(DoubleClickEvent event) {
            if (event.getSelection().isEmpty()) {
                return;
            }
            int start = -1;
            int length = 0;
            if (event.getSelection() instanceof IStructuredSelection) {
                Object[] newSelection;
                Object[] current;
                ISelection currentSelection = StructuredTextEditor.this.getSelectionProvider().getSelection();
                if (currentSelection instanceof IStructuredSelection && !(current = ((IStructuredSelection)currentSelection).toArray()).equals(newSelection = ((IStructuredSelection)event.getSelection()).toArray())) {
                    IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                    Object o = selection.getFirstElement();
                    if (o instanceof IndexedRegion) {
                        start = ((IndexedRegion)o).getStartOffset();
                        length = ((IndexedRegion)o).getEndOffset() - start;
                    } else if (o instanceof ITextRegion) {
                        start = ((ITextRegion)o).getStart();
                        length = ((ITextRegion)o).getEnd() - start;
                    } else if (o instanceof IRegion) {
                        start = ((ITextRegion)o).getStart();
                        length = ((ITextRegion)o).getLength();
                    }
                }
            } else if (event.getSelection() instanceof ITextSelection) {
                start = ((ITextSelection)event.getSelection()).getOffset();
                length = ((ITextSelection)event.getSelection()).getLength();
            }
            if (start > -1) {
                StructuredTextEditor.this.getSourceViewer().setRangeIndication(start, length, false);
                StructuredTextEditor.this.selectAndReveal(start, length);
            }
        }

        public void selectionChanged(SelectionChangedEvent event) {
            if (event.getSelection().isEmpty() || StructuredTextEditor.this.fStructuredSelectionProvider.isFiringSelection()) {
                return;
            }
            if (StructuredTextEditor.this.getSourceViewer() != null && StructuredTextEditor.this.getSourceViewer().getTextWidget() != null && !StructuredTextEditor.this.getSourceViewer().getTextWidget().isDisposed() && !StructuredTextEditor.this.getSourceViewer().getTextWidget().isFocusControl()) {
                int start = -1;
                int length = 0;
                if (event.getSelection() instanceof IStructuredSelection) {
                    Object[] newSelection;
                    Object[] currentSelection;
                    ISelection current = StructuredTextEditor.this.getSelectionProvider().getSelection();
                    if (current instanceof IStructuredSelection && !Arrays.equals(currentSelection = ((IStructuredSelection)current).toArray(), newSelection = ((IStructuredSelection)event.getSelection()).toArray()) && newSelection.length > 0) {
                        Object o = newSelection[0];
                        if (o instanceof IndexedRegion) {
                            start = ((IndexedRegion)o).getStartOffset();
                            int end = ((IndexedRegion)o).getEndOffset();
                            if (newSelection.length > 1) {
                                int i = 1;
                                while (i < newSelection.length) {
                                    start = Math.min(start, ((IndexedRegion)newSelection[i]).getStartOffset());
                                    end = Math.max(end, ((IndexedRegion)newSelection[i]).getEndOffset());
                                    ++i;
                                }
                                length = end - start;
                            }
                        } else if (o instanceof ITextRegion) {
                            start = ((ITextRegion)o).getStart();
                            int end = ((ITextRegion)o).getEnd();
                            if (newSelection.length > 1) {
                                int i = 1;
                                while (i < newSelection.length) {
                                    start = Math.min(start, ((ITextRegion)newSelection[i]).getStart());
                                    end = Math.max(end, ((ITextRegion)newSelection[i]).getEnd());
                                    ++i;
                                }
                                length = end - start;
                            }
                        } else if (o instanceof IRegion) {
                            start = ((IRegion)o).getOffset();
                            int end = start + ((IRegion)o).getLength();
                            if (newSelection.length > 1) {
                                int i = 1;
                                while (i < newSelection.length) {
                                    start = Math.min(start, ((IRegion)newSelection[i]).getOffset());
                                    end = Math.max(end, ((IRegion)newSelection[i]).getOffset() + ((IRegion)newSelection[i]).getLength());
                                    ++i;
                                }
                                length = end - start;
                            }
                        }
                    }
                } else if (event.getSelection() instanceof ITextSelection) {
                    start = ((ITextSelection)event.getSelection()).getOffset();
                }
                if (start > -1) {
                    StructuredTextEditor.this.updateRangeIndication(event.getSelection());
                    StructuredTextEditor.this.selectAndReveal(start, length);
                }
            }
        }
    }

    private class ShowInTargetListAdapter
    implements IShowInTargetList {
        private ShowInTargetListAdapter() {
        }

        public String[] getShowInTargetIds() {
            return StructuredTextEditor.this.fShowInTargetIds;
        }
    }

    private static class StructuredSelectionProvider
    implements IPostSelectionProvider,
    ISelectionValidator {
        private SoftReference weakDocument;
        private ISelectionProvider fParentProvider = null;
        private boolean isFiringSelection = false;
        private ListenerList listeners = new ListenerList();
        private ListenerList postListeners = new ListenerList();
        private ISelection fLastSelection = null;
        private ISelectionProvider fLastSelectionProvider = null;
        private SelectionChangedEvent fLastUpdatedSelectionChangedEvent = null;
        private SoftReference weakEditor;

        StructuredSelectionProvider(ISelectionProvider parentProvider, StructuredTextEditor structuredTextEditor) {
            this.fParentProvider = parentProvider;
            this.weakEditor = new SoftReference<StructuredTextEditor>(structuredTextEditor);
            IDocument document = structuredTextEditor.getDocumentProvider().getDocument((Object)structuredTextEditor.getEditorInput());
            if (document != null) {
                this.setDocument(document);
            }
            this.fParentProvider.addSelectionChangedListener(new ISelectionChangedListener(this){
                final /* synthetic */ StructuredSelectionProvider this$1;
                {
                    this.this$1 = structuredSelectionProvider;
                }

                public void selectionChanged(SelectionChangedEvent event) {
                    this.this$1.handleSelectionChanged(event);
                }
            });
            if (this.fParentProvider instanceof IPostSelectionProvider) {
                ((IPostSelectionProvider)this.fParentProvider).addPostSelectionChangedListener(new ISelectionChangedListener(this){
                    final /* synthetic */ StructuredSelectionProvider this$1;
                    {
                        this.this$1 = structuredSelectionProvider;
                    }

                    public void selectionChanged(SelectionChangedEvent event) {
                        this.this$1.handlePostSelectionChanged(event);
                    }
                });
            }
        }

        public void addPostSelectionChangedListener(ISelectionChangedListener listener) {
            this.postListeners.add((Object)listener);
        }

        public void addSelectionChangedListener(ISelectionChangedListener listener) {
            this.listeners.add((Object)listener);
        }

        private void fireSelectionChanged(SelectionChangedEvent event, ListenerList listenerList) {
            Object[] listeners = listenerList.getListeners();
            this.isFiringSelection = true;
            int i = 0;
            while (i < listeners.length) {
                ISelectionChangedListener l = (ISelectionChangedListener)listeners[i];
                SafeRunner.run((ISafeRunnable)new SafeRunnable(this, l, event){
                    final /* synthetic */ StructuredSelectionProvider this$1;
                    private final /* synthetic */ ISelectionChangedListener val$l;
                    private final /* synthetic */ SelectionChangedEvent val$event;
                    {
                        this.this$1 = structuredSelectionProvider;
                        this.val$l = iSelectionChangedListener;
                        this.val$event = selectionChangedEvent;
                    }

                    public void run() {
                        this.val$l.selectionChanged(this.val$event);
                    }
                });
                ++i;
            }
            this.isFiringSelection = false;
        }

        private ISelectionProvider getParentProvider() {
            return this.fParentProvider;
        }

        public ISelection getSelection() {
            this.fLastSelection = null;
            this.fLastSelectionProvider = null;
            this.fLastUpdatedSelectionChangedEvent = null;
            Object selection = this.getParentProvider().getSelection();
            if (!(selection instanceof IStructuredSelection) && selection instanceof ITextSelection) {
                IStructuredModel model = null;
                StructuredTextEditor localEditor = this.getStructuredTextEditor();
                if (localEditor != null) {
                    model = localEditor.getModel();
                    selection = new StructuredTextSelection((ITextSelection)selection, this.getDocument(), model);
                } else {
                    selection = new StructuredTextSelection((ITextSelection)selection, this.getDocument(), null);
                }
            }
            return selection;
        }

        private StructuredTextEditor getStructuredTextEditor() {
            StructuredTextEditor editor = null;
            if (this.weakEditor != null) {
                editor = (StructuredTextEditor)((Object)this.weakEditor.get());
            }
            return editor;
        }

        void handlePostSelectionChanged(SelectionChangedEvent event) {
            SelectionChangedEvent updatedEvent = null;
            updatedEvent = this.fLastSelection == event.getSelection() && this.fLastSelectionProvider == event.getSelectionProvider() ? this.fLastUpdatedSelectionChangedEvent : this.updateEvent(event);
            StructuredTextEditor localEditor = (StructuredTextEditor)((Object)this.weakEditor.get());
            if (localEditor != null) {
                localEditor.updateRangeIndication(updatedEvent.getSelection());
                this.fireSelectionChanged(updatedEvent, this.postListeners);
            }
        }

        void handleSelectionChanged(SelectionChangedEvent event) {
            SelectionChangedEvent updatedEvent = event;
            if (this.fLastSelection != event.getSelection() || this.fLastSelectionProvider != event.getSelectionProvider()) {
                this.fLastSelection = event.getSelection();
                this.fLastSelectionProvider = event.getSelectionProvider();
                this.fLastUpdatedSelectionChangedEvent = updatedEvent = this.updateEvent(event);
            }
            this.fireSelectionChanged(updatedEvent, this.listeners);
        }

        IDocument getDocument() {
            IDocument document = null;
            if (this.weakDocument != null) {
                document = (IDocument)this.weakDocument.get();
            }
            return document;
        }

        boolean isFiringSelection() {
            return this.isFiringSelection;
        }

        public boolean isValid(ISelection selection) {
            boolean result = true;
            StructuredTextEditor e = this.getStructuredTextEditor();
            if (e == null || e.fEditorDisposed) {
                result = false;
            } else if (this.getParentProvider() instanceof ISelectionValidator) {
                result = ((ISelectionValidator)this.getParentProvider()).isValid(selection);
            }
            return result;
        }

        public void removePostSelectionChangedListener(ISelectionChangedListener listener) {
            this.postListeners.remove((Object)listener);
        }

        public void removeSelectionChangedListener(ISelectionChangedListener listener) {
            this.listeners.remove((Object)listener);
        }

        public void setSelection(ISelection selection) {
            if (this.isFiringSelection()) {
                return;
            }
            this.fLastSelection = null;
            this.fLastSelectionProvider = null;
            this.fLastUpdatedSelectionChangedEvent = null;
            ISelection textSelection = this.updateSelection(selection);
            this.getParentProvider().setSelection(textSelection);
            StructuredTextEditor localEditor = this.getStructuredTextEditor();
            if (localEditor != null) {
                localEditor.updateRangeIndication(textSelection);
            }
        }

        private SelectionChangedEvent updateEvent(SelectionChangedEvent event) {
            Object selection = event.getSelection();
            if (selection instanceof ITextSelection && !(selection instanceof IStructuredSelection)) {
                IStructuredModel structuredModel = null;
                StructuredTextEditor localEditor = this.getStructuredTextEditor();
                if (localEditor != null) {
                    structuredModel = localEditor.getInternalModel();
                }
                selection = new StructuredTextSelection((ITextSelection)event.getSelection(), this.getDocument(), structuredModel);
            }
            SelectionChangedEvent newEvent = new SelectionChangedEvent(event.getSelectionProvider(), selection);
            return newEvent;
        }

        private ISelection updateSelection(ISelection selection) {
            Object[] selectedObjects;
            Object updated = selection;
            if (selection instanceof IStructuredSelection && !(selection instanceof ITextSelection) && !selection.isEmpty() && (selectedObjects = ((IStructuredSelection)selection).toArray()).length > 0) {
                int start = -1;
                int length = 0;
                Object o = selectedObjects[0];
                if (o instanceof IndexedRegion) {
                    start = ((IndexedRegion)o).getStartOffset();
                    int end = ((IndexedRegion)o).getEndOffset();
                    if (selectedObjects.length > 1) {
                        int i = 1;
                        while (i < selectedObjects.length) {
                            start = Math.min(start, ((IndexedRegion)selectedObjects[i]).getStartOffset());
                            end = Math.max(end, ((IndexedRegion)selectedObjects[i]).getEndOffset());
                            ++i;
                        }
                        length = end - start;
                    }
                } else if (o instanceof ITextRegion) {
                    start = ((ITextRegion)o).getStart();
                    int end = ((ITextRegion)o).getEnd();
                    if (selectedObjects.length > 1) {
                        int i = 1;
                        while (i < selectedObjects.length) {
                            start = Math.min(start, ((ITextRegion)selectedObjects[i]).getStart());
                            end = Math.max(end, ((ITextRegion)selectedObjects[i]).getEnd());
                            ++i;
                        }
                        length = end - start;
                    }
                }
                if (start > -1) {
                    updated = new StructuredTextSelection(this.getDocument(), start, length, selectedObjects);
                }
            }
            return updated;
        }

        public void setDocument(IDocument document) {
            this.weakDocument = new SoftReference<IDocument>(document);
        }

        private static class StructuredTextSelection
        extends TextSelection
        implements IStructuredSelection,
        ITextSelection {
            private Reference selectedStructured;
            private InternalTextSelection fInternalTextSelection;

            StructuredTextSelection(ITextSelection selection, IDocument document, IStructuredModel model) {
                super(selection.getOffset(), selection.getLength());
                this.fInternalTextSelection = new InternalTextSelection(document, selection.getOffset(), selection.getLength());
                this.selectedStructured = new SoftReference<Object[]>(this.initializeInferredSelectedObjects(selection, model));
            }

            StructuredTextSelection(ITextSelection selection, Object[] selectedObjects, IDocument document) {
                super(selection.getOffset(), selection.getLength());
                this.fInternalTextSelection = new InternalTextSelection(document, selection.getOffset(), selection.getLength());
                this.selectedStructured = new SoftReference<Object[]>(selectedObjects);
            }

            StructuredTextSelection(IDocument document, int offset, int length, Object[] selectedObjects) {
                super(offset, length);
                this.fInternalTextSelection = new InternalTextSelection(document, offset, length);
                this.selectedStructured = new SoftReference<Object[]>(selectedObjects);
            }

            public Object getFirstElement() {
                Object[] selectedStructures = this.getSelectedStructures();
                return selectedStructures.length > 0 ? selectedStructures[0] : null;
            }

            private Object[] getSelectedStructures() {
                Object[] selectedStructures = (Object[])this.selectedStructured.get();
                if (selectedStructures == null) {
                    selectedStructures = new Object[]{};
                }
                return selectedStructures;
            }

            private Object[] initializeInferredSelectedObjects(ITextSelection selection, IStructuredModel model) {
                Object[] localSelectedStructures = null;
                if (model != null) {
                    IndexedRegion region = model.getIndexedRegion(selection.getOffset());
                    int end = selection.getOffset() + selection.getLength();
                    if (region != null) {
                        if (end <= region.getEndOffset()) {
                            localSelectedStructures = new Object[]{region};
                        } else {
                            int maxLength = model.getStructuredDocument().getLength();
                            ArrayList<IndexedRegion> structures = new ArrayList<IndexedRegion>(2);
                            while (region != null && region.getEndOffset() <= end && region.getEndOffset() < maxLength) {
                                structures.add(region);
                                region = model.getIndexedRegion(region.getEndOffset() + 1);
                            }
                            localSelectedStructures = structures.toArray();
                        }
                    }
                }
                if (localSelectedStructures == null) {
                    localSelectedStructures = new Object[]{};
                }
                return localSelectedStructures;
            }

            public boolean isEmpty() {
                return this.fInternalTextSelection.isEmpty() || this.getSelectedStructures().length == 0;
            }

            public Iterator iterator() {
                return this.toList().iterator();
            }

            public int size() {
                return this.getSelectedStructures().length;
            }

            public Object[] toArray() {
                return this.getSelectedStructures();
            }

            public List toList() {
                return Arrays.asList(this.getSelectedStructures());
            }

            public String toString() {
                return String.valueOf(this.fInternalTextSelection.getOffset()) + ":" + this.fInternalTextSelection.getLength() + "@" + this.getSelectedStructures();
            }

            public int getOffset() {
                return this.fInternalTextSelection.getOffset();
            }

            public int getLength() {
                return this.fInternalTextSelection.getLength();
            }

            public int getStartLine() {
                return this.fInternalTextSelection.getStartLine();
            }

            public int getEndLine() {
                return this.fInternalTextSelection.getEndLine();
            }

            public String getText() {
                return this.fInternalTextSelection.getText();
            }

            private static class InternalTextSelection
            implements ITextSelection {
                private SoftReference weakDocument;
                private int fOffset;
                private int fLength;

                InternalTextSelection(int offset, int length) {
                    this(null, offset, length);
                }

                InternalTextSelection(IDocument document, int offset, int length) {
                    this.weakDocument = new SoftReference<IDocument>(document);
                    this.fOffset = offset;
                    this.fLength = length;
                }

                public boolean isEmpty() {
                    return this.fOffset < 0 || this.fLength < 0;
                }

                public int getOffset() {
                    return this.fOffset;
                }

                public int getLength() {
                    return this.fLength;
                }

                public int getStartLine() {
                    IDocument document = (IDocument)this.weakDocument.get();
                    try {
                        if (document != null) {
                            return document.getLineOfOffset(this.fOffset);
                        }
                    }
                    catch (BadLocationException badLocationException) {}
                    return -1;
                }

                public int getEndLine() {
                    IDocument document = (IDocument)this.weakDocument.get();
                    try {
                        if (document != null) {
                            int endOffset = this.fOffset + this.fLength;
                            if (this.fLength != 0) {
                                --endOffset;
                            }
                            return document.getLineOfOffset(endOffset);
                        }
                    }
                    catch (BadLocationException badLocationException) {}
                    return -1;
                }

                public String getText() {
                    IDocument document = (IDocument)this.weakDocument.get();
                    try {
                        if (document != null) {
                            return document.get(this.fOffset, this.fLength);
                        }
                    }
                    catch (BadLocationException badLocationException) {}
                    return null;
                }

                public boolean equals(Object obj) {
                    boolean sameRange;
                    if (obj == this) {
                        return true;
                    }
                    if (obj == null || this.getClass() != obj.getClass()) {
                        return false;
                    }
                    InternalTextSelection s = (InternalTextSelection)obj;
                    boolean bl = sameRange = s.fOffset == this.fOffset && s.fLength == this.fLength;
                    if (sameRange) {
                        IDocument document = (IDocument)this.weakDocument.get();
                        IDocument sDocument = s.getDocument();
                        if (sDocument == null && document == null) {
                            return true;
                        }
                        if (sDocument == null || document == null) {
                            return false;
                        }
                        try {
                            String sContent = sDocument.get(this.fOffset, this.fLength);
                            String content = document.get(this.fOffset, this.fLength);
                            return sContent.equals(content);
                        }
                        catch (BadLocationException badLocationException) {}
                    }
                    return false;
                }

                public int hashCode() {
                    IDocument document = (IDocument)this.weakDocument.get();
                    int low = document != null ? document.hashCode() : 0;
                    return this.fOffset << 24 | this.fLength << 16 | low;
                }

                private IDocument getDocument() {
                    if (this.weakDocument == null) {
                        return null;
                    }
                    return (IDocument)this.weakDocument.get();
                }
            }
        }
    }

    class TimeOutExpired
    extends TimerTask {
        TimeOutExpired() {
        }

        public void run() {
            StructuredTextEditor.this.getDisplay().syncExec(new Runnable(this){
                final /* synthetic */ TimeOutExpired this$1;
                {
                    this.this$1 = timeOutExpired;
                }

                public void run() {
                    if (TimeOutExpired.access$0(this.this$1).getDisplay() != null && !TimeOutExpired.access$0(this.this$1).getDisplay().isDisposed()) {
                        StructuredTextEditor.access$5(TimeOutExpired.access$0(this.this$1));
                    }
                }
            });
        }

        static /* synthetic */ StructuredTextEditor access$0(TimeOutExpired timeOutExpired) {
            return timeOutExpired.StructuredTextEditor.this;
        }
    }
}

