/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.corext.callhierarchy;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.wst.jsdt.core.IJavaElement;
import org.eclipse.wst.jsdt.core.IMember;
import org.eclipse.wst.jsdt.core.IMethod;
import org.eclipse.wst.jsdt.core.IType;
import org.eclipse.wst.jsdt.core.JavaModelException;
import org.eclipse.wst.jsdt.internal.corext.callhierarchy.IImplementorFinder;
import org.eclipse.wst.jsdt.internal.corext.callhierarchy.JavaImplementorFinder;
import org.eclipse.wst.jsdt.internal.ui.JavaPlugin;

public class Implementors {
    private static IImplementorFinder[] IMPLEMENTOR_FINDERS = new IImplementorFinder[]{new JavaImplementorFinder()};
    private static Implementors fgInstance;

    public static Implementors getInstance() {
        if (fgInstance == null) {
            fgInstance = new Implementors();
        }
        return fgInstance;
    }

    public IJavaElement[] searchForImplementors(IJavaElement[] elements, IProgressMonitor progressMonitor) {
        if (elements != null && elements.length > 0) {
            IJavaElement element = elements[0];
            try {
                IMember member;
                IType type;
                if (element instanceof IMember && (type = (member = (IMember)element).getDeclaringType()) != null && type.isInterface()) {
                    IType[] implementingTypes = this.findImplementingTypes(type, progressMonitor);
                    if (member.getElementType() == 9) {
                        return this.findMethods((IMethod)member, implementingTypes, progressMonitor);
                    }
                    return implementingTypes;
                }
            }
            catch (JavaModelException e) {
                JavaPlugin.log(e);
            }
        }
        return null;
    }

    public IJavaElement[] searchForInterfaces(IJavaElement[] elements, IProgressMonitor progressMonitor) {
        IJavaElement element;
        if (elements != null && elements.length > 0 && (element = elements[0]) instanceof IMember) {
            IMember member = (IMember)element;
            IType type = member.getDeclaringType();
            IType[] implementingTypes = this.findInterfaces(type, progressMonitor);
            if (!progressMonitor.isCanceled()) {
                if (member.getElementType() == 9) {
                    return this.findMethods((IMethod)member, implementingTypes, progressMonitor);
                }
                return implementingTypes;
            }
        }
        return null;
    }

    private IImplementorFinder[] getImplementorFinders() {
        return IMPLEMENTOR_FINDERS;
    }

    private IType[] findImplementingTypes(IType type, IProgressMonitor progressMonitor) {
        ArrayList implementingTypes = new ArrayList();
        IImplementorFinder[] finders = this.getImplementorFinders();
        int i = 0;
        while (i < finders.length && !progressMonitor.isCanceled()) {
            Collection types = finders[i].findImplementingTypes(type, (IProgressMonitor)new SubProgressMonitor(progressMonitor, 10, 2));
            if (types != null) {
                implementingTypes.addAll(types);
            }
            ++i;
        }
        return implementingTypes.toArray(new IType[implementingTypes.size()]);
    }

    private IType[] findInterfaces(IType type, IProgressMonitor progressMonitor) {
        ArrayList interfaces = new ArrayList();
        IImplementorFinder[] finders = this.getImplementorFinders();
        int i = 0;
        while (i < finders.length && !progressMonitor.isCanceled()) {
            Collection types = finders[i].findInterfaces(type, (IProgressMonitor)new SubProgressMonitor(progressMonitor, 10, 2));
            if (types != null) {
                interfaces.addAll(types);
            }
            ++i;
        }
        return interfaces.toArray(new IType[interfaces.size()]);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private IJavaElement[] findMethods(IMethod method, IType[] types, IProgressMonitor progressMonitor) {
        ArrayList<IMethod> foundMethods = new ArrayList<IMethod>();
        SubProgressMonitor subProgressMonitor = new SubProgressMonitor(progressMonitor, 10, 2);
        subProgressMonitor.beginTask("", types.length);
        try {
            int i = 0;
            while (i < types.length) {
                IType type = types[i];
                IMethod[] methods = type.findMethods(method);
                if (methods != null) {
                    int j = 0;
                    while (j < methods.length) {
                        foundMethods.add(methods[j]);
                        ++j;
                    }
                }
                subProgressMonitor.worked(1);
                ++i;
            }
        }
        catch (Throwable throwable) {
            Object var10_11 = null;
            subProgressMonitor.done();
            throw throwable;
        }
        {
            Object var10_12 = null;
        }
        subProgressMonitor.done();
        return foundMethods.toArray(new IJavaElement[foundMethods.size()]);
    }
}

