/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.corext.fix;

import java.util.HashSet;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.text.edits.TextEditGroup;
import org.eclipse.wst.jsdt.core.IJavaElement;
import org.eclipse.wst.jsdt.core.IJavaProject;
import org.eclipse.wst.jsdt.core.dom.AST;
import org.eclipse.wst.jsdt.core.dom.ASTNode;
import org.eclipse.wst.jsdt.core.dom.ASTVisitor;
import org.eclipse.wst.jsdt.core.dom.ArrayAccess;
import org.eclipse.wst.jsdt.core.dom.Assignment;
import org.eclipse.wst.jsdt.core.dom.CompilationUnit;
import org.eclipse.wst.jsdt.core.dom.EnhancedForStatement;
import org.eclipse.wst.jsdt.core.dom.Expression;
import org.eclipse.wst.jsdt.core.dom.FieldAccess;
import org.eclipse.wst.jsdt.core.dom.ForStatement;
import org.eclipse.wst.jsdt.core.dom.IBinding;
import org.eclipse.wst.jsdt.core.dom.ITypeBinding;
import org.eclipse.wst.jsdt.core.dom.IVariableBinding;
import org.eclipse.wst.jsdt.core.dom.InfixExpression;
import org.eclipse.wst.jsdt.core.dom.Name;
import org.eclipse.wst.jsdt.core.dom.NumberLiteral;
import org.eclipse.wst.jsdt.core.dom.PostfixExpression;
import org.eclipse.wst.jsdt.core.dom.PrefixExpression;
import org.eclipse.wst.jsdt.core.dom.PrimitiveType;
import org.eclipse.wst.jsdt.core.dom.QualifiedName;
import org.eclipse.wst.jsdt.core.dom.SimpleName;
import org.eclipse.wst.jsdt.core.dom.SingleVariableDeclaration;
import org.eclipse.wst.jsdt.core.dom.Statement;
import org.eclipse.wst.jsdt.core.dom.Type;
import org.eclipse.wst.jsdt.core.dom.VariableDeclarationExpression;
import org.eclipse.wst.jsdt.core.dom.VariableDeclarationFragment;
import org.eclipse.wst.jsdt.core.dom.VariableDeclarationStatement;
import org.eclipse.wst.jsdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.wst.jsdt.core.dom.rewrite.ImportRewrite;
import org.eclipse.wst.jsdt.core.dom.rewrite.ListRewrite;
import org.eclipse.wst.jsdt.core.dom.rewrite.TargetSourceRangeComputer;
import org.eclipse.wst.jsdt.internal.corext.codemanipulation.StubUtility;
import org.eclipse.wst.jsdt.internal.corext.dom.GenericVisitor;
import org.eclipse.wst.jsdt.internal.corext.dom.ModifierRewrite;
import org.eclipse.wst.jsdt.internal.corext.fix.ConvertLoopOperation;
import org.eclipse.wst.jsdt.internal.corext.fix.FixMessages;
import org.eclipse.wst.jsdt.internal.corext.fix.LinkedProposalModel;
import org.eclipse.wst.jsdt.internal.corext.fix.LinkedProposalPositionGroup;
import org.eclipse.wst.jsdt.internal.corext.refactoring.structure.CompilationUnitRewrite;
import org.eclipse.wst.jsdt.internal.corext.refactoring.util.TightSourceRangeComputer;
import org.eclipse.wst.jsdt.internal.corext.util.JavaModelUtil;

public class ConvertForLoopOperation
extends ConvertLoopOperation {
    private static final String LENGTH_QUERY = "length";
    private static final String LITERAL_0 = "0";
    private static final String LITERAL_1 = "1";
    private IVariableBinding fIndexBinding;
    private IVariableBinding fLengthBinding;
    private IBinding fArrayBinding;
    private Expression fArrayAccess;
    private VariableDeclarationFragment fElementDeclaration;
    private final boolean fMakeFinal;

    public ConvertForLoopOperation(ForStatement forStatement) {
        this(forStatement, new String[0], false);
    }

    public ConvertForLoopOperation(ForStatement forStatement, String[] usedNames, boolean makeFinal) {
        super(forStatement, usedNames);
        this.fMakeFinal = makeFinal;
    }

    public IStatus satisfiesPreconditions() {
        ForStatement statement = this.getForStatement();
        CompilationUnit ast = (CompilationUnit)statement.getRoot();
        IJavaElement javaElement = ast.getJavaElement();
        if (javaElement == null) {
            return ERROR_STATUS;
        }
        if (!JavaModelUtil.is50OrHigher(javaElement.getJavaProject())) {
            return ERROR_STATUS;
        }
        if (!this.validateInitializers(statement)) {
            return ERROR_STATUS;
        }
        if (!this.validateExpression(statement)) {
            return ERROR_STATUS;
        }
        if (!this.validateUpdaters(statement)) {
            return ERROR_STATUS;
        }
        if (!this.validateBody(statement)) {
            return ERROR_STATUS;
        }
        return Status.OK_STATUS;
    }

    private boolean validateInitializers(ForStatement statement) {
        List initializers = statement.initializers();
        if (initializers.size() != 1) {
            return false;
        }
        Expression expression = (Expression)initializers.get(0);
        if (!(expression instanceof VariableDeclarationExpression)) {
            return false;
        }
        VariableDeclarationExpression declaration = (VariableDeclarationExpression)expression;
        ITypeBinding declarationBinding = declaration.resolveTypeBinding();
        if (declarationBinding == null) {
            return false;
        }
        if (!declarationBinding.isPrimitive()) {
            return false;
        }
        if (!PrimitiveType.INT.toString().equals(declarationBinding.getQualifiedName())) {
            return false;
        }
        List fragments = declaration.fragments();
        if (fragments.size() == 1) {
            IVariableBinding indexBinding = this.getIndexBindingFromFragment((VariableDeclarationFragment)fragments.get(0));
            if (indexBinding == null) {
                return false;
            }
            this.fIndexBinding = indexBinding;
            return true;
        }
        if (fragments.size() == 2) {
            IVariableBinding indexBinding = this.getIndexBindingFromFragment((VariableDeclarationFragment)fragments.get(0));
            if (indexBinding == null) {
                indexBinding = this.getIndexBindingFromFragment((VariableDeclarationFragment)fragments.get(1));
                if (indexBinding == null) {
                    return false;
                }
                if (!this.validateLengthFragment((VariableDeclarationFragment)fragments.get(0))) {
                    return false;
                }
            } else if (!this.validateLengthFragment((VariableDeclarationFragment)fragments.get(1))) {
                return false;
            }
            this.fIndexBinding = indexBinding;
            return true;
        }
        return false;
    }

    private boolean validateLengthFragment(VariableDeclarationFragment fragment) {
        Expression initializer = fragment.getInitializer();
        if (initializer == null) {
            return false;
        }
        if (!this.validateLengthQuery(initializer)) {
            return false;
        }
        IVariableBinding lengthBinding = (IVariableBinding)fragment.getName().resolveBinding();
        if (lengthBinding == null) {
            return false;
        }
        this.fLengthBinding = lengthBinding;
        return true;
    }

    private IVariableBinding getIndexBindingFromFragment(VariableDeclarationFragment fragment) {
        Expression initializer = fragment.getInitializer();
        if (!(initializer instanceof NumberLiteral)) {
            return null;
        }
        NumberLiteral number = (NumberLiteral)initializer;
        if (!LITERAL_0.equals(number.getToken())) {
            return null;
        }
        return (IVariableBinding)fragment.getName().resolveBinding();
    }

    private boolean validateExpression(ForStatement statement) {
        Expression expression = statement.getExpression();
        if (!(expression instanceof InfixExpression)) {
            return false;
        }
        InfixExpression infix = (InfixExpression)expression;
        Expression left = infix.getLeftOperand();
        Expression right = infix.getRightOperand();
        if (left instanceof SimpleName && right instanceof SimpleName) {
            IVariableBinding lengthBinding = this.fLengthBinding;
            if (lengthBinding == null) {
                return false;
            }
            IBinding leftBinding = ((SimpleName)left).resolveBinding();
            IBinding righBinding = ((SimpleName)right).resolveBinding();
            if (this.fIndexBinding.equals((Object)leftBinding)) {
                return lengthBinding.equals((Object)righBinding);
            }
            if (this.fIndexBinding.equals((Object)righBinding)) {
                return lengthBinding.equals((Object)leftBinding);
            }
            return false;
        }
        if (left instanceof SimpleName) {
            if (!this.fIndexBinding.equals((Object)((SimpleName)left).resolveBinding())) {
                return false;
            }
            if (!InfixExpression.Operator.LESS.equals(infix.getOperator())) {
                return false;
            }
            return this.validateLengthQuery(right);
        }
        if (right instanceof SimpleName) {
            if (!this.fIndexBinding.equals((Object)((SimpleName)right).resolveBinding())) {
                return false;
            }
            if (!InfixExpression.Operator.GREATER.equals(infix.getOperator())) {
                return false;
            }
            return this.validateLengthQuery(left);
        }
        return false;
    }

    private boolean validateLengthQuery(Expression lengthQuery) {
        if (lengthQuery instanceof QualifiedName) {
            QualifiedName qualifiedName = (QualifiedName)lengthQuery;
            SimpleName name = qualifiedName.getName();
            if (!LENGTH_QUERY.equals(name.getIdentifier())) {
                return false;
            }
            Name arrayAccess = qualifiedName.getQualifier();
            ITypeBinding accessType = arrayAccess.resolveTypeBinding();
            if (accessType == null) {
                return false;
            }
            if (!accessType.isArray()) {
                return false;
            }
            IBinding arrayBinding = arrayAccess.resolveBinding();
            if (arrayBinding == null) {
                return false;
            }
            this.fArrayBinding = arrayBinding;
            this.fArrayAccess = arrayAccess;
            return true;
        }
        if (lengthQuery instanceof FieldAccess) {
            FieldAccess fieldAccess = (FieldAccess)lengthQuery;
            SimpleName name = fieldAccess.getName();
            if (!LENGTH_QUERY.equals(name.getIdentifier())) {
                return false;
            }
            Expression arrayAccess = fieldAccess.getExpression();
            ITypeBinding accessType = arrayAccess.resolveTypeBinding();
            if (accessType == null) {
                return false;
            }
            if (!accessType.isArray()) {
                return false;
            }
            IBinding arrayBinding = ConvertForLoopOperation.getBinding(arrayAccess);
            if (arrayBinding == null) {
                return false;
            }
            this.fArrayBinding = arrayBinding;
            this.fArrayAccess = arrayAccess;
            return true;
        }
        return false;
    }

    private boolean validateUpdaters(ForStatement statement) {
        List updaters = statement.updaters();
        if (updaters.size() != 1) {
            return false;
        }
        Expression updater = (Expression)updaters.get(0);
        if (updater instanceof PostfixExpression) {
            PostfixExpression postfix = (PostfixExpression)updater;
            if (!PostfixExpression.Operator.INCREMENT.equals(postfix.getOperator())) {
                return false;
            }
            IBinding binding = ConvertForLoopOperation.getBinding(postfix.getOperand());
            return this.fIndexBinding.equals((Object)binding);
        }
        if (updater instanceof Assignment) {
            Assignment assignment = (Assignment)updater;
            Expression left = assignment.getLeftHandSide();
            IBinding binding = ConvertForLoopOperation.getBinding(left);
            if (!this.fIndexBinding.equals((Object)binding)) {
                return false;
            }
            if (Assignment.Operator.PLUS_ASSIGN.equals(assignment.getOperator())) {
                return this.isOneLiteral(assignment.getRightHandSide());
            }
            if (Assignment.Operator.ASSIGN.equals(assignment.getOperator())) {
                Expression right = assignment.getRightHandSide();
                if (!(right instanceof InfixExpression)) {
                    return false;
                }
                InfixExpression infixExpression = (InfixExpression)right;
                Expression leftOperand = infixExpression.getLeftOperand();
                IBinding leftBinding = ConvertForLoopOperation.getBinding(leftOperand);
                Expression rightOperand = infixExpression.getRightOperand();
                IBinding rightBinding = ConvertForLoopOperation.getBinding(rightOperand);
                if (this.fIndexBinding.equals((Object)leftBinding)) {
                    return this.isOneLiteral(rightOperand);
                }
                if (this.fIndexBinding.equals((Object)rightBinding)) {
                    return this.isOneLiteral(leftOperand);
                }
            }
        }
        return false;
    }

    private boolean isOneLiteral(Expression expression) {
        if (!(expression instanceof NumberLiteral)) {
            return false;
        }
        NumberLiteral literal = (NumberLiteral)expression;
        return LITERAL_1.equals(literal.getToken());
    }

    private boolean validateBody(ForStatement statement) {
        Statement body = statement.getBody();
        try {
            body.accept((ASTVisitor)new GenericVisitor(){

                protected boolean visitNode(ASTNode node) {
                    if (node instanceof Name) {
                        Name name = (Name)node;
                        IBinding nameBinding = name.resolveBinding();
                        if (nameBinding == null) {
                            throw new InvalidBodyError();
                        }
                        if (nameBinding.equals((Object)ConvertForLoopOperation.this.fIndexBinding)) {
                            if (node.getLocationInParent() != ArrayAccess.INDEX_PROPERTY) {
                                throw new InvalidBodyError();
                            }
                            ArrayAccess arrayAccess = (ArrayAccess)node.getParent();
                            Expression array = arrayAccess.getArray();
                            IBinding binding = ConvertForLoopOperation.getBinding(array);
                            if (binding == null) {
                                throw new InvalidBodyError();
                            }
                            if (!ConvertForLoopOperation.this.fArrayBinding.equals((Object)binding)) {
                                throw new InvalidBodyError();
                            }
                        } else if (nameBinding.equals((Object)ConvertForLoopOperation.this.fArrayBinding)) {
                            ASTNode current = node;
                            while (current != null && !(current instanceof Statement)) {
                                if (current.getLocationInParent() == Assignment.LEFT_HAND_SIDE_PROPERTY) {
                                    throw new InvalidBodyError();
                                }
                                if (current instanceof PrefixExpression) {
                                    throw new InvalidBodyError();
                                }
                                if (current instanceof PostfixExpression) {
                                    throw new InvalidBodyError();
                                }
                                current = current.getParent();
                            }
                        } else if (nameBinding.equals((Object)ConvertForLoopOperation.this.fLengthBinding)) {
                            throw new InvalidBodyError();
                        }
                    }
                    return true;
                }

                public boolean visit(ArrayAccess node) {
                    if (ConvertForLoopOperation.this.fElementDeclaration != null) {
                        return super.visit(node);
                    }
                    IBinding binding = ConvertForLoopOperation.getBinding(node.getArray());
                    if (ConvertForLoopOperation.this.fArrayBinding.equals((Object)binding)) {
                        IBinding index = ConvertForLoopOperation.getBinding(node.getIndex());
                        if (ConvertForLoopOperation.this.fIndexBinding.equals((Object)index) && node.getLocationInParent() == VariableDeclarationFragment.INITIALIZER_PROPERTY) {
                            ConvertForLoopOperation.this.fElementDeclaration = (VariableDeclarationFragment)node.getParent();
                        }
                    }
                    return super.visit(node);
                }
            });
        }
        catch (InvalidBodyError invalidBodyError) {
            return false;
        }
        return true;
    }

    private static IBinding getBinding(Expression expression) {
        if (expression instanceof FieldAccess) {
            return ((FieldAccess)expression).resolveFieldBinding();
        }
        if (expression instanceof Name) {
            return ((Name)expression).resolveBinding();
        }
        return null;
    }

    public String getIntroducedVariableName() {
        if (this.fElementDeclaration != null) {
            return this.fElementDeclaration.getName().getIdentifier();
        }
        ForStatement forStatement = this.getForStatement();
        IJavaProject javaProject = ((CompilationUnit)forStatement.getRoot()).getJavaElement().getJavaProject();
        String[] proposals = this.getVariableNameProposals(this.fArrayAccess.resolveTypeBinding(), javaProject);
        return proposals[0];
    }

    public void rewriteAST(CompilationUnitRewrite cuRewrite, List textEditGroups, LinkedProposalModel positionGroups) throws CoreException {
        TextEditGroup group = this.createTextEditGroup(FixMessages.Java50Fix_ConvertToEnhancedForLoop_description);
        textEditGroups.add(group);
        ASTRewrite rewrite = cuRewrite.getASTRewrite();
        TightSourceRangeComputer rangeComputer = rewrite.getExtendedSourceRangeComputer() instanceof TightSourceRangeComputer ? (TightSourceRangeComputer)rewrite.getExtendedSourceRangeComputer() : new TightSourceRangeComputer();
        rangeComputer.addTightSourceNode((ASTNode)this.getForStatement());
        rewrite.setTargetSourceRangeComputer((TargetSourceRangeComputer)rangeComputer);
        Statement statement = this.convert(cuRewrite, group, positionGroups);
        rewrite.replace((ASTNode)this.getForStatement(), (ASTNode)statement, group);
    }

    protected Statement convert(CompilationUnitRewrite cuRewrite, TextEditGroup group, LinkedProposalModel positionGroups) throws CoreException {
        ASTRewrite rewrite = cuRewrite.getASTRewrite();
        ImportRewrite importRewrite = cuRewrite.getImportRewrite();
        ForStatement forStatement = this.getForStatement();
        IJavaProject javaProject = ((CompilationUnit)forStatement.getRoot()).getJavaElement().getJavaProject();
        String[] proposals = this.getVariableNameProposals(this.fArrayAccess.resolveTypeBinding(), javaProject);
        String parameterName = this.fElementDeclaration != null ? this.fElementDeclaration.getName().getIdentifier() : proposals[0];
        LinkedProposalPositionGroup pg = positionGroups.getPositionGroup(parameterName, true);
        if (this.fElementDeclaration != null) {
            pg.addProposal(parameterName, null, 10);
        }
        int i = 0;
        while (i < proposals.length) {
            pg.addProposal(proposals[i], null, 10);
            ++i;
        }
        AST ast = forStatement.getAST();
        EnhancedForStatement result = ast.newEnhancedForStatement();
        SingleVariableDeclaration parameterDeclaration = this.createParameterDeclaration(parameterName, this.fElementDeclaration, this.fArrayAccess, forStatement, importRewrite, rewrite, group, pg, this.fMakeFinal);
        result.setParameter(parameterDeclaration);
        result.setExpression((Expression)rewrite.createCopyTarget((ASTNode)this.fArrayAccess));
        this.convertBody(forStatement.getBody(), (IBinding)this.fIndexBinding, this.fArrayBinding, parameterName, rewrite, group, pg);
        result.setBody(this.getBody(cuRewrite, group, positionGroups));
        positionGroups.setEndPosition(rewrite.track((ASTNode)result));
        return result;
    }

    private void convertBody(Statement body, final IBinding indexBinding, final IBinding arrayBinding, final String parameterName, final ASTRewrite rewrite, final TextEditGroup editGroup, final LinkedProposalPositionGroup pg) {
        final AST ast = body.getAST();
        final HashSet assignedBindings = new HashSet();
        body.accept((ASTVisitor)new GenericVisitor(){

            public boolean visit(ArrayAccess node) {
                IBinding index;
                IBinding binding = ConvertForLoopOperation.getBinding(node.getArray());
                if (arrayBinding.equals((Object)binding) && indexBinding.equals((Object)(index = ConvertForLoopOperation.getBinding(node.getIndex())))) {
                    this.replaceAccess((ASTNode)node);
                }
                return super.visit(node);
            }

            public boolean visit(SimpleName node) {
                if (assignedBindings.contains(node.resolveBinding())) {
                    this.replaceAccess((ASTNode)node);
                }
                return super.visit(node);
            }

            private void replaceAccess(ASTNode node) {
                if (node.getLocationInParent() == VariableDeclarationFragment.INITIALIZER_PROPERTY) {
                    VariableDeclarationFragment fragment = (VariableDeclarationFragment)node.getParent();
                    IBinding targetBinding = fragment.getName().resolveBinding();
                    if (targetBinding != null) {
                        assignedBindings.add(targetBinding);
                        VariableDeclarationStatement statement = (VariableDeclarationStatement)fragment.getParent();
                        if (statement.fragments().size() == 1) {
                            rewrite.remove((ASTNode)statement, editGroup);
                        } else {
                            ListRewrite listRewrite = rewrite.getListRewrite((ASTNode)statement, VariableDeclarationStatement.FRAGMENTS_PROPERTY);
                            listRewrite.remove((ASTNode)fragment, editGroup);
                        }
                    } else {
                        SimpleName name = ast.newSimpleName(parameterName);
                        rewrite.replace(node, (ASTNode)name, editGroup);
                        pg.addPosition(rewrite.track((ASTNode)name), true);
                    }
                } else {
                    SimpleName name = ast.newSimpleName(parameterName);
                    rewrite.replace(node, (ASTNode)name, editGroup);
                    pg.addPosition(rewrite.track((ASTNode)name), true);
                }
            }
        });
    }

    private SingleVariableDeclaration createParameterDeclaration(String parameterName, VariableDeclarationFragment fragement, Expression arrayAccess, ForStatement statement, ImportRewrite importRewrite, ASTRewrite rewrite, TextEditGroup group, LinkedProposalPositionGroup pg, boolean makeFinal) {
        CompilationUnit compilationUnit = (CompilationUnit)arrayAccess.getRoot();
        AST ast = compilationUnit.getAST();
        SingleVariableDeclaration result = ast.newSingleVariableDeclaration();
        SimpleName name = ast.newSimpleName(parameterName);
        pg.addPosition(rewrite.track((ASTNode)name), true);
        result.setName(name);
        ITypeBinding arrayTypeBinding = arrayAccess.resolveTypeBinding();
        Type type = this.importType(arrayTypeBinding.getElementType(), (ASTNode)statement, importRewrite, compilationUnit);
        if (arrayTypeBinding.getDimensions() != 1) {
            type = ast.newArrayType(type, arrayTypeBinding.getDimensions() - 1);
        }
        result.setType(type);
        if (fragement != null) {
            VariableDeclarationStatement declaration = (VariableDeclarationStatement)fragement.getParent();
            ModifierRewrite.create(rewrite, (ASTNode)result).copyAllModifiers((ASTNode)declaration, group);
        }
        if (makeFinal) {
            ModifierRewrite.create(rewrite, (ASTNode)result).setModifiers(16, 0, group);
        }
        return result;
    }

    private String[] getVariableNameProposals(ITypeBinding arrayTypeBinding, IJavaProject project) {
        String[] variableNames = this.getUsedVariableNames();
        String[] elementSuggestions = StubUtility.getLocalNameSuggestions(project, "element", 0, variableNames);
        String type = arrayTypeBinding.getElementType().getName();
        String[] typeSuggestions = StubUtility.getLocalNameSuggestions(project, type, arrayTypeBinding.getDimensions() - 1, variableNames);
        String[] result = new String[elementSuggestions.length + typeSuggestions.length];
        System.arraycopy(elementSuggestions, 0, result, 0, elementSuggestions.length);
        System.arraycopy(typeSuggestions, 0, result, elementSuggestions.length, typeSuggestions.length);
        return result;
    }

    private static final class InvalidBodyError
    extends Error {
        private static final long serialVersionUID = 1L;

        private InvalidBodyError() {
        }
    }
}

