/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.corext.fix;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.text.edits.TextEditGroup;
import org.eclipse.wst.jsdt.core.dom.ASTNode;
import org.eclipse.wst.jsdt.core.dom.ASTVisitor;
import org.eclipse.wst.jsdt.core.dom.CompilationUnit;
import org.eclipse.wst.jsdt.core.dom.ForStatement;
import org.eclipse.wst.jsdt.core.dom.SingleVariableDeclaration;
import org.eclipse.wst.jsdt.core.dom.Statement;
import org.eclipse.wst.jsdt.core.dom.VariableDeclarationFragment;
import org.eclipse.wst.jsdt.internal.corext.dom.GenericVisitor;
import org.eclipse.wst.jsdt.internal.corext.dom.ScopeAnalyzer;
import org.eclipse.wst.jsdt.internal.corext.fix.LinkedFix;
import org.eclipse.wst.jsdt.internal.corext.fix.LinkedProposalModel;
import org.eclipse.wst.jsdt.internal.corext.refactoring.structure.CompilationUnitRewrite;
import org.eclipse.wst.jsdt.internal.ui.JavaPlugin;

public abstract class ConvertLoopOperation
extends LinkedFix.AbstractLinkedFixRewriteOperation {
    protected static final String FOR_LOOP_ELEMENT_IDENTIFIER = "element";
    protected static final IStatus ERROR_STATUS = new Status(4, JavaPlugin.getPluginId(), "");
    private final ForStatement fStatement;
    private ConvertLoopOperation fOperation;
    private final String[] fUsedNames;

    public ConvertLoopOperation(ForStatement statement, String[] usedNames) {
        this.fStatement = statement;
        this.fUsedNames = usedNames;
    }

    public void setBodyConverter(ConvertLoopOperation operation) {
        this.fOperation = operation;
    }

    public abstract String getIntroducedVariableName();

    public abstract IStatus satisfiesPreconditions();

    protected abstract Statement convert(CompilationUnitRewrite var1, TextEditGroup var2, LinkedProposalModel var3) throws CoreException;

    protected ForStatement getForStatement() {
        return this.fStatement;
    }

    protected Statement getBody(CompilationUnitRewrite cuRewrite, TextEditGroup group, LinkedProposalModel positionGroups) throws CoreException {
        if (this.fOperation != null) {
            return this.fOperation.convert(cuRewrite, group, positionGroups);
        }
        return (Statement)cuRewrite.getASTRewrite().createMoveTarget((ASTNode)this.getForStatement().getBody());
    }

    protected String[] getUsedVariableNames() {
        final ArrayList<String> results = new ArrayList<String>();
        ForStatement forStatement = this.getForStatement();
        CompilationUnit root = (CompilationUnit)forStatement.getRoot();
        Collection variableNames = new ScopeAnalyzer(root).getUsedVariableNames(forStatement.getStartPosition(), forStatement.getLength());
        results.addAll(variableNames);
        forStatement.accept((ASTVisitor)new GenericVisitor(){

            public boolean visit(SingleVariableDeclaration node) {
                results.add(node.getName().getIdentifier());
                return super.visit(node);
            }

            public boolean visit(VariableDeclarationFragment fragment) {
                results.add(fragment.getName().getIdentifier());
                return super.visit(fragment);
            }
        });
        results.addAll(Arrays.asList(this.fUsedNames));
        return results.toArray(new String[results.size()]);
    }
}

