/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.corext.fix;

import org.eclipse.core.runtime.Assert;
import org.eclipse.wst.jsdt.core.ICompilationUnit;
import org.eclipse.wst.jsdt.core.dom.ASTNode;
import org.eclipse.wst.jsdt.core.dom.Expression;
import org.eclipse.wst.jsdt.core.dom.NumberLiteral;
import org.eclipse.wst.jsdt.core.dom.VariableDeclarationFragment;
import org.eclipse.wst.jsdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.wst.jsdt.internal.corext.fix.AbstractSerialVersionOperation;
import org.eclipse.wst.jsdt.internal.corext.fix.LinkedProposalModel;
import org.eclipse.wst.jsdt.internal.corext.fix.LinkedProposalPositionGroup;

public final class SerialVersionDefaultOperation
extends AbstractSerialVersionOperation {
    private static final String GROUP_INITIALIZER = "initializer";

    public SerialVersionDefaultOperation(ICompilationUnit unit, ASTNode[] nodes) {
        super(unit, nodes);
    }

    protected boolean addInitializer(VariableDeclarationFragment fragment, ASTNode declarationNode) {
        Assert.isNotNull((Object)fragment);
        NumberLiteral expression = fragment.getAST().newNumberLiteral("1L");
        if (expression != null) {
            fragment.setInitializer((Expression)expression);
        }
        return true;
    }

    protected void addLinkedPositions(ASTRewrite rewrite, VariableDeclarationFragment fragment, LinkedProposalModel positionGroups) {
        Assert.isNotNull((Object)rewrite);
        Assert.isNotNull((Object)fragment);
        Expression initializer = fragment.getInitializer();
        if (initializer != null) {
            LinkedProposalPositionGroup group = new LinkedProposalPositionGroup(GROUP_INITIALIZER);
            group.addPosition(rewrite.track((ASTNode)initializer), true);
            positionGroups.addPositionGroup(group);
        }
    }
}

