/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.corext.fix;

import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.ltk.core.refactoring.CategorizedTextEditGroup;
import org.eclipse.ltk.core.refactoring.GroupCategory;
import org.eclipse.ltk.core.refactoring.GroupCategorySet;
import org.eclipse.ltk.core.refactoring.TextChange;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.text.edits.TextEditGroup;
import org.eclipse.wst.jsdt.core.IBuffer;
import org.eclipse.wst.jsdt.core.ICompilationUnit;
import org.eclipse.wst.jsdt.core.JavaModelException;
import org.eclipse.wst.jsdt.core.compiler.IProblem;
import org.eclipse.wst.jsdt.core.dom.CompilationUnit;
import org.eclipse.wst.jsdt.core.formatter.IndentManipulation;
import org.eclipse.wst.jsdt.internal.corext.fix.FixMessages;
import org.eclipse.wst.jsdt.internal.corext.fix.IFix;
import org.eclipse.wst.jsdt.internal.corext.refactoring.changes.CompilationUnitChange;
import org.eclipse.wst.jsdt.internal.corext.refactoring.changes.TextChangeCompatibility;
import org.eclipse.wst.jsdt.internal.corext.refactoring.nls.NLSUtil;
import org.eclipse.wst.jsdt.internal.ui.dialogs.StatusInfo;
import org.eclipse.wst.jsdt.internal.ui.text.correction.ProblemLocation;
import org.eclipse.wst.jsdt.ui.text.java.IProblemLocation;

public class StringFix
implements IFix {
    private final TextEditGroup[] fEditGroups;
    private final String fName;
    private final ICompilationUnit fCompilationUnit;

    public static StringFix createFix(CompilationUnit compilationUnit, IProblemLocation problem, boolean removeNLSTag, boolean addNLSTag) throws CoreException {
        String label;
        IBuffer buffer;
        TextEdit addEdit = null;
        ICompilationUnit cu = (ICompilationUnit)compilationUnit.getJavaElement();
        if (addNLSTag) {
            addEdit = NLSUtil.createNLSEdit(cu, problem.getOffset());
        }
        ReplaceEdit removeEdit = null;
        if (removeNLSTag && (buffer = cu.getBuffer()) != null) {
            removeEdit = StringFix.getReplace(problem.getOffset(), problem.getLength(), buffer, true);
        }
        if (addEdit != null && removeEdit != null) {
            label = FixMessages.StringFix_AddRemoveNonNls_description;
            return new StringFix(label, compilationUnit, new TextEditGroup[]{new TextEditGroup(label, addEdit), new TextEditGroup(label, (TextEdit)removeEdit)});
        }
        if (addEdit != null) {
            label = FixMessages.StringFix_AddNonNls_description;
            return new StringFix(label, compilationUnit, new TextEditGroup[]{new TextEditGroup(label, addEdit)});
        }
        if (removeEdit != null) {
            label = FixMessages.StringFix_RemoveNonNls_description;
            return new StringFix(label, compilationUnit, new TextEditGroup[]{new TextEditGroup(label, (TextEdit)removeEdit)});
        }
        return null;
    }

    public static IFix createCleanUp(CompilationUnit compilationUnit, boolean addNLSTag, boolean removeNLSTag) throws CoreException, JavaModelException {
        if (!addNLSTag && !removeNLSTag) {
            return null;
        }
        IProblem[] problems = compilationUnit.getProblems();
        IProblemLocation[] locations = new IProblemLocation[problems.length];
        int i = 0;
        while (i < problems.length) {
            locations[i] = new ProblemLocation(problems[i]);
            ++i;
        }
        return StringFix.createCleanUp(compilationUnit, addNLSTag, removeNLSTag, locations);
    }

    public static IFix createCleanUp(CompilationUnit compilationUnit, IProblemLocation[] problems, boolean addNLSTag, boolean removeNLSTag) throws CoreException, JavaModelException {
        if (!addNLSTag && !removeNLSTag) {
            return null;
        }
        return StringFix.createCleanUp(compilationUnit, addNLSTag, removeNLSTag, problems);
    }

    private static IFix createCleanUp(CompilationUnit compilationUnit, boolean addNLSTag, boolean removeNLSTag, IProblemLocation[] problems) throws CoreException, JavaModelException {
        String label;
        ICompilationUnit cu = (ICompilationUnit)compilationUnit.getJavaElement();
        ArrayList<CategorizedTextEditGroup> result = new ArrayList<CategorizedTextEditGroup>();
        ArrayList<IProblemLocation> missingNLSProblems = new ArrayList<IProblemLocation>();
        int i = 0;
        while (i < problems.length) {
            ReplaceEdit edit;
            IBuffer buffer;
            IProblemLocation problem = problems[i];
            if (addNLSTag && problem.getProblemId() == 536871173) {
                missingNLSProblems.add(problem);
            }
            if (removeNLSTag && problem.getProblemId() == 536871177 && (buffer = cu.getBuffer()) != null && (edit = StringFix.getReplace(problem.getOffset(), problem.getLength(), buffer, false)) != null) {
                label = FixMessages.StringFix_RemoveNonNls_description;
                result.add(new CategorizedTextEditGroup(label, (TextEdit)edit, new GroupCategorySet(new GroupCategory(label, label, label))));
            }
            ++i;
        }
        if (!missingNLSProblems.isEmpty()) {
            int[] positions = new int[missingNLSProblems.size()];
            int i2 = 0;
            Iterator iter = missingNLSProblems.iterator();
            while (iter.hasNext()) {
                IProblemLocation problem = (IProblemLocation)iter.next();
                positions[i2] = problem.getOffset();
                ++i2;
            }
            TextEdit[] edits = NLSUtil.createNLSEdits(cu, positions);
            if (edits != null) {
                int j = 0;
                while (j < edits.length) {
                    label = FixMessages.StringFix_AddNonNls_description;
                    result.add(new CategorizedTextEditGroup(label, edits[j], new GroupCategorySet(new GroupCategory(label, label, label))));
                    ++j;
                }
            }
        }
        if (result.isEmpty()) {
            return null;
        }
        return new StringFix("", compilationUnit, result.toArray(new TextEditGroup[result.size()]));
    }

    private static ReplaceEdit getReplace(int offset, int length, IBuffer buffer, boolean removeLeadingIndents) {
        String replaceString = new String();
        boolean hasMoreInComment = false;
        for (int next = offset + length; next < buffer.getLength(); ++next) {
            char ch = buffer.getChar(next);
            if (IndentManipulation.isIndentChar((char)ch)) {
                continue;
            }
            if (IndentManipulation.isLineDelimiterChar((char)ch)) {
                length = next - offset;
                break;
            }
            if (ch == '/') {
                if (++next == buffer.getLength() || buffer.getChar(next) != '/') {
                    replaceString = "//";
                } else {
                    length = next - offset - 1;
                }
                hasMoreInComment = true;
                break;
            }
            replaceString = "//";
            hasMoreInComment = true;
            break;
        }
        if (!hasMoreInComment && removeLeadingIndents) {
            while (offset > 0 && IndentManipulation.isIndentChar((char)buffer.getChar(offset - 1))) {
                --offset;
                ++length;
            }
        }
        if (length > 0) {
            ReplaceEdit replaceEdit = new ReplaceEdit(offset, length, replaceString);
            return replaceEdit;
        }
        return null;
    }

    private StringFix(String name, CompilationUnit compilationUnit, TextEditGroup[] groups) {
        this.fName = name;
        this.fCompilationUnit = (ICompilationUnit)compilationUnit.getJavaElement();
        this.fEditGroups = groups;
    }

    public TextChange createChange() throws CoreException {
        if (this.fEditGroups == null || this.fEditGroups.length == 0) {
            return null;
        }
        CompilationUnitChange result = new CompilationUnitChange(this.getDescription(), this.getCompilationUnit());
        int i = 0;
        while (i < this.fEditGroups.length) {
            TextEdit[] edits = this.fEditGroups[i].getTextEdits();
            String groupName = this.fEditGroups[i].getName();
            int j = 0;
            while (j < edits.length) {
                TextChangeCompatibility.addTextEdit((TextChange)result, groupName, edits[j]);
                ++j;
            }
            ++i;
        }
        return result;
    }

    public String getDescription() {
        return this.fName;
    }

    public ICompilationUnit getCompilationUnit() {
        return this.fCompilationUnit;
    }

    public IStatus getStatus() {
        return StatusInfo.OK_STATUS;
    }
}

