/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.corext.refactoring;

import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.ltk.core.refactoring.Refactoring;
import org.eclipse.ltk.core.refactoring.RefactoringContribution;
import org.eclipse.ltk.core.refactoring.RefactoringCore;
import org.eclipse.ltk.core.refactoring.RefactoringDescriptor;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.wst.jsdt.core.IJavaElement;
import org.eclipse.wst.jsdt.core.IJavaProject;
import org.eclipse.wst.jsdt.core.IMethod;
import org.eclipse.wst.jsdt.core.JavaCore;
import org.eclipse.wst.jsdt.core.WorkingCopyOwner;
import org.eclipse.wst.jsdt.core.refactoring.descriptors.JavaRefactoringDescriptor;
import org.eclipse.wst.jsdt.internal.corext.refactoring.JDTRefactoringContribution;
import org.eclipse.wst.jsdt.internal.corext.refactoring.JavaRefactoringArguments;
import org.eclipse.wst.jsdt.internal.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.wst.jsdt.internal.corext.refactoring.tagging.IScriptableRefactoring;
import org.eclipse.wst.jsdt.internal.corext.util.Messages;

public class JDTRefactoringDescriptor
extends JavaRefactoringDescriptor {
    public static final String ATTRIBUTE_ELEMENT = "element";
    public static final String ATTRIBUTE_INPUT = "input";
    public static final String ATTRIBUTE_NAME = "name";
    public static final String ATTRIBUTE_REFERENCES = "references";
    public static final String ATTRIBUTE_SELECTION = "selection";
    public static final int DEPRECATION_RESOLVING = 131072;

    public static String elementToHandle(String project, IJavaElement element) {
        String handle = element.getHandleIdentifier();
        if (project != null && !(element instanceof IJavaProject)) {
            String id = element.getJavaProject().getHandleIdentifier();
            return handle.substring(id.length());
        }
        return handle;
    }

    public static IJavaElement handleToElement(String project, String handle) {
        return JDTRefactoringDescriptor.handleToElement(project, handle, true);
    }

    public static IJavaElement handleToElement(String project, String handle, boolean check) {
        return JDTRefactoringDescriptor.handleToElement(null, project, handle, check);
    }

    public static IJavaElement handleToElement(WorkingCopyOwner owner, String project, String handle, boolean check) {
        IJavaElement element = null;
        element = owner != null ? JavaCore.create((String)handle, (WorkingCopyOwner)owner) : JavaCore.create((String)handle);
        if (element == null && project != null) {
            IJavaProject javaProject = JavaCore.create((IWorkspaceRoot)ResourcesPlugin.getWorkspace().getRoot()).getJavaProject(project);
            String identifier = javaProject.getHandleIdentifier();
            element = owner != null ? JavaCore.create((String)(String.valueOf(identifier) + handle), (WorkingCopyOwner)owner) : JavaCore.create((String)(String.valueOf(identifier) + handle));
        }
        if (check && element instanceof IMethod) {
            IMethod method = (IMethod)element;
            IMethod[] methods = null;
            methods = method.getDeclaringType() != null ? method.getDeclaringType().findMethods(method) : method.getCompilationUnit().findMethods(method);
            if (methods != null && methods.length > 0) {
                element = methods[0];
            }
        }
        if (element != null && (!check || element.exists())) {
            return element;
        }
        return null;
    }

    public static IResource handleToResource(String project, String handle) {
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        if ("".equals(handle)) {
            return null;
        }
        IPath path = Path.fromPortableString((String)handle);
        if (path == null) {
            return null;
        }
        if (project != null && !"".equals(project)) {
            return root.getProject(project).findMember(path);
        }
        return root.findMember(path);
    }

    public static String resourceToHandle(String project, IResource resource) {
        if (project != null && !"".equals(project)) {
            return resource.getProjectRelativePath().toPortableString();
        }
        return resource.getFullPath().toPortableString();
    }

    public JDTRefactoringDescriptor(String id, String project, String description, String comment, Map arguments, int flags) {
        super(id, arguments);
        this.setProject(project);
        this.setDescription(description);
        this.setComment(comment);
        this.setFlags(flags);
    }

    public JavaRefactoringArguments createArguments() {
        JavaRefactoringArguments arguments = new JavaRefactoringArguments(this.getProject());
        Iterator iterator = this.getArguments().entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            String name = (String)entry.getKey();
            String value = (String)entry.getValue();
            if (name == null || "".equals(name) || value == null) continue;
            arguments.setAttribute(name, value);
        }
        return arguments;
    }

    public Refactoring createRefactoring(RefactoringStatus status) throws CoreException {
        Refactoring refactoring = null;
        RefactoringContribution contribution = RefactoringCore.getRefactoringContribution((String)this.getID());
        if (contribution instanceof JDTRefactoringContribution) {
            JDTRefactoringContribution extended = (JDTRefactoringContribution)contribution;
            refactoring = extended.createRefactoring((RefactoringDescriptor)this);
        }
        if (refactoring != null) {
            if (refactoring instanceof IScriptableRefactoring) {
                JavaRefactoringArguments arguments = this.createArguments();
                if (arguments != null) {
                    status.merge(((IScriptableRefactoring)refactoring).initialize(arguments));
                } else {
                    status.merge(RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.InitializableRefactoring_inacceptable_arguments));
                }
            } else {
                status.merge(RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.JavaRefactoringDescriptor_initialization_error, this.getID())));
            }
        }
        return refactoring;
    }

    public String elementToHandle(IJavaElement element) {
        Assert.isNotNull((Object)element);
        return JDTRefactoringDescriptor.elementToHandle(this.getProject(), element);
    }

    public Map getArguments() {
        return super.getArguments();
    }

    public String resourceToHandle(IResource resource) {
        Assert.isNotNull((Object)resource);
        return JDTRefactoringDescriptor.resourceToHandle(this.getProject(), resource);
    }
}

