/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.corext.refactoring.binary;

import java.util.ArrayList;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.wst.jsdt.core.Flags;
import org.eclipse.wst.jsdt.core.IField;
import org.eclipse.wst.jsdt.core.IJavaElement;
import org.eclipse.wst.jsdt.core.IMember;
import org.eclipse.wst.jsdt.core.IMethod;
import org.eclipse.wst.jsdt.core.IType;
import org.eclipse.wst.jsdt.core.ITypeParameter;
import org.eclipse.wst.jsdt.core.JavaModelException;
import org.eclipse.wst.jsdt.core.Signature;
import org.eclipse.wst.jsdt.internal.corext.refactoring.Checks;
import org.eclipse.wst.jsdt.internal.corext.refactoring.RefactoringCoreMessages;

public class StubCreator {
    protected StringBuffer fBuffer;
    protected final boolean fStubInvisible;

    public StubCreator(boolean stubInvisible) {
        this.fStubInvisible = stubInvisible;
    }

    protected void appendEnumConstants(IType type) throws JavaModelException {
        IField[] fields = type.getFields();
        ArrayList<IField> list = new ArrayList<IField>(fields.length);
        int index = 0;
        while (index < fields.length) {
            IField field = fields[index];
            if (Flags.isEnum((int)field.getFlags())) {
                list.add(field);
            }
            ++index;
        }
        index = 0;
        while (index < list.size()) {
            if (index > 0) {
                this.fBuffer.append(",");
            }
            this.fBuffer.append(((IField)list.get(index)).getElementName());
            ++index;
        }
        this.fBuffer.append(";");
    }

    protected void appendExpression(String signature) {
        switch (signature.charAt(0)) {
            case 'Z': {
                this.fBuffer.append("false");
                break;
            }
            case 'B': 
            case 'C': 
            case 'D': 
            case 'F': 
            case 'I': 
            case 'J': 
            case 'S': {
                this.fBuffer.append("0");
                break;
            }
            default: {
                this.fBuffer.append("(");
                this.fBuffer.append(Signature.toString((String)signature));
                this.fBuffer.append(")");
                this.fBuffer.append("null");
            }
        }
    }

    protected void appendFieldDeclaration(IField field) throws JavaModelException {
        this.appendFlags((IMember)field);
        this.fBuffer.append(" ");
        String signature = field.getTypeSignature();
        this.fBuffer.append(Signature.toString((String)signature));
        this.fBuffer.append(" ");
        this.fBuffer.append(field.getElementName());
        if (Flags.isFinal((int)field.getFlags())) {
            this.fBuffer.append("=");
            this.appendExpression(signature);
        }
        this.fBuffer.append(";");
    }

    protected void appendFlags(IMember member) throws JavaModelException {
        int flags = member.getFlags();
        int kind = member.getElementType();
        if (kind == 7) {
            flags &= 0xFFFFFFDF;
            IType type = (IType)member;
            if (!type.isMember()) {
                flags &= 0xFFFFFFFD;
            }
        }
        if (Flags.isEnum((int)flags)) {
            flags &= 0xFFFFFFEF;
        }
        if (kind == 9) {
            flags &= 0xFFFFFF7F;
            flags &= 0xFFFFFFBF;
        }
        if (flags != 0) {
            this.fBuffer.append(Flags.toString((int)flags));
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void appendMembers(IType type, IProgressMonitor monitor) throws JavaModelException {
        try {
            monitor.beginTask(RefactoringCoreMessages.StubCreationOperation_creating_type_stubs, 1);
            IJavaElement[] children = type.getChildren();
            int index = 0;
            while (index < children.length) {
                block15: {
                    block13: {
                        boolean skip;
                        int count;
                        boolean stub;
                        int flags;
                        IMember child;
                        block14: {
                            block12: {
                                child = (IMember)children[index];
                                flags = child.getFlags();
                                boolean isPrivate = Flags.isPrivate((int)flags);
                                boolean isDefault = !Flags.isPublic((int)flags) && !Flags.isProtected((int)flags) && !isPrivate;
                                boolean bl = stub = this.fStubInvisible || !isPrivate && !isDefault;
                                if (!(child instanceof IType)) break block12;
                                if (stub) {
                                    this.appendTypeDeclaration((IType)child, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                                }
                                break block13;
                            }
                            if (!(child instanceof IField)) break block14;
                            if (stub && !Flags.isEnum((int)flags) && !Flags.isSynthetic((int)flags)) {
                                this.appendFieldDeclaration((IField)child);
                            }
                            break block13;
                        }
                        if (!(child instanceof IMethod)) break block13;
                        IMethod method = (IMethod)child;
                        String name = method.getElementName();
                        if (method.getDeclaringType() != null && method.getDeclaringType().isEnum() && ((count = method.getNumberOfParameters()) == 0 && "values".equals(name) || count == 1 && "valueOf".equals(name) && "Ljava.lang.String;".equals(method.getParameterTypes()[0]) || method.isConstructor())) break block15;
                        boolean bl = skip = !stub || name.equals("<clinit>");
                        if (method.isConstructor()) {
                            skip = false;
                        }
                        boolean bl2 = skip = skip || Flags.isSynthetic((int)flags) || Flags.isBridge((int)flags);
                        if (!skip) {
                            this.appendMethodDeclaration(method);
                        }
                    }
                    this.fBuffer.append("\n");
                }
                ++index;
            }
        }
        catch (Throwable throwable) {
            Object var13_14 = null;
            monitor.done();
            throw throwable;
        }
        {
            Object var13_15 = null;
        }
        monitor.done();
    }

    protected void appendMethodBody(IMethod method) throws JavaModelException {
        if (method.isConstructor()) {
            IType declaringType = method.getDeclaringType();
            String superSignature = declaringType.getSuperclassTypeSignature();
            if (superSignature != null) {
                superSignature = Signature.getTypeErasure((String)superSignature);
                IType superclass = declaringType.getJavaProject().findType(Signature.getSignatureQualifier((String)superSignature), Signature.getSignatureSimpleName((String)superSignature));
                if (superclass != null) {
                    String[] superParameters;
                    int paramLength;
                    IMethod[] superMethods = superclass.getMethods();
                    IMethod superConstructor = null;
                    int length = superMethods.length;
                    int index = 0;
                    while (index < length) {
                        IMethod superMethod = superMethods[index];
                        if (superMethod.isConstructor() && !Flags.isPrivate((int)superMethod.getFlags()) && (superConstructor = superMethod).getExceptionTypes().length == 0) break;
                        ++index;
                    }
                    if (superConstructor != null && (paramLength = (superParameters = superConstructor.getParameterTypes()).length) != 0) {
                        this.fBuffer.append("super(");
                        int index2 = 0;
                        while (index2 < paramLength) {
                            if (index2 > 0) {
                                this.fBuffer.append(",");
                            }
                            this.appendExpression(superParameters[index2]);
                            ++index2;
                        }
                        this.fBuffer.append(");");
                    }
                }
            }
        } else {
            String returnType = method.getReturnType();
            if (!"V".equals(returnType)) {
                this.fBuffer.append("return ");
                this.appendExpression(returnType);
                this.fBuffer.append(";");
            }
        }
    }

    protected void appendMethodDeclaration(IMethod method) throws JavaModelException {
        this.appendFlags((IMember)method);
        this.fBuffer.append(" ");
        String returnType = method.getReturnType();
        if (!method.isConstructor()) {
            this.fBuffer.append(Signature.toString((String)returnType));
            this.fBuffer.append(" ");
            ITypeParameter[] parameters = method.getTypeParameters();
            if (parameters.length > 0) {
                this.appendTypeParameters(parameters);
                this.fBuffer.append(" ");
            }
        }
        this.fBuffer.append(method.getElementName());
        this.fBuffer.append("(");
        String[] parameterTypes = method.getParameterTypes();
        int flags = method.getFlags();
        boolean varargs = Flags.isVarargs((int)flags);
        int parameterLength = parameterTypes.length;
        int index = 0;
        while (index < parameterLength) {
            if (index > 0) {
                this.fBuffer.append(",");
            }
            this.fBuffer.append(Signature.toString((String)parameterTypes[index]));
            if (varargs && index == parameterLength - 1) {
                int length = this.fBuffer.length();
                if (length >= 2 && this.fBuffer.indexOf("[]", length - 2) >= 0) {
                    this.fBuffer.setLength(length - 2);
                }
                this.fBuffer.append("...");
            }
            this.fBuffer.append(" ");
            this.appendMethodParameterName(method, index);
            ++index;
        }
        this.fBuffer.append(")");
        String[] exceptionTypes = method.getExceptionTypes();
        int exceptionLength = exceptionTypes.length;
        if (exceptionLength > 0) {
            this.fBuffer.append(" throws ");
        }
        int index2 = 0;
        while (index2 < exceptionLength) {
            if (index2 > 0) {
                this.fBuffer.append(",");
            }
            this.fBuffer.append(Signature.toString((String)exceptionTypes[index2]));
            ++index2;
        }
        if (Flags.isAbstract((int)flags) || Flags.isNative((int)flags)) {
            this.fBuffer.append(";");
        } else {
            this.fBuffer.append("{\n");
            this.appendMethodBody(method);
            this.fBuffer.append("}");
        }
    }

    protected void appendMethodParameterName(IMethod method, int index) {
        this.fBuffer.append("a");
        this.fBuffer.append(index);
    }

    protected void appendSuperInterfaceTypes(IType type) throws JavaModelException {
        String[] signatures = type.getSuperInterfaceTypeSignatures();
        if (signatures.length > 0) {
            if (type.isInterface()) {
                this.fBuffer.append(" extends ");
            } else {
                this.fBuffer.append(" implements ");
            }
        }
        int index = 0;
        while (index < signatures.length) {
            if (index > 0) {
                this.fBuffer.append(",");
            }
            this.fBuffer.append(Signature.toString((String)signatures[index]));
            ++index;
        }
    }

    protected void appendTopLevelType(IType type, IProgressMonitor subProgressMonitor) throws JavaModelException {
        String packageName = type.getPackageFragment().getElementName();
        if (packageName.length() > 0) {
            this.fBuffer.append("package ");
            this.fBuffer.append(packageName);
            this.fBuffer.append(";\n");
        }
        this.appendTypeDeclaration(type, subProgressMonitor);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void appendTypeDeclaration(IType type, IProgressMonitor monitor) throws JavaModelException {
        try {
            monitor.beginTask(RefactoringCoreMessages.StubCreationOperation_creating_type_stubs, 1);
            if (type.isInterface()) {
                this.appendFlags((IMember)type);
                this.fBuffer.append(" interface ");
                this.fBuffer.append(type.getElementName());
                this.appendTypeParameters(type.getTypeParameters());
                this.appendSuperInterfaceTypes(type);
                this.fBuffer.append("{\n");
                this.appendMembers(type, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                this.fBuffer.append("}");
            } else if (type.isClass()) {
                this.appendFlags((IMember)type);
                this.fBuffer.append(" class ");
                this.fBuffer.append(type.getElementName());
                this.appendTypeParameters(type.getTypeParameters());
                String signature = type.getSuperclassTypeSignature();
                if (signature != null) {
                    this.fBuffer.append(" extends ");
                    this.fBuffer.append(Signature.toString((String)signature));
                }
                this.appendSuperInterfaceTypes(type);
                this.fBuffer.append("{\n");
                this.appendMembers(type, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                this.fBuffer.append("}");
            } else if (type.isAnnotation()) {
                this.appendFlags((IMember)type);
                this.fBuffer.append(" @interface ");
                this.fBuffer.append(type.getElementName());
                this.fBuffer.append("{\n");
                this.appendMembers(type, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                this.fBuffer.append("}");
            } else if (type.isEnum()) {
                this.appendFlags((IMember)type);
                this.fBuffer.append(" enum ");
                this.fBuffer.append(type.getElementName());
                this.appendSuperInterfaceTypes(type);
                this.fBuffer.append("{\n");
                this.appendEnumConstants(type);
                this.appendMembers(type, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                this.fBuffer.append("}");
            }
            Object var4_6 = null;
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            monitor.done();
            throw throwable;
        }
        monitor.done();
    }

    protected void appendTypeParameters(ITypeParameter[] parameters) throws JavaModelException {
        int length = parameters.length;
        if (length > 0) {
            this.fBuffer.append("<");
        }
        int index = 0;
        while (index < length) {
            if (index > 0) {
                this.fBuffer.append(",");
            }
            ITypeParameter parameter = parameters[index];
            this.fBuffer.append(parameter.getElementName());
            String[] bounds = parameter.getBounds();
            int size = bounds.length;
            if (size > 0) {
                this.fBuffer.append(" extends ");
            }
            int offset = 0;
            while (offset < size) {
                if (offset > 0) {
                    this.fBuffer.append(" & ");
                }
                this.fBuffer.append(bounds[offset]);
                ++offset;
            }
            ++index;
        }
        if (length > 0) {
            this.fBuffer.append(">");
        }
    }

    public String createStub(IType topLevelType, IProgressMonitor monitor) throws JavaModelException {
        Assert.isTrue((boolean)Checks.isTopLevel(topLevelType));
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        this.fBuffer = new StringBuffer(2046);
        this.appendTopLevelType(topLevelType, monitor);
        String result = this.fBuffer.toString();
        this.fBuffer = null;
        return result;
    }
}

