/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.corext.refactoring.changes;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.NullChange;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ui.ide.undo.ResourceDescription;
import org.eclipse.wst.jsdt.core.ICompilationUnit;
import org.eclipse.wst.jsdt.core.IJavaElement;
import org.eclipse.wst.jsdt.core.IPackageFragment;
import org.eclipse.wst.jsdt.core.ISourceManipulation;
import org.eclipse.wst.jsdt.core.JavaCore;
import org.eclipse.wst.jsdt.internal.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.wst.jsdt.internal.corext.refactoring.changes.AbstractDeleteChange;
import org.eclipse.wst.jsdt.internal.corext.refactoring.changes.UndoDeleteResourceChange;
import org.eclipse.wst.jsdt.internal.corext.refactoring.util.JavaElementUtil;
import org.eclipse.wst.jsdt.internal.corext.util.Messages;

public class DeleteSourceManipulationChange
extends AbstractDeleteChange {
    private final String fHandle;
    private final boolean fIsExecuteChange;

    public DeleteSourceManipulationChange(ISourceManipulation sm, boolean isExecuteChange) {
        Assert.isNotNull((Object)sm);
        this.fHandle = DeleteSourceManipulationChange.getJavaElement(sm).getHandleIdentifier();
        this.fIsExecuteChange = isExecuteChange;
    }

    public String getName() {
        return Messages.format(RefactoringCoreMessages.DeleteSourceManipulationChange_0, this.getElementName());
    }

    public RefactoringStatus isValid(IProgressMonitor pm) throws CoreException {
        ISourceManipulation element = this.getSourceManipulation();
        if (this.fIsExecuteChange) {
            if (element instanceof ICompilationUnit) {
                return super.isValid(pm, 0);
            }
            return super.isValid(pm, 2);
        }
        return super.isValid(pm, 3);
    }

    private String getElementName() {
        IJavaElement javaElement = DeleteSourceManipulationChange.getJavaElement(this.getSourceManipulation());
        if (JavaElementUtil.isDefaultPackage(javaElement)) {
            return RefactoringCoreMessages.DeleteSourceManipulationChange_1;
        }
        return javaElement.getElementName();
    }

    public Object getModifiedElement() {
        return JavaCore.create((String)this.fHandle);
    }

    protected Change doDelete(IProgressMonitor pm) throws CoreException {
        ISourceManipulation element = this.getSourceManipulation();
        if (element instanceof ICompilationUnit) {
            pm.beginTask("", 2);
            ICompilationUnit unit = (ICompilationUnit)element;
            DeleteSourceManipulationChange.saveCUnitIfNeeded(unit, (IProgressMonitor)new SubProgressMonitor(pm, 1));
            IResource resource = unit.getResource();
            ResourceDescription resourceDescription = ResourceDescription.fromResource((IResource)resource);
            element.delete(false, (IProgressMonitor)new SubProgressMonitor(pm, 1));
            resourceDescription.recordStateFromHistory(resource, (IProgressMonitor)new SubProgressMonitor(pm, 1));
            return new UndoDeleteResourceChange(resourceDescription);
        }
        if (element instanceof IPackageFragment) {
            ICompilationUnit[] units = ((IPackageFragment)element).getCompilationUnits();
            pm.beginTask("", units.length + 1);
            int i = 0;
            while (i < units.length) {
                DeleteSourceManipulationChange.saveCUnitIfNeeded(units[i], (IProgressMonitor)new SubProgressMonitor(pm, 1));
                ++i;
            }
            element.delete(false, (IProgressMonitor)new SubProgressMonitor(pm, 1));
            return new NullChange();
        }
        element.delete(false, pm);
        return null;
    }

    private ISourceManipulation getSourceManipulation() {
        return (ISourceManipulation)this.getModifiedElement();
    }

    private static IJavaElement getJavaElement(ISourceManipulation sm) {
        return (IJavaElement)sm;
    }

    private static void saveCUnitIfNeeded(ICompilationUnit unit, IProgressMonitor pm) throws CoreException {
        DeleteSourceManipulationChange.saveFileIfNeeded((IFile)unit.getResource(), pm);
    }
}

