/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.corext.refactoring.changes;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.mapping.ResourceMapping;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.participants.ReorgExecutionLog;
import org.eclipse.wst.jsdt.core.IJavaProject;
import org.eclipse.wst.jsdt.core.IPackageFragmentRoot;
import org.eclipse.wst.jsdt.core.JavaCore;
import org.eclipse.wst.jsdt.core.JavaModelException;
import org.eclipse.wst.jsdt.internal.corext.refactoring.base.JDTChange;
import org.eclipse.wst.jsdt.internal.corext.refactoring.changes.Utils;
import org.eclipse.wst.jsdt.internal.corext.refactoring.reorg.INewNameQuery;
import org.eclipse.wst.jsdt.internal.corext.refactoring.reorg.IPackageFragmentRootManipulationQuery;
import org.eclipse.wst.jsdt.internal.corext.refactoring.util.JavaElementUtil;
import org.eclipse.wst.jsdt.internal.corext.util.JavaElementResourceMapping;

abstract class PackageFragmentRootReorgChange
extends JDTChange {
    private final String fRootHandle;
    private final IPath fDestinationPath;
    private final INewNameQuery fNewNameQuery;
    private final IPackageFragmentRootManipulationQuery fUpdateClasspathQuery;
    static /* synthetic */ Class class$0;

    PackageFragmentRootReorgChange(IPackageFragmentRoot root, IProject destination, INewNameQuery newNameQuery, IPackageFragmentRootManipulationQuery updateClasspathQuery) {
        Assert.isTrue((!root.isExternal() ? 1 : 0) != 0);
        this.fRootHandle = root.getHandleIdentifier();
        this.fDestinationPath = Utils.getResourcePath((IResource)destination);
        this.fNewNameQuery = newNameQuery;
        this.fUpdateClasspathQuery = updateClasspathQuery;
    }

    public RefactoringStatus isValid(IProgressMonitor pm) throws CoreException {
        return this.isValid(pm, 0);
    }

    public final Change perform(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        Change change;
        pm.beginTask(this.getName(), 2);
        try {
            String newName = this.getNewResourceName();
            IPackageFragmentRoot root = this.getRoot();
            ResourceMapping mapping = JavaElementResourceMapping.create(root);
            Change result = this.doPerformReorg(this.getDestinationProjectPath().append(newName), (IProgressMonitor)new SubProgressMonitor(pm, 1));
            this.markAsExecuted(root, mapping);
            change = result;
            Object var6_7 = null;
        }
        catch (Throwable throwable) {
            Object var6_8 = null;
            pm.done();
            throw throwable;
        }
        pm.done();
        return change;
    }

    protected abstract Change doPerformReorg(IPath var1, IProgressMonitor var2) throws JavaModelException;

    public Object getModifiedElement() {
        return this.getRoot();
    }

    protected IPackageFragmentRoot getRoot() {
        return (IPackageFragmentRoot)JavaCore.create((String)this.fRootHandle);
    }

    protected IPath getDestinationProjectPath() {
        return this.fDestinationPath;
    }

    protected IProject getDestinationProject() {
        return Utils.getProject(this.getDestinationProjectPath());
    }

    private String getNewResourceName() throws OperationCanceledException {
        if (this.fNewNameQuery == null) {
            return this.getRoot().getElementName();
        }
        String name = this.fNewNameQuery.getNewName();
        if (name == null) {
            return this.getRoot().getElementName();
        }
        return name;
    }

    protected int getUpdateModelFlags(boolean isCopy) throws JavaModelException {
        int otherProjects;
        int originating;
        if (isCopy) {
            originating = 0;
            otherProjects = 0;
        } else {
            originating = 2;
            otherProjects = 4;
        }
        if (!JavaCore.create((IProject)this.getDestinationProject()).exists()) {
            return 0x10 | originating;
        }
        if (this.fUpdateClasspathQuery == null) {
            return 0x10 | originating | 8;
        }
        IJavaProject[] referencingProjects = JavaElementUtil.getReferencingProjects(this.getRoot());
        if (referencingProjects.length <= 1) {
            return 0x10 | originating | 8;
        }
        boolean updateOtherProjectsToo = this.fUpdateClasspathQuery.confirmManipulation(this.getRoot(), referencingProjects);
        if (updateOtherProjectsToo) {
            return 0x10 | originating | 8 | otherProjects;
        }
        return 0x10 | originating | 8;
    }

    protected int getResourceUpdateFlags() {
        return 34;
    }

    private void markAsExecuted(IPackageFragmentRoot root, ResourceMapping mapping) {
        ReorgExecutionLog log;
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.ltk.core.refactoring.participants.ReorgExecutionLog");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((log = (ReorgExecutionLog)this.getAdapter(clazz)) != null) {
            log.markAsProcessed((Object)root);
            log.markAsProcessed((Object)mapping);
        }
    }
}

