/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.corext.refactoring.delegates;

import java.util.ArrayList;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.ltk.core.refactoring.CategorizedTextEditGroup;
import org.eclipse.ltk.core.refactoring.GroupCategory;
import org.eclipse.ltk.core.refactoring.GroupCategorySet;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.text.edits.TextEditGroup;
import org.eclipse.wst.jsdt.core.JavaModelException;
import org.eclipse.wst.jsdt.core.dom.AST;
import org.eclipse.wst.jsdt.core.dom.ASTNode;
import org.eclipse.wst.jsdt.core.dom.AbstractTypeDeclaration;
import org.eclipse.wst.jsdt.core.dom.AnonymousClassDeclaration;
import org.eclipse.wst.jsdt.core.dom.BodyDeclaration;
import org.eclipse.wst.jsdt.core.dom.ChildListPropertyDescriptor;
import org.eclipse.wst.jsdt.core.dom.ChildPropertyDescriptor;
import org.eclipse.wst.jsdt.core.dom.Expression;
import org.eclipse.wst.jsdt.core.dom.IBinding;
import org.eclipse.wst.jsdt.core.dom.ITypeBinding;
import org.eclipse.wst.jsdt.core.dom.Javadoc;
import org.eclipse.wst.jsdt.core.dom.Name;
import org.eclipse.wst.jsdt.core.dom.StructuralPropertyDescriptor;
import org.eclipse.wst.jsdt.core.dom.TagElement;
import org.eclipse.wst.jsdt.core.dom.TextElement;
import org.eclipse.wst.jsdt.core.dom.Type;
import org.eclipse.wst.jsdt.core.dom.rewrite.ITrackedNodePosition;
import org.eclipse.wst.jsdt.core.dom.rewrite.ListRewrite;
import org.eclipse.wst.jsdt.internal.corext.codemanipulation.CodeGenerationSettings;
import org.eclipse.wst.jsdt.internal.corext.dom.ASTNodeFactory;
import org.eclipse.wst.jsdt.internal.corext.dom.ASTNodes;
import org.eclipse.wst.jsdt.internal.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.wst.jsdt.internal.corext.refactoring.structure.CompilationUnitRewrite;
import org.eclipse.wst.jsdt.internal.corext.util.Strings;
import org.eclipse.wst.jsdt.internal.ui.JavaPlugin;
import org.eclipse.wst.jsdt.internal.ui.preferences.JavaPreferencesSettings;

public abstract class DelegateCreator {
    public static final GroupCategorySet CATEGORY_DELEGATE = new GroupCategorySet(new GroupCategory("org.eclipse.wst.jsdt.internal.corext.refactoring.delegates.delegate", RefactoringCoreMessages.DelegateCreator_change_category_title, RefactoringCoreMessages.DelegateCreator_change_category_description));
    private CompilationUnitRewrite fOriginalRewrite;
    private CompilationUnitRewrite fDelegateRewrite;
    private boolean fIsMoveToAnotherFile;
    private boolean fCopy = true;
    private boolean fDeclareDeprecated = true;
    private boolean fInsertBefore = false;
    private BodyDeclaration fDeclaration;
    private String fNewElementName;
    private ITypeBinding fDestinationTypeBinding;
    private Type fDestinationType;
    private ITrackedNodePosition fTrackedPosition;
    private CodeGenerationSettings fPreferences;

    public void setSourceRewrite(CompilationUnitRewrite rewrite) {
        this.fOriginalRewrite = rewrite;
        this.fPreferences = JavaPreferencesSettings.getCodeGenerationSettings(rewrite.getCu().getJavaProject());
        this.fDelegateRewrite = new CompilationUnitRewrite(rewrite.getCu(), rewrite.getRoot());
        this.fDelegateRewrite.getASTRewrite().setTargetSourceRangeComputer(rewrite.getASTRewrite().getExtendedSourceRangeComputer());
    }

    public void setDeclaration(BodyDeclaration declaration) {
        this.fDeclaration = declaration;
    }

    public void setNewElementName(String newName) {
        this.fNewElementName = newName;
    }

    public void setNewLocation(ITypeBinding binding) {
        this.fDestinationTypeBinding = binding;
    }

    public void setCopy(boolean isCopy) {
        this.fCopy = isCopy;
    }

    public void setDeclareDeprecated(boolean declareDeprecated) {
        this.fDeclareDeprecated = declareDeprecated;
    }

    public void setInsertBefore(boolean insertBefore) {
        this.fInsertBefore = insertBefore;
    }

    protected abstract void initialize();

    protected abstract ASTNode createBody(BodyDeclaration var1) throws JavaModelException;

    protected abstract ASTNode createDocReference(BodyDeclaration var1) throws JavaModelException;

    protected abstract ASTNode getBodyHead(BodyDeclaration var1);

    protected abstract ChildPropertyDescriptor getJavaDocProperty();

    protected abstract ChildPropertyDescriptor getBodyProperty();

    protected boolean isMoveToAnotherFile() {
        return this.fIsMoveToAnotherFile;
    }

    protected AST getAst() {
        return this.fDelegateRewrite.getAST();
    }

    protected BodyDeclaration getDeclaration() {
        return this.fDeclaration;
    }

    protected String getNewElementName() {
        return this.fNewElementName;
    }

    public void prepareDelegate() throws JavaModelException {
        Assert.isNotNull((Object)this.fDelegateRewrite);
        Assert.isNotNull((Object)this.fDeclaration);
        this.initialize();
        if (this.fDestinationTypeBinding != null) {
            this.fDestinationType = this.fOriginalRewrite.getImportRewrite().addImport(this.fDestinationTypeBinding, this.getAst());
            this.fIsMoveToAnotherFile = true;
        } else {
            this.fIsMoveToAnotherFile = false;
        }
        this.fTrackedPosition = this.fDelegateRewrite.getASTRewrite().track((ASTNode)this.fDeclaration);
        ASTNode delegateBody = this.createBody(this.fDeclaration);
        if (delegateBody != null) {
            this.fDelegateRewrite.getASTRewrite().set(this.getBodyHead(this.fDeclaration), (StructuralPropertyDescriptor)this.getBodyProperty(), (Object)delegateBody, null);
        }
        if (this.fDeclareDeprecated) {
            this.createJavadoc();
        }
    }

    private void createJavadoc() throws JavaModelException {
        TagElement tag = this.getDelegateJavadocTag(this.fDeclaration);
        Javadoc comment = this.fDeclaration.getJavadoc();
        if (comment == null) {
            comment = this.getAst().newJavadoc();
            comment.tags().add(tag);
            this.fDelegateRewrite.getASTRewrite().set((ASTNode)this.fDeclaration, (StructuralPropertyDescriptor)this.getJavaDocProperty(), (Object)comment, null);
        } else {
            this.fDelegateRewrite.getASTRewrite().getListRewrite((ASTNode)comment, Javadoc.TAGS_PROPERTY).insertLast((ASTNode)tag, null);
        }
    }

    public void createEdit() throws JavaModelException {
        try {
            Document document = new Document(this.fDelegateRewrite.getCu().getBuffer().getContents());
            TextEdit edit = this.fDelegateRewrite.getASTRewrite().rewriteAST((IDocument)document, this.fDelegateRewrite.getCu().getJavaProject().getOptions(true));
            edit.apply((IDocument)document, 2);
            String newSource = Strings.trimIndentation(document.get(this.fTrackedPosition.getStartPosition(), this.fTrackedPosition.getLength()), this.fPreferences.tabWidth, this.fPreferences.indentWidth, false);
            ASTNode placeholder = this.fOriginalRewrite.getASTRewrite().createStringPlaceholder(newSource, this.fDeclaration.getNodeType());
            CategorizedTextEditGroup groupDescription = this.fOriginalRewrite.createCategorizedGroupDescription(this.getTextEditGroupLabel(), CATEGORY_DELEGATE);
            ListRewrite bodyDeclarationsListRewrite = this.fOriginalRewrite.getASTRewrite().getListRewrite(this.fDeclaration.getParent(), this.getTypeBodyDeclarationsProperty());
            if (this.fCopy) {
                if (this.fInsertBefore) {
                    bodyDeclarationsListRewrite.insertBefore(placeholder, (ASTNode)this.fDeclaration, (TextEditGroup)groupDescription);
                } else {
                    bodyDeclarationsListRewrite.insertAfter(placeholder, (ASTNode)this.fDeclaration, (TextEditGroup)groupDescription);
                }
            } else {
                bodyDeclarationsListRewrite.replace((ASTNode)this.fDeclaration, placeholder, (TextEditGroup)groupDescription);
            }
        }
        catch (BadLocationException e) {
            JavaPlugin.log(e);
        }
    }

    protected abstract String getTextEditGroupLabel();

    protected abstract IBinding getDeclarationBinding();

    public CompilationUnitRewrite getDelegateRewrite() {
        return this.fDelegateRewrite;
    }

    private TagElement getDelegateJavadocTag(BodyDeclaration declaration) throws JavaModelException {
        Assert.isNotNull((Object)declaration);
        String msg = RefactoringCoreMessages.DelegateCreator_use_member_instead;
        int firstParam = msg.indexOf("{0}");
        Assert.isTrue((firstParam != -1 ? 1 : 0) != 0);
        ArrayList<Object> fragments = new ArrayList<Object>();
        TextElement text = this.getAst().newTextElement();
        text.setText(msg.substring(0, firstParam).trim());
        fragments.add(text);
        fragments.add(this.createJavadocMemberReferenceTag(declaration, this.getAst()));
        text = this.getAst().newTextElement();
        text.setText(msg.substring(firstParam + 3).trim());
        fragments.add(text);
        TagElement tag = this.getAst().newTagElement();
        tag.setTagName("@deprecated");
        tag.fragments().addAll(fragments);
        return tag;
    }

    private TagElement createJavadocMemberReferenceTag(BodyDeclaration declaration, AST ast) throws JavaModelException {
        Assert.isNotNull((Object)ast);
        Assert.isNotNull((Object)declaration);
        ASTNode javadocReference = this.createDocReference(declaration);
        TagElement element = ast.newTagElement();
        element.setTagName("@link");
        element.fragments().add(javadocReference);
        return element;
    }

    protected Expression getAccess() {
        return this.isMoveToAnotherFile() ? this.createDestinationTypeName() : null;
    }

    protected Name createDestinationTypeName() {
        return ASTNodeFactory.newName(this.getAst(), ASTNodes.asString((ASTNode)this.fDestinationType));
    }

    private ChildListPropertyDescriptor getTypeBodyDeclarationsProperty() {
        ASTNode parent = this.fDeclaration.getParent();
        if (parent instanceof AbstractTypeDeclaration) {
            return ((AbstractTypeDeclaration)parent).getBodyDeclarationsProperty();
        }
        if (parent instanceof AnonymousClassDeclaration) {
            return AnonymousClassDeclaration.BODY_DECLARATIONS_PROPERTY;
        }
        Assert.isTrue((boolean)false);
        return null;
    }
}

