/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.corext.refactoring.generics;

import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.wst.jsdt.core.ICompilationUnit;
import org.eclipse.wst.jsdt.core.dom.ASTNode;
import org.eclipse.wst.jsdt.core.dom.ArrayAccess;
import org.eclipse.wst.jsdt.core.dom.ArrayCreation;
import org.eclipse.wst.jsdt.core.dom.ArrayType;
import org.eclipse.wst.jsdt.core.dom.Assignment;
import org.eclipse.wst.jsdt.core.dom.BooleanLiteral;
import org.eclipse.wst.jsdt.core.dom.CastExpression;
import org.eclipse.wst.jsdt.core.dom.CatchClause;
import org.eclipse.wst.jsdt.core.dom.CharacterLiteral;
import org.eclipse.wst.jsdt.core.dom.ClassInstanceCreation;
import org.eclipse.wst.jsdt.core.dom.CompilationUnit;
import org.eclipse.wst.jsdt.core.dom.ConditionalExpression;
import org.eclipse.wst.jsdt.core.dom.Expression;
import org.eclipse.wst.jsdt.core.dom.FieldAccess;
import org.eclipse.wst.jsdt.core.dom.FieldDeclaration;
import org.eclipse.wst.jsdt.core.dom.IBinding;
import org.eclipse.wst.jsdt.core.dom.IMethodBinding;
import org.eclipse.wst.jsdt.core.dom.ITypeBinding;
import org.eclipse.wst.jsdt.core.dom.IVariableBinding;
import org.eclipse.wst.jsdt.core.dom.Javadoc;
import org.eclipse.wst.jsdt.core.dom.MethodDeclaration;
import org.eclipse.wst.jsdt.core.dom.MethodInvocation;
import org.eclipse.wst.jsdt.core.dom.NumberLiteral;
import org.eclipse.wst.jsdt.core.dom.ParenthesizedExpression;
import org.eclipse.wst.jsdt.core.dom.QualifiedName;
import org.eclipse.wst.jsdt.core.dom.RegularExpressionLiteral;
import org.eclipse.wst.jsdt.core.dom.ReturnStatement;
import org.eclipse.wst.jsdt.core.dom.SimpleName;
import org.eclipse.wst.jsdt.core.dom.SingleVariableDeclaration;
import org.eclipse.wst.jsdt.core.dom.StringLiteral;
import org.eclipse.wst.jsdt.core.dom.ThisExpression;
import org.eclipse.wst.jsdt.core.dom.Type;
import org.eclipse.wst.jsdt.core.dom.TypeLiteral;
import org.eclipse.wst.jsdt.core.dom.VariableDeclarationExpression;
import org.eclipse.wst.jsdt.core.dom.VariableDeclarationFragment;
import org.eclipse.wst.jsdt.core.dom.VariableDeclarationStatement;
import org.eclipse.wst.jsdt.internal.corext.dom.ASTNodes;
import org.eclipse.wst.jsdt.internal.corext.dom.Bindings;
import org.eclipse.wst.jsdt.internal.corext.dom.HierarchicalASTVisitor;
import org.eclipse.wst.jsdt.internal.corext.refactoring.generics.InferTypeArgumentsTCModel;
import org.eclipse.wst.jsdt.internal.corext.refactoring.rename.MethodChecks;
import org.eclipse.wst.jsdt.internal.corext.refactoring.typeconstraints.types.GenericType;
import org.eclipse.wst.jsdt.internal.corext.refactoring.typeconstraints.types.ParameterizedType;
import org.eclipse.wst.jsdt.internal.corext.refactoring.typeconstraints.types.TType;
import org.eclipse.wst.jsdt.internal.corext.refactoring.typeconstraints.types.TypeVariable;
import org.eclipse.wst.jsdt.internal.corext.refactoring.typeconstraints.types.WildcardType;
import org.eclipse.wst.jsdt.internal.corext.refactoring.typeconstraints2.ArrayElementVariable2;
import org.eclipse.wst.jsdt.internal.corext.refactoring.typeconstraints2.ArrayTypeVariable2;
import org.eclipse.wst.jsdt.internal.corext.refactoring.typeconstraints2.CollectionElementVariable2;
import org.eclipse.wst.jsdt.internal.corext.refactoring.typeconstraints2.ConstraintVariable2;
import org.eclipse.wst.jsdt.internal.corext.refactoring.typeconstraints2.ImmutableTypeVariable2;
import org.eclipse.wst.jsdt.internal.corext.refactoring.typeconstraints2.IndependentTypeVariable2;
import org.eclipse.wst.jsdt.internal.corext.refactoring.typeconstraints2.ParameterTypeVariable2;
import org.eclipse.wst.jsdt.internal.corext.refactoring.typeconstraints2.ParameterizedTypeVariable2;
import org.eclipse.wst.jsdt.internal.corext.refactoring.typeconstraints2.ReturnTypeVariable2;
import org.eclipse.wst.jsdt.internal.corext.refactoring.typeconstraints2.TTypes;
import org.eclipse.wst.jsdt.internal.corext.refactoring.typeconstraints2.TypeVariable2;
import org.eclipse.wst.jsdt.internal.corext.refactoring.typeconstraints2.VariableVariable2;
import org.eclipse.wst.jsdt.internal.corext.util.JdtFlags;

public class InferTypeArgumentsConstraintCreator
extends HierarchicalASTVisitor {
    private static final String CV_PROP = "org.eclipse.wst.jsdt.internal.corext.refactoring.typeconstraints.CONSTRAINT_VARIABLE";
    private InferTypeArgumentsTCModel fTCModel;
    private ICompilationUnit fCU;
    private final boolean fAssumeCloneReturnsSameType;

    public InferTypeArgumentsConstraintCreator(InferTypeArgumentsTCModel model, boolean assumeCloneReturnsSameType) {
        this.fTCModel = model;
        this.fAssumeCloneReturnsSameType = assumeCloneReturnsSameType;
    }

    public boolean visit(CompilationUnit node) {
        this.fTCModel.newCu();
        this.fCU = (ICompilationUnit)node.getJavaElement();
        return super.visit(node);
    }

    public boolean visit(Javadoc node) {
        return false;
    }

    public boolean visit(Type node) {
        return false;
    }

    public void endVisit(Type node) {
        if (node.isParameterizedType()) {
            ImmutableTypeVariable2 typeVariable = this.fTCModel.makeImmutableTypeVariable(node.resolveBinding(), null);
            InferTypeArgumentsConstraintCreator.setConstraintVariable((ASTNode)node, typeVariable);
        } else {
            TypeVariable2 typeVariable = this.fTCModel.makeTypeVariable(node);
            InferTypeArgumentsConstraintCreator.setConstraintVariable((ASTNode)node, typeVariable);
        }
    }

    public void endVisit(SimpleName node) {
        if (node.resolveBoxing()) {
            ImmutableTypeVariable2 boxed = this.fTCModel.makeImmutableTypeVariable(node.resolveTypeBinding(), (Expression)node);
            InferTypeArgumentsConstraintCreator.setConstraintVariable((ASTNode)node, boxed);
            return;
        }
        IBinding binding = node.resolveBinding();
        if (binding instanceof IVariableBinding) {
            ConstraintVariable2 receiverCv;
            Expression receiver;
            IVariableBinding variableBinding = (IVariableBinding)binding;
            ITypeBinding declaredVariableType = variableBinding.getVariableDeclaration().getType();
            if (declaredVariableType.isTypeVariable()) {
                receiver = this.getSimpleNameReceiver(node);
                if (receiver != null) {
                    ConstraintVariable2 receiverCv2 = InferTypeArgumentsConstraintCreator.getConstraintVariable((ASTNode)receiver);
                    Assert.isNotNull((Object)receiverCv2);
                    CollectionElementVariable2 elementCv = this.fTCModel.getElementVariable(receiverCv2, declaredVariableType);
                    InferTypeArgumentsConstraintCreator.setConstraintVariable((ASTNode)node, elementCv);
                    return;
                }
            } else if (declaredVariableType.isParameterizedType() && (receiver = this.getSimpleNameReceiver(node)) != null && (receiverCv = InferTypeArgumentsConstraintCreator.getConstraintVariable((ASTNode)receiver)) != null) {
                ParameterizedTypeVariable2 returnTypeCv = this.fTCModel.makeParameterizedTypeVariable(declaredVariableType);
                InferTypeArgumentsConstraintCreator.setConstraintVariable((ASTNode)node, returnTypeCv);
                TType declaredVariableTType = this.fTCModel.createTType(declaredVariableType);
                this.fTCModel.createTypeVariablesEqualityConstraints(receiverCv, Collections.EMPTY_MAP, returnTypeCv, declaredVariableTType);
                return;
            }
            VariableVariable2 cv = this.fTCModel.makeVariableVariable(variableBinding);
            InferTypeArgumentsConstraintCreator.setConstraintVariable((ASTNode)node, cv);
        }
    }

    private Expression getSimpleNameReceiver(SimpleName node) {
        Object receiver = node.getParent() instanceof QualifiedName && node.getLocationInParent() == QualifiedName.NAME_PROPERTY ? ((QualifiedName)node.getParent()).getQualifier() : (node.getParent() instanceof FieldAccess && node.getLocationInParent() == FieldAccess.NAME_PROPERTY ? ((FieldAccess)node.getParent()).getExpression() : null);
        if (receiver instanceof ThisExpression) {
            return null;
        }
        return receiver;
    }

    public void endVisit(FieldAccess node) {
        if (node.resolveBoxing()) {
            ImmutableTypeVariable2 boxed = this.fTCModel.makeImmutableTypeVariable(node.resolveTypeBinding(), (Expression)node);
            InferTypeArgumentsConstraintCreator.setConstraintVariable((ASTNode)node, boxed);
            return;
        }
        ConstraintVariable2 nameCv = InferTypeArgumentsConstraintCreator.getConstraintVariable((ASTNode)node.getName());
        InferTypeArgumentsConstraintCreator.setConstraintVariable((ASTNode)node, nameCv);
    }

    public void endVisit(QualifiedName node) {
        if (node.resolveBoxing()) {
            ImmutableTypeVariable2 boxed = this.fTCModel.makeImmutableTypeVariable(node.resolveTypeBinding(), (Expression)node);
            InferTypeArgumentsConstraintCreator.setConstraintVariable((ASTNode)node, boxed);
            return;
        }
        ConstraintVariable2 cv = InferTypeArgumentsConstraintCreator.getConstraintVariable((ASTNode)node.getName());
        InferTypeArgumentsConstraintCreator.setConstraintVariable((ASTNode)node, cv);
    }

    public void endVisit(ArrayAccess node) {
        if (node.resolveBoxing()) {
            ImmutableTypeVariable2 boxed = this.fTCModel.makeImmutableTypeVariable(node.resolveTypeBinding(), (Expression)node);
            InferTypeArgumentsConstraintCreator.setConstraintVariable((ASTNode)node, boxed);
            return;
        }
        ConstraintVariable2 arrayCv = InferTypeArgumentsConstraintCreator.getConstraintVariable((ASTNode)node.getArray());
        if (arrayCv == null) {
            return;
        }
        ArrayElementVariable2 arrayElementCv = this.fTCModel.getArrayElementVariable(arrayCv);
        InferTypeArgumentsConstraintCreator.setConstraintVariable((ASTNode)node, arrayElementCv);
    }

    public void endVisit(Assignment node) {
        Expression lhs = node.getLeftHandSide();
        Expression rhs = node.getRightHandSide();
        ConstraintVariable2 left = InferTypeArgumentsConstraintCreator.getConstraintVariable((ASTNode)lhs);
        ConstraintVariable2 right = InferTypeArgumentsConstraintCreator.getConstraintVariable((ASTNode)rhs);
        if (node.resolveBoxing()) {
            ImmutableTypeVariable2 boxed = this.fTCModel.makeImmutableTypeVariable(node.resolveTypeBinding(), (Expression)node);
            InferTypeArgumentsConstraintCreator.setConstraintVariable((ASTNode)node, boxed);
        } else {
            InferTypeArgumentsConstraintCreator.setConstraintVariable((ASTNode)node, left);
        }
        if (left == null || right == null) {
            return;
        }
        Assignment.Operator op = node.getOperator();
        if (op != Assignment.Operator.PLUS_ASSIGN || lhs.resolveTypeBinding() != node.getAST().resolveWellKnownType("java.lang.String")) {
            this.fTCModel.createElementEqualsConstraints(left, right);
            this.fTCModel.createSubtypeConstraint(right, left);
        }
    }

    public void endVisit(CastExpression node) {
        boolean eitherIsIntf;
        Type type = node.getType();
        ITypeBinding typeBinding = type.resolveBinding();
        if (typeBinding.isPrimitive()) {
            ImmutableTypeVariable2 boxed = this.fTCModel.makeImmutableTypeVariable(typeBinding, (Expression)node);
            InferTypeArgumentsConstraintCreator.setConstraintVariable((ASTNode)node, boxed);
            return;
        }
        ConstraintVariable2 typeCv = InferTypeArgumentsConstraintCreator.getConstraintVariable((ASTNode)type);
        if (typeCv == null) {
            return;
        }
        InferTypeArgumentsConstraintCreator.setConstraintVariable((ASTNode)node, typeCv);
        Expression expression = node.getExpression();
        ConstraintVariable2 expressionCv = InferTypeArgumentsConstraintCreator.getConstraintVariable((ASTNode)expression);
        if (expressionCv == null) {
            return;
        }
        if (expressionCv instanceof ImmutableTypeVariable2) {
            return;
        }
        if (!(expressionCv instanceof TypeVariable2 || expressionCv instanceof IndependentTypeVariable2 || expressionCv instanceof CollectionElementVariable2 || this.fTCModel.getElementVariables(expressionCv).size() != 0 || this.fTCModel.getArrayElementVariable(expressionCv) != null)) {
            return;
        }
        this.fTCModel.createAssignmentElementConstraints(typeCv, expressionCv);
        if (expression instanceof MethodInvocation) {
            MethodInvocation invoc = (MethodInvocation)expression;
            if (!this.isSpecialCloneInvocation(invoc.resolveMethodBinding(), invoc.getExpression())) {
                this.fTCModel.makeCastVariable(node, expressionCv);
            }
        } else {
            this.fTCModel.makeCastVariable(node, expressionCv);
        }
        boolean bl = eitherIsIntf = typeBinding.isInterface() || expression.resolveTypeBinding().isInterface();
        if (eitherIsIntf) {
            return;
        }
    }

    public void endVisit(ParenthesizedExpression node) {
        if (node.resolveBoxing()) {
            ImmutableTypeVariable2 boxed = this.fTCModel.makeImmutableTypeVariable(node.resolveTypeBinding(), (Expression)node);
            InferTypeArgumentsConstraintCreator.setConstraintVariable((ASTNode)node, boxed);
            return;
        }
        ConstraintVariable2 expressionCv = InferTypeArgumentsConstraintCreator.getConstraintVariable((ASTNode)node.getExpression());
        InferTypeArgumentsConstraintCreator.setConstraintVariable((ASTNode)node, expressionCv);
    }

    public void endVisit(ConditionalExpression node) {
        ImmutableTypeVariable2 boxed = this.fTCModel.makeImmutableTypeVariable(node.resolveTypeBinding(), (Expression)node);
        InferTypeArgumentsConstraintCreator.setConstraintVariable((ASTNode)node, boxed);
    }

    public boolean visit(CatchClause node) {
        SingleVariableDeclaration exception = node.getException();
        IVariableBinding variableBinding = exception.resolveBinding();
        VariableVariable2 cv = this.fTCModel.makeDeclaredVariableVariable(variableBinding, this.fCU);
        InferTypeArgumentsConstraintCreator.setConstraintVariable((ASTNode)exception, cv);
        return true;
    }

    public void endVisit(StringLiteral node) {
        ITypeBinding typeBinding = node.resolveTypeBinding();
        ImmutableTypeVariable2 cv = this.fTCModel.makeImmutableTypeVariable(typeBinding, null);
        InferTypeArgumentsConstraintCreator.setConstraintVariable((ASTNode)node, cv);
    }

    public void endVisit(NumberLiteral node) {
        ITypeBinding typeBinding = node.resolveTypeBinding();
        ImmutableTypeVariable2 cv = this.fTCModel.makeImmutableTypeVariable(typeBinding, (Expression)node);
        InferTypeArgumentsConstraintCreator.setConstraintVariable((ASTNode)node, cv);
    }

    public void endVisit(BooleanLiteral node) {
        ITypeBinding typeBinding = node.resolveTypeBinding();
        ImmutableTypeVariable2 cv = this.fTCModel.makeImmutableTypeVariable(typeBinding, (Expression)node);
        InferTypeArgumentsConstraintCreator.setConstraintVariable((ASTNode)node, cv);
    }

    public void endVisit(CharacterLiteral node) {
        ITypeBinding typeBinding = node.resolveTypeBinding();
        ImmutableTypeVariable2 cv = this.fTCModel.makeImmutableTypeVariable(typeBinding, (Expression)node);
        InferTypeArgumentsConstraintCreator.setConstraintVariable((ASTNode)node, cv);
    }

    public void endVisit(RegularExpressionLiteral node) {
        ITypeBinding typeBinding = node.resolveTypeBinding();
        ImmutableTypeVariable2 cv = this.fTCModel.makeImmutableTypeVariable(typeBinding, (Expression)node);
        InferTypeArgumentsConstraintCreator.setConstraintVariable((ASTNode)node, cv);
    }

    public void endVisit(ThisExpression node) {
        ITypeBinding typeBinding = node.resolveTypeBinding();
        ImmutableTypeVariable2 cv = this.fTCModel.makeImmutableTypeVariable(typeBinding, null);
        InferTypeArgumentsConstraintCreator.setConstraintVariable((ASTNode)node, cv);
    }

    public void endVisit(TypeLiteral node) {
        ITypeBinding typeBinding = node.resolveTypeBinding();
        ImmutableTypeVariable2 cv = this.fTCModel.makeImmutableTypeVariable(typeBinding, null);
        InferTypeArgumentsConstraintCreator.setConstraintVariable((ASTNode)node, cv);
    }

    public void endVisit(MethodDeclaration node) {
        ReturnTypeVariable2 returnTypeBindingCv;
        IMethodBinding methodBinding = node.resolveBinding();
        if (methodBinding == null) {
            return;
        }
        int parameterCount = node.parameters().size();
        ConstraintVariable2[] parameterTypeCvs = new ConstraintVariable2[parameterCount];
        int i = 0;
        while (i < parameterCount) {
            SingleVariableDeclaration paramDecl = (SingleVariableDeclaration)node.parameters().get(i);
            ParameterTypeVariable2 parameterTypeCv = this.fTCModel.makeDeclaredParameterTypeVariable(methodBinding, i, this.fCU);
            parameterTypeCvs[i] = parameterTypeCv;
            if (parameterTypeCv != null) {
                ConstraintVariable2 typeCv = InferTypeArgumentsConstraintCreator.getConstraintVariable((ASTNode)paramDecl.getType());
                this.fTCModel.createElementEqualsConstraints(parameterTypeCv, typeCv);
                ConstraintVariable2 nameCv = InferTypeArgumentsConstraintCreator.getConstraintVariable((ASTNode)paramDecl.getName());
                this.fTCModel.createElementEqualsConstraints(parameterTypeCv, nameCv);
            }
            ++i;
        }
        ConstraintVariable2 returnTypeCv = null;
        if (!methodBinding.isConstructor() && (returnTypeBindingCv = this.fTCModel.makeDeclaredReturnTypeVariable(methodBinding, this.fCU)) != null) {
            returnTypeCv = InferTypeArgumentsConstraintCreator.getConstraintVariable((ASTNode)node.getReturnType2());
            this.fTCModel.createElementEqualsConstraints(returnTypeBindingCv, returnTypeCv);
        }
        if (MethodChecks.isVirtual(methodBinding)) {
            this.addConstraintsForOverriding(methodBinding, returnTypeCv, parameterTypeCvs);
        }
    }

    private void addConstraintsForOverriding(IMethodBinding methodBinding, ConstraintVariable2 returnTypeCv, ConstraintVariable2[] parameterTypeCvs) {
        boolean hasParameterElementCvs = false;
        int i = 0;
        while (i < parameterTypeCvs.length) {
            if (parameterTypeCvs[i] != null) {
                hasParameterElementCvs = true;
            }
            ++i;
        }
        if (returnTypeCv == null && !hasParameterElementCvs) {
            return;
        }
        ITypeBinding[] allSuperTypes = Bindings.getAllSuperTypes(methodBinding.getDeclaringClass());
        int i2 = 0;
        while (i2 < allSuperTypes.length) {
            ITypeBinding superType = allSuperTypes[i2];
            IMethodBinding superMethod = Bindings.findOverriddenMethodInType(superType, methodBinding);
            if (superMethod != null) {
                int p = 0;
                while (p < parameterTypeCvs.length) {
                    if (parameterTypeCvs[p] != null) {
                        ParameterTypeVariable2 parameterTypeCv = this.fTCModel.makeParameterTypeVariable(superMethod, p);
                        this.fTCModel.createElementEqualsConstraints(parameterTypeCv, parameterTypeCvs[p]);
                    }
                    ++p;
                }
                if (returnTypeCv != null) {
                    ReturnTypeVariable2 superMethodReturnTypeCv = this.fTCModel.makeReturnTypeVariable(superMethod);
                    this.fTCModel.createElementEqualsConstraints(superMethodReturnTypeCv, returnTypeCv);
                }
            }
            ++i2;
        }
    }

    public void endVisit(MethodInvocation node) {
        IMethodBinding methodBinding = node.resolveMethodBinding();
        if (methodBinding == null) {
            return;
        }
        Expression receiver = JdtFlags.isStatic(methodBinding) ? null : node.getExpression();
        if (this.isSpecialCloneInvocation(methodBinding, receiver)) {
            ConstraintVariable2 expressionCv = InferTypeArgumentsConstraintCreator.getConstraintVariable((ASTNode)receiver);
            InferTypeArgumentsConstraintCreator.setConstraintVariable((ASTNode)node, expressionCv);
        } else if ("getClass".equals(methodBinding.getName()) && methodBinding.getParameterTypes().length == 0) {
            ITypeBinding returnType = node.resolveTypeBinding();
            ITypeBinding returnTypeDeclaration = returnType.getTypeDeclaration();
            ParameterizedTypeVariable2 expressionCv = this.fTCModel.makeParameterizedTypeVariable(returnTypeDeclaration);
            InferTypeArgumentsConstraintCreator.setConstraintVariable((ASTNode)node, expressionCv);
            CollectionElementVariable2 classTypeVariable = this.fTCModel.getElementVariable((ConstraintVariable2)expressionCv, returnTypeDeclaration.getTypeParameters()[0]);
            ITypeBinding capture = returnType.getTypeArguments()[0];
            ITypeBinding wildcard = capture.getWildcard();
            ImmutableTypeVariable2 wildcardType = this.fTCModel.makeImmutableTypeVariable(wildcard, null);
            this.fTCModel.createSubtypeConstraint(classTypeVariable, wildcardType);
        } else {
            Map methodTypeVariables = this.createMethodTypeArguments(methodBinding);
            this.doVisitMethodInvocationReturnType(node, methodBinding, receiver, methodTypeVariables);
            this.doVisitMethodInvocationArguments(methodBinding, node.arguments(), receiver, methodTypeVariables, null);
        }
    }

    private Map createMethodTypeArguments(IMethodBinding methodBinding) {
        HashMap<String, IndependentTypeVariable2> methodTypeVariables;
        ITypeBinding[] methodTypeParameters = methodBinding.getMethodDeclaration().getTypeParameters();
        if (methodTypeParameters.length == 0) {
            methodTypeVariables = Collections.EMPTY_MAP;
        } else {
            methodTypeVariables = new HashMap<String, IndependentTypeVariable2>();
            int i = 0;
            while (i < methodTypeParameters.length) {
                ITypeBinding methodTypeParameter = methodTypeParameters[i];
                TypeVariable typeVariable = (TypeVariable)this.fTCModel.createTType(methodTypeParameter);
                IndependentTypeVariable2 typeVariableCv = this.fTCModel.makeIndependentTypeVariable(typeVariable);
                methodTypeVariables.put(methodTypeParameter.getKey(), typeVariableCv);
                ++i;
            }
        }
        return methodTypeVariables;
    }

    private void doVisitMethodInvocationReturnType(MethodInvocation node, IMethodBinding methodBinding, Expression receiver, Map methodTypeVariables) {
        ITypeBinding declaredReturnType = methodBinding.getMethodDeclaration().getReturnType();
        if (declaredReturnType.isPrimitive()) {
            ImmutableTypeVariable2 boxed = this.fTCModel.makeImmutableTypeVariable(declaredReturnType, (Expression)node);
            InferTypeArgumentsConstraintCreator.setConstraintVariable((ASTNode)node, boxed);
        } else if (declaredReturnType.isTypeVariable()) {
            ConstraintVariable2 methodTypeVariableCv = (ConstraintVariable2)methodTypeVariables.get(declaredReturnType.getKey());
            if (methodTypeVariableCv != null) {
                InferTypeArgumentsConstraintCreator.setConstraintVariable((ASTNode)node, methodTypeVariableCv);
            } else {
                if (receiver == null) {
                    return;
                }
                ConstraintVariable2 expressionCv = InferTypeArgumentsConstraintCreator.getConstraintVariable((ASTNode)receiver);
                CollectionElementVariable2 elementCv = this.fTCModel.getElementVariable(expressionCv, declaredReturnType);
                InferTypeArgumentsConstraintCreator.setConstraintVariable((ASTNode)node, elementCv);
            }
        } else if (declaredReturnType.isParameterizedType()) {
            ParameterizedTypeVariable2 returnTypeCv = this.fTCModel.makeParameterizedTypeVariable(declaredReturnType.getTypeDeclaration());
            InferTypeArgumentsConstraintCreator.setConstraintVariable((ASTNode)node, returnTypeCv);
            ConstraintVariable2 receiverCv = null;
            if (receiver != null) {
                receiverCv = InferTypeArgumentsConstraintCreator.getConstraintVariable((ASTNode)receiver);
            }
            TType declaredReturnTType = this.fTCModel.createTType(declaredReturnType);
            this.fTCModel.createTypeVariablesEqualityConstraints(receiverCv, methodTypeVariables, returnTypeCv, declaredReturnTType);
        } else if (declaredReturnType.isArray()) {
            ArrayTypeVariable2 returnTypeCv = this.fTCModel.makeArrayTypeVariable(declaredReturnType);
            InferTypeArgumentsConstraintCreator.setConstraintVariable((ASTNode)node, returnTypeCv);
            ConstraintVariable2 receiverCv = null;
            if (receiver != null) {
                receiverCv = InferTypeArgumentsConstraintCreator.getConstraintVariable((ASTNode)receiver);
                this.fTCModel.setMethodReceiverCV(returnTypeCv, receiverCv);
            }
            TType declaredReturnTType = this.fTCModel.createTType(declaredReturnType);
            this.fTCModel.createTypeVariablesEqualityConstraints(receiverCv, methodTypeVariables, returnTypeCv, declaredReturnTType);
        } else {
            ReturnTypeVariable2 returnTypeCv = this.fTCModel.makeReturnTypeVariable(methodBinding);
            InferTypeArgumentsConstraintCreator.setConstraintVariable((ASTNode)node, returnTypeCv);
        }
    }

    private boolean isSpecialCloneInvocation(IMethodBinding methodBinding, Expression receiver) {
        return this.fAssumeCloneReturnsSameType && "clone".equals(methodBinding.getName()) && methodBinding.getParameterTypes().length == 0 && receiver != null && receiver.resolveTypeBinding() != methodBinding.getMethodDeclaration().getReturnType();
    }

    private void doVisitMethodInvocationArguments(IMethodBinding methodBinding, List arguments, Expression receiver, Map methodTypeVariables, Type createdType) {
        ITypeBinding[] declaredParameterTypes = methodBinding.getMethodDeclaration().getParameterTypes();
        int lastParamIdx = declaredParameterTypes.length - 1;
        int i = 0;
        while (i < arguments.size()) {
            Expression arg = (Expression)arguments.get(i);
            ConstraintVariable2 argCv = InferTypeArgumentsConstraintCreator.getConstraintVariable((ASTNode)arg);
            if (argCv != null) {
                TType declaredParameterType;
                int iParam;
                if (!methodBinding.isVarargs() || i < lastParamIdx) {
                    iParam = i;
                    declaredParameterType = this.fTCModel.createTType(declaredParameterTypes[iParam]);
                } else {
                    iParam = lastParamIdx;
                    declaredParameterType = this.fTCModel.createTType(declaredParameterTypes[iParam]);
                    if (i != lastParamIdx || !this.canAssignToVararg(this.fTCModel.createTType(arg.resolveTypeBinding()), (org.eclipse.wst.jsdt.internal.corext.refactoring.typeconstraints.types.ArrayType)declaredParameterType)) {
                        declaredParameterType = ((org.eclipse.wst.jsdt.internal.corext.refactoring.typeconstraints.types.ArrayType)declaredParameterType).getComponentType();
                    }
                }
                if (declaredParameterType.isTypeVariable()) {
                    ConstraintVariable2 methodTypeVariableCv = (ConstraintVariable2)methodTypeVariables.get(declaredParameterType.getBindingKey());
                    if (methodTypeVariableCv != null) {
                        this.fTCModel.createSubtypeConstraint(argCv, methodTypeVariableCv);
                    } else {
                        CollectionElementVariable2 elementCv;
                        if (createdType != null) {
                            ConstraintVariable2 createdTypeCv = InferTypeArgumentsConstraintCreator.getConstraintVariable((ASTNode)createdType);
                            elementCv = this.fTCModel.getElementVariable(createdTypeCv, (TypeVariable)declaredParameterType);
                            this.fTCModel.createSubtypeConstraint(argCv, elementCv);
                        }
                        if (receiver != null) {
                            ConstraintVariable2 expressionCv = InferTypeArgumentsConstraintCreator.getConstraintVariable((ASTNode)receiver);
                            elementCv = this.fTCModel.getElementVariable(expressionCv, (TypeVariable)declaredParameterType);
                            this.fTCModel.createSubtypeConstraint(argCv, elementCv);
                        }
                    }
                } else if (declaredParameterType.isParameterizedType()) {
                    TType[] typeArguments = ((ParameterizedType)declaredParameterType).getTypeArguments();
                    TypeVariable[] typeParameters = ((GenericType)declaredParameterType.getTypeDeclaration()).getTypeParameters();
                    int ta = 0;
                    while (ta < typeArguments.length) {
                        TType typeArgument = typeArguments[ta];
                        CollectionElementVariable2 argElementCv = this.fTCModel.getElementVariable(argCv, typeParameters[ta]);
                        if (typeArgument.isWildcardType()) {
                            WildcardType wildcardTypeArgument = (WildcardType)typeArgument;
                            TType bound = wildcardTypeArgument.getBound();
                            if (bound != null && bound.isTypeVariable()) {
                                ConstraintVariable2 methodTypeVariableCv = (ConstraintVariable2)methodTypeVariables.get(bound.getBindingKey());
                                if (methodTypeVariableCv != null) {
                                    this.createWildcardConstraint(wildcardTypeArgument, argElementCv, methodTypeVariableCv);
                                } else {
                                    CollectionElementVariable2 elementCv;
                                    if (createdType != null) {
                                        ConstraintVariable2 createdTypeCv = InferTypeArgumentsConstraintCreator.getConstraintVariable((ASTNode)createdType);
                                        elementCv = this.fTCModel.getElementVariable(createdTypeCv, typeParameters[ta]);
                                        this.createWildcardConstraint(wildcardTypeArgument, argElementCv, elementCv);
                                    }
                                    if (receiver != null) {
                                        ConstraintVariable2 expressionCv = InferTypeArgumentsConstraintCreator.getConstraintVariable((ASTNode)receiver);
                                        elementCv = this.fTCModel.getElementVariable(expressionCv, typeParameters[ta]);
                                        this.createWildcardConstraint(wildcardTypeArgument, argElementCv, elementCv);
                                    }
                                }
                            }
                        } else if (typeArgument.isTypeVariable()) {
                            ConstraintVariable2 methodTypeVariableCv = (ConstraintVariable2)methodTypeVariables.get(typeArgument.getBindingKey());
                            if (methodTypeVariableCv != null) {
                                this.fTCModel.createEqualsConstraint(argElementCv, methodTypeVariableCv);
                            } else {
                                CollectionElementVariable2 elementCv;
                                if (createdType != null) {
                                    ConstraintVariable2 createdTypeCv = InferTypeArgumentsConstraintCreator.getConstraintVariable((ASTNode)createdType);
                                    elementCv = this.fTCModel.getElementVariable(createdTypeCv, (TypeVariable)typeArgument);
                                    this.fTCModel.createEqualsConstraint(argElementCv, elementCv);
                                }
                                if (receiver != null) {
                                    ConstraintVariable2 expressionCv = InferTypeArgumentsConstraintCreator.getConstraintVariable((ASTNode)receiver);
                                    elementCv = this.fTCModel.getElementVariable(expressionCv, (TypeVariable)typeArgument);
                                    this.fTCModel.createEqualsConstraint(argElementCv, elementCv);
                                }
                            }
                        } else {
                            ImmutableTypeVariable2 typeArgumentCv = this.fTCModel.makeImmutableTypeVariable(typeArgument);
                            this.fTCModel.createEqualsConstraint(argElementCv, typeArgumentCv);
                        }
                        ++ta;
                    }
                } else if (declaredParameterType.isArrayType()) {
                    ConstraintVariable2 methodTypeVariableCv;
                    TType declaredElementType = ((org.eclipse.wst.jsdt.internal.corext.refactoring.typeconstraints.types.ArrayType)declaredParameterType).getElementType();
                    if (declaredElementType.isTypeVariable() && (methodTypeVariableCv = (ConstraintVariable2)methodTypeVariables.get(declaredElementType.getBindingKey())) != null) {
                        ArrayElementVariable2 argElementCv = this.fTCModel.getArrayElementVariable(argCv);
                        this.fTCModel.createEqualsConstraint(argElementCv, methodTypeVariableCv);
                    }
                } else if (InferTypeArgumentsTCModel.isAGenericType(declaredParameterType)) {
                    ParameterTypeVariable2 parameterTypeCv = this.fTCModel.makeParameterTypeVariable(methodBinding, iParam);
                    this.fTCModel.createElementEqualsConstraints(parameterTypeCv, argCv);
                }
            }
            ++i;
        }
    }

    private boolean canAssignToVararg(TType rhs, org.eclipse.wst.jsdt.internal.corext.refactoring.typeconstraints.types.ArrayType lhs) {
        return TTypes.canAssignTo(rhs.getErasure(), lhs.getErasure());
    }

    private void createWildcardConstraint(WildcardType typeArgument, CollectionElementVariable2 argElementCv, ConstraintVariable2 paramElementCv) {
        if (typeArgument.isExtendsWildcardType()) {
            this.fTCModel.createSubtypeConstraint(argElementCv, paramElementCv);
        } else {
            this.fTCModel.createSubtypeConstraint(paramElementCv, argElementCv);
        }
    }

    public void endVisit(ClassInstanceCreation node) {
        ConstraintVariable2 typeCv;
        Expression receiver = node.getExpression();
        Type createdType = node.getType();
        if (node.getAnonymousClassDeclaration() == null) {
            typeCv = InferTypeArgumentsConstraintCreator.getConstraintVariable((ASTNode)createdType);
        } else {
            typeCv = this.fTCModel.makeImmutableTypeVariable(createdType.resolveBinding(), null);
            InferTypeArgumentsConstraintCreator.setConstraintVariable((ASTNode)createdType, typeCv);
        }
        InferTypeArgumentsConstraintCreator.setConstraintVariable((ASTNode)node, typeCv);
        IMethodBinding methodBinding = node.resolveConstructorBinding();
        Map methodTypeVariables = this.createMethodTypeArguments(methodBinding);
        List arguments = node.arguments();
        this.doVisitMethodInvocationArguments(methodBinding, arguments, receiver, methodTypeVariables, createdType);
    }

    public void endVisit(ArrayCreation node) {
        ArrayType arrayType = node.getType();
        TypeVariable2 arrayTypeCv = (TypeVariable2)InferTypeArgumentsConstraintCreator.getConstraintVariable((ASTNode)arrayType);
        if (arrayTypeCv == null) {
            return;
        }
        InferTypeArgumentsConstraintCreator.setConstraintVariable((ASTNode)node, arrayTypeCv);
    }

    public void endVisit(ReturnStatement node) {
        Expression expression = node.getExpression();
        if (expression == null) {
            return;
        }
        ConstraintVariable2 expressionCv = InferTypeArgumentsConstraintCreator.getConstraintVariable((ASTNode)expression);
        if (expressionCv == null) {
            return;
        }
        MethodDeclaration methodDeclaration = (MethodDeclaration)ASTNodes.getParent((ASTNode)node, 31);
        if (methodDeclaration == null) {
            return;
        }
        IMethodBinding methodBinding = methodDeclaration.resolveBinding();
        if (methodBinding == null) {
            return;
        }
        ReturnTypeVariable2 returnTypeCv = this.fTCModel.makeReturnTypeVariable(methodBinding);
        if (returnTypeCv == null) {
            return;
        }
        this.fTCModel.createElementEqualsConstraints(returnTypeCv, expressionCv);
    }

    public void endVisit(VariableDeclarationExpression node) {
        Type type = node.getType();
        ConstraintVariable2 typeCv = InferTypeArgumentsConstraintCreator.getConstraintVariable((ASTNode)type);
        if (typeCv == null) {
            return;
        }
        InferTypeArgumentsConstraintCreator.setConstraintVariable((ASTNode)node, typeCv);
        List fragments = node.fragments();
        Iterator iter = fragments.iterator();
        while (iter.hasNext()) {
            VariableDeclarationFragment fragment = (VariableDeclarationFragment)iter.next();
            ConstraintVariable2 fragmentCv = InferTypeArgumentsConstraintCreator.getConstraintVariable((ASTNode)fragment);
            this.fTCModel.createElementEqualsConstraints(typeCv, fragmentCv);
        }
    }

    public void endVisit(VariableDeclarationStatement node) {
        this.endVisitFieldVariableDeclaration(node.getType(), node.fragments());
    }

    public void endVisit(FieldDeclaration node) {
        this.endVisitFieldVariableDeclaration(node.getType(), node.fragments());
    }

    private void endVisitFieldVariableDeclaration(Type type, List variableDeclarationFragments) {
        ConstraintVariable2 typeCv = InferTypeArgumentsConstraintCreator.getConstraintVariable((ASTNode)type);
        if (typeCv == null) {
            return;
        }
        Iterator iter = variableDeclarationFragments.iterator();
        while (iter.hasNext()) {
            VariableDeclarationFragment fragment = (VariableDeclarationFragment)iter.next();
            ConstraintVariable2 fragmentCv = InferTypeArgumentsConstraintCreator.getConstraintVariable((ASTNode)fragment);
            this.fTCModel.createElementEqualsConstraints(typeCv, fragmentCv);
        }
    }

    public void endVisit(SingleVariableDeclaration node) {
        Expression initializer = node.getInitializer();
        if (initializer == null) {
            return;
        }
    }

    public void endVisit(VariableDeclarationFragment node) {
        VariableVariable2 cv = this.fTCModel.makeDeclaredVariableVariable(node.resolveBinding(), this.fCU);
        if (cv == null) {
            return;
        }
        InferTypeArgumentsConstraintCreator.setConstraintVariable((ASTNode)node, cv);
        Expression initializer = node.getInitializer();
        if (initializer == null) {
            return;
        }
        ConstraintVariable2 initializerCv = InferTypeArgumentsConstraintCreator.getConstraintVariable((ASTNode)initializer);
        if (initializerCv == null) {
            return;
        }
        this.fTCModel.createElementEqualsConstraints(cv, initializerCv);
    }

    public InferTypeArgumentsTCModel getTCModel() {
        return this.fTCModel;
    }

    protected static ConstraintVariable2 getConstraintVariable(ASTNode node) {
        return (ConstraintVariable2)node.getProperty(CV_PROP);
    }

    protected static void setConstraintVariable(ASTNode node, ConstraintVariable2 constraintVariable) {
        node.setProperty(CV_PROP, (Object)constraintVariable);
    }
}

