/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.corext.refactoring.nls;

import com.ibm.icu.text.Collator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.filebuffers.FileBuffers;
import org.eclipse.core.filebuffers.ITextFileBuffer;
import org.eclipse.core.filebuffers.ITextFileBufferManager;
import org.eclipse.core.filebuffers.LocationKind;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.TextChange;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.text.edits.TextEditGroup;
import org.eclipse.wst.jsdt.core.ICompilationUnit;
import org.eclipse.wst.jsdt.core.IJavaElement;
import org.eclipse.wst.jsdt.core.dom.AST;
import org.eclipse.wst.jsdt.core.dom.ASTNode;
import org.eclipse.wst.jsdt.core.dom.ASTVisitor;
import org.eclipse.wst.jsdt.core.dom.AbstractTypeDeclaration;
import org.eclipse.wst.jsdt.core.dom.CompilationUnit;
import org.eclipse.wst.jsdt.core.dom.FieldDeclaration;
import org.eclipse.wst.jsdt.core.dom.Modifier;
import org.eclipse.wst.jsdt.core.dom.Name;
import org.eclipse.wst.jsdt.core.dom.Type;
import org.eclipse.wst.jsdt.core.dom.TypeDeclaration;
import org.eclipse.wst.jsdt.core.dom.VariableDeclarationFragment;
import org.eclipse.wst.jsdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.wst.jsdt.core.dom.rewrite.ListRewrite;
import org.eclipse.wst.jsdt.internal.corext.dom.GenericVisitor;
import org.eclipse.wst.jsdt.internal.corext.refactoring.changes.CompilationUnitChange;
import org.eclipse.wst.jsdt.internal.corext.refactoring.nls.AccessorClassModifier;
import org.eclipse.wst.jsdt.internal.corext.refactoring.nls.NLSMessages;
import org.eclipse.wst.jsdt.internal.corext.refactoring.nls.NLSPropertyFileModifier;
import org.eclipse.wst.jsdt.internal.corext.refactoring.nls.NLSSubstitution;
import org.eclipse.wst.jsdt.internal.corext.util.Messages;
import org.eclipse.wst.jsdt.internal.ui.JavaPlugin;
import org.eclipse.wst.jsdt.internal.ui.javaeditor.ASTProvider;

public class AccessorClassModifier {
    private CompilationUnit fRoot;
    private AST fAst;
    private ASTRewrite fASTRewrite;
    private ListRewrite fListRewrite;
    private ICompilationUnit fCU;
    private List fFields;

    private AccessorClassModifier(ICompilationUnit cu) throws CoreException {
        this.fCU = cu;
        this.fRoot = JavaPlugin.getDefault().getASTProvider().getAST((IJavaElement)cu, ASTProvider.WAIT_YES, null);
        this.fAst = this.fRoot.getAST();
        this.fASTRewrite = ASTRewrite.create((AST)this.fAst);
        AbstractTypeDeclaration parent = null;
        if (this.fRoot.types().size() <= 0) {
            Status status = new Status(4, "org.eclipse.wst.jsdt.ui", 10001, NLSMessages.AccessorClassModifier_missingType, null);
            throw new CoreException((IStatus)status);
        }
        parent = (AbstractTypeDeclaration)this.fRoot.types().get(0);
        this.fFields = new ArrayList();
        parent.accept((ASTVisitor)new GenericVisitor(){

            public boolean visit(FieldDeclaration node) {
                int modifiers = node.getModifiers();
                if (!Modifier.isPublic((int)modifiers)) {
                    return false;
                }
                if (!Modifier.isStatic((int)modifiers)) {
                    return false;
                }
                List fragments = node.fragments();
                if (fragments.size() != 1) {
                    return false;
                }
                VariableDeclarationFragment fragment = (VariableDeclarationFragment)fragments.get(0);
                if (fragment.getInitializer() != null) {
                    return false;
                }
                AccessorClassModifier.this.fFields.add(node);
                return false;
            }
        });
        this.fListRewrite = this.fASTRewrite.getListRewrite((ASTNode)parent, TypeDeclaration.BODY_DECLARATIONS_PROPERTY);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private TextEdit getTextEdit() throws CoreException {
        Document document = null;
        ITextFileBufferManager manager = FileBuffers.getTextFileBufferManager();
        IPath path = this.fCU.getPath();
        if (manager != null && path != null) {
            manager.connect(path, LocationKind.NORMALIZE, null);
            try {
                ITextFileBuffer buffer = manager.getTextFileBuffer(path, LocationKind.NORMALIZE);
                if (buffer != null) {
                    document = buffer.getDocument();
                }
            }
            catch (Throwable throwable) {
                Object var5_6 = null;
                manager.disconnect(path, LocationKind.NORMALIZE, null);
                throw throwable;
            }
            {
                Object var5_7 = null;
            }
            manager.disconnect(path, LocationKind.NORMALIZE, null);
        }
        if (document == null) {
            document = new Document(this.fCU.getSource());
        }
        return this.fASTRewrite.rewriteAST((IDocument)document, this.fCU.getJavaProject().getOptions(true));
    }

    public static Change create(ICompilationUnit cu, NLSSubstitution[] substitutions) throws CoreException {
        NLSSubstitution substitution;
        HashMap newKeyToSubstMap = NLSPropertyFileModifier.getNewKeyToSubstitutionMap(substitutions);
        HashMap oldKeyToSubstMap = NLSPropertyFileModifier.getOldKeyToSubstitutionMap(substitutions);
        AccessorClassModifier sourceModification = new AccessorClassModifier(cu);
        String message = Messages.format(NLSMessages.NLSSourceModifier_change_description, cu.getElementName());
        CompilationUnitChange change = new CompilationUnitChange(message, cu);
        MultiTextEdit multiTextEdit = new MultiTextEdit();
        change.setEdit((TextEdit)multiTextEdit);
        int i = 0;
        while (i < substitutions.length) {
            substitution = substitutions[i];
            if (NLSPropertyFileModifier.doRemove(substitution, newKeyToSubstMap, oldKeyToSubstMap)) {
                sourceModification.removeKey(substitution, (TextChange)change);
            }
            ++i;
        }
        i = 0;
        while (i < substitutions.length) {
            substitution = substitutions[i];
            if (substitution.isKeyRename() && NLSPropertyFileModifier.doReplace(substitution, newKeyToSubstMap, oldKeyToSubstMap)) {
                sourceModification.renameKey(substitution, (TextChange)change);
            }
            ++i;
        }
        i = 0;
        while (i < substitutions.length) {
            substitution = substitutions[i];
            if (NLSPropertyFileModifier.doInsert(substitution, newKeyToSubstMap, oldKeyToSubstMap)) {
                sourceModification.addKey(substitution, (TextChange)change);
            }
            ++i;
        }
        if (change.getChangeGroups().length == 0) {
            return null;
        }
        change.addEdit(sourceModification.getTextEdit());
        return change;
    }

    private void removeKey(NLSSubstitution sub, TextChange change) throws CoreException {
        ASTNode node = this.findField((ASTNode)this.fRoot, sub.getKey());
        if (node == null) {
            return;
        }
        String name = Messages.format(NLSMessages.AccessorClassModifier_remove_entry, sub.getKey());
        TextEditGroup editGroup = new TextEditGroup(name);
        this.fListRewrite.remove(node, editGroup);
        change.addTextEditGroup(editGroup);
        this.fFields.remove(node);
    }

    private void renameKey(NLSSubstitution sub, TextChange change) throws CoreException {
        ASTNode node = this.findField((ASTNode)this.fRoot, sub.getInitialKey());
        if (node == null) {
            return;
        }
        String name = Messages.format(NLSMessages.AccessorClassModifier_replace_entry, sub.getKey());
        TextEditGroup editGroup = new TextEditGroup(name);
        this.fListRewrite.remove(node, editGroup);
        this.fFields.remove(node);
        this.addKey(sub, change, editGroup);
        change.addTextEditGroup(editGroup);
    }

    private ASTNode findField(ASTNode astRoot, final String name) {
        class STOP_VISITING
        extends RuntimeException {
            private static final long serialVersionUID = 1L;
            final /* synthetic */ AccessorClassModifier this$0;

            STOP_VISITING(AccessorClassModifier accessorClassModifier) {
                this.this$0 = accessorClassModifier;
            }
        }
        final ASTNode[] result = new ASTNode[1];
        try {
            astRoot.accept(new ASTVisitor(){

                public boolean visit(VariableDeclarationFragment node) {
                    if (name.equals(node.getName().getFullyQualifiedName())) {
                        result[0] = node.getParent();
                        throw new STOP_VISITING(AccessorClassModifier.this);
                    }
                    return true;
                }
            });
        }
        catch (STOP_VISITING sTOP_VISITING) {}
        return result[0];
    }

    private void addKey(NLSSubstitution sub, TextChange change) throws CoreException {
        String name = Messages.format(NLSMessages.AccessorClassModifier_add_entry, sub.getKey());
        TextEditGroup editGroup = new TextEditGroup(name);
        change.addTextEditGroup(editGroup);
        this.addKey(sub, change, editGroup);
    }

    private void addKey(NLSSubstitution sub, TextChange change, TextEditGroup editGroup) throws CoreException {
        if (this.fListRewrite == null) {
            return;
        }
        String key = sub.getKey();
        FieldDeclaration fieldDeclaration = this.getNewFinalStringFieldDeclaration(key);
        Iterator iter = this.fFields.iterator();
        int insertionPosition = 0;
        if (iter.hasNext()) {
            FieldDeclaration existingFieldDecl;
            VariableDeclarationFragment fragment;
            String identifier;
            Collator collator = Collator.getInstance();
            if (collator.compare(key, identifier = (fragment = (VariableDeclarationFragment)(existingFieldDecl = (FieldDeclaration)iter.next()).fragments().get(0)).getName().getIdentifier()) != 1) {
                insertionPosition = 0;
                this.fListRewrite.insertBefore((ASTNode)fieldDeclaration, (ASTNode)existingFieldDecl, editGroup);
            } else {
                ++insertionPosition;
                while (iter.hasNext()) {
                    FieldDeclaration next = (FieldDeclaration)iter.next();
                    fragment = (VariableDeclarationFragment)next.fragments().get(0);
                    identifier = fragment.getName().getIdentifier();
                    if (collator.compare(key, identifier) == -1) break;
                    ++insertionPosition;
                    existingFieldDecl = next;
                }
                this.fListRewrite.insertAfter((ASTNode)fieldDeclaration, (ASTNode)existingFieldDecl, editGroup);
            }
        } else {
            insertionPosition = 0;
            this.fListRewrite.insertLast((ASTNode)fieldDeclaration, editGroup);
        }
        this.fFields.add(insertionPosition, fieldDeclaration);
    }

    private FieldDeclaration getNewFinalStringFieldDeclaration(String name) {
        VariableDeclarationFragment variableDeclarationFragment = this.fAst.newVariableDeclarationFragment();
        variableDeclarationFragment.setName(this.fAst.newSimpleName(name));
        FieldDeclaration fieldDeclaration = this.fAst.newFieldDeclaration(variableDeclarationFragment);
        fieldDeclaration.setType((Type)this.fAst.newSimpleType((Name)this.fAst.newSimpleName("String")));
        fieldDeclaration.modifiers().add(this.fAst.newModifier(Modifier.ModifierKeyword.PUBLIC_KEYWORD));
        fieldDeclaration.modifiers().add(this.fAst.newModifier(Modifier.ModifierKeyword.STATIC_KEYWORD));
        return fieldDeclaration;
    }
}

