/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.corext.refactoring.rename;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.RefactoringDescriptor;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.participants.RefactoringArguments;
import org.eclipse.wst.jsdt.core.Flags;
import org.eclipse.wst.jsdt.core.IField;
import org.eclipse.wst.jsdt.core.IJavaElement;
import org.eclipse.wst.jsdt.core.IJavaProject;
import org.eclipse.wst.jsdt.core.IType;
import org.eclipse.wst.jsdt.core.JavaModelException;
import org.eclipse.wst.jsdt.core.refactoring.descriptors.RenameJavaElementDescriptor;
import org.eclipse.wst.jsdt.internal.corext.refactoring.Checks;
import org.eclipse.wst.jsdt.internal.corext.refactoring.JDTRefactoringDescriptor;
import org.eclipse.wst.jsdt.internal.corext.refactoring.JDTRefactoringDescriptorComment;
import org.eclipse.wst.jsdt.internal.corext.refactoring.JavaRefactoringArguments;
import org.eclipse.wst.jsdt.internal.corext.refactoring.RefactoringAvailabilityTester;
import org.eclipse.wst.jsdt.internal.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.wst.jsdt.internal.corext.refactoring.changes.RefactoringDescriptorChange;
import org.eclipse.wst.jsdt.internal.corext.refactoring.code.ScriptableRefactoring;
import org.eclipse.wst.jsdt.internal.corext.refactoring.rename.RenameFieldProcessor;
import org.eclipse.wst.jsdt.internal.corext.util.Messages;
import org.eclipse.wst.jsdt.internal.ui.JavaPlugin;
import org.eclipse.wst.jsdt.ui.JavaElementLabels;

public final class RenameEnumConstProcessor
extends RenameFieldProcessor {
    public static final String IDENTIFIER = "org.eclipse.wst.jsdt.ui.renameEnumConstProcessor";

    public RenameEnumConstProcessor(IField field) {
        super(field);
    }

    public String canEnableGetterRenaming() throws CoreException {
        return "";
    }

    public String canEnableSetterRenaming() throws CoreException {
        return "";
    }

    public RefactoringStatus checkNewElementName(String newName) throws CoreException {
        RefactoringStatus result = Checks.checkEnumConstantName(newName);
        if (Checks.isAlreadyNamed((IJavaElement)this.getField(), newName)) {
            result.addFatalError(RefactoringCoreMessages.RenameEnumConstRefactoring_another_name);
        }
        if (this.getField().getDeclaringType().getField(newName).exists()) {
            result.addFatalError(RefactoringCoreMessages.RenameEnumConstRefactoring_const_already_defined);
        }
        return result;
    }

    public Change createChange(IProgressMonitor monitor) throws CoreException {
        Change change = super.createChange(monitor);
        if (change != null) {
            IField field = this.getField();
            String project = null;
            IJavaProject javaProject = field.getJavaProject();
            if (javaProject != null) {
                project = javaProject.getElementName();
            }
            int flags = 589826;
            IType declaring = field.getDeclaringType();
            try {
                if (!Flags.isPrivate((int)declaring.getFlags())) {
                    flags |= 4;
                }
                if (declaring.isAnonymous() || declaring.isLocal()) {
                    flags |= 0x40000;
                }
            }
            catch (JavaModelException exception) {
                JavaPlugin.log(exception);
            }
            String description = Messages.format(RefactoringCoreMessages.RenameEnumConstProcessor_descriptor_description_short, this.fField.getElementName());
            String header = Messages.format(RefactoringCoreMessages.RenameEnumConstProcessor_descriptor_description, new String[]{field.getElementName(), JavaElementLabels.getElementLabel(field.getParent(), JavaElementLabels.ALL_FULLY_QUALIFIED), this.getNewElementName()});
            String comment = new JDTRefactoringDescriptorComment(project, this, header).asString();
            RenameJavaElementDescriptor descriptor = new RenameJavaElementDescriptor("org.eclipse.wst.jsdt.ui.rename.enum.constant");
            descriptor.setProject(project);
            descriptor.setDescription(description);
            descriptor.setComment(comment);
            descriptor.setFlags(flags);
            descriptor.setJavaElement((IJavaElement)field);
            descriptor.setNewName(this.getNewElementName());
            descriptor.setUpdateReferences(this.fUpdateReferences);
            descriptor.setUpdateTextualOccurrences(this.fUpdateTextualMatches);
            RefactoringDescriptorChange extended = new RefactoringDescriptorChange((RefactoringDescriptor)descriptor, RefactoringCoreMessages.RenameEnumConstProcessor_change_name, new Change[]{change});
            extended.markAsSynthetic();
            return extended;
        }
        return change;
    }

    public String getIdentifier() {
        return IDENTIFIER;
    }

    public String getProcessorName() {
        return RefactoringCoreMessages.RenameEnumConstRefactoring_name;
    }

    public RefactoringStatus initialize(RefactoringArguments arguments) {
        String matches;
        if (arguments instanceof JavaRefactoringArguments) {
            IJavaElement element;
            JavaRefactoringArguments extended = (JavaRefactoringArguments)arguments;
            String handle = extended.getAttribute("input");
            if (handle != null) {
                element = JDTRefactoringDescriptor.handleToElement(extended.getProject(), handle, false);
                if (element == null || !element.exists() || element.getElementType() != 8) {
                    return ScriptableRefactoring.createInputFatalStatus(element, this.getRefactoring().getName(), "org.eclipse.wst.jsdt.ui.rename.enum.constant");
                }
            } else {
                return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, "input"));
            }
            this.fField = (IField)element;
            String name = extended.getAttribute("name");
            if (name == null || "".equals(name)) {
                return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, "name"));
            }
            this.setNewElementName(name);
            String references = extended.getAttribute("references");
            if (references == null) {
                return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, "references"));
            }
            this.setUpdateReferences(Boolean.valueOf(references));
            matches = extended.getAttribute("textual");
            if (matches == null) {
                return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, "textual"));
            }
        } else {
            return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.InitializableRefactoring_inacceptable_arguments);
        }
        this.setUpdateTextualMatches(Boolean.valueOf(matches));
        return new RefactoringStatus();
    }

    public boolean isApplicable() throws CoreException {
        return RefactoringAvailabilityTester.isRenameEnumConstAvailable(this.getField());
    }
}

