/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.corext.refactoring.rename;

import java.util.StringTokenizer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.GroupCategorySet;
import org.eclipse.ltk.core.refactoring.RefactoringDescriptor;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.TextChange;
import org.eclipse.ltk.core.refactoring.participants.CheckConditionsContext;
import org.eclipse.ltk.core.refactoring.participants.RefactoringArguments;
import org.eclipse.ltk.core.refactoring.participants.RenameArguments;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.text.edits.TextEditGroup;
import org.eclipse.wst.jsdt.core.ICompilationUnit;
import org.eclipse.wst.jsdt.core.IJavaElement;
import org.eclipse.wst.jsdt.core.IJavaProject;
import org.eclipse.wst.jsdt.core.ILocalVariable;
import org.eclipse.wst.jsdt.core.IMethod;
import org.eclipse.wst.jsdt.core.ISourceRange;
import org.eclipse.wst.jsdt.core.ITypeRoot;
import org.eclipse.wst.jsdt.core.JavaModelException;
import org.eclipse.wst.jsdt.core.dom.ASTNode;
import org.eclipse.wst.jsdt.core.dom.CompilationUnit;
import org.eclipse.wst.jsdt.core.dom.VariableDeclaration;
import org.eclipse.wst.jsdt.core.refactoring.descriptors.RenameLocalVariableDescriptor;
import org.eclipse.wst.jsdt.internal.corext.dom.NodeFinder;
import org.eclipse.wst.jsdt.internal.corext.refactoring.Checks;
import org.eclipse.wst.jsdt.internal.corext.refactoring.JDTRefactoringDescriptor;
import org.eclipse.wst.jsdt.internal.corext.refactoring.JDTRefactoringDescriptorComment;
import org.eclipse.wst.jsdt.internal.corext.refactoring.JavaRefactoringArguments;
import org.eclipse.wst.jsdt.internal.corext.refactoring.RefactoringAvailabilityTester;
import org.eclipse.wst.jsdt.internal.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.wst.jsdt.internal.corext.refactoring.changes.CompilationUnitChange;
import org.eclipse.wst.jsdt.internal.corext.refactoring.changes.RefactoringDescriptorChange;
import org.eclipse.wst.jsdt.internal.corext.refactoring.changes.TextChangeCompatibility;
import org.eclipse.wst.jsdt.internal.corext.refactoring.code.ScriptableRefactoring;
import org.eclipse.wst.jsdt.internal.corext.refactoring.participants.JavaProcessors;
import org.eclipse.wst.jsdt.internal.corext.refactoring.rename.JavaRenameProcessor;
import org.eclipse.wst.jsdt.internal.corext.refactoring.rename.RenameAnalyzeUtil;
import org.eclipse.wst.jsdt.internal.corext.refactoring.rename.RenameModifications;
import org.eclipse.wst.jsdt.internal.corext.refactoring.rename.TempOccurrenceAnalyzer;
import org.eclipse.wst.jsdt.internal.corext.refactoring.tagging.IReferenceUpdating;
import org.eclipse.wst.jsdt.internal.corext.refactoring.util.RefactoringASTParser;
import org.eclipse.wst.jsdt.internal.corext.refactoring.util.ResourceUtil;
import org.eclipse.wst.jsdt.internal.corext.refactoring.util.TextChangeManager;
import org.eclipse.wst.jsdt.internal.corext.util.Messages;
import org.eclipse.wst.jsdt.internal.ui.JavaPlugin;
import org.eclipse.wst.jsdt.ui.JavaElementLabels;

public class RenameLocalVariableProcessor
extends JavaRenameProcessor
implements IReferenceUpdating {
    private ILocalVariable fLocalVariable;
    private ICompilationUnit fCu;
    private boolean fUpdateReferences;
    private String fCurrentName;
    private String fNewName;
    private CompilationUnit fCompilationUnitNode;
    private VariableDeclaration fTempDeclarationNode;
    private TextChange fChange;
    private boolean fIsComposite;
    private GroupCategorySet fCategorySet;
    private TextChangeManager fChangeManager;
    private RenameAnalyzeUtil.LocalAnalyzePackage fLocalAnalyzePackage;
    public static final String IDENTIFIER = "org.eclipse.wst.jsdt.ui.renameLocalVariableProcessor";
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public RenameLocalVariableProcessor(ILocalVariable localVariable) {
        this.fLocalVariable = localVariable;
        this.fUpdateReferences = true;
        if (localVariable != null) {
            this.fCu = (ICompilationUnit)localVariable.getAncestor(5);
        }
        this.fNewName = "";
        this.fIsComposite = false;
    }

    RenameLocalVariableProcessor(ILocalVariable localVariable, TextChangeManager manager, CompilationUnit node, GroupCategorySet categorySet) {
        this(localVariable);
        this.fChangeManager = manager;
        this.fCategorySet = categorySet;
        this.fCompilationUnitNode = node;
        this.fIsComposite = true;
    }

    protected final String[] getAffectedProjectNatures() throws CoreException {
        return JavaProcessors.computeAffectedNatures((IJavaElement)this.fLocalVariable);
    }

    public Object[] getElements() {
        return new Object[]{this.fLocalVariable};
    }

    public String getIdentifier() {
        return IDENTIFIER;
    }

    public String getProcessorName() {
        return RefactoringCoreMessages.RenameTempRefactoring_rename;
    }

    public boolean isApplicable() throws CoreException {
        return RefactoringAvailabilityTester.isRenameAvailable(this.fLocalVariable);
    }

    public boolean canEnableUpdateReferences() {
        return true;
    }

    public boolean getUpdateReferences() {
        return this.fUpdateReferences;
    }

    public void setUpdateReferences(boolean updateReferences) {
        this.fUpdateReferences = updateReferences;
    }

    public String getCurrentElementName() {
        return this.fCurrentName;
    }

    public String getNewElementName() {
        return this.fNewName;
    }

    public void setNewElementName(String newName) {
        Assert.isNotNull((Object)newName);
        this.fNewName = newName;
    }

    public Object getNewElement() {
        return null;
    }

    public RefactoringStatus checkInitialConditions(IProgressMonitor pm) throws CoreException {
        this.initAST();
        if (this.fTempDeclarationNode == null || this.fTempDeclarationNode.resolveBinding() == null) {
            return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.RenameTempRefactoring_must_select_local);
        }
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.wst.jsdt.core.dom.MethodDeclaration");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (!Checks.isDeclaredIn(this.fTempDeclarationNode, clazz)) {
            Class<?> clazz2 = class$1;
            if (clazz2 == null) {
                try {
                    clazz2 = class$1 = Class.forName("org.eclipse.wst.jsdt.core.dom.Initializer");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (!Checks.isDeclaredIn(this.fTempDeclarationNode, clazz2)) {
                return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.RenameTempRefactoring_only_in_methods_and_initializers);
            }
        }
        this.initNames();
        return new RefactoringStatus();
    }

    private void initAST() throws JavaModelException {
        ISourceRange sourceRange;
        ASTNode name;
        if (!this.fIsComposite) {
            this.fCompilationUnitNode = RefactoringASTParser.parseWithASTProvider((ITypeRoot)this.fCu, true, null);
        }
        if ((name = NodeFinder.perform((ASTNode)this.fCompilationUnitNode, sourceRange = this.fLocalVariable.getNameRange())) == null) {
            return;
        }
        if (name.getParent() instanceof VariableDeclaration) {
            this.fTempDeclarationNode = (VariableDeclaration)name.getParent();
        }
    }

    private void initNames() {
        this.fCurrentName = this.fTempDeclarationNode.getName().getIdentifier();
    }

    protected RenameModifications computeRenameModifications() throws CoreException {
        RenameModifications result = new RenameModifications();
        result.rename(this.fLocalVariable, new RenameArguments(this.getNewElementName(), this.getUpdateReferences()));
        return result;
    }

    protected IFile[] getChangedFiles() throws CoreException {
        return new IFile[]{ResourceUtil.getFile(this.fCu)};
    }

    public int getSaveMode() {
        return 5;
    }

    protected RefactoringStatus doCheckFinalConditions(IProgressMonitor pm, CheckConditionsContext context) throws CoreException, OperationCanceledException {
        RefactoringStatus result;
        block6: {
            RefactoringStatus refactoringStatus;
            try {
                pm.beginTask("", 1);
                result = this.checkNewElementName(this.fNewName);
                if (!result.hasFatalError()) break block6;
                refactoringStatus = result;
                Object var5_6 = null;
            }
            catch (Throwable throwable) {
                block7: {
                    Object var5_8 = null;
                    pm.done();
                    if (!this.fIsComposite) break block7;
                    this.fChange = null;
                    this.fCompilationUnitNode = null;
                    this.fTempDeclarationNode = null;
                }
                throw throwable;
            }
            pm.done();
            if (this.fIsComposite) {
                this.fChange = null;
                this.fCompilationUnitNode = null;
                this.fTempDeclarationNode = null;
            }
            return refactoringStatus;
        }
        this.createEdits();
        if (!this.fIsComposite) {
            RenameAnalyzeUtil.LocalAnalyzePackage[] localAnalyzePackages = new RenameAnalyzeUtil.LocalAnalyzePackage[]{this.fLocalAnalyzePackage};
            result.merge(RenameAnalyzeUtil.analyzeLocalRenames(localAnalyzePackages, this.fChange, this.fCompilationUnitNode, true));
        }
        RefactoringStatus refactoringStatus = result;
        Object var5_7 = null;
        pm.done();
        if (this.fIsComposite) {
            this.fChange = null;
            this.fCompilationUnitNode = null;
            this.fTempDeclarationNode = null;
        }
        return refactoringStatus;
    }

    public RefactoringStatus checkNewElementName(String newName) throws JavaModelException {
        RefactoringStatus result = Checks.checkFieldName(newName);
        if (!Checks.startsWithLowerCase(newName)) {
            if (this.fIsComposite) {
                String nameOfParent = this.fLocalVariable.getParent() instanceof IMethod ? this.fLocalVariable.getParent().getElementName() : RefactoringCoreMessages.JavaElementUtil_initializer;
                String nameOfType = this.fLocalVariable.getAncestor(7).getElementName();
                result.addWarning(Messages.format(RefactoringCoreMessages.RenameTempRefactoring_lowercase2, new String[]{newName, nameOfParent, nameOfType}));
            } else {
                result.addWarning(RefactoringCoreMessages.RenameTempRefactoring_lowercase);
            }
        }
        return result;
    }

    private void createEdits() {
        TextEdit declarationEdit = this.createRenameEdit(this.fTempDeclarationNode.getName().getStartPosition());
        TextEdit[] allRenameEdits = this.getAllRenameEdits(declarationEdit);
        TextEdit[] allUnparentedRenameEdits = new TextEdit[allRenameEdits.length];
        TextEdit unparentedDeclarationEdit = null;
        this.fChange = new CompilationUnitChange(RefactoringCoreMessages.RenameTempRefactoring_rename, this.fCu);
        MultiTextEdit rootEdit = new MultiTextEdit();
        this.fChange.setEdit((TextEdit)rootEdit);
        this.fChange.setKeepPreviewEdits(true);
        int i = 0;
        while (i < allRenameEdits.length) {
            if (this.fIsComposite) {
                TextChangeCompatibility.addTextEdit(this.fChangeManager.get(this.fCu), RefactoringCoreMessages.RenameTempRefactoring_changeName, allRenameEdits[i].copy(), this.fCategorySet);
                allUnparentedRenameEdits[i] = allRenameEdits[i].copy();
                if (allRenameEdits[i].equals((Object)declarationEdit)) {
                    unparentedDeclarationEdit = allUnparentedRenameEdits[i];
                }
            }
            rootEdit.addChild(allRenameEdits[i]);
            this.fChange.addTextEditGroup(new TextEditGroup(RefactoringCoreMessages.RenameTempRefactoring_changeName, allRenameEdits[i]));
            ++i;
        }
        this.fLocalAnalyzePackage = this.fIsComposite ? new RenameAnalyzeUtil.LocalAnalyzePackage(unparentedDeclarationEdit, allUnparentedRenameEdits) : new RenameAnalyzeUtil.LocalAnalyzePackage(declarationEdit, allRenameEdits);
    }

    private TextEdit[] getAllRenameEdits(TextEdit declarationEdit) {
        if (!this.fUpdateReferences) {
            return new TextEdit[]{declarationEdit};
        }
        TempOccurrenceAnalyzer fTempAnalyzer = new TempOccurrenceAnalyzer(this.fTempDeclarationNode, true);
        fTempAnalyzer.perform();
        int[] referenceOffsets = fTempAnalyzer.getReferenceAndJavadocOffsets();
        TextEdit[] allRenameEdits = new TextEdit[referenceOffsets.length + 1];
        int i = 0;
        while (i < referenceOffsets.length) {
            allRenameEdits[i] = this.createRenameEdit(referenceOffsets[i]);
            ++i;
        }
        allRenameEdits[referenceOffsets.length] = declarationEdit;
        return allRenameEdits;
    }

    private TextEdit createRenameEdit(int offset) {
        return new ReplaceEdit(offset, this.fCurrentName.length(), this.fNewName);
    }

    public Change createChange(IProgressMonitor monitor) throws CoreException {
        TextChange textChange;
        try {
            monitor.beginTask(RefactoringCoreMessages.RenameTypeProcessor_creating_changes, 1);
            Object change = this.fChange;
            if (change != null) {
                ISourceRange range = this.fLocalVariable.getNameRange();
                String project = null;
                IJavaProject javaProject = this.fCu.getJavaProject();
                if (javaProject != null) {
                    project = javaProject.getElementName();
                }
                String header = Messages.format(RefactoringCoreMessages.RenameLocalVariableProcessor_descriptor_description, new String[]{this.fCurrentName, JavaElementLabels.getElementLabel(this.fLocalVariable.getParent(), JavaElementLabels.ALL_FULLY_QUALIFIED), this.fNewName});
                String description = Messages.format(RefactoringCoreMessages.RenameLocalVariableProcessor_descriptor_description_short, this.fCurrentName);
                String comment = new JDTRefactoringDescriptorComment(project, this, header).asString();
                RenameLocalVariableDescriptor descriptor = new RenameLocalVariableDescriptor();
                descriptor.setProject(project);
                descriptor.setDescription(description);
                descriptor.setComment(comment);
                descriptor.setFlags(0);
                descriptor.setCompilationUnit(this.fCu);
                descriptor.setNewName(this.getNewElementName());
                descriptor.setSelection(range);
                descriptor.setUpdateReferences(this.fUpdateReferences);
                RefactoringDescriptorChange result = new RefactoringDescriptorChange((RefactoringDescriptor)descriptor, RefactoringCoreMessages.RenameTempRefactoring_rename, new Change[]{change});
                result.markAsSynthetic();
                change = result;
            }
            textChange = change;
            Object var11_12 = null;
        }
        catch (Throwable throwable) {
            Object var11_13 = null;
            monitor.done();
            throw throwable;
        }
        monitor.done();
        return textChange;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public RefactoringStatus initialize(RefactoringArguments arguments) {
        String references;
        if (!(arguments instanceof JavaRefactoringArguments)) return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.InitializableRefactoring_inacceptable_arguments);
        JavaRefactoringArguments extended = (JavaRefactoringArguments)arguments;
        String handle = extended.getAttribute("input");
        if (handle == null) return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, "input"));
        IJavaElement element = JDTRefactoringDescriptor.handleToElement(extended.getProject(), handle, false);
        if (element == null || !element.exists()) return ScriptableRefactoring.createInputFatalStatus(element, this.getRefactoring().getName(), "org.eclipse.wst.jsdt.ui.rename.local.variable");
        if (element.getElementType() == 5) {
            this.fCu = (ICompilationUnit)element;
        } else {
            if (element.getElementType() != 14) return ScriptableRefactoring.createInputFatalStatus(element, this.getRefactoring().getName(), "org.eclipse.wst.jsdt.ui.rename.local.variable");
            this.fLocalVariable = (ILocalVariable)element;
            this.fCu = (ICompilationUnit)this.fLocalVariable.getAncestor(5);
            if (this.fCu == null) {
                return ScriptableRefactoring.createInputFatalStatus(element, this.getRefactoring().getName(), "org.eclipse.wst.jsdt.ui.rename.local.variable");
            }
        }
        String name = extended.getAttribute("name");
        if (name == null || "".equals(name)) {
            return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, "name"));
        }
        this.setNewElementName(name);
        if (this.fCu != null && this.fLocalVariable == null) {
            String selection = extended.getAttribute("selection");
            if (selection == null) return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, "selection"));
            int offset = -1;
            int length = -1;
            StringTokenizer tokenizer = new StringTokenizer(selection);
            if (tokenizer.hasMoreTokens()) {
                offset = Integer.valueOf(tokenizer.nextToken());
            }
            if (tokenizer.hasMoreTokens()) {
                length = Integer.valueOf(tokenizer.nextToken());
            }
            if (offset < 0 || length < 0) return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_illegal_argument, new Object[]{selection, "selection"}));
            try {
                IJavaElement[] elements = this.fCu.codeSelect(offset, length);
                if (elements != null) {
                    int index = 0;
                    while (index < elements.length) {
                        IJavaElement element2 = elements[index];
                        if (element2 instanceof ILocalVariable) {
                            this.fLocalVariable = (ILocalVariable)element2;
                        }
                        ++index;
                    }
                }
                if (this.fLocalVariable == null) {
                    return ScriptableRefactoring.createInputFatalStatus(null, this.getRefactoring().getName(), "org.eclipse.wst.jsdt.ui.rename.local.variable");
                }
            }
            catch (JavaModelException exception) {
                JavaPlugin.log(exception);
            }
        }
        if ((references = extended.getAttribute("references")) == null) {
            return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, "references"));
        }
        this.fUpdateReferences = Boolean.valueOf(references);
        return new RefactoringStatus();
    }

    public RenameAnalyzeUtil.LocalAnalyzePackage getLocalAnalyzePackage() {
        return this.fLocalAnalyzePackage;
    }
}

