/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.corext.refactoring.rename;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.ltk.core.refactoring.GroupCategorySet;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.RefactoringStatusContext;
import org.eclipse.ltk.core.refactoring.participants.CheckConditionsContext;
import org.eclipse.ltk.core.refactoring.participants.RefactoringArguments;
import org.eclipse.wst.jsdt.core.IMember;
import org.eclipse.wst.jsdt.core.IMethod;
import org.eclipse.wst.jsdt.core.IType;
import org.eclipse.wst.jsdt.core.ITypeHierarchy;
import org.eclipse.wst.jsdt.core.JavaModelException;
import org.eclipse.wst.jsdt.internal.corext.refactoring.Checks;
import org.eclipse.wst.jsdt.internal.corext.refactoring.RefactoringAvailabilityTester;
import org.eclipse.wst.jsdt.internal.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.wst.jsdt.internal.corext.refactoring.base.JavaStatusContext;
import org.eclipse.wst.jsdt.internal.corext.refactoring.rename.MethodChecks;
import org.eclipse.wst.jsdt.internal.corext.refactoring.rename.RenameMethodProcessor;
import org.eclipse.wst.jsdt.internal.corext.refactoring.util.TextChangeManager;
import org.eclipse.wst.jsdt.internal.corext.util.JdtFlags;
import org.eclipse.wst.jsdt.internal.corext.util.Messages;

public class RenameVirtualMethodProcessor
extends RenameMethodProcessor {
    private IMethod fOriginalMethod = this.getMethod();
    private boolean fActivationChecked;
    private ITypeHierarchy fCachedHierarchy = null;

    public RenameVirtualMethodProcessor(IMethod method) {
        super(method);
    }

    RenameVirtualMethodProcessor(IMethod topLevel, IMethod[] ripples, TextChangeManager changeManager, ITypeHierarchy hierarchy, GroupCategorySet categorySet) {
        super(topLevel, changeManager, categorySet);
        this.fActivationChecked = true;
        this.fCachedHierarchy = hierarchy;
        this.setMethodsToRename(ripples);
    }

    public IMethod getOriginalMethod() {
        return this.fOriginalMethod;
    }

    private ITypeHierarchy getCachedHierarchy(IType declaring, IProgressMonitor monitor) throws JavaModelException {
        if (this.fCachedHierarchy != null && declaring.equals(this.fCachedHierarchy.getType())) {
            return this.fCachedHierarchy;
        }
        this.fCachedHierarchy = declaring.newTypeHierarchy((IProgressMonitor)new SubProgressMonitor(monitor, 1));
        return this.fCachedHierarchy;
    }

    public boolean isApplicable() throws CoreException {
        return RefactoringAvailabilityTester.isRenameVirtualMethodAvailable(this.getMethod());
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public RefactoringStatus checkInitialConditions(IProgressMonitor monitor) throws CoreException {
        RefactoringStatus result = super.checkInitialConditions(monitor);
        if (result.hasFatalError()) {
            return result;
        }
        try {
            monitor.beginTask("", 3);
            if (!this.fActivationChecked) {
                IMethod topmost;
                IMethod method;
                this.fOriginalMethod = method = this.getMethod();
                ITypeHierarchy hierarchy = null;
                IType declaringType = method.getDeclaringType();
                if (declaringType != null && !declaringType.isInterface()) {
                    hierarchy = this.getCachedHierarchy(declaringType, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                }
                if (MethodChecks.isVirtual(topmost = this.getMethod())) {
                    topmost = MethodChecks.getTopmostMethod(this.getMethod(), hierarchy, monitor);
                }
                if (topmost != null) {
                    this.initialize(topmost);
                }
                this.fActivationChecked = true;
            }
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            monitor.done();
            throw throwable;
        }
        {
            Object var7_9 = null;
        }
        monitor.done();
        return result;
    }

    protected RefactoringStatus doCheckFinalConditions(IProgressMonitor pm, CheckConditionsContext checkContext) throws CoreException {
        RefactoringStatus refactoringStatus;
        RefactoringStatus result;
        block11: {
            pm.beginTask("", 9);
            result = new RefactoringStatus();
            result.merge(super.doCheckFinalConditions((IProgressMonitor)new SubProgressMonitor(pm, 7), checkContext));
            if (!result.hasFatalError()) break block11;
            RefactoringStatus refactoringStatus2 = result;
            Object var12_6 = null;
            pm.done();
            return refactoringStatus2;
        }
        try {
            IMethod method = this.getMethod();
            IType declaring = method.getDeclaringType();
            ITypeHierarchy hierarchy = this.getCachedHierarchy(declaring, (IProgressMonitor)new SubProgressMonitor(pm, 1));
            String name = this.getNewElementName();
            if (declaring.isInterface()) {
                if (this.isSpecialCase()) {
                    result.addError(RefactoringCoreMessages.RenameMethodInInterfaceRefactoring_special_case);
                }
                pm.worked(1);
                IMethod[] relatedMethods = this.relatedTypeDeclaresMethodName((IProgressMonitor)new SubProgressMonitor(pm, 1), method, name);
                int i = 0;
                while (i < relatedMethods.length) {
                    IMethod relatedMethod = relatedMethods[i];
                    RefactoringStatusContext context = JavaStatusContext.create((IMember)relatedMethod);
                    result.addError(RefactoringCoreMessages.RenameMethodInInterfaceRefactoring_already_defined, context);
                    ++i;
                }
            } else {
                if (this.classesDeclareOverridingNativeMethod(hierarchy.getAllSubtypes(declaring))) {
                    result.addError(Messages.format(RefactoringCoreMessages.RenameVirtualMethodRefactoring_requieres_renaming_native, new String[]{method.getElementName(), "UnsatisfiedLinkError"}));
                }
                IMethod[] hierarchyMethods = RenameVirtualMethodProcessor.hierarchyDeclaresMethodName((IProgressMonitor)new SubProgressMonitor(pm, 1), hierarchy, method, name);
                int i = 0;
                while (i < hierarchyMethods.length) {
                    IMethod hierarchyMethod = hierarchyMethods[i];
                    RefactoringStatusContext context = JavaStatusContext.create((IMember)hierarchyMethod);
                    if (Checks.compareParamTypes(method.getParameterTypes(), hierarchyMethod.getParameterTypes())) {
                        result.addError(Messages.format(RefactoringCoreMessages.RenameVirtualMethodRefactoring_hierarchy_declares2, name), context);
                    } else {
                        result.addWarning(Messages.format(RefactoringCoreMessages.RenameVirtualMethodRefactoring_hierarchy_declares1, name), context);
                    }
                    ++i;
                }
            }
            this.fCachedHierarchy = null;
            refactoringStatus = result;
            Object var12_7 = null;
        }
        catch (Throwable throwable) {
            Object var12_8 = null;
            pm.done();
            throw throwable;
        }
        pm.done();
        return refactoringStatus;
    }

    private IMethod[] relatedTypeDeclaresMethodName(IProgressMonitor pm, IMethod method, String newName) throws CoreException {
        IMethod[] iMethodArray;
        try {
            HashSet<IMethod> result = new HashSet<IMethod>();
            Set types = this.getRelatedTypes();
            pm.beginTask("", types.size());
            Iterator iter = types.iterator();
            while (iter.hasNext()) {
                IMethod found = Checks.findMethod(method, (IType)iter.next());
                IType declaring = found.getDeclaringType();
                result.addAll(Arrays.asList(RenameVirtualMethodProcessor.hierarchyDeclaresMethodName((IProgressMonitor)new SubProgressMonitor(pm, 1), declaring.newTypeHierarchy((IProgressMonitor)new SubProgressMonitor(pm, 1)), found, newName)));
            }
            iMethodArray = result.toArray(new IMethod[result.size()]);
            Object var9_10 = null;
        }
        catch (Throwable throwable) {
            Object var9_11 = null;
            pm.done();
            throw throwable;
        }
        pm.done();
        return iMethodArray;
    }

    private boolean isSpecialCase() throws CoreException {
        String[] noParams = new String[]{};
        String[] specialNames = new String[]{"toString", "toString", "toString", "toString", "equals", "equals", "getClass", "getClass", "hashCode", "notify", "notifyAll", "wait", "wait", "wait"};
        String[][] specialParamTypes = new String[][]{noParams, noParams, noParams, noParams, {"QObject;"}, {"Qjava.lang.Object;"}, noParams, noParams, noParams, noParams, noParams, {"J", "I"}, {"J"}, noParams};
        String[] specialReturnTypes = new String[]{"QString;", "QString;", "Qjava.lang.String;", "Qjava.lang.String;", "Z", "Z", "QClass;", "Qjava.lang.Class;", "I", "V", "V", "V", "V", "V"};
        Assert.isTrue((specialNames.length == specialParamTypes.length && specialParamTypes.length == specialReturnTypes.length ? 1 : 0) != 0);
        int i = 0;
        while (i < specialNames.length) {
            if (specialNames[i].equals(this.getNewElementName()) && Checks.compareParamTypes(this.getMethod().getParameterTypes(), specialParamTypes[i]) && !specialReturnTypes[i].equals(this.getMethod().getReturnType())) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private Set getRelatedTypes() {
        Set methods = this.getMethodsToRename();
        HashSet<IType> result = new HashSet<IType>(methods.size());
        Iterator iter = methods.iterator();
        while (iter.hasNext()) {
            result.add(((IMethod)iter.next()).getDeclaringType());
        }
        return result;
    }

    private boolean classesDeclareOverridingNativeMethod(IType[] classes) throws CoreException {
        int i = 0;
        while (i < classes.length) {
            IMethod[] methods = classes[i].getMethods();
            int j = 0;
            while (j < methods.length) {
                if (!methods[j].equals(this.getMethod()) && JdtFlags.isNative((IMember)methods[j]) && Checks.findSimilarMethod(this.getMethod(), new IMethod[]{methods[j]}) != null) {
                    return true;
                }
                ++j;
            }
            ++i;
        }
        return false;
    }

    public RefactoringStatus initialize(RefactoringArguments arguments) {
        RefactoringStatus status = super.initialize(arguments);
        this.fOriginalMethod = this.getMethod();
        return status;
    }

    public String getDelegateUpdatingTitle(boolean plural) {
        if (plural) {
            return RefactoringCoreMessages.DelegateMethodCreator_keep_original_renamed_plural;
        }
        return RefactoringCoreMessages.DelegateMethodCreator_keep_original_renamed_singular;
    }
}

