/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.corext.refactoring.rename;

import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.wst.jsdt.core.dom.ASTNode;
import org.eclipse.wst.jsdt.core.dom.ASTVisitor;
import org.eclipse.wst.jsdt.core.dom.CompilationUnit;
import org.eclipse.wst.jsdt.core.dom.IBinding;
import org.eclipse.wst.jsdt.core.dom.Name;
import org.eclipse.wst.jsdt.core.dom.SimpleName;
import org.eclipse.wst.jsdt.core.dom.VariableDeclaration;
import org.eclipse.wst.jsdt.core.dom.VariableDeclarationStatement;
import org.eclipse.wst.jsdt.internal.corext.dom.Selection;
import org.eclipse.wst.jsdt.internal.corext.dom.SelectionAnalyzer;

public class TempDeclarationFinder {
    private TempDeclarationFinder() {
    }

    public static VariableDeclaration findTempDeclaration(CompilationUnit cu, int selectionOffset, int selectionLength) {
        TempSelectionAnalyzer analyzer = new TempSelectionAnalyzer(selectionOffset, selectionLength);
        cu.accept((ASTVisitor)analyzer);
        ASTNode[] selected = analyzer.getSelectedNodes();
        if (selected == null || selected.length != 1) {
            return null;
        }
        ASTNode selectedNode = selected[0];
        if (selectedNode instanceof VariableDeclaration) {
            return (VariableDeclaration)selectedNode;
        }
        if (selectedNode instanceof Name) {
            Name reference = (Name)selectedNode;
            IBinding binding = reference.resolveBinding();
            if (binding == null) {
                return null;
            }
            ASTNode declaringNode = cu.findDeclaringNode(binding);
            if (declaringNode instanceof VariableDeclaration) {
                return (VariableDeclaration)declaringNode;
            }
            return null;
        }
        if (selectedNode instanceof VariableDeclarationStatement) {
            VariableDeclarationStatement vds = (VariableDeclarationStatement)selectedNode;
            if (vds.fragments().size() != 1) {
                return null;
            }
            return (VariableDeclaration)vds.fragments().get(0);
        }
        return null;
    }

    private static class TempSelectionAnalyzer
    extends SelectionAnalyzer {
        private ASTNode fNode;

        TempSelectionAnalyzer(int selectionOffset, int selectionLength) {
            super(Selection.createFromStartLength(selectionOffset, selectionLength), true);
        }

        public boolean visitNode(ASTNode node) {
            if (node instanceof VariableDeclaration) {
                return this.visitVariableDeclaration((VariableDeclaration)node);
            }
            if (node instanceof SimpleName) {
                return this.visitSimpleName((SimpleName)node);
            }
            return super.visitNode(node);
        }

        private boolean addNodeAndStop(ASTNode node) {
            this.fNode = node;
            return false;
        }

        private boolean visitSimpleName(SimpleName name) {
            if (this.getSelection().coveredBy((ASTNode)name)) {
                return this.addNodeAndStop((ASTNode)name);
            }
            return super.visitNode((ASTNode)name);
        }

        private boolean visitVariableDeclaration(VariableDeclaration vd) {
            if (vd.getInitializer() != null) {
                int start = vd.getStartPosition();
                Region declarationRange = new Region(start, vd.getInitializer().getStartPosition() - start);
                if (this.getSelection().coveredBy((IRegion)declarationRange)) {
                    return this.addNodeAndStop((ASTNode)vd);
                }
                return super.visitNode((ASTNode)vd);
            }
            if (this.getSelection().coveredBy((ASTNode)vd)) {
                return this.addNodeAndStop((ASTNode)vd);
            }
            return super.visitNode((ASTNode)vd);
        }

        public ASTNode[] getSelectedNodes() {
            if (this.fNode != null) {
                return new ASTNode[]{this.fNode};
            }
            return super.getSelectedNodes();
        }
    }
}

