/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.corext.refactoring.reorg;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.mapping.IResourceChangeDescriptionFactory;
import org.eclipse.core.resources.mapping.ResourceMapping;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.participants.CopyArguments;
import org.eclipse.ltk.core.refactoring.participants.IParticipantDescriptorFilter;
import org.eclipse.ltk.core.refactoring.participants.ParticipantManager;
import org.eclipse.ltk.core.refactoring.participants.RefactoringArguments;
import org.eclipse.ltk.core.refactoring.participants.RefactoringParticipant;
import org.eclipse.ltk.core.refactoring.participants.RefactoringProcessor;
import org.eclipse.ltk.core.refactoring.participants.SharableParticipants;
import org.eclipse.wst.jsdt.core.ICompilationUnit;
import org.eclipse.wst.jsdt.core.IJavaElement;
import org.eclipse.wst.jsdt.core.IPackageFragment;
import org.eclipse.wst.jsdt.core.IPackageFragmentRoot;
import org.eclipse.wst.jsdt.internal.corext.refactoring.participants.ResourceModifications;
import org.eclipse.wst.jsdt.internal.corext.refactoring.reorg.RefactoringModifications;
import org.eclipse.wst.jsdt.internal.corext.util.JavaElementResourceMapping;

public class CopyModifications
extends RefactoringModifications {
    private List fCopies = new ArrayList();
    private List fCopyArguments = new ArrayList();
    private List fParticipantDescriptorFilter = new ArrayList();

    public void copy(IResource resource, CopyArguments args) {
        this.add(resource, (RefactoringArguments)args, null);
    }

    public void copy(IJavaElement element, CopyArguments javaArgs, CopyArguments resourceArgs) throws CoreException {
        switch (element.getElementType()) {
            case 3: {
                this.copy((IPackageFragmentRoot)element, javaArgs, resourceArgs);
                break;
            }
            case 4: {
                this.copy((IPackageFragment)element, javaArgs, resourceArgs);
                break;
            }
            case 5: {
                this.copy((ICompilationUnit)element, javaArgs, resourceArgs);
                break;
            }
            default: {
                this.add(element, (RefactoringArguments)javaArgs, null);
            }
        }
    }

    public void copy(IPackageFragmentRoot sourceFolder, CopyArguments javaArgs, CopyArguments resourceArgs) {
        IResource sourceResource;
        this.add(sourceFolder, (RefactoringArguments)javaArgs, null);
        ResourceMapping mapping = JavaElementResourceMapping.create(sourceFolder);
        if (mapping != null) {
            this.add(mapping, (RefactoringArguments)resourceArgs, null);
        }
        if ((sourceResource = sourceFolder.getResource()) != null) {
            this.getResourceModifications().addCopyDelta(sourceResource, resourceArgs);
            IFile classpath = this.getClasspathFile((IResource)resourceArgs.getDestination());
            if (classpath != null) {
                this.getResourceModifications().addChanged(classpath);
            }
        }
    }

    public void copy(IPackageFragment pack, CopyArguments javaArgs, CopyArguments resourceArgs) throws CoreException {
        IPackageFragmentRoot javaDestination;
        this.add(pack, (RefactoringArguments)javaArgs, null);
        ResourceMapping mapping = JavaElementResourceMapping.create(pack);
        if (mapping != null) {
            this.add(mapping, (RefactoringArguments)resourceArgs, null);
        }
        if ((javaDestination = (IPackageFragmentRoot)javaArgs.getDestination()).getResource() == null) {
            return;
        }
        IPackageFragment newPack = javaDestination.getPackageFragment(pack.getElementName());
        if (!(pack.hasSubpackages() || newPack.exists() && !pack.equals(newPack))) {
            IContainer resourceDestination = newPack.getResource().getParent();
            this.createIncludingParents(resourceDestination);
            this.getResourceModifications().addCopyDelta(pack.getResource(), resourceArgs);
        } else {
            IContainer resourceDestination = (IContainer)newPack.getResource();
            this.createIncludingParents(resourceDestination);
            CopyArguments arguments = new CopyArguments((Object)resourceDestination, resourceArgs.getExecutionLog());
            IResource[] resourcesToCopy = this.collectResourcesOfInterest(pack);
            int i = 0;
            while (i < resourcesToCopy.length) {
                IResource toCopy = resourcesToCopy[i];
                this.getResourceModifications().addCopyDelta(toCopy, arguments);
                ++i;
            }
        }
    }

    public void copy(ICompilationUnit unit, CopyArguments javaArgs, CopyArguments resourceArgs) throws CoreException {
        this.add(unit, (RefactoringArguments)javaArgs, null);
        ResourceMapping mapping = JavaElementResourceMapping.create(unit);
        if (mapping != null) {
            this.add(mapping, (RefactoringArguments)resourceArgs, null);
        }
        if (unit.getResource() != null) {
            this.getResourceModifications().addCopyDelta(unit.getResource(), resourceArgs);
        }
    }

    public void buildDelta(IResourceChangeDescriptionFactory builder) {
        int i = 0;
        while (i < this.fCopies.size()) {
            Object element = this.fCopies.get(i);
            if (element instanceof IResource) {
                ResourceModifications.buildCopyDelta(builder, (IResource)element, (CopyArguments)this.fCopyArguments.get(i));
            }
            ++i;
        }
        this.getResourceModifications().buildDelta(builder);
    }

    public RefactoringParticipant[] loadParticipants(RefactoringStatus status, RefactoringProcessor owner, String[] natures, SharableParticipants shared) {
        ArrayList<Object> result = new ArrayList<Object>();
        int i = 0;
        while (i < this.fCopies.size()) {
            result.addAll(Arrays.asList(ParticipantManager.loadCopyParticipants((RefactoringStatus)status, (RefactoringProcessor)owner, this.fCopies.get(i), (CopyArguments)((CopyArguments)this.fCopyArguments.get(i)), (IParticipantDescriptorFilter)((IParticipantDescriptorFilter)this.fParticipantDescriptorFilter.get(i)), (String[])natures, (SharableParticipants)shared)));
            ++i;
        }
        result.addAll(Arrays.asList(this.getResourceModifications().getParticipants(status, owner, natures, shared)));
        return result.toArray(new RefactoringParticipant[result.size()]);
    }

    private void add(Object element, RefactoringArguments args, IParticipantDescriptorFilter filter) {
        Assert.isNotNull((Object)element);
        Assert.isNotNull((Object)args);
        this.fCopies.add(element);
        this.fCopyArguments.add(args);
        this.fParticipantDescriptorFilter.add(filter);
    }
}

