/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.corext.refactoring.structure;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.ltk.core.refactoring.CategorizedTextEditGroup;
import org.eclipse.ltk.core.refactoring.GroupCategory;
import org.eclipse.ltk.core.refactoring.GroupCategorySet;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.RefactoringStatusContext;
import org.eclipse.text.edits.TextEditGroup;
import org.eclipse.wst.jsdt.core.Flags;
import org.eclipse.wst.jsdt.core.ICompilationUnit;
import org.eclipse.wst.jsdt.core.IField;
import org.eclipse.wst.jsdt.core.IInitializer;
import org.eclipse.wst.jsdt.core.IJavaElement;
import org.eclipse.wst.jsdt.core.IMember;
import org.eclipse.wst.jsdt.core.IMethod;
import org.eclipse.wst.jsdt.core.IPackageFragment;
import org.eclipse.wst.jsdt.core.IType;
import org.eclipse.wst.jsdt.core.ITypeHierarchy;
import org.eclipse.wst.jsdt.core.JavaCore;
import org.eclipse.wst.jsdt.core.JavaModelException;
import org.eclipse.wst.jsdt.core.WorkingCopyOwner;
import org.eclipse.wst.jsdt.core.dom.ASTNode;
import org.eclipse.wst.jsdt.core.dom.AbstractTypeDeclaration;
import org.eclipse.wst.jsdt.core.dom.BodyDeclaration;
import org.eclipse.wst.jsdt.core.dom.CompilationUnit;
import org.eclipse.wst.jsdt.core.dom.FieldDeclaration;
import org.eclipse.wst.jsdt.core.dom.IExtendedModifier;
import org.eclipse.wst.jsdt.core.dom.Modifier;
import org.eclipse.wst.jsdt.core.dom.SimpleName;
import org.eclipse.wst.jsdt.core.dom.Type;
import org.eclipse.wst.jsdt.core.dom.VariableDeclarationFragment;
import org.eclipse.wst.jsdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.wst.jsdt.core.dom.rewrite.ListRewrite;
import org.eclipse.wst.jsdt.core.search.IJavaSearchScope;
import org.eclipse.wst.jsdt.core.search.SearchMatch;
import org.eclipse.wst.jsdt.core.search.SearchPattern;
import org.eclipse.wst.jsdt.internal.corext.dom.ModifierRewrite;
import org.eclipse.wst.jsdt.internal.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.wst.jsdt.internal.corext.refactoring.RefactoringScopeFactory;
import org.eclipse.wst.jsdt.internal.corext.refactoring.RefactoringSearchEngine2;
import org.eclipse.wst.jsdt.internal.corext.refactoring.SearchResultGroup;
import org.eclipse.wst.jsdt.internal.corext.refactoring.base.JavaStatusContext;
import org.eclipse.wst.jsdt.internal.corext.refactoring.structure.ASTNodeSearchUtil;
import org.eclipse.wst.jsdt.internal.corext.refactoring.structure.CompilationUnitRewrite;
import org.eclipse.wst.jsdt.internal.corext.util.JavaModelUtil;
import org.eclipse.wst.jsdt.internal.corext.util.Messages;
import org.eclipse.wst.jsdt.ui.JavaElementLabels;

public final class MemberVisibilityAdjustor {
    public static final GroupCategorySet SET_VISIBILITY_ADJUSTMENTS = new GroupCategorySet(new GroupCategory("org.eclipse.wst.jsdt.internal.corext.visibilityAdjustments", RefactoringCoreMessages.MemberVisibilityAdjustor_adjustments_name, RefactoringCoreMessages.MemberVisibilityAdjustor_adjustments_description));
    private Map fAdjustments = new HashMap();
    private boolean fIncoming = true;
    private boolean fOutgoing = true;
    private final IMember fReferenced;
    private final IJavaElement fReferencing;
    private ASTRewrite fRewrite = null;
    private Map fRewrites = new HashMap(3);
    private CompilationUnit fRoot = null;
    private IJavaSearchScope fScope;
    private RefactoringStatus fStatus = new RefactoringStatus();
    private final Map fTypeHierarchies = new HashMap();
    private int fVisibilitySeverity = 2;
    private WorkingCopyOwner fOwner = null;

    public static String getLabel(IJavaElement element) {
        Assert.isNotNull((Object)element);
        return JavaElementLabels.getElementLabel(element, JavaElementLabels.ALL_FULLY_QUALIFIED | JavaElementLabels.ALL_DEFAULT);
    }

    public static String getLabel(Modifier.ModifierKeyword keyword) {
        Assert.isTrue((boolean)MemberVisibilityAdjustor.isVisibilityKeyword(keyword));
        if (keyword == null) {
            return RefactoringCoreMessages.MemberVisibilityAdjustor_change_visibility_default;
        }
        if (Modifier.ModifierKeyword.PUBLIC_KEYWORD.equals(keyword)) {
            return RefactoringCoreMessages.MemberVisibilityAdjustor_change_visibility_public;
        }
        if (Modifier.ModifierKeyword.PROTECTED_KEYWORD.equals(keyword)) {
            return RefactoringCoreMessages.MemberVisibilityAdjustor_change_visibility_protected;
        }
        return RefactoringCoreMessages.MemberVisibilityAdjustor_change_visibility_private;
    }

    public static String getMessage(IMember member) {
        Assert.isTrue((member instanceof IType || member instanceof IMethod || member instanceof IField ? 1 : 0) != 0);
        if (member instanceof IType) {
            return RefactoringCoreMessages.MemberVisibilityAdjustor_change_visibility_type_warning;
        }
        if (member instanceof IMethod) {
            return RefactoringCoreMessages.MemberVisibilityAdjustor_change_visibility_method_warning;
        }
        return RefactoringCoreMessages.MemberVisibilityAdjustor_change_visibility_field_warning;
    }

    public static boolean hasLowerVisibility(int modifiers, int threshold) {
        if (Modifier.isPrivate((int)threshold)) {
            return false;
        }
        if (Modifier.isPublic((int)threshold)) {
            return !Modifier.isPublic((int)modifiers);
        }
        if (Modifier.isProtected((int)threshold)) {
            return !Modifier.isProtected((int)modifiers) && !Modifier.isPublic((int)modifiers);
        }
        return Modifier.isPrivate((int)modifiers);
    }

    public static boolean hasLowerVisibility(Modifier.ModifierKeyword keyword, Modifier.ModifierKeyword threshold) {
        Assert.isTrue((boolean)MemberVisibilityAdjustor.isVisibilityKeyword(keyword));
        Assert.isTrue((boolean)MemberVisibilityAdjustor.isVisibilityKeyword(threshold));
        return MemberVisibilityAdjustor.hasLowerVisibility(keyword != null ? keyword.toFlagValue() : 0, threshold != null ? threshold.toFlagValue() : 0);
    }

    private static boolean isStatusSeverity(int severity) {
        return severity == 3 || severity == 4 || severity == 1 || severity == 0 || severity == 2;
    }

    private static boolean isVisibilityKeyword(Modifier.ModifierKeyword keyword) {
        return keyword == null || Modifier.ModifierKeyword.PUBLIC_KEYWORD.equals(keyword) || Modifier.ModifierKeyword.PROTECTED_KEYWORD.equals(keyword) || Modifier.ModifierKeyword.PRIVATE_KEYWORD.equals(keyword);
    }

    private static boolean isVisibilityModifier(int modifier) {
        return modifier == 0 || modifier == 1 || modifier == 4 || modifier == 2;
    }

    private static int keywordToVisibility(Modifier.ModifierKeyword keyword) {
        int visibility = 0;
        if (keyword == Modifier.ModifierKeyword.PUBLIC_KEYWORD) {
            visibility = 1;
        } else if (keyword == Modifier.ModifierKeyword.PRIVATE_KEYWORD) {
            visibility = 2;
        } else if (keyword == Modifier.ModifierKeyword.PROTECTED_KEYWORD) {
            visibility = 4;
        }
        return visibility;
    }

    public static boolean needsVisibilityAdjustments(IMember member, int threshold, Map adjustments) {
        Assert.isNotNull((Object)member);
        Assert.isTrue((boolean)MemberVisibilityAdjustor.isVisibilityModifier(threshold));
        Assert.isNotNull((Object)adjustments);
        IncomingMemberVisibilityAdjustment adjustment = (IncomingMemberVisibilityAdjustment)adjustments.get(member);
        if (adjustment != null) {
            Modifier.ModifierKeyword keyword = adjustment.getKeyword();
            return MemberVisibilityAdjustor.hasLowerVisibility(keyword == null ? 0 : keyword.toFlagValue(), threshold);
        }
        return true;
    }

    public static boolean needsVisibilityAdjustments(IMember member, Modifier.ModifierKeyword threshold, Map adjustments) {
        Assert.isNotNull((Object)member);
        Assert.isNotNull((Object)adjustments);
        IncomingMemberVisibilityAdjustment adjustment = (IncomingMemberVisibilityAdjustment)adjustments.get(member);
        if (adjustment != null) {
            return MemberVisibilityAdjustor.hasLowerVisibility(adjustment.getKeyword(), threshold);
        }
        return true;
    }

    public MemberVisibilityAdjustor(IJavaElement referencing, IMember referenced) {
        Assert.isTrue((!(referenced instanceof IInitializer) ? 1 : 0) != 0);
        Assert.isTrue((referencing instanceof ICompilationUnit || referencing instanceof IType || referencing instanceof IPackageFragment ? 1 : 0) != 0);
        this.fScope = RefactoringScopeFactory.createReferencedScope(new IJavaElement[]{referenced}, 11);
        this.fReferencing = referencing;
        this.fReferenced = referenced;
    }

    private void adjustIncomingVisibility(IJavaElement element, IMember referencedMovedElement, IProgressMonitor monitor) throws JavaModelException {
        Modifier.ModifierKeyword threshold = this.getVisibilityThreshold(element, referencedMovedElement, monitor);
        int flags = referencedMovedElement.getFlags();
        IType declaring = referencedMovedElement.getDeclaringType();
        if (declaring.isInterface()) {
            return;
        }
        if (MemberVisibilityAdjustor.hasLowerVisibility(flags, threshold == null ? 0 : threshold.toFlagValue()) && this.needsVisibilityAdjustment(referencedMovedElement, threshold)) {
            this.fAdjustments.put(referencedMovedElement, new IncomingMemberVisibilityAdjustment(referencedMovedElement, threshold, RefactoringStatus.createStatus((int)this.fVisibilitySeverity, (String)Messages.format(MemberVisibilityAdjustor.getMessage(referencedMovedElement), new String[]{MemberVisibilityAdjustor.getLabel((IJavaElement)referencedMovedElement), MemberVisibilityAdjustor.getLabel(threshold)}), (RefactoringStatusContext)JavaStatusContext.create(referencedMovedElement), null, (int)-1, null)));
        }
    }

    private void adjustMemberVisibility(IMember member, IProgressMonitor monitor) throws JavaModelException {
        int i;
        if (member instanceof IType) {
            IJavaElement[] typeMembers = ((IType)member).getChildren();
            i = 0;
            while (i < typeMembers.length) {
                if (!(typeMembers[i] instanceof IInitializer)) {
                    this.adjustMemberVisibility((IMember)typeMembers[i], monitor);
                }
                ++i;
            }
        }
        if (member.equals(this.fReferenced) || Modifier.isPublic((int)member.getFlags())) {
            return;
        }
        SearchResultGroup[] references = this.findReferences(member, monitor);
        i = 0;
        while (i < references.length) {
            SearchMatch[] searchResults = references[i].getSearchResults();
            int k = 0;
            while (k < searchResults.length) {
                IJavaElement referenceToMember = (IJavaElement)searchResults[k].getElement();
                if (this.fAdjustments.get(member) == null && referenceToMember instanceof IMember && !this.isInsideMovedMember(referenceToMember)) {
                    this.adjustIncomingVisibility(this.fReferencing, member, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                }
                ++k;
            }
            ++i;
        }
    }

    private boolean isInsideMovedMember(IJavaElement element) {
        IJavaElement current = element;
        while ((current = current.getParent()) != null) {
            if (!current.equals(this.fReferenced)) continue;
            return true;
        }
        return false;
    }

    private SearchResultGroup[] findReferences(IMember member, IProgressMonitor monitor) throws JavaModelException {
        RefactoringSearchEngine2 engine = new RefactoringSearchEngine2(SearchPattern.createPattern((IJavaElement)member, (int)2, (int)24));
        engine.setOwner(this.fOwner);
        engine.setFiltering(true, true);
        engine.setScope(RefactoringScopeFactory.create((IJavaElement)member));
        engine.searchPattern((IProgressMonitor)new SubProgressMonitor(monitor, 1));
        return (SearchResultGroup[])engine.getResults();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void adjustIncomingVisibility(SearchResultGroup[] groups, IProgressMonitor monitor) throws JavaModelException {
        try {
            monitor.beginTask("", groups.length);
            monitor.setTaskName(RefactoringCoreMessages.MemberVisibilityAdjustor_checking);
            SearchMatch[] matches = null;
            boolean adjusted = false;
            int index = 0;
            while (index < groups.length) {
                matches = groups[index].getSearchResults();
                int offset = 0;
                while (offset < matches.length) {
                    Object element = matches[offset].getElement();
                    if (element instanceof IMember && !this.isInsideMovedMember((IJavaElement)((IMember)element))) {
                        this.adjustIncomingVisibility(this.fReferencing, this.fReferenced, monitor);
                        adjusted = true;
                        break;
                    }
                    ++offset;
                }
                if (!adjusted) {
                    monitor.worked(1);
                    ++index;
                    continue;
                }
                break;
            }
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            monitor.done();
            throw throwable;
        }
        {
            Object var8_10 = null;
        }
        monitor.done();
    }

    private void adjustOutgoingVisibility(IField field, Modifier.ModifierKeyword threshold) throws JavaModelException {
        Assert.isTrue((!field.isBinary() && !field.isReadOnly() ? 1 : 0) != 0);
        IType declaring = field.getDeclaringType();
        if (declaring != null && declaring.equals(this.fReferenced)) {
            return;
        }
        if (MemberVisibilityAdjustor.hasLowerVisibility(field.getFlags(), MemberVisibilityAdjustor.keywordToVisibility(threshold)) && this.needsVisibilityAdjustment((IMember)field, threshold)) {
            this.adjustOutgoingVisibility((IMember)field, threshold, RefactoringCoreMessages.MemberVisibilityAdjustor_change_visibility_field_warning);
        }
    }

    private void adjustOutgoingVisibility(IMember member, Modifier.ModifierKeyword threshold, String template) throws JavaModelException {
        Assert.isTrue((!member.isBinary() && !member.isReadOnly() ? 1 : 0) != 0);
        boolean adjust = true;
        IType declaring = member.getDeclaringType();
        if (declaring != null && (JavaModelUtil.isInterfaceOrAnnotation(declaring) || declaring.equals(this.fReferenced))) {
            adjust = false;
        }
        if (adjust && MemberVisibilityAdjustor.hasLowerVisibility(member.getFlags(), MemberVisibilityAdjustor.keywordToVisibility(threshold)) && this.needsVisibilityAdjustment(member, threshold)) {
            this.fAdjustments.put(member, new OutgoingMemberVisibilityAdjustment(member, threshold, RefactoringStatus.createStatus((int)this.fVisibilitySeverity, (String)Messages.format(template, new String[]{JavaElementLabels.getTextLabel(member, 1L | JavaElementLabels.ALL_FULLY_QUALIFIED), MemberVisibilityAdjustor.getLabel(threshold)}), (RefactoringStatusContext)JavaStatusContext.create(member), null, (int)-1, null)));
        }
    }

    private void adjustOutgoingVisibility(SearchMatch match, IProgressMonitor monitor) throws JavaModelException {
        IMember member;
        Object element = match.getElement();
        if (element instanceof IMember && !(member = (IMember)element).isBinary() && !member.isReadOnly() && !this.isInsideMovedMember((IJavaElement)member)) {
            this.adjustOutgoingVisibilityChain(member, monitor);
        }
    }

    private void adjustOutgoingVisibilityChain(IMember member, IProgressMonitor monitor) throws JavaModelException {
        if (!Modifier.isPublic((int)member.getFlags())) {
            Modifier.ModifierKeyword threshold = this.computeOutgoingVisibilityThreshold(this.fReferencing, member, monitor);
            if (member instanceof IMethod) {
                this.adjustOutgoingVisibility(member, threshold, RefactoringCoreMessages.MemberVisibilityAdjustor_change_visibility_method_warning);
            } else if (member instanceof IField) {
                this.adjustOutgoingVisibility((IField)member, threshold);
            } else if (member instanceof IType) {
                this.adjustOutgoingVisibility(member, threshold, RefactoringCoreMessages.MemberVisibilityAdjustor_change_visibility_type_warning);
            }
        }
        if (member.getDeclaringType() != null) {
            this.adjustOutgoingVisibilityChain((IMember)member.getDeclaringType(), monitor);
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void adjustOutgoingVisibility(SearchResultGroup[] groups, IProgressMonitor monitor) throws JavaModelException {
        try {
            monitor.beginTask("", groups.length);
            monitor.setTaskName(RefactoringCoreMessages.MemberVisibilityAdjustor_checking);
            IJavaElement element = null;
            SearchMatch[] matches = null;
            SearchResultGroup group = null;
            int index = 0;
            while (index < groups.length) {
                group = groups[index];
                element = JavaCore.create((IResource)group.getResource());
                if (element instanceof ICompilationUnit) {
                    matches = group.getSearchResults();
                    int offset = 0;
                    while (offset < matches.length) {
                        this.adjustOutgoingVisibility(matches[offset], (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                        ++offset;
                    }
                }
                monitor.worked(1);
                ++index;
            }
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            monitor.done();
            throw throwable;
        }
        {
            Object var8_10 = null;
        }
        monitor.done();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void adjustVisibility(IProgressMonitor monitor) throws JavaModelException {
        try {
            monitor.beginTask("", 7);
            monitor.setTaskName(RefactoringCoreMessages.MemberVisibilityAdjustor_checking);
            RefactoringSearchEngine2 engine = new RefactoringSearchEngine2(SearchPattern.createPattern((IJavaElement)this.fReferenced, (int)2, (int)24));
            engine.setScope(this.fScope);
            engine.setStatus(this.fStatus);
            engine.setOwner(this.fOwner);
            if (this.fIncoming) {
                engine.searchPattern((IProgressMonitor)new SubProgressMonitor(monitor, 1));
                this.adjustIncomingVisibility((SearchResultGroup[])engine.getResults(), (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                engine.clearResults();
                if (this.fReferenced instanceof IType) {
                    IType type = (IType)this.fReferenced;
                    this.adjustMemberVisibility((IMember)type, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                }
            }
            if (this.fOutgoing) {
                engine.searchReferencedTypes((IJavaElement)this.fReferenced, (IProgressMonitor)new SubProgressMonitor(monitor, 1, 2));
                engine.searchReferencedFields((IJavaElement)this.fReferenced, (IProgressMonitor)new SubProgressMonitor(monitor, 1, 2));
                engine.searchReferencedMethods((IJavaElement)this.fReferenced, (IProgressMonitor)new SubProgressMonitor(monitor, 1, 2));
                this.adjustOutgoingVisibility((SearchResultGroup[])engine.getResults(), (IProgressMonitor)new SubProgressMonitor(monitor, 1));
            }
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            monitor.done();
            throw throwable;
        }
        {
            Object var4_6 = null;
        }
        monitor.done();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Modifier.ModifierKeyword getVisibilityThreshold(IJavaElement referencing, IMember referenced, IProgressMonitor monitor) throws JavaModelException {
        Assert.isTrue((!(referencing instanceof IInitializer) ? 1 : 0) != 0);
        Assert.isTrue((!(referenced instanceof IInitializer) ? 1 : 0) != 0);
        Modifier.ModifierKeyword keyword = Modifier.ModifierKeyword.PUBLIC_KEYWORD;
        try {
            monitor.beginTask("", 1);
            monitor.setTaskName(RefactoringCoreMessages.MemberVisibilityAdjustor_checking);
            int referencingType = referencing.getElementType();
            int referencedType = referenced.getElementType();
            switch (referencedType) {
                case 7: {
                    IType typeReferenced = (IType)referenced;
                    ICompilationUnit referencedUnit = typeReferenced.getCompilationUnit();
                    switch (referencingType) {
                        case 7: {
                            keyword = this.thresholdTypeToType((IType)referencing, typeReferenced, monitor);
                            break;
                        }
                        case 8: 
                        case 9: {
                            IMember member = (IMember)referencing;
                            if (typeReferenced.equals(member.getDeclaringType())) {
                                keyword = Modifier.ModifierKeyword.PRIVATE_KEYWORD;
                                break;
                            }
                            if (referencedUnit != null && referencedUnit.equals(member.getCompilationUnit())) {
                                keyword = Modifier.ModifierKeyword.PRIVATE_KEYWORD;
                                break;
                            }
                            if (!typeReferenced.getPackageFragment().equals(member.getDeclaringType().getPackageFragment())) break;
                            keyword = null;
                            break;
                        }
                        case 4: {
                            IPackageFragment fragment = (IPackageFragment)referencing;
                            if (!typeReferenced.getPackageFragment().equals(fragment)) break;
                            keyword = null;
                            break;
                        }
                        default: {
                            Assert.isTrue((boolean)false);
                            break;
                        }
                    }
                    break;
                }
                case 8: {
                    IField fieldReferenced = (IField)referenced;
                    ICompilationUnit referencedUnit = fieldReferenced.getCompilationUnit();
                    switch (referencingType) {
                        case 7: {
                            keyword = this.thresholdTypeToField((IType)referencing, fieldReferenced, monitor);
                            break;
                        }
                        case 8: 
                        case 9: {
                            IMember member = (IMember)referencing;
                            if (fieldReferenced.getDeclaringType().equals(member.getDeclaringType())) {
                                keyword = Modifier.ModifierKeyword.PRIVATE_KEYWORD;
                                break;
                            }
                            if (referencedUnit != null && referencedUnit.equals(member.getCompilationUnit())) {
                                keyword = Modifier.ModifierKeyword.PRIVATE_KEYWORD;
                                break;
                            }
                            if (!fieldReferenced.getDeclaringType().getPackageFragment().equals(member.getDeclaringType().getPackageFragment())) break;
                            keyword = null;
                            break;
                        }
                        case 4: {
                            IPackageFragment fragment = (IPackageFragment)referencing;
                            if (!fieldReferenced.getDeclaringType().getPackageFragment().equals(fragment)) break;
                            keyword = null;
                            break;
                        }
                        default: {
                            Assert.isTrue((boolean)false);
                            break;
                        }
                    }
                    break;
                }
                case 9: {
                    IMethod methodReferenced = (IMethod)referenced;
                    ICompilationUnit referencedUnit = methodReferenced.getCompilationUnit();
                    switch (referencingType) {
                        case 7: {
                            keyword = this.thresholdTypeToMethod((IType)referencing, methodReferenced, monitor);
                            break;
                        }
                        case 8: 
                        case 9: {
                            IMember member = (IMember)referencing;
                            if (methodReferenced.getDeclaringType().equals(member.getDeclaringType())) {
                                keyword = Modifier.ModifierKeyword.PRIVATE_KEYWORD;
                                break;
                            }
                            if (referencedUnit != null && referencedUnit.equals(member.getCompilationUnit())) {
                                keyword = Modifier.ModifierKeyword.PRIVATE_KEYWORD;
                                break;
                            }
                            if (!methodReferenced.getDeclaringType().getPackageFragment().equals(member.getDeclaringType().getPackageFragment())) break;
                            keyword = null;
                            break;
                        }
                        case 4: {
                            IPackageFragment fragment = (IPackageFragment)referencing;
                            if (!methodReferenced.getDeclaringType().getPackageFragment().equals(fragment)) break;
                            keyword = null;
                            break;
                        }
                        default: {
                            Assert.isTrue((boolean)false);
                            break;
                        }
                    }
                    break;
                }
                default: {
                    Assert.isTrue((boolean)false);
                    break;
                }
            }
        }
        catch (Throwable throwable) {
            Object var10_20 = null;
            monitor.done();
            throw throwable;
        }
        {
            Object var10_21 = null;
        }
        monitor.done();
        return keyword;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Modifier.ModifierKeyword computeOutgoingVisibilityThreshold(IJavaElement referencing, IMember referenced, IProgressMonitor monitor) throws JavaModelException {
        Assert.isTrue((referencing instanceof ICompilationUnit || referencing instanceof IType || referencing instanceof IPackageFragment ? 1 : 0) != 0);
        Assert.isTrue((referenced instanceof IType || referenced instanceof IField || referenced instanceof IMethod ? 1 : 0) != 0);
        Modifier.ModifierKeyword keyword = Modifier.ModifierKeyword.PUBLIC_KEYWORD;
        try {
            monitor.beginTask("", 1);
            monitor.setTaskName(RefactoringCoreMessages.MemberVisibilityAdjustor_checking);
            int referencingType = referencing.getElementType();
            int referencedType = referenced.getElementType();
            switch (referencedType) {
                case 7: {
                    IType typeReferenced = (IType)referenced;
                    switch (referencingType) {
                        case 5: {
                            ICompilationUnit unit = (ICompilationUnit)referencing;
                            ICompilationUnit referencedUnit = typeReferenced.getCompilationUnit();
                            if (referencedUnit != null && referencedUnit.equals(unit)) {
                                keyword = Modifier.ModifierKeyword.PRIVATE_KEYWORD;
                                break;
                            }
                            if (referencedUnit == null || !referencedUnit.getParent().equals(unit.getParent())) break;
                            keyword = null;
                            break;
                        }
                        case 7: {
                            keyword = this.thresholdTypeToType((IType)referencing, typeReferenced, monitor);
                            break;
                        }
                        case 4: {
                            IPackageFragment fragment = (IPackageFragment)referencing;
                            if (!typeReferenced.getPackageFragment().equals(fragment)) break;
                            keyword = null;
                            break;
                        }
                        default: {
                            Assert.isTrue((boolean)false);
                            break;
                        }
                    }
                    break;
                }
                case 8: {
                    IField fieldReferenced = (IField)referenced;
                    ICompilationUnit referencedUnit = fieldReferenced.getCompilationUnit();
                    switch (referencingType) {
                        case 5: {
                            ICompilationUnit unit = (ICompilationUnit)referencing;
                            if (referencedUnit != null && referencedUnit.equals(unit)) {
                                keyword = Modifier.ModifierKeyword.PRIVATE_KEYWORD;
                                break;
                            }
                            if (referencedUnit == null || !referencedUnit.getParent().equals(unit.getParent())) break;
                            keyword = null;
                            break;
                        }
                        case 7: {
                            keyword = this.thresholdTypeToField((IType)referencing, fieldReferenced, monitor);
                            break;
                        }
                        case 4: {
                            IPackageFragment fragment = (IPackageFragment)referencing;
                            if (!fieldReferenced.getDeclaringType().getPackageFragment().equals(fragment)) break;
                            keyword = null;
                            break;
                        }
                        default: {
                            Assert.isTrue((boolean)false);
                            break;
                        }
                    }
                    break;
                }
                case 9: {
                    IMethod methodReferenced = (IMethod)referenced;
                    ICompilationUnit referencedUnit = methodReferenced.getCompilationUnit();
                    switch (referencingType) {
                        case 5: {
                            ICompilationUnit unit = (ICompilationUnit)referencing;
                            if (referencedUnit != null && referencedUnit.equals(unit)) {
                                keyword = Modifier.ModifierKeyword.PRIVATE_KEYWORD;
                                break;
                            }
                            if (referencedUnit == null || !referencedUnit.getParent().equals(unit.getParent())) break;
                            keyword = null;
                            break;
                        }
                        case 7: {
                            keyword = this.thresholdTypeToMethod((IType)referencing, methodReferenced, monitor);
                            break;
                        }
                        case 4: {
                            IPackageFragment fragment = (IPackageFragment)referencing;
                            if (!methodReferenced.getDeclaringType().getPackageFragment().equals(fragment)) break;
                            keyword = null;
                            break;
                        }
                        default: {
                            Assert.isTrue((boolean)false);
                            break;
                        }
                    }
                    break;
                }
                default: {
                    Assert.isTrue((boolean)false);
                    break;
                }
            }
        }
        catch (Throwable throwable) {
            Object var10_20 = null;
            monitor.done();
            throw throwable;
        }
        {
            Object var10_21 = null;
        }
        monitor.done();
        return keyword;
    }

    public final Map getAdjustments() {
        return this.fAdjustments;
    }

    private CompilationUnitRewrite getCompilationUnitRewrite(ICompilationUnit unit) {
        CompilationUnitRewrite rewrite = (CompilationUnitRewrite)this.fRewrites.get(unit);
        if (rewrite == null) {
            rewrite = this.fOwner == null ? new CompilationUnitRewrite(unit) : new CompilationUnitRewrite(this.fOwner, unit);
        }
        return rewrite;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private ITypeHierarchy getTypeHierarchy(IType type, IProgressMonitor monitor) throws JavaModelException {
        ITypeHierarchy hierarchy = null;
        try {
            monitor.beginTask("", 1);
            monitor.setTaskName(RefactoringCoreMessages.MemberVisibilityAdjustor_checking);
            try {
                hierarchy = (ITypeHierarchy)this.fTypeHierarchies.get(type);
                if (hierarchy == null) {
                    hierarchy = this.fOwner == null ? type.newSupertypeHierarchy((IProgressMonitor)new SubProgressMonitor(monitor, 1, 2)) : type.newSupertypeHierarchy(this.fOwner, (IProgressMonitor)new SubProgressMonitor(monitor, 1, 2));
                }
            }
            catch (Throwable throwable) {
                Object var4_5 = null;
                monitor.done();
                throw throwable;
            }
            {
                Object var4_6 = null;
                monitor.done();
            }
        }
        catch (Throwable throwable) {
            Object var6_8 = null;
            monitor.done();
            throw throwable;
        }
        {
            Object var6_9 = null;
        }
        monitor.done();
        return hierarchy;
    }

    private boolean needsVisibilityAdjustment(IMember member, Modifier.ModifierKeyword threshold) {
        Assert.isNotNull((Object)member);
        return MemberVisibilityAdjustor.needsVisibilityAdjustments(member, threshold, this.fAdjustments);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void rewriteVisibility(ICompilationUnit unit, IProgressMonitor monitor) throws JavaModelException {
        try {
            monitor.beginTask("", this.fAdjustments.keySet().size());
            monitor.setTaskName(RefactoringCoreMessages.MemberVisibilityAdjustor_adjusting);
            IMember member = null;
            IVisibilityAdjustment adjustment = null;
            Iterator iterator = this.fAdjustments.keySet().iterator();
            while (iterator.hasNext()) {
                member = (IMember)iterator.next();
                if (!unit.equals(member.getCompilationUnit()) || (adjustment = (IVisibilityAdjustment)this.fAdjustments.get(member)) == null) continue;
                adjustment.rewriteVisibility(this, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
            }
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            this.fTypeHierarchies.clear();
            monitor.done();
            throw throwable;
        }
        {
            Object var6_8 = null;
            this.fTypeHierarchies.clear();
        }
        monitor.done();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void rewriteVisibility(IProgressMonitor monitor) throws JavaModelException {
        try {
            monitor.beginTask("", this.fAdjustments.keySet().size());
            monitor.setTaskName(RefactoringCoreMessages.MemberVisibilityAdjustor_adjusting);
            IMember member = null;
            IVisibilityAdjustment adjustment = null;
            Iterator iterator = this.fAdjustments.keySet().iterator();
            while (iterator.hasNext()) {
                member = (IMember)iterator.next();
                adjustment = (IVisibilityAdjustment)this.fAdjustments.get(member);
                if (adjustment != null) {
                    adjustment.rewriteVisibility(this, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                }
                if (!monitor.isCanceled()) continue;
                throw new OperationCanceledException();
            }
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            this.fTypeHierarchies.clear();
            monitor.done();
            throw throwable;
        }
        {
            Object var5_7 = null;
            this.fTypeHierarchies.clear();
        }
        monitor.done();
    }

    public final void setAdjustments(Map adjustments) {
        Assert.isNotNull((Object)adjustments);
        this.fAdjustments = adjustments;
    }

    public final void setFailureSeverity(int severity) {
        Assert.isTrue((boolean)MemberVisibilityAdjustor.isStatusSeverity(severity));
    }

    public final void setIncoming(boolean incoming) {
        this.fIncoming = incoming;
    }

    public final void setOutgoing(boolean outgoing) {
        this.fOutgoing = outgoing;
    }

    public final void setRewrite(ASTRewrite rewrite, CompilationUnit root) {
        Assert.isTrue((rewrite == null || root != null ? 1 : 0) != 0);
        this.fRewrite = rewrite;
        this.fRoot = root;
    }

    public final void setRewrites(Map rewrites) {
        Assert.isNotNull((Object)rewrites);
        this.fRewrites = rewrites;
    }

    public final void setScope(IJavaSearchScope scope) {
        Assert.isNotNull((Object)scope);
        this.fScope = scope;
    }

    public final void setOwner(WorkingCopyOwner owner) {
        this.fOwner = owner;
    }

    public final void setStatus(RefactoringStatus status) {
        Assert.isNotNull((Object)status);
        this.fStatus = status;
    }

    public final void setVisibilitySeverity(int severity) {
        Assert.isTrue((boolean)MemberVisibilityAdjustor.isStatusSeverity(severity));
        this.fVisibilitySeverity = severity;
    }

    private Modifier.ModifierKeyword thresholdTypeToField(IType referencing, IField referenced, IProgressMonitor monitor) throws JavaModelException {
        Modifier.ModifierKeyword keyword = Modifier.ModifierKeyword.PUBLIC_KEYWORD;
        ICompilationUnit referencedUnit = referenced.getCompilationUnit();
        if (referenced.getDeclaringType().equals(referencing)) {
            keyword = Modifier.ModifierKeyword.PRIVATE_KEYWORD;
        } else {
            ITypeHierarchy hierarchy = this.getTypeHierarchy(referencing, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
            IType[] types = hierarchy.getSupertypes(referencing);
            IType superType = null;
            int index = 0;
            while (index < types.length) {
                superType = types[index];
                if (superType.equals(referenced.getDeclaringType())) {
                    keyword = Modifier.ModifierKeyword.PROTECTED_KEYWORD;
                    return keyword;
                }
                ++index;
            }
        }
        ICompilationUnit typeUnit = referencing.getCompilationUnit();
        if (referencedUnit != null && referencedUnit.equals(typeUnit)) {
            keyword = Modifier.ModifierKeyword.PRIVATE_KEYWORD;
        } else if (referencedUnit != null && typeUnit != null && referencedUnit.getParent().equals(typeUnit.getParent())) {
            keyword = null;
        }
        return keyword;
    }

    private Modifier.ModifierKeyword thresholdTypeToMethod(IType referencing, IMethod referenced, IProgressMonitor monitor) throws JavaModelException {
        ICompilationUnit referencedUnit = referenced.getCompilationUnit();
        Object keyword = Modifier.ModifierKeyword.PUBLIC_KEYWORD;
        if (referenced.getDeclaringType().equals(referencing)) {
            keyword = Modifier.ModifierKeyword.PRIVATE_KEYWORD;
        } else {
            ITypeHierarchy hierarchy = this.getTypeHierarchy(referencing, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
            IType[] types = hierarchy.getSupertypes(referencing);
            IType superType = null;
            int index = 0;
            while (index < types.length) {
                superType = types[index];
                if (superType.equals(referenced.getDeclaringType())) {
                    keyword = Modifier.ModifierKeyword.PROTECTED_KEYWORD;
                    return keyword;
                }
                ++index;
            }
        }
        ICompilationUnit typeUnit = referencing.getCompilationUnit();
        if (referencedUnit != null && referencedUnit.equals(typeUnit)) {
            keyword = referenced.getDeclaringType().getDeclaringType() != null ? null : Modifier.ModifierKeyword.PRIVATE_KEYWORD;
        } else if (referencedUnit != null && referencedUnit.getParent().equals(typeUnit.getParent())) {
            keyword = null;
        }
        return keyword;
    }

    private Modifier.ModifierKeyword thresholdTypeToType(IType referencing, IType referenced, IProgressMonitor monitor) throws JavaModelException {
        Object keyword = Modifier.ModifierKeyword.PUBLIC_KEYWORD;
        ICompilationUnit referencedUnit = referenced.getCompilationUnit();
        if (referencing.equals(referenced.getDeclaringType())) {
            keyword = Modifier.ModifierKeyword.PRIVATE_KEYWORD;
        } else {
            ITypeHierarchy hierarchy = this.getTypeHierarchy(referencing, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
            IType[] types = hierarchy.getSupertypes(referencing);
            IType superType = null;
            int index = 0;
            while (index < types.length) {
                superType = types[index];
                if (superType.equals(referenced)) {
                    keyword = null;
                    return keyword;
                }
                ++index;
            }
        }
        ICompilationUnit typeUnit = referencing.getCompilationUnit();
        if (referencedUnit != null && referencedUnit.equals(typeUnit)) {
            keyword = referenced.getDeclaringType() != null ? null : Modifier.ModifierKeyword.PRIVATE_KEYWORD;
        } else if (referencedUnit != null && typeUnit != null && referencedUnit.getParent().equals(typeUnit.getParent())) {
            keyword = null;
        }
        return keyword;
    }

    public static interface IVisibilityAdjustment {
        public void rewriteVisibility(MemberVisibilityAdjustor var1, IProgressMonitor var2) throws JavaModelException;
    }

    public static class IncomingMemberVisibilityAdjustment
    implements IVisibilityAdjustment {
        protected final Modifier.ModifierKeyword fKeyword;
        protected final IMember fMember;
        protected boolean fNeedsRewriting = true;
        protected final RefactoringStatus fRefactoringStatus;

        public IncomingMemberVisibilityAdjustment(IMember member, Modifier.ModifierKeyword keyword, RefactoringStatus status) {
            Assert.isNotNull((Object)member);
            Assert.isTrue((!(member instanceof IInitializer) ? 1 : 0) != 0);
            Assert.isTrue((boolean)MemberVisibilityAdjustor.isVisibilityKeyword(keyword));
            this.fMember = member;
            this.fKeyword = keyword;
            this.fRefactoringStatus = status;
        }

        public final Modifier.ModifierKeyword getKeyword() {
            return this.fKeyword;
        }

        public final IMember getMember() {
            return this.fMember;
        }

        public final RefactoringStatus getStatus() {
            return this.fRefactoringStatus;
        }

        public final boolean needsRewriting() {
            return this.fNeedsRewriting;
        }

        protected final void rewriteVisibility(MemberVisibilityAdjustor adjustor, ASTRewrite rewrite, CompilationUnit root, CategorizedTextEditGroup group, RefactoringStatus status) throws JavaModelException {
            BodyDeclaration declaration;
            int visibility;
            Assert.isNotNull((Object)adjustor);
            Assert.isNotNull((Object)rewrite);
            Assert.isNotNull((Object)root);
            int n = visibility = this.fKeyword != null ? this.fKeyword.toFlagValue() : 0;
            if (this.fMember instanceof IField && !Flags.isEnum((int)this.fMember.getFlags())) {
                VariableDeclarationFragment fragment = ASTNodeSearchUtil.getFieldDeclarationFragmentNode((IField)this.fMember, root);
                FieldDeclaration declaration2 = (FieldDeclaration)fragment.getParent();
                if (declaration2.fragments().size() == 1) {
                    ModifierRewrite.create(rewrite, (ASTNode)declaration2).setVisibility(visibility, (TextEditGroup)group);
                } else {
                    VariableDeclarationFragment newFragment = rewrite.getAST().newVariableDeclarationFragment();
                    newFragment.setName((SimpleName)rewrite.createCopyTarget((ASTNode)fragment.getName()));
                    FieldDeclaration newDeclaration = rewrite.getAST().newFieldDeclaration(newFragment);
                    newDeclaration.setType((Type)rewrite.createCopyTarget((ASTNode)declaration2.getType()));
                    IExtendedModifier extended = null;
                    Iterator iterator = declaration2.modifiers().iterator();
                    while (iterator.hasNext()) {
                        Modifier modifier;
                        int flag;
                        extended = (IExtendedModifier)iterator.next();
                        if (extended.isModifier() && ((flag = (modifier = (Modifier)extended).getKeyword().toFlagValue()) & 7) != 0) continue;
                        newDeclaration.modifiers().add(rewrite.createCopyTarget((ASTNode)extended));
                    }
                    ModifierRewrite.create(rewrite, (ASTNode)newDeclaration).setVisibility(visibility, (TextEditGroup)group);
                    AbstractTypeDeclaration type = (AbstractTypeDeclaration)declaration2.getParent();
                    rewrite.getListRewrite((ASTNode)type, type.getBodyDeclarationsProperty()).insertAfter((ASTNode)newDeclaration, (ASTNode)declaration2, null);
                    ListRewrite list = rewrite.getListRewrite((ASTNode)declaration2, FieldDeclaration.FRAGMENTS_PROPERTY);
                    list.remove((ASTNode)fragment, (TextEditGroup)group);
                    if (list.getRewrittenList().isEmpty()) {
                        rewrite.remove((ASTNode)declaration2, null);
                    }
                }
                if (status != null) {
                    adjustor.fStatus.merge(status);
                }
            } else if (this.fMember != null && (declaration = ASTNodeSearchUtil.getBodyDeclarationNode(this.fMember, root)) != null) {
                ModifierRewrite.create(rewrite, (ASTNode)declaration).setVisibility(visibility, (TextEditGroup)group);
                if (status != null) {
                    adjustor.fStatus.merge(status);
                }
            }
        }

        /*
         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void rewriteVisibility(MemberVisibilityAdjustor adjustor, IProgressMonitor monitor) throws JavaModelException {
            Assert.isNotNull((Object)adjustor);
            Assert.isNotNull((Object)monitor);
            try {
                monitor.beginTask("", 1);
                monitor.setTaskName(RefactoringCoreMessages.MemberVisibilityAdjustor_adjusting);
                if (this.fNeedsRewriting) {
                    if (adjustor.fRewrite != null && adjustor.fRoot != null) {
                        this.rewriteVisibility(adjustor, adjustor.fRewrite, adjustor.fRoot, null, this.fRefactoringStatus);
                    } else {
                        CompilationUnitRewrite rewrite = adjustor.getCompilationUnitRewrite(this.fMember.getCompilationUnit());
                        this.rewriteVisibility(adjustor, rewrite.getASTRewrite(), rewrite.getRoot(), rewrite.createCategorizedGroupDescription(Messages.format(RefactoringCoreMessages.MemberVisibilityAdjustor_change_visibility, MemberVisibilityAdjustor.getLabel(this.getKeyword())), SET_VISIBILITY_ADJUSTMENTS), this.fRefactoringStatus);
                    }
                } else if (this.fRefactoringStatus != null) {
                    adjustor.fStatus.merge(this.fRefactoringStatus);
                }
                monitor.worked(1);
            }
            catch (Throwable throwable) {
                Object var4_5 = null;
                monitor.done();
                throw throwable;
            }
            {
                Object var4_6 = null;
            }
            monitor.done();
        }

        public final void setNeedsRewriting(boolean rewriting) {
            this.fNeedsRewriting = rewriting;
        }
    }

    public static class OutgoingMemberVisibilityAdjustment
    extends IncomingMemberVisibilityAdjustment {
        public OutgoingMemberVisibilityAdjustment(IMember member, Modifier.ModifierKeyword keyword, RefactoringStatus status) {
            super(member, keyword, status);
        }

        /*
         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void rewriteVisibility(MemberVisibilityAdjustor adjustor, IProgressMonitor monitor) throws JavaModelException {
            Assert.isNotNull((Object)adjustor);
            Assert.isNotNull((Object)monitor);
            try {
                monitor.beginTask("", 1);
                monitor.setTaskName(RefactoringCoreMessages.MemberVisibilityAdjustor_adjusting);
                if (this.fNeedsRewriting) {
                    CompilationUnitRewrite rewrite = adjustor.getCompilationUnitRewrite(this.fMember.getCompilationUnit());
                    this.rewriteVisibility(adjustor, rewrite.getASTRewrite(), rewrite.getRoot(), rewrite.createCategorizedGroupDescription(Messages.format(RefactoringCoreMessages.MemberVisibilityAdjustor_change_visibility, MemberVisibilityAdjustor.getLabel(this.getKeyword())), SET_VISIBILITY_ADJUSTMENTS), this.fRefactoringStatus);
                }
                monitor.worked(1);
            }
            catch (Throwable throwable) {
                Object var4_5 = null;
                monitor.done();
                throw throwable;
            }
            {
                Object var4_6 = null;
            }
            monitor.done();
        }
    }
}

