/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.corext.refactoring.structure.constraints;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.wst.jsdt.core.ICompilationUnit;
import org.eclipse.wst.jsdt.internal.corext.refactoring.structure.constraints.ConditionalTypeConstraint;
import org.eclipse.wst.jsdt.internal.corext.refactoring.structure.constraints.CovariantTypeConstraint;
import org.eclipse.wst.jsdt.internal.corext.refactoring.structure.constraints.SuperTypeConstraintsModel;
import org.eclipse.wst.jsdt.internal.corext.refactoring.structure.constraints.SuperTypeSet;
import org.eclipse.wst.jsdt.internal.corext.refactoring.typeconstraints.types.TType;
import org.eclipse.wst.jsdt.internal.corext.refactoring.typeconstraints2.CastVariable2;
import org.eclipse.wst.jsdt.internal.corext.refactoring.typeconstraints2.ConstraintVariable2;
import org.eclipse.wst.jsdt.internal.corext.refactoring.typeconstraints2.ITypeConstraint2;
import org.eclipse.wst.jsdt.internal.corext.refactoring.typeconstraints2.ITypeConstraintVariable;
import org.eclipse.wst.jsdt.internal.corext.refactoring.typeconstraints2.ITypeSet;
import org.eclipse.wst.jsdt.internal.corext.refactoring.typeconstraints2.ImmutableTypeVariable2;
import org.eclipse.wst.jsdt.internal.corext.refactoring.typeconstraints2.TypeEquivalenceSet;

public class SuperTypeConstraintsSolver {
    public static final String DATA_TYPE_ESTIMATE = "te";
    protected final SuperTypeConstraintsModel fModel;
    protected Map fObsoleteCasts = null;
    protected LinkedList fProcessable = null;
    protected Map fTypeOccurrences = null;

    public SuperTypeConstraintsSolver(SuperTypeConstraintsModel model) {
        Assert.isNotNull((Object)model);
        this.fModel = model;
    }

    private void computeConditionalTypeConstraints(Collection constraints, int level) {
        ITypeConstraint2 constraint = null;
        Iterator iterator = constraints.iterator();
        while (iterator.hasNext()) {
            constraint = (ITypeConstraint2)iterator.next();
            if (!(constraint instanceof ConditionalTypeConstraint)) continue;
            ConditionalTypeConstraint conditional = (ConditionalTypeConstraint)constraint;
            this.fModel.createEqualityConstraint(constraint.getLeft(), constraint.getRight());
            this.fModel.createEqualityConstraint(conditional.getExpression(), constraint.getLeft());
            this.fModel.createEqualityConstraint(conditional.getExpression(), constraint.getRight());
        }
    }

    private void computeNonCovariantConstraints(Collection constraints, int level) {
        if (level != 3) {
            ITypeConstraint2 constraint = null;
            Iterator iterator = constraints.iterator();
            while (iterator.hasNext()) {
                constraint = (ITypeConstraint2)iterator.next();
                if (!(constraint instanceof CovariantTypeConstraint)) continue;
                this.fModel.createEqualityConstraint(constraint.getLeft(), constraint.getRight());
            }
        }
    }

    private void computeObsoleteCasts(Collection variables) {
        this.fObsoleteCasts = new HashMap();
        CastVariable2 variable = null;
        Iterator iterator = variables.iterator();
        while (iterator.hasNext()) {
            variable = (CastVariable2)iterator.next();
            TType type = (TType)variable.getExpressionVariable().getData(DATA_TYPE_ESTIMATE);
            if (type == null || !type.canAssignTo(variable.getType())) continue;
            ICompilationUnit unit = variable.getCompilationUnit();
            ArrayList<CastVariable2> casts = (ArrayList<CastVariable2>)this.fObsoleteCasts.get(unit);
            if (casts != null) {
                casts.add(variable);
                continue;
            }
            casts = new ArrayList<CastVariable2>(1);
            casts.add(variable);
            this.fObsoleteCasts.put(unit, casts);
        }
    }

    protected ITypeSet computeTypeEstimate(ConstraintVariable2 variable) {
        TType type = variable.getType();
        if (variable instanceof ImmutableTypeVariable2 || !type.getErasure().equals(this.fModel.getSubType().getErasure())) {
            return SuperTypeSet.createTypeSet(type);
        }
        return SuperTypeSet.createTypeSet(type, this.fModel.getSuperType());
    }

    private void computeTypeEstimates(Collection variables) {
        ConstraintVariable2 variable = null;
        Iterator iterator = variables.iterator();
        while (iterator.hasNext()) {
            variable = (ConstraintVariable2)iterator.next();
            TypeEquivalenceSet set = variable.getTypeEquivalenceSet();
            if (set == null) {
                set = new TypeEquivalenceSet(variable);
                set.setTypeEstimate(this.computeTypeEstimate(variable));
                variable.setTypeEquivalenceSet(set);
                continue;
            }
            ITypeSet estimate = variable.getTypeEstimate();
            if (estimate != null) continue;
            ConstraintVariable2[] contributing = set.getContributingVariables();
            estimate = SuperTypeSet.getUniverse();
            int index = 0;
            while (index < contributing.length) {
                estimate = estimate.restrictedTo(this.computeTypeEstimate(contributing[index]));
                ++index;
            }
            set.setTypeEstimate(estimate);
        }
    }

    private void computeTypeOccurrences(Collection variables) {
        this.fTypeOccurrences = new HashMap();
        TType superErasure = this.fModel.getSuperType().getErasure();
        TType estimatedType = null;
        ITypeSet set = null;
        ICompilationUnit unit = null;
        ConstraintVariable2 variable = null;
        ITypeConstraintVariable declaration = null;
        TType variableType = null;
        Iterator iterator = variables.iterator();
        while (iterator.hasNext()) {
            TType typeErasure;
            variable = (ConstraintVariable2)iterator.next();
            if (!(variable instanceof ITypeConstraintVariable)) continue;
            declaration = (ITypeConstraintVariable)((Object)variable);
            variableType = variable.getType();
            set = declaration.getTypeEstimate();
            if (set == null || (estimatedType = set.chooseSingleType()) == null || (typeErasure = estimatedType.getErasure()).equals(variableType.getErasure()) || !typeErasure.equals(superErasure)) continue;
            declaration.setData(DATA_TYPE_ESTIMATE, estimatedType);
            unit = declaration.getCompilationUnit();
            if (unit == null) continue;
            ArrayList<ITypeConstraintVariable> matches = (ArrayList<ITypeConstraintVariable>)this.fTypeOccurrences.get(unit);
            if (matches != null) {
                matches.add(declaration);
                continue;
            }
            matches = new ArrayList<ITypeConstraintVariable>(1);
            matches.add(declaration);
            this.fTypeOccurrences.put(unit, matches);
        }
    }

    public final Map getObsoleteCasts() {
        return this.fObsoleteCasts;
    }

    public final Map getTypeOccurrences() {
        return this.fTypeOccurrences;
    }

    private void processConstraints(Collection constraints) {
        int level = this.fModel.getCompliance();
        ITypeConstraint2 constraint = null;
        Iterator iterator = constraints.iterator();
        while (iterator.hasNext()) {
            constraint = (ITypeConstraint2)iterator.next();
            if (level != 3 && constraint instanceof CovariantTypeConstraint || constraint instanceof ConditionalTypeConstraint) continue;
            ConstraintVariable2 leftVariable = constraint.getLeft();
            ITypeSet leftEstimate = leftVariable.getTypeEstimate();
            TypeEquivalenceSet set = leftVariable.getTypeEquivalenceSet();
            ITypeSet newEstimate = leftEstimate.restrictedTo(constraint.getRight().getTypeEstimate());
            if (leftEstimate == newEstimate) continue;
            set.setTypeEstimate(newEstimate);
            this.fProcessable.addAll(Arrays.asList(set.getContributingVariables()));
        }
    }

    public final void solveConstraints() {
        this.fProcessable = new LinkedList();
        Collection variables = this.fModel.getConstraintVariables();
        Collection constraints = this.fModel.getTypeConstraints();
        int level = this.fModel.getCompliance();
        this.computeNonCovariantConstraints(constraints, level);
        this.computeConditionalTypeConstraints(constraints, level);
        this.computeTypeEstimates(variables);
        this.fProcessable.addAll(variables);
        Collection usage = null;
        ConstraintVariable2 variable = null;
        while (!this.fProcessable.isEmpty()) {
            variable = (ConstraintVariable2)this.fProcessable.removeFirst();
            usage = SuperTypeConstraintsModel.getVariableUsage(variable);
            if (!usage.isEmpty()) {
                this.processConstraints(usage);
                continue;
            }
            variable.setData(DATA_TYPE_ESTIMATE, variable.getTypeEstimate().chooseSingleType());
        }
        this.computeTypeOccurrences(variables);
        this.computeObsoleteCasts(this.fModel.getCastVariables());
    }
}

