/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.corext.refactoring.typeconstraints;

import org.eclipse.core.runtime.Assert;
import org.eclipse.wst.jsdt.core.ICompilationUnit;
import org.eclipse.wst.jsdt.core.dom.ASTNode;
import org.eclipse.wst.jsdt.core.dom.ITypeBinding;
import org.eclipse.wst.jsdt.core.dom.Type;
import org.eclipse.wst.jsdt.internal.corext.dom.ASTNodes;
import org.eclipse.wst.jsdt.internal.corext.refactoring.typeconstraints.ASTCreator;
import org.eclipse.wst.jsdt.internal.corext.refactoring.typeconstraints.CompilationUnitRange;
import org.eclipse.wst.jsdt.internal.corext.refactoring.typeconstraints.ConstraintVariable;

public final class TypeVariable
extends ConstraintVariable {
    private final String fSource;
    private final CompilationUnitRange fTypeRange;

    public TypeVariable(Type type) {
        super(type.resolveBinding());
        this.fSource = type.toString();
        ICompilationUnit cu = ASTCreator.getCu((ASTNode)type);
        Assert.isNotNull((Object)cu);
        this.fTypeRange = new CompilationUnitRange(cu, (ASTNode)ASTNodes.getElementType(type));
    }

    public TypeVariable(ITypeBinding binding, String source, CompilationUnitRange range) {
        super(binding);
        this.fSource = source;
        this.fTypeRange = range;
    }

    public String toString() {
        return this.fSource;
    }

    public CompilationUnitRange getCompilationUnitRange() {
        return this.fTypeRange;
    }
}

