/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.corext.util;

import java.util.StringTokenizer;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.wst.jsdt.core.IType;
import org.eclipse.wst.jsdt.core.search.TypeNameMatch;
import org.eclipse.wst.jsdt.internal.corext.util.JavaModelUtil;
import org.eclipse.wst.jsdt.internal.ui.JavaPlugin;
import org.eclipse.wst.jsdt.internal.ui.util.StringMatcher;
import org.eclipse.wst.jsdt.ui.PreferenceConstants;

public class TypeFilter
implements IPropertyChangeListener {
    private StringMatcher[] fStringMatchers = null;

    public static TypeFilter getDefault() {
        return JavaPlugin.getDefault().getTypeFilter();
    }

    public static boolean isFiltered(String fullTypeName) {
        return TypeFilter.getDefault().filter(fullTypeName);
    }

    public static boolean isFiltered(char[] fullTypeName) {
        return TypeFilter.getDefault().filter(new String(fullTypeName));
    }

    public static boolean isFiltered(char[] packageName, char[] typeName) {
        return TypeFilter.getDefault().filter(JavaModelUtil.concatenateName(packageName, typeName));
    }

    public static boolean isFiltered(IType type) {
        TypeFilter typeFilter = TypeFilter.getDefault();
        if (typeFilter.hasFilters()) {
            return typeFilter.filter(JavaModelUtil.getFullyQualifiedName(type));
        }
        return false;
    }

    public static boolean isFiltered(TypeNameMatch match) {
        return TypeFilter.getDefault().filter(match.getFullyQualifiedName());
    }

    public TypeFilter() {
        PreferenceConstants.getPreferenceStore().addPropertyChangeListener((IPropertyChangeListener)this);
    }

    private synchronized StringMatcher[] getStringMatchers() {
        if (this.fStringMatchers == null) {
            String str = PreferenceConstants.getPreferenceStore().getString("org.eclipse.wst.jsdt.ui.typefilter.enabled");
            StringTokenizer tok = new StringTokenizer(str, ";");
            int nTokens = tok.countTokens();
            this.fStringMatchers = new StringMatcher[nTokens];
            int i = 0;
            while (i < nTokens) {
                String curr = tok.nextToken();
                if (curr.length() > 0) {
                    this.fStringMatchers[i] = new StringMatcher(curr, false, false);
                }
                ++i;
            }
        }
        return this.fStringMatchers;
    }

    public void dispose() {
        PreferenceConstants.getPreferenceStore().removePropertyChangeListener((IPropertyChangeListener)this);
        this.fStringMatchers = null;
    }

    public boolean hasFilters() {
        return this.getStringMatchers().length > 0;
    }

    public boolean filter(String fullTypeName) {
        StringMatcher[] matchers = this.getStringMatchers();
        int i = 0;
        while (i < matchers.length) {
            StringMatcher curr = matchers[i];
            if (curr.match(fullTypeName)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public synchronized void propertyChange(PropertyChangeEvent event) {
        if ("org.eclipse.wst.jsdt.ui.typefilter.enabled".equals(event.getProperty())) {
            this.fStringMatchers = null;
        }
    }
}

