/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.actions;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;
import org.eclipse.wst.jsdt.core.dom.IMethodBinding;
import org.eclipse.wst.jsdt.core.dom.ITypeBinding;
import org.eclipse.wst.jsdt.core.dom.IVariableBinding;
import org.eclipse.wst.jsdt.internal.corext.util.Messages;
import org.eclipse.wst.jsdt.internal.ui.actions.ActionMessages;
import org.eclipse.wst.jsdt.internal.ui.actions.GenerateConstructorUsingFieldsSelectionDialog;
import org.eclipse.wst.jsdt.internal.ui.dialogs.StatusInfo;

public class GenerateConstructorUsingFieldsValidator
implements ISelectionStatusValidator {
    private GenerateConstructorUsingFieldsSelectionDialog fDialog;
    private final int fEntries;
    private List fSignatures;
    private ITypeBinding fType = null;

    public GenerateConstructorUsingFieldsValidator(GenerateConstructorUsingFieldsSelectionDialog dialog, ITypeBinding type, int entries) {
        this.fEntries = entries;
        this.fDialog = dialog;
        this.fType = type;
        this.fSignatures = this.getExistingConstructorSignatures();
    }

    public GenerateConstructorUsingFieldsValidator(int entries) {
        this.fEntries = entries;
        this.fType = null;
    }

    private int countSelectedFields(Object[] selection) {
        int count = 0;
        int index = 0;
        while (index < selection.length) {
            if (selection[index] instanceof IVariableBinding) {
                ++count;
            }
            ++index;
        }
        return count;
    }

    private void createSignature(IMethodBinding constructor, StringBuffer buffer, Object[] selection) {
        ITypeBinding[] types = constructor.getParameterTypes();
        int index = 0;
        while (index < types.length) {
            buffer.append(types[index].getName());
            ++index;
        }
        if (selection != null) {
            index = 0;
            while (index < selection.length) {
                if (selection[index] instanceof IVariableBinding) {
                    buffer.append(((IVariableBinding)selection[index]).getType().getErasure().getName());
                }
                ++index;
            }
        }
    }

    private List getExistingConstructorSignatures() {
        ArrayList<String> existing = new ArrayList<String>();
        IMethodBinding[] methods = this.fType.getDeclaredMethods();
        int index = 0;
        while (index < methods.length) {
            if (methods[index].isConstructor()) {
                StringBuffer buffer = new StringBuffer();
                this.createSignature(methods[index], buffer, null);
                existing.add(buffer.toString());
            }
            ++index;
        }
        return existing;
    }

    public IStatus validate(Object[] selection) {
        StringBuffer buffer = new StringBuffer();
        IMethodBinding constructor = this.fDialog.getSuperConstructorChoice();
        this.createSignature(constructor, buffer, selection);
        if (this.fSignatures.contains(buffer.toString())) {
            return new StatusInfo(2, ActionMessages.GenerateConstructorUsingFieldsAction_error_duplicate_constructor);
        }
        return new StatusInfo(1, Messages.format(ActionMessages.GenerateConstructorUsingFieldsAction_fields_selected, new Object[]{String.valueOf(this.countSelectedFields(selection)), String.valueOf(this.fEntries)}));
    }
}

