/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.actions;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IPartService;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowPulldownDelegate2;
import org.eclipse.ui.actions.RetargetAction;
import org.eclipse.wst.jsdt.internal.ui.JavaPlugin;
import org.eclipse.wst.jsdt.internal.ui.actions.JDTQuickMenuAction;
import org.eclipse.wst.jsdt.internal.ui.javaeditor.JavaEditor;
import org.eclipse.wst.jsdt.internal.ui.search.SearchMessages;

public class OccurrencesSearchMenuAction
implements IWorkbenchWindowPulldownDelegate2 {
    private static Action NO_ACTION_AVAILABLE = new Action(SearchMessages.group_occurrences_quickMenu_noEntriesAvailable){

        public boolean isEnabled() {
            return false;
        }
    };
    private Menu fMenu;
    private IPartService fPartService;
    private RetargetAction[] fRetargetActions;

    public Menu getMenu(Menu parent) {
        this.setMenu(new Menu(parent));
        this.fillMenu(this.fMenu);
        return this.fMenu;
    }

    public Menu getMenu(Control parent) {
        this.setMenu(new Menu(parent));
        this.fillMenu(this.fMenu);
        return this.fMenu;
    }

    public void dispose() {
        this.setMenu(null);
        this.disposeSubmenuActions();
    }

    private RetargetAction createSubmenuAction(IPartService partService, String actionID, String text, String actionDefinitionId) {
        RetargetAction action = new RetargetAction(actionID, text);
        action.setActionDefinitionId(actionDefinitionId);
        partService.addPartListener((IPartListener)action);
        IWorkbenchPart activePart = partService.getActivePart();
        if (activePart != null) {
            action.partActivated(activePart);
        }
        return action;
    }

    private void disposeSubmenuActions() {
        if (this.fPartService != null && this.fRetargetActions != null) {
            int i = 0;
            while (i < this.fRetargetActions.length) {
                this.fPartService.removePartListener((IPartListener)this.fRetargetActions[i]);
                this.fRetargetActions[i].dispose();
                ++i;
            }
        }
        this.fRetargetActions = null;
        this.fPartService = null;
    }

    public void init(IWorkbenchWindow window) {
        this.disposeSubmenuActions();
        if (window != null) {
            this.fPartService = window.getPartService();
            if (this.fPartService != null) {
                this.fRetargetActions = new RetargetAction[]{this.createSubmenuAction(this.fPartService, "org.eclipse.wst.jsdt.ui.actions.OccurrencesInFile", SearchMessages.Search_FindOccurrencesInFile_shortLabel, "org.eclipse.wst.jsdt.ui.edit.text.java.search.occurrences.in.file")};
            }
        }
    }

    public void run(IAction action) {
        JavaEditor editor = null;
        IWorkbenchPart activePart = JavaPlugin.getActivePage().getActivePart();
        if (activePart instanceof JavaEditor) {
            editor = (JavaEditor)activePart;
        }
        new JDTQuickMenuAction(editor, "org.eclipse.wst.jsdt.ui.edit.text.java.search.occurrences.in.file.quickMenu"){

            protected void fillMenu(IMenuManager menu) {
                OccurrencesSearchMenuAction.this.fillQuickMenu(menu);
            }
        }.run();
    }

    public void selectionChanged(IAction action, ISelection selection) {
    }

    private void fillQuickMenu(IMenuManager manager) {
        RetargetAction[] actions = this.fRetargetActions;
        if (actions != null) {
            boolean hasAction = false;
            int i = 0;
            while (i < actions.length) {
                RetargetAction action = actions[i];
                if (action.isEnabled()) {
                    hasAction = true;
                    manager.add((IAction)action);
                }
                ++i;
            }
            if (!hasAction) {
                manager.add((IAction)NO_ACTION_AVAILABLE);
            }
        } else {
            manager.add((IAction)NO_ACTION_AVAILABLE);
        }
    }

    private void fillMenu(Menu menu) {
        if (this.fRetargetActions != null) {
            int i = 0;
            while (i < this.fRetargetActions.length) {
                ActionContributionItem item = new ActionContributionItem((IAction)this.fRetargetActions[i]);
                item.fill(menu, -1);
                ++i;
            }
        } else {
            ActionContributionItem item = new ActionContributionItem((IAction)NO_ACTION_AVAILABLE);
            item.fill(menu, -1);
        }
    }

    private void setMenu(Menu menu) {
        if (this.fMenu != null) {
            this.fMenu.dispose();
        }
        this.fMenu = menu;
    }
}

