/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.browsing;

import java.util.Arrays;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.part.IShowInTargetList;
import org.eclipse.wst.jsdt.core.IClassFile;
import org.eclipse.wst.jsdt.core.ICompilationUnit;
import org.eclipse.wst.jsdt.core.IJavaElement;
import org.eclipse.wst.jsdt.core.IMember;
import org.eclipse.wst.jsdt.core.IPackageFragment;
import org.eclipse.wst.jsdt.core.IType;
import org.eclipse.wst.jsdt.internal.ui.actions.SelectAllAction;
import org.eclipse.wst.jsdt.internal.ui.browsing.JavaBrowsingPart;
import org.eclipse.wst.jsdt.internal.ui.browsing.LogicalPackage;
import org.eclipse.wst.jsdt.internal.ui.browsing.TopLevelTypeProblemsLabelDecorator;
import org.eclipse.wst.jsdt.internal.ui.filters.NonJavaElementFilter;
import org.eclipse.wst.jsdt.internal.ui.viewsupport.AppearanceAwareLabelProvider;
import org.eclipse.wst.jsdt.internal.ui.viewsupport.ColoredViewersManager;
import org.eclipse.wst.jsdt.internal.ui.viewsupport.DecoratingJavaLabelProvider;
import org.eclipse.wst.jsdt.internal.ui.viewsupport.JavaUILabelProvider;

public class TypesView
extends JavaBrowsingPart {
    private SelectAllAction fSelectAllAction;
    static /* synthetic */ Class class$0;

    protected JavaUILabelProvider createLabelProvider() {
        return new AppearanceAwareLabelProvider(2288083699499049L, 1);
    }

    protected StructuredViewer createViewer(Composite parent) {
        StructuredViewer viewer = super.createViewer(parent);
        ColoredViewersManager.install(viewer);
        return viewer;
    }

    public Object getAdapter(Class key) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.ui.part.IShowInTargetList");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (key == clazz) {
            return new IShowInTargetList(){

                public String[] getShowInTargetIds() {
                    return new String[]{"org.eclipse.wst.jsdt.ui.PackageExplorer", "org.eclipse.ui.views.ResourceNavigator"};
                }
            };
        }
        return super.getAdapter(key);
    }

    protected void addFilters() {
        super.addFilters();
        this.getViewer().addFilter((ViewerFilter)new NonJavaElementFilter());
    }

    protected boolean isValidInput(Object element) {
        return element instanceof IPackageFragment;
    }

    protected boolean isValidElement(Object element) {
        if (element instanceof ICompilationUnit) {
            return super.isValidElement(((ICompilationUnit)element).getParent());
        }
        if (element instanceof IType) {
            IType type = (IType)element;
            return type.getDeclaringType() == null && this.isValidElement(type.getCompilationUnit());
        }
        return false;
    }

    protected IJavaElement findElementToSelect(IJavaElement je) {
        if (je == null) {
            return null;
        }
        switch (je.getElementType()) {
            case 7: {
                IType type = ((IType)je).getDeclaringType();
                if (type == null) {
                    type = (IType)je;
                }
                return type;
            }
            case 5: {
                return this.getTypeForCU((ICompilationUnit)je);
            }
            case 6: {
                return this.findElementToSelect((IJavaElement)((IClassFile)je).getType());
            }
            case 11: 
            case 12: 
            case 13: {
                return this.findElementToSelect(je.getParent());
            }
        }
        if (je instanceof IMember) {
            return this.findElementToSelect((IJavaElement)((IMember)je).getDeclaringType());
        }
        return null;
    }

    protected String getHelpContextId() {
        return "org.eclipse.wst.jsdt.ui.types_view_context";
    }

    protected String getLinkToEditorKey() {
        return "org.eclipse.wst.jsdt.ui.browsing.typestoeditor";
    }

    protected void createActions() {
        super.createActions();
        this.fSelectAllAction = new SelectAllAction((TableViewer)this.getViewer());
    }

    protected void fillActionBars(IActionBars actionBars) {
        super.fillActionBars(actionBars);
        actionBars.setGlobalActionHandler(ActionFactory.SELECT_ALL.getId(), (IAction)this.fSelectAllAction);
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        if (!this.needsToProcessSelectionChanged(part, selection)) {
            return;
        }
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection sel = (IStructuredSelection)selection;
            Object selectedElement = sel.getFirstElement();
            if (sel.size() == 1 && selectedElement instanceof LogicalPackage) {
                IPackageFragment[] fragments = ((LogicalPackage)((Object)selectedElement)).getFragments();
                List<IPackageFragment> selectedElements = Arrays.asList(fragments);
                if (selectedElements.size() > 1) {
                    this.adjustInput(part, selectedElements);
                    this.fPreviousSelectedElement = selectedElements;
                    this.fPreviousSelectionProvider = part;
                } else if (selectedElements.size() == 1) {
                    super.selectionChanged(part, (ISelection)new StructuredSelection((Object)selectedElements.get(0)));
                } else {
                    Assert.isLegal((boolean)false);
                }
                return;
            }
        }
        super.selectionChanged(part, selection);
    }

    private void adjustInput(IWorkbenchPart part, List selectedElements) {
        Object currentInput = this.getViewer().getInput();
        if (!selectedElements.equals(currentInput)) {
            this.setInput(selectedElements);
        }
    }

    protected DecoratingJavaLabelProvider createDecoratingLabelProvider(JavaUILabelProvider provider) {
        DecoratingJavaLabelProvider decoratingLabelProvider = super.createDecoratingLabelProvider(provider);
        provider.addLabelDecorator(new TopLevelTypeProblemsLabelDecorator(null));
        return decoratingLabelProvider;
    }
}

