/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.compare;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.ResourceBundle;
import org.eclipse.compare.IEncodedStreamContentAccessor;
import org.eclipse.compare.ITypedElement;
import org.eclipse.compare.structuremergeviewer.DiffNode;
import org.eclipse.compare.structuremergeviewer.ICompareInput;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionDelegate;
import org.eclipse.wst.jsdt.core.IJavaElement;
import org.eclipse.wst.jsdt.core.ISourceRange;
import org.eclipse.wst.jsdt.core.ISourceReference;
import org.eclipse.wst.jsdt.core.JavaModelException;
import org.eclipse.wst.jsdt.internal.corext.util.Messages;
import org.eclipse.wst.jsdt.internal.ui.JavaPlugin;
import org.eclipse.wst.jsdt.internal.ui.compare.CompareDialog;
import org.eclipse.wst.jsdt.internal.ui.compare.JavaCompareUtilities;
import org.eclipse.wst.jsdt.ui.JavaElementLabelProvider;

public class JavaCompareAction
implements IActionDelegate {
    private static final String BUNDLE_NAME = "org.eclipse.wst.jsdt.internal.ui.compare.CompareAction";
    private ISourceReference fLeft;
    private ISourceReference fRight;
    private JavaElementLabelProvider fJavaElementLabelProvider;

    public void selectionChanged(IAction action, ISelection selection) {
        action.setEnabled(this.isEnabled(selection));
    }

    public void run(IAction action) {
        Shell shell = JavaPlugin.getActiveWorkbenchShell();
        ResourceBundle bundle = ResourceBundle.getBundle(BUNDLE_NAME);
        CompareDialog d = new CompareDialog(shell, bundle);
        String left = null;
        String right = null;
        try {
            left = this.getExtendedSource(this.fLeft);
        }
        catch (JavaModelException ex) {
            JavaPlugin.log(ex);
        }
        try {
            right = this.getExtendedSource(this.fRight);
        }
        catch (JavaModelException ex) {
            JavaPlugin.log(ex);
        }
        this.fJavaElementLabelProvider = new JavaElementLabelProvider(82);
        if (left == null || right == null) {
            String errorTitle = JavaCompareUtilities.getString(bundle, "errorTitle");
            String errorFormat = JavaCompareUtilities.getString(bundle, "errorFormat");
            ISourceReference element = null;
            element = left == null ? this.fLeft : this.fRight;
            String message = Messages.format(errorFormat, new String[]{this.fJavaElementLabelProvider.getText(element)});
            MessageDialog.openError((Shell)shell, (String)errorTitle, (String)message);
            return;
        }
        d.compare((ICompareInput)new DiffNode((ITypedElement)new TypedElement(this.fLeft, left), (ITypedElement)new TypedElement(this.fRight, right)));
        this.fJavaElementLabelProvider.dispose();
        this.fJavaElementLabelProvider = null;
    }

    protected boolean isEnabled(ISelection selection) {
        Object[] sel;
        if (selection instanceof IStructuredSelection && (sel = ((IStructuredSelection)selection).toArray()).length == 2) {
            int i = 0;
            while (i < 2) {
                Object o = sel[i];
                if (!(o instanceof ISourceReference)) {
                    return false;
                }
                ++i;
            }
            this.fLeft = (ISourceReference)sel[0];
            this.fRight = (ISourceReference)sel[1];
            return true;
        }
        return false;
    }

    private String getExtendedSource(ISourceReference ref) throws JavaModelException {
        ISourceReference sr;
        String parentContent;
        IJavaElement parent;
        if (ref instanceof IJavaElement && (parent = ((IJavaElement)ref).getParent()) instanceof ISourceReference && (parentContent = (sr = (ISourceReference)parent).getSource()) != null) {
            ISourceRange parentRange = sr.getSourceRange();
            ISourceRange childRange = ref.getSourceRange();
            int start = childRange.getOffset() - parentRange.getOffset();
            int end = start + childRange.getLength();
            while (start > 0) {
                char c = parentContent.charAt(start - 1);
                if (c == '\n' || c == '\r') break;
                --start;
            }
            return parentContent.substring(start, end);
        }
        return ref.getSource();
    }

    class TypedElement
    implements ITypedElement,
    IEncodedStreamContentAccessor {
        private ISourceReference fSource;
        private String fContents;

        TypedElement(ISourceReference s, String contents) {
            this.fSource = s;
            this.fContents = contents;
        }

        public String getName() {
            return JavaCompareAction.this.fJavaElementLabelProvider.getText(this.fSource);
        }

        public String getType() {
            return "JAVA";
        }

        public Image getImage() {
            return JavaCompareAction.this.fJavaElementLabelProvider.getImage(this.fSource);
        }

        public InputStream getContents() throws CoreException {
            byte[] bytes;
            try {
                bytes = this.fContents.getBytes("UTF-16");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                bytes = this.fContents.getBytes();
            }
            return new ByteArrayInputStream(bytes);
        }

        public String getCharset() {
            return "UTF-16";
        }
    }
}

