/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.compare;

import java.io.IOException;
import org.eclipse.compare.CompareUI;
import org.eclipse.compare.IEditableContent;
import org.eclipse.compare.ISharedDocumentAdapter;
import org.eclipse.compare.IStreamContentAccessor;
import org.eclipse.compare.ITypedElement;
import org.eclipse.compare.structuremergeviewer.DocumentRangeNode;
import org.eclipse.compare.structuremergeviewer.IStructureComparator;
import org.eclipse.compare.structuremergeviewer.StructureCreator;
import org.eclipse.compare.structuremergeviewer.StructureRootNode;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentPartitioner;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.rules.FastPartitioner;
import org.eclipse.jface.text.rules.IPartitionTokenScanner;
import org.eclipse.swt.graphics.Image;
import org.eclipse.wst.jsdt.internal.ui.JavaPlugin;
import org.eclipse.wst.jsdt.internal.ui.compare.CompareMessages;
import org.eclipse.wst.jsdt.internal.ui.compare.JavaCompareUtilities;
import org.eclipse.wst.jsdt.internal.ui.propertiesfileeditor.IPropertiesFilePartitions;
import org.eclipse.wst.jsdt.internal.ui.propertiesfileeditor.PropertiesFilePartitionScanner;

public class PropertiesStructureCreator
extends StructureCreator {
    private static final String WHITESPACE = " \t\r\n\f";
    private static final String SEPARATORS = "=:";
    private static final String SEPARATORS2 = "=: \t\r\n\f";

    public String getName() {
        return CompareMessages.PropertyCompareViewer_title;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected IStructureComparator createStructureComparator(Object input, IDocument document, ISharedDocumentAdapter sharedDocumentAdapter, IProgressMonitor monitor) throws CoreException {
        final boolean isEditable = input instanceof IEditableContent ? ((IEditableContent)input).isEditable() : false;
        StructureRootNode root = new StructureRootNode(document, input, this, sharedDocumentAdapter){

            public boolean isEditable() {
                return isEditable;
            }
        };
        try {
            try {
                monitor = this.beginWork(monitor);
                this.parsePropertyFile((DocumentRangeNode)root, document, monitor);
            }
            catch (IOException ex) {
                if (sharedDocumentAdapter == null) throw new CoreException((IStatus)new Status(4, JavaPlugin.getPluginId(), 0, CompareMessages.PropertiesStructureCreator_error_occurred, (Throwable)ex));
                sharedDocumentAdapter.disconnect(input);
                throw new CoreException((IStatus)new Status(4, JavaPlugin.getPluginId(), 0, CompareMessages.PropertiesStructureCreator_error_occurred, (Throwable)ex));
            }
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            monitor.done();
            throw throwable;
        }
        {
            Object var8_10 = null;
        }
        monitor.done();
        return root;
    }

    public IStructureComparator locate(Object path, Object source) {
        return null;
    }

    public String getContents(Object node, boolean ignoreWhitespace) {
        if (node instanceof IStreamContentAccessor) {
            IStreamContentAccessor sca = (IStreamContentAccessor)node;
            try {
                return JavaCompareUtilities.readString(sca);
            }
            catch (CoreException ex) {
                JavaPlugin.log(ex);
            }
        }
        return null;
    }

    private String readLine(int[] args, IDocument doc) {
        int n = args[0];
        args[0] = n + 1;
        int line = n;
        try {
            IRegion region = doc.getLineInformation(line);
            int start = region.getOffset();
            int length = region.getLength();
            try {
                region = doc.getLineInformation(line + 1);
                args[1] = region.getOffset();
            }
            catch (BadLocationException badLocationException) {
                args[1] = doc.getLength();
            }
            return doc.get(start, length);
        }
        catch (BadLocationException badLocationException) {
            return null;
        }
    }

    /*
     * Unable to fully structure code
     */
    private void parsePropertyFile(DocumentRangeNode root, IDocument doc, IProgressMonitor monitor) throws IOException {
        start = -1;
        lineStart = 0;
        args = new int[]{0, 0};
        while (true) {
            this.worked(monitor);
            lineStart = args[1];
            line = this.readLine(args, doc);
            if (line == null) {
                return;
            }
            if (line.length() <= 0) continue;
            firstChar = line.charAt(0);
            if (firstChar != '#' && firstChar != '!') ** GOTO lbl27
            if (start >= 0) continue;
            start = lineStart;
            continue;
lbl-1000:
            // 1 sources

            {
                nextLine = this.readLine(args, doc);
                if (nextLine == null) {
                    nextLine = "";
                }
                line2 = line.substring(0, line.length() - 1);
                startPos = 0;
                while (startPos < nextLine.length()) {
                    if (" \t\r\n\f".indexOf(nextLine.charAt(startPos)) == -1) break;
                    ++startPos;
                }
                nextLine = nextLine.substring(startPos, nextLine.length());
                line = String.valueOf(line2) + nextLine;
lbl27:
                // 2 sources

                ** while (this.needNextLine((String)line))
            }
lbl28:
            // 1 sources

            len = line.length();
            keyPos = 0;
            while (keyPos < len) {
                if (" \t\r\n\f".indexOf(line.charAt(keyPos)) == -1) break;
                ++keyPos;
            }
            separatorPos = keyPos;
            while (separatorPos < len) {
                c = line.charAt(separatorPos);
                if (c == '\\') {
                    ++separatorPos;
                } else if ("=: \t\r\n\f".indexOf(c) != -1) break;
                ++separatorPos;
            }
            valuePos = separatorPos;
            while (valuePos < len) {
                if (" \t\r\n\f".indexOf(line.charAt(valuePos)) == -1) break;
                ++valuePos;
            }
            if (valuePos < len && "=:".indexOf(line.charAt(valuePos)) != -1) {
                ++valuePos;
            }
            while (valuePos < len) {
                if (" \t\r\n\f".indexOf(line.charAt(valuePos)) == -1) break;
                ++valuePos;
            }
            if ((key = this.convert(line.substring(keyPos, separatorPos))).length() <= 0) continue;
            if (start < 0) {
                start = lineStart;
            }
            value = "";
            if (separatorPos < len) {
                value = this.convert(line.substring(valuePos, len));
            }
            length = args[1] - start;
            try {
                s = doc.get(start, length);
                i = s.length() - 1;
                while (i >= 0) {
                    c = s.charAt(i);
                    if (c == '\r' || c == '\n') {
                        --length;
                        --i;
                        continue;
                    }
                    break;
                }
            }
            catch (BadLocationException v0) {}
            new PropertyNode(root, 0, key, value, doc, start, length);
            start = -1;
        }
    }

    private boolean needNextLine(String line) {
        int slashes = 0;
        int ix = line.length() - 1;
        while (ix >= 0 && line.charAt(ix--) == '\\') {
            ++slashes;
        }
        return slashes % 2 == 1;
    }

    private String convert(String s) {
        int l = s.length();
        StringBuffer buf = new StringBuffer(l);
        int i = 0;
        while (i < l) {
            char c;
            if ((c = s.charAt(i++)) == '\\') {
                if ((c = s.charAt(i++)) == 'u') {
                    int v = 0;
                    int j = 0;
                    while (j < 4) {
                        c = s.charAt(i++);
                        switch (c) {
                            case '0': 
                            case '1': 
                            case '2': 
                            case '3': 
                            case '4': 
                            case '5': 
                            case '6': 
                            case '7': 
                            case '8': 
                            case '9': {
                                v = (v << 4) + (c - 48);
                                break;
                            }
                            case 'a': 
                            case 'b': 
                            case 'c': 
                            case 'd': 
                            case 'e': 
                            case 'f': {
                                v = (v << 4) + 10 + (c - 97);
                                break;
                            }
                            case 'A': 
                            case 'B': 
                            case 'C': 
                            case 'D': 
                            case 'E': 
                            case 'F': {
                                v = (v << 4) + 10 + (c - 65);
                                break;
                            }
                            default: {
                                throw new IllegalArgumentException(CompareMessages.PropertyCompareViewer_malformedEncoding);
                            }
                        }
                        ++j;
                    }
                    buf.append((char)v);
                    continue;
                }
                switch (c) {
                    case 't': {
                        c = '\t';
                        break;
                    }
                    case 'r': {
                        c = '\r';
                        break;
                    }
                    case 'n': {
                        c = '\n';
                        break;
                    }
                    case 'f': {
                        c = '\f';
                    }
                }
                buf.append(c);
                continue;
            }
            buf.append(c);
        }
        return buf.toString();
    }

    protected IDocumentPartitioner getDocumentPartitioner() {
        return new FastPartitioner((IPartitionTokenScanner)new PropertiesFilePartitionScanner(), IPropertiesFilePartitions.PARTITIONS);
    }

    protected String getDocumentPartitioning() {
        return "___pf_partitioning";
    }

    private void worked(IProgressMonitor monitor) {
        if (monitor.isCanceled()) {
            throw new OperationCanceledException();
        }
        monitor.worked(1);
    }

    private IProgressMonitor beginWork(IProgressMonitor monitor) {
        if (monitor == null) {
            return new NullProgressMonitor();
        }
        return new SubProgressMonitor(monitor, -1);
    }

    static class PropertyNode
    extends DocumentRangeNode
    implements ITypedElement,
    IAdaptable {
        public PropertyNode(DocumentRangeNode parent, int type, String id, String value, IDocument doc, int start, int length) {
            super(parent, type, id, doc, start, length);
            if (parent != null) {
                parent.addChild((DocumentRangeNode)this);
            }
        }

        public String getName() {
            return this.getId();
        }

        public String getType() {
            return "properties2";
        }

        public Image getImage() {
            return CompareUI.getImage((String)this.getType());
        }
    }
}

