/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.dialogs;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.jobs.IJobManager;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.LabelProviderChangedEvent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.WorkbenchException;
import org.eclipse.ui.XMLMemento;
import org.eclipse.ui.dialogs.FilteredItemsSelectionDialog;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;
import org.eclipse.ui.dialogs.PreferencesUtil;
import org.eclipse.ui.dialogs.SearchPattern;
import org.eclipse.wst.jsdt.core.Flags;
import org.eclipse.wst.jsdt.core.IJavaElement;
import org.eclipse.wst.jsdt.core.IPackageFragmentRoot;
import org.eclipse.wst.jsdt.core.IType;
import org.eclipse.wst.jsdt.core.JavaConventions;
import org.eclipse.wst.jsdt.core.JavaModelException;
import org.eclipse.wst.jsdt.core.search.IJavaSearchScope;
import org.eclipse.wst.jsdt.core.search.SearchEngine;
import org.eclipse.wst.jsdt.core.search.TypeNameMatch;
import org.eclipse.wst.jsdt.core.search.TypeNameMatchRequestor;
import org.eclipse.wst.jsdt.core.search.TypeNameRequestor;
import org.eclipse.wst.jsdt.internal.corext.util.Messages;
import org.eclipse.wst.jsdt.internal.corext.util.OpenTypeHistory;
import org.eclipse.wst.jsdt.internal.corext.util.Strings;
import org.eclipse.wst.jsdt.internal.corext.util.TypeFilter;
import org.eclipse.wst.jsdt.internal.corext.util.TypeInfoRequestorAdapter;
import org.eclipse.wst.jsdt.internal.ui.JavaPlugin;
import org.eclipse.wst.jsdt.internal.ui.JavaUIMessages;
import org.eclipse.wst.jsdt.internal.ui.dialogs.TextFieldNavigationHandler;
import org.eclipse.wst.jsdt.internal.ui.search.JavaSearchScopeFactory;
import org.eclipse.wst.jsdt.internal.ui.util.ExceptionHandler;
import org.eclipse.wst.jsdt.internal.ui.util.TypeNameMatchLabelProvider;
import org.eclipse.wst.jsdt.internal.ui.viewsupport.ColoredJavaElementLabels;
import org.eclipse.wst.jsdt.internal.ui.viewsupport.ColoredString;
import org.eclipse.wst.jsdt.internal.ui.viewsupport.ColoredViewersManager;
import org.eclipse.wst.jsdt.internal.ui.viewsupport.JavaElementImageProvider;
import org.eclipse.wst.jsdt.internal.ui.viewsupport.OwnerDrawSupport;
import org.eclipse.wst.jsdt.internal.ui.workingsets.WorkingSetFilterActionGroup;
import org.eclipse.wst.jsdt.launching.IVMInstall;
import org.eclipse.wst.jsdt.launching.IVMInstallType;
import org.eclipse.wst.jsdt.launching.JavaRuntime;
import org.eclipse.wst.jsdt.launching.LibraryLocation;
import org.eclipse.wst.jsdt.ui.JavaElementLabels;
import org.eclipse.wst.jsdt.ui.dialogs.ITypeInfoFilterExtension;
import org.eclipse.wst.jsdt.ui.dialogs.ITypeInfoImageProvider;
import org.eclipse.wst.jsdt.ui.dialogs.ITypeSelectionComponent;
import org.eclipse.wst.jsdt.ui.dialogs.TypeSelectionExtension;

public class FilteredTypesSelectionDialog
extends FilteredItemsSelectionDialog
implements ITypeSelectionComponent {
    private static final boolean BUG_184693 = true;
    private static final String DIALOG_SETTINGS = "org.eclipse.wst.jsdt.internal.ui.dialogs.FilteredTypesSelectionDialog";
    private static final String SHOW_CONTAINER_FOR_DUPLICATES = "ShowContainerForDuplicates";
    private static final String WORKINGS_SET_SETTINGS = "WorkingSet";
    private WorkingSetFilterActionGroup fFilterActionGroup;
    private final TypeItemLabelProvider fTypeInfoLabelProvider;
    private String fTitle;
    private ShowContainerForDuplicatesAction fShowContainerForDuplicatesAction;
    private IJavaSearchScope fSearchScope;
    private boolean fAllowScopeSwitching;
    private final int fElementKinds;
    private final ITypeInfoFilterExtension fFilterExtension;
    private final TypeSelectionExtension fExtension;
    private ISelectionStatusValidator fValidator;
    private final TypeInfoUtil fTypeInfoUtil;
    private static boolean fgFirstTime = true;
    private final TypeItemsComparator fTypeItemsComparator;
    private int fTypeFilterVersion = 0;

    public FilteredTypesSelectionDialog(Shell parent, boolean multi, IRunnableContext context, IJavaSearchScope scope, int elementKinds) {
        this(parent, multi, context, scope, elementKinds, null);
    }

    public FilteredTypesSelectionDialog(Shell shell, boolean multi, IRunnableContext context, IJavaSearchScope scope, int elementKinds, TypeSelectionExtension extension) {
        super(shell, multi);
        this.setSelectionHistory(new TypeSelectionHistory());
        if (scope == null) {
            this.fAllowScopeSwitching = true;
            scope = SearchEngine.createWorkspaceScope();
        }
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)shell, "org.eclipse.wst.jsdt.ui.type_selection_dialog2_context");
        this.fElementKinds = elementKinds;
        this.fExtension = extension;
        this.fFilterExtension = extension == null ? null : extension.getFilterExtension();
        this.fSearchScope = scope;
        if (extension != null) {
            this.fValidator = extension.getSelectionValidator();
        }
        this.fTypeInfoUtil = new TypeInfoUtil(extension != null ? extension.getImageProvider() : null);
        this.fTypeInfoLabelProvider = new TypeItemLabelProvider();
        this.setListLabelProvider((ILabelProvider)this.fTypeInfoLabelProvider);
        this.setListSelectionLabelDecorator(this.fTypeInfoLabelProvider);
        this.setDetailsLabelProvider((ILabelProvider)new TypeItemDetailsLabelProvider(this.fTypeInfoUtil));
        this.fTypeItemsComparator = new TypeItemsComparator();
    }

    public void setTitle(String title) {
        super.setTitle(title);
        this.fTitle = title;
    }

    private void setSubtitle(String text) {
        if (text == null || text.length() == 0) {
            this.getShell().setText(this.fTitle);
        } else {
            this.getShell().setText(Messages.format(JavaUIMessages.FilteredTypeSelectionDialog_titleFormat, new String[]{this.fTitle, text}));
        }
    }

    protected IDialogSettings getDialogSettings() {
        IDialogSettings settings = JavaPlugin.getDefault().getDialogSettings().getSection(DIALOG_SETTINGS);
        if (settings == null) {
            settings = JavaPlugin.getDefault().getDialogSettings().addNewSection(DIALOG_SETTINGS);
        }
        return settings;
    }

    protected void storeDialog(IDialogSettings settings) {
        super.storeDialog(settings);
        if (this.fFilterActionGroup != null) {
            XMLMemento memento = XMLMemento.createWriteRoot((String)"workingSet");
            this.fFilterActionGroup.saveState((IMemento)memento);
            this.fFilterActionGroup.dispose();
            StringWriter writer = new StringWriter();
            try {
                memento.save((Writer)writer);
                settings.put(WORKINGS_SET_SETTINGS, writer.getBuffer().toString());
            }
            catch (IOException e) {
                JavaPlugin.log(e);
            }
        }
    }

    protected void restoreDialog(IDialogSettings settings) {
        super.restoreDialog(settings);
        this.fTypeInfoLabelProvider.setContainerInfo(true);
        if (this.fAllowScopeSwitching) {
            IWorkingSet ws;
            String setting = settings.get(WORKINGS_SET_SETTINGS);
            if (setting != null) {
                try {
                    XMLMemento memento = XMLMemento.createReadRoot((Reader)new StringReader(setting));
                    this.fFilterActionGroup.restoreState((IMemento)memento);
                }
                catch (WorkbenchException e) {
                    JavaPlugin.log(e);
                }
            }
            if ((ws = this.fFilterActionGroup.getWorkingSet()) == null || ws.isAggregateWorkingSet() && ws.isEmpty()) {
                this.setSearchScope(SearchEngine.createWorkspaceScope());
                this.setSubtitle(null);
            } else {
                this.setSearchScope(JavaSearchScopeFactory.getInstance().createJavaSearchScope(ws, true));
                this.setSubtitle(ws.getLabel());
            }
        }
    }

    protected void fillViewMenu(IMenuManager menuManager) {
        super.fillViewMenu(menuManager);
        if (this.fAllowScopeSwitching) {
            this.fFilterActionGroup = new WorkingSetFilterActionGroup(this.getShell(), JavaPlugin.getActivePage(), new IPropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent event) {
                    IWorkingSet ws = (IWorkingSet)event.getNewValue();
                    if (ws == null || ws.isAggregateWorkingSet() && ws.isEmpty()) {
                        FilteredTypesSelectionDialog.this.setSearchScope(SearchEngine.createWorkspaceScope());
                        FilteredTypesSelectionDialog.this.setSubtitle(null);
                    } else {
                        FilteredTypesSelectionDialog.this.setSearchScope(JavaSearchScopeFactory.getInstance().createJavaSearchScope(ws, true));
                        FilteredTypesSelectionDialog.this.setSubtitle(ws.getLabel());
                    }
                    FilteredTypesSelectionDialog.this.applyFilter();
                }
            });
            this.fFilterActionGroup.fillViewMenu(menuManager);
        }
        menuManager.add((IContributionItem)new Separator());
        menuManager.add((IAction)new TypeFiltersPreferencesAction());
    }

    protected Control createExtendedContentArea(Composite parent) {
        Control addition = null;
        if (this.fExtension != null) {
            addition = this.fExtension.createContentArea(parent);
            if (addition != null) {
                GridData gd = new GridData(768);
                gd.horizontalSpan = 2;
                addition.setLayoutData((Object)gd);
            }
            this.fExtension.initialize(this);
        }
        return addition;
    }

    protected void setResult(List newResult) {
        ArrayList<IType> resultToReturn = new ArrayList<IType>();
        int i = 0;
        while (i < newResult.size()) {
            if (newResult.get(i) instanceof TypeNameMatch) {
                IType type = ((TypeNameMatch)newResult.get(i)).getType();
                if (type.exists()) {
                    resultToReturn.add(type);
                } else {
                    TypeNameMatch typeInfo = (TypeNameMatch)newResult.get(i);
                    IPackageFragmentRoot root = typeInfo.getPackageFragmentRoot();
                    String containerName = JavaElementLabels.getElementLabel((IJavaElement)root, 0x20000000000L);
                    String message = Messages.format(JavaUIMessages.FilteredTypesSelectionDialog_dialogMessage, new String[]{typeInfo.getFullyQualifiedName(), containerName});
                    MessageDialog.openError((Shell)this.getShell(), (String)this.fTitle, (String)message);
                    this.getSelectionHistory().remove((Object)typeInfo);
                }
            }
            ++i;
        }
        super.setResult(resultToReturn);
    }

    public void create() {
        super.create();
        Control patternControl = this.getPatternControl();
        if (patternControl instanceof Text) {
            TextFieldNavigationHandler.install((Text)patternControl);
        }
    }

    public int open() {
        String text;
        ISelection selection;
        IWorkbenchWindow window;
        if (this.getInitialPattern() == null && (window = JavaPlugin.getActiveWorkbenchWindow()) != null && (selection = window.getSelectionService().getSelection()) instanceof ITextSelection && (text = ((ITextSelection)selection).getText()) != null && (text = text.trim()).length() > 0 && JavaConventions.validateJavaTypeName((String)text, (String)"1.3", (String)"1.3").isOK()) {
            this.setInitialPattern(text, 2);
        }
        return super.open();
    }

    public void setValidator(ISelectionStatusValidator validator) {
        this.fValidator = validator;
    }

    protected FilteredItemsSelectionDialog.ItemsFilter createFilter() {
        return new TypeItemsFilter(this.fSearchScope, this.fElementKinds, this.fFilterExtension);
    }

    protected Control createContents(Composite parent) {
        Table listControl;
        Control contents = super.createContents(parent);
        if (ColoredViewersManager.showColoredLabels() && contents instanceof Composite && (listControl = this.findTableControl((Composite)contents)) != null) {
            this.installOwnerDraw(listControl);
        }
        return contents;
    }

    private void installOwnerDraw(Table tableControl) {
        new OwnerDrawSupport((Control)tableControl){

            public ColoredString getColoredLabel(Item item) {
                String text = item.getText();
                ColoredString str = new ColoredString(text);
                int index = text.indexOf(45);
                if (index != -1) {
                    str.colorize(index, str.length() - index, ColoredJavaElementLabels.QUALIFIER_STYLE);
                }
                return str;
            }

            public Color getColor(String foregroundColorName, Display display) {
                return PlatformUI.getWorkbench().getThemeManager().getCurrentTheme().getColorRegistry().get(foregroundColorName);
            }
        };
    }

    private Table findTableControl(Composite composite) {
        Control[] children = composite.getChildren();
        int i = 0;
        while (i < children.length) {
            Table res;
            Control curr = children[i];
            if (curr instanceof Table) {
                return (Table)curr;
            }
            if (curr instanceof Composite && (res = this.findTableControl((Composite)curr)) != null) {
                return res;
            }
            ++i;
        }
        return null;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void fillContentProvider(FilteredItemsSelectionDialog.AbstractContentProvider provider, FilteredItemsSelectionDialog.ItemsFilter itemsFilter, IProgressMonitor progressMonitor) throws CoreException {
        TypeItemsFilter typeSearchFilter = (TypeItemsFilter)itemsFilter;
        TypeSearchRequestor requestor = new TypeSearchRequestor(provider, typeSearchFilter);
        SearchEngine engine = new SearchEngine(null);
        String packPattern = typeSearchFilter.getPackagePattern();
        progressMonitor.setTaskName(JavaUIMessages.FilteredTypesSelectionDialog_searchJob_taskName);
        String typePattern = itemsFilter.getPattern();
        int matchRule = typeSearchFilter.getMatchRule();
        if (matchRule == 128) {
            char lastChar = typePattern.charAt(typePattern.length() - 1);
            if (lastChar == '<' || lastChar == ' ') {
                typePattern = typePattern.substring(0, typePattern.length() - 1);
            } else {
                typeSearchFilter.setMatchEverythingMode(true);
            }
        } else {
            typeSearchFilter.setMatchEverythingMode(true);
        }
        try {
            engine.searchAllTypeNames(packPattern == null ? null : packPattern.toCharArray(), typeSearchFilter.getPackageFlags(), typePattern.toCharArray(), matchRule, typeSearchFilter.getElementKind(), typeSearchFilter.getSearchScope(), (TypeNameMatchRequestor)requestor, 3, progressMonitor);
        }
        catch (Throwable throwable) {
            Object var10_11 = null;
            typeSearchFilter.setMatchEverythingMode(false);
            throw throwable;
        }
        {
            Object var10_12 = null;
            typeSearchFilter.setMatchEverythingMode(false);
            return;
        }
    }

    protected Comparator getItemsComparator() {
        return this.fTypeItemsComparator;
    }

    public String getElementName(Object item) {
        TypeNameMatch type = (TypeNameMatch)item;
        return this.fTypeInfoUtil.getText(type);
    }

    protected IStatus validateItem(Object item) {
        if (item == null) {
            return new Status(4, JavaPlugin.getPluginId(), 4, "", null);
        }
        if (this.fValidator != null) {
            IType type = ((TypeNameMatch)item).getType();
            if (!type.exists()) {
                return new Status(4, JavaPlugin.getPluginId(), 4, Messages.format(JavaUIMessages.FilteredTypesSelectionDialog_error_type_doesnot_exist, ((TypeNameMatch)item).getFullyQualifiedName()), null);
            }
            Object[] elements = new Object[]{type};
            return this.fValidator.validate(elements);
        }
        return new Status(0, JavaPlugin.getPluginId(), 0, "", null);
    }

    private void setSearchScope(IJavaSearchScope scope) {
        this.fSearchScope = scope;
    }

    public void reloadCache(boolean checkDuplicates, IProgressMonitor monitor) {
        IProgressMonitor remainingMonitor;
        if (ConsistencyRunnable.needsExecution()) {
            monitor.beginTask(JavaUIMessages.TypeSelectionDialog_progress_consistency, 10);
            try {
                ConsistencyRunnable runnable = new ConsistencyRunnable();
                runnable.run((IProgressMonitor)new SubProgressMonitor(monitor, 1));
            }
            catch (InvocationTargetException e) {
                ExceptionHandler.handle(e, JavaUIMessages.TypeSelectionDialog_error3Title, JavaUIMessages.TypeSelectionDialog_error3Message);
                this.close();
                return;
            }
            catch (InterruptedException interruptedException) {
                this.close();
                return;
            }
            remainingMonitor = new SubProgressMonitor(monitor, 9);
        } else {
            remainingMonitor = monitor;
        }
        super.reloadCache(checkDuplicates, remainingMonitor);
        monitor.done();
    }

    public void triggerSearch() {
        ++this.fTypeFilterVersion;
        this.applyFilter();
    }

    private static class ConsistencyRunnable
    implements IRunnableWithProgress {
        private ConsistencyRunnable() {
        }

        public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
            if (fgFirstTime) {
                IJobManager manager = Job.getJobManager();
                manager.join((Object)"org.eclipse.wst.jsdt.ui", monitor);
            }
            OpenTypeHistory history = OpenTypeHistory.getInstance();
            if (fgFirstTime || history.isEmpty()) {
                if (history.needConsistencyCheck()) {
                    monitor.beginTask(JavaUIMessages.TypeSelectionDialog_progress_consistency, 100);
                    this.refreshSearchIndices((IProgressMonitor)new SubProgressMonitor(monitor, 90));
                    history.checkConsistency((IProgressMonitor)new SubProgressMonitor(monitor, 10));
                } else {
                    this.refreshSearchIndices(monitor);
                }
                monitor.done();
                fgFirstTime = false;
            } else {
                history.checkConsistency(monitor);
            }
        }

        public static boolean needsExecution() {
            OpenTypeHistory history = OpenTypeHistory.getInstance();
            return fgFirstTime || history.isEmpty() || history.needConsistencyCheck();
        }

        private void refreshSearchIndices(IProgressMonitor monitor) throws InvocationTargetException {
            try {
                new SearchEngine().searchAllTypeNames(null, 0, "_______________".toCharArray(), 8, 7, SearchEngine.createWorkspaceScope(), new TypeNameRequestor(this){
                    final /* synthetic */ ConsistencyRunnable this$1;
                    {
                        this.this$1 = consistencyRunnable;
                    }
                }, 3, monitor);
            }
            catch (JavaModelException e) {
                throw new InvocationTargetException(e);
            }
        }
    }

    private class ShowContainerForDuplicatesAction
    extends Action {
        public ShowContainerForDuplicatesAction() {
            super(JavaUIMessages.FilteredTypeSelectionDialog_showContainerForDuplicatesAction, 2);
        }

        public void run() {
            FilteredTypesSelectionDialog.this.fTypeInfoLabelProvider.setContainerInfo(this.isChecked());
        }
    }

    private class TypeFiltersPreferencesAction
    extends Action {
        public TypeFiltersPreferencesAction() {
            super(JavaUIMessages.FilteredTypesSelectionDialog_TypeFiltersPreferencesAction_label);
        }

        public void run() {
            String typeFilterID = "org.eclipse.wst.jsdt.ui.preferences.TypeFilterPreferencePage";
            PreferencesUtil.createPreferenceDialogOn((Shell)FilteredTypesSelectionDialog.this.getShell(), (String)typeFilterID, (String[])new String[]{typeFilterID}, null).open();
            FilteredTypesSelectionDialog.this.triggerSearch();
        }
    }

    private static class TypeInfoUtil {
        private final ITypeInfoImageProvider fProviderExtension;
        private final TypeInfoRequestorAdapter fAdapter = new TypeInfoRequestorAdapter();
        private final Map fLib2Name = new HashMap();
        private final String[] fInstallLocations;
        private final String[] fVMNames;
        private boolean fFullyQualifyDuplicates;

        public TypeInfoUtil(ITypeInfoImageProvider extension) {
            this.fProviderExtension = extension;
            ArrayList locations = new ArrayList();
            ArrayList labels = new ArrayList();
            IVMInstallType[] installs = JavaRuntime.getVMInstallTypes();
            int i = 0;
            while (i < installs.length) {
                this.processVMInstallType(installs[i], locations, labels);
                ++i;
            }
            this.fInstallLocations = locations.toArray(new String[locations.size()]);
            this.fVMNames = labels.toArray(new String[labels.size()]);
        }

        public void setFullyQualifyDuplicates(boolean value) {
            this.fFullyQualifyDuplicates = value;
        }

        private void processVMInstallType(IVMInstallType installType, List locations, List labels) {
            if (installType != null) {
                IVMInstall[] installs = installType.getVMInstalls();
                boolean isMac = "macosx".equals(Platform.getOS());
                int i = 0;
                while (i < installs.length) {
                    String label = this.getFormattedLabel(installs[i].getName());
                    LibraryLocation[] libLocations = installs[i].getLibraryLocations();
                    if (libLocations != null) {
                        this.processLibraryLocation(libLocations, label);
                    } else {
                        String filePath = installs[i].getInstallLocation().getAbsolutePath();
                        if (isMac && filePath.endsWith("/Home")) {
                            filePath = filePath.substring(0, filePath.length() - "/Home".length() + 1);
                        }
                        locations.add(filePath);
                        labels.add(label);
                    }
                    ++i;
                }
            }
        }

        private void processLibraryLocation(LibraryLocation[] libLocations, String label) {
            int l = 0;
            while (l < libLocations.length) {
                LibraryLocation location = libLocations[l];
                this.fLib2Name.put(location.getSystemLibraryPath().toOSString(), label);
                ++l;
            }
        }

        private String getFormattedLabel(String name) {
            return Messages.format(JavaUIMessages.FilteredTypesSelectionDialog_library_name_format, name);
        }

        public String getText(Object element) {
            return ((TypeNameMatch)element).getSimpleTypeName();
        }

        public String getQualifiedText(TypeNameMatch type) {
            StringBuffer result = new StringBuffer();
            result.append(type.getSimpleTypeName());
            String containerName = type.getTypeContainerName();
            result.append(JavaElementLabels.CONCAT_STRING);
            if (containerName.length() > 0) {
                result.append(containerName);
            } else {
                result.append(JavaUIMessages.FilteredTypesSelectionDialog_default_package);
            }
            return result.toString();
        }

        public String getFullyQualifiedText(TypeNameMatch type) {
            StringBuffer result = new StringBuffer();
            result.append(type.getSimpleTypeName());
            String containerName = type.getTypeContainerName();
            if (containerName.length() > 0) {
                result.append(JavaElementLabels.CONCAT_STRING);
                result.append(containerName);
            }
            result.append(JavaElementLabels.CONCAT_STRING);
            result.append(this.getContainerName(type));
            return result.toString();
        }

        public String getText(TypeNameMatch last, TypeNameMatch current, TypeNameMatch next) {
            StringBuffer result = new StringBuffer();
            int qualifications = 0;
            String currentTN = current.getSimpleTypeName();
            result.append(currentTN);
            String currentTCN = this.getTypeContainerName(current);
            if (last != null) {
                String lastTN = last.getSimpleTypeName();
                String lastTCN = this.getTypeContainerName(last);
                if (currentTCN.equals(lastTCN)) {
                    if (currentTN.equals(lastTN)) {
                        result.append(JavaElementLabels.CONCAT_STRING);
                        result.append(currentTCN);
                        result.append(JavaElementLabels.CONCAT_STRING);
                        result.append(this.getContainerName(current));
                        return result.toString();
                    }
                } else if (currentTN.equals(lastTN)) {
                    qualifications = 1;
                }
            }
            if (next != null) {
                String nextTN = next.getSimpleTypeName();
                String nextTCN = this.getTypeContainerName(next);
                if (currentTCN.equals(nextTCN)) {
                    if (currentTN.equals(nextTN)) {
                        result.append(JavaElementLabels.CONCAT_STRING);
                        result.append(currentTCN);
                        result.append(JavaElementLabels.CONCAT_STRING);
                        result.append(this.getContainerName(current));
                        return result.toString();
                    }
                } else if (currentTN.equals(nextTN)) {
                    qualifications = 1;
                }
            }
            if (qualifications > 0) {
                result.append(JavaElementLabels.CONCAT_STRING);
                result.append(currentTCN);
                if (this.fFullyQualifyDuplicates) {
                    result.append(JavaElementLabels.CONCAT_STRING);
                    result.append(this.getContainerName(current));
                }
            }
            return result.toString();
        }

        public String getQualificationText(TypeNameMatch type) {
            StringBuffer result = new StringBuffer();
            String containerName = type.getTypeContainerName();
            if (containerName.length() > 0) {
                result.append(containerName);
                result.append(JavaElementLabels.CONCAT_STRING);
            }
            result.append(this.getContainerName(type));
            return result.toString();
        }

        private boolean isInnerType(TypeNameMatch match) {
            return match.getTypeQualifiedName().indexOf(46) != -1;
        }

        public ImageDescriptor getImageDescriptor(Object element) {
            TypeNameMatch type = (TypeNameMatch)element;
            if (this.fProviderExtension != null) {
                this.fAdapter.setMatch(type);
                ImageDescriptor descriptor = this.fProviderExtension.getImageDescriptor(this.fAdapter);
                if (descriptor != null) {
                    return descriptor;
                }
            }
            return JavaElementImageProvider.getTypeImageDescriptor(this.isInnerType(type), false, type.getModifiers(), false);
        }

        private String getTypeContainerName(TypeNameMatch info) {
            String result = info.getTypeContainerName();
            if (result.length() > 0) {
                return result;
            }
            return JavaUIMessages.FilteredTypesSelectionDialog_default_package;
        }

        private String getContainerName(TypeNameMatch type) {
            IPackageFragmentRoot root = type.getPackageFragmentRoot();
            if (root.isExternal()) {
                String name = root.getPath().toOSString();
                int i = 0;
                while (i < this.fInstallLocations.length) {
                    if (name.startsWith(this.fInstallLocations[i])) {
                        return this.fVMNames[i];
                    }
                    ++i;
                }
                String lib = (String)this.fLib2Name.get(name);
                if (lib != null) {
                    return lib;
                }
            }
            StringBuffer buf = new StringBuffer();
            JavaElementLabels.getPackageFragmentRootLabel(root, 0x30000000000L, buf);
            return buf.toString();
        }
    }

    private static class TypeItemDetailsLabelProvider
    extends LabelProvider {
        private final TypeNameMatchLabelProvider fLabelProvider = new TypeNameMatchLabelProvider(40);
        private final TypeInfoUtil fTypeInfoUtil;

        public TypeItemDetailsLabelProvider(TypeInfoUtil typeInfoUtil) {
            this.fTypeInfoUtil = typeInfoUtil;
        }

        public Image getImage(Object element) {
            if (element instanceof TypeNameMatch) {
                return this.fLabelProvider.getImage(element);
            }
            return super.getImage(element);
        }

        public String getText(Object element) {
            if (element instanceof TypeNameMatch) {
                return this.fTypeInfoUtil.getQualificationText((TypeNameMatch)element);
            }
            return super.getText(element);
        }
    }

    private class TypeItemLabelProvider
    extends LabelProvider
    implements ILabelDecorator {
        private boolean fContainerInfo;

        public void setContainerInfo(boolean containerInfo) {
            this.fContainerInfo = containerInfo;
            this.fireLabelProviderChanged(new LabelProviderChangedEvent((IBaseLabelProvider)this));
        }

        private boolean isInnerType(TypeNameMatch match) {
            return match.getTypeQualifiedName().indexOf(46) != -1;
        }

        public Image getImage(Object element) {
            if (!(element instanceof TypeNameMatch)) {
                return super.getImage(element);
            }
            TypeNameMatch type = (TypeNameMatch)element;
            ImageDescriptor iD = JavaElementImageProvider.getTypeImageDescriptor(this.isInnerType(type), false, type.getModifiers(), false);
            return JavaPlugin.getImageDescriptorRegistry().get(iD);
        }

        public String getText(Object element) {
            if (!(element instanceof TypeNameMatch)) {
                return super.getText(element);
            }
            if (this.fContainerInfo && FilteredTypesSelectionDialog.this.isDuplicateElement(element)) {
                return FilteredTypesSelectionDialog.this.fTypeInfoUtil.getFullyQualifiedText((TypeNameMatch)element);
            }
            if (!this.fContainerInfo && FilteredTypesSelectionDialog.this.isDuplicateElement(element)) {
                return FilteredTypesSelectionDialog.this.fTypeInfoUtil.getQualifiedText((TypeNameMatch)element);
            }
            return FilteredTypesSelectionDialog.this.fTypeInfoUtil.getText(element);
        }

        public Image decorateImage(Image image, Object element) {
            return null;
        }

        public String decorateText(String text, Object element) {
            if (!(element instanceof TypeNameMatch)) {
                return null;
            }
            if (this.fContainerInfo && FilteredTypesSelectionDialog.this.isDuplicateElement(element)) {
                return FilteredTypesSelectionDialog.this.fTypeInfoUtil.getFullyQualifiedText((TypeNameMatch)element);
            }
            return FilteredTypesSelectionDialog.this.fTypeInfoUtil.getQualifiedText((TypeNameMatch)element);
        }
    }

    private static class TypeItemsComparator
    implements Comparator {
        private final Map fLib2Name = new HashMap();
        private final String[] fInstallLocations;
        private final String[] fVMNames;

        public TypeItemsComparator() {
            ArrayList locations = new ArrayList();
            ArrayList labels = new ArrayList();
            IVMInstallType[] installs = JavaRuntime.getVMInstallTypes();
            int i = 0;
            while (i < installs.length) {
                this.processVMInstallType(installs[i], locations, labels);
                ++i;
            }
            this.fInstallLocations = locations.toArray(new String[locations.size()]);
            this.fVMNames = labels.toArray(new String[labels.size()]);
        }

        private void processVMInstallType(IVMInstallType installType, List locations, List labels) {
            if (installType != null) {
                IVMInstall[] installs = installType.getVMInstalls();
                boolean isMac = "macosx".equals(Platform.getOS());
                int i = 0;
                while (i < installs.length) {
                    String label = this.getFormattedLabel(installs[i].getName());
                    LibraryLocation[] libLocations = installs[i].getLibraryLocations();
                    if (libLocations != null) {
                        this.processLibraryLocation(libLocations, label);
                    } else {
                        String filePath = installs[i].getInstallLocation().getAbsolutePath();
                        if (isMac && filePath.endsWith("/Home")) {
                            filePath = filePath.substring(0, filePath.length() - "/Home".length() + 1);
                        }
                        locations.add(filePath);
                        labels.add(label);
                    }
                    ++i;
                }
            }
        }

        private void processLibraryLocation(LibraryLocation[] libLocations, String label) {
            int l = 0;
            while (l < libLocations.length) {
                LibraryLocation location = libLocations[l];
                this.fLib2Name.put(location.getSystemLibraryPath().toString(), label);
                ++l;
            }
        }

        private String getFormattedLabel(String name) {
            return MessageFormat.format(JavaUIMessages.FilteredTypesSelectionDialog_library_name_format, name);
        }

        public int compare(Object left, Object right) {
            int rightCategory;
            TypeNameMatch leftInfo = (TypeNameMatch)left;
            TypeNameMatch rightInfo = (TypeNameMatch)right;
            int result = this.compareName(leftInfo.getSimpleTypeName(), rightInfo.getSimpleTypeName());
            if (result != 0) {
                return result;
            }
            result = this.compareTypeContainerName(leftInfo.getTypeContainerName(), rightInfo.getTypeContainerName());
            if (result != 0) {
                return result;
            }
            int leftCategory = this.getElementTypeCategory(leftInfo);
            if (leftCategory < (rightCategory = this.getElementTypeCategory(rightInfo))) {
                return -1;
            }
            if (leftCategory > rightCategory) {
                return 1;
            }
            return this.compareContainerName(leftInfo, rightInfo);
        }

        private int compareName(String leftString, String rightString) {
            int result = leftString.compareToIgnoreCase(rightString);
            if (result != 0 || rightString.length() == 0) {
                return result;
            }
            if (Strings.isLowerCase(leftString.charAt(0)) && !Strings.isLowerCase(rightString.charAt(0))) {
                return 1;
            }
            if (Strings.isLowerCase(rightString.charAt(0)) && !Strings.isLowerCase(leftString.charAt(0))) {
                return -1;
            }
            return leftString.compareTo(rightString);
        }

        private int compareTypeContainerName(String leftString, String rightString) {
            int leftLength = leftString.length();
            int rightLength = rightString.length();
            if (leftLength == 0 && rightLength > 0) {
                return -1;
            }
            if (leftLength == 0 && rightLength == 0) {
                return 0;
            }
            if (leftLength > 0 && rightLength == 0) {
                return 1;
            }
            return this.compareName(leftString, rightString);
        }

        private int compareContainerName(TypeNameMatch leftType, TypeNameMatch rightType) {
            return this.getContainerName(leftType).compareTo(this.getContainerName(rightType));
        }

        private String getContainerName(TypeNameMatch type) {
            IPackageFragmentRoot root = type.getPackageFragmentRoot();
            if (root.isExternal()) {
                String name = root.getPath().toOSString();
                int i = 0;
                while (i < this.fInstallLocations.length) {
                    if (name.startsWith(this.fInstallLocations[i])) {
                        return this.fVMNames[i];
                    }
                    ++i;
                }
                String lib = (String)this.fLib2Name.get(name);
                if (lib != null) {
                    return lib;
                }
            }
            StringBuffer buf = new StringBuffer();
            JavaElementLabels.getPackageFragmentRootLabel(root, 0x30000000000L, buf);
            return buf.toString();
        }

        private int getElementTypeCategory(TypeNameMatch type) {
            try {
                if (type.getPackageFragmentRoot().getKind() == 1) {
                    return 0;
                }
            }
            catch (JavaModelException e) {
                JavaPlugin.log(e);
            }
            return 1;
        }
    }

    private class TypeItemsFilter
    extends FilteredItemsSelectionDialog.ItemsFilter {
        private static final int TYPE_MODIFIERS = 25088;
        private final IJavaSearchScope fScope;
        private final boolean fIsWorkspaceScope;
        private final int fElemKind;
        private final ITypeInfoFilterExtension fFilterExt;
        private final TypeInfoRequestorAdapter fAdapter = new TypeInfoRequestorAdapter();
        private SearchPattern fPackageMatcher;
        private boolean fMatchEverything = false;
        private final int fMyTypeFilterVersion;

        public TypeItemsFilter(IJavaSearchScope scope, int elementKind, ITypeInfoFilterExtension extension) {
            super((FilteredItemsSelectionDialog)FilteredTypesSelectionDialog.this, (SearchPattern)new TypeSearchPattern());
            this.fMyTypeFilterVersion = FilteredTypesSelectionDialog.this.fTypeFilterVersion;
            this.fScope = scope;
            this.fIsWorkspaceScope = scope == null ? false : scope.equals(SearchEngine.createWorkspaceScope());
            this.fElemKind = elementKind;
            this.fFilterExt = extension;
            String stringPackage = ((TypeSearchPattern)this.patternMatcher).getPackagePattern();
            if (stringPackage != null) {
                this.fPackageMatcher = new SearchPattern();
                this.fPackageMatcher.setPattern(stringPackage);
            } else {
                this.fPackageMatcher = null;
            }
        }

        public boolean isSubFilter(FilteredItemsSelectionDialog.ItemsFilter filter) {
            if (!super.isSubFilter(filter)) {
                return false;
            }
            TypeItemsFilter typeItemsFilter = (TypeItemsFilter)filter;
            if (this.fScope != typeItemsFilter.getSearchScope()) {
                return false;
            }
            if (this.fMyTypeFilterVersion != typeItemsFilter.getMyTypeFilterVersion()) {
                return false;
            }
            return this.getPattern().indexOf(46, filter.getPattern().length()) == -1;
        }

        public boolean equalsFilter(FilteredItemsSelectionDialog.ItemsFilter iFilter) {
            if (!super.equalsFilter(iFilter)) {
                return false;
            }
            if (!(iFilter instanceof TypeItemsFilter)) {
                return false;
            }
            TypeItemsFilter typeItemsFilter = (TypeItemsFilter)iFilter;
            if (this.fScope != typeItemsFilter.getSearchScope()) {
                return false;
            }
            return this.fMyTypeFilterVersion == typeItemsFilter.getMyTypeFilterVersion();
        }

        public int getElementKind() {
            return this.fElemKind;
        }

        public ITypeInfoFilterExtension getFilterExtension() {
            return this.fFilterExt;
        }

        public IJavaSearchScope getSearchScope() {
            return this.fScope;
        }

        public int getMyTypeFilterVersion() {
            return this.fMyTypeFilterVersion;
        }

        public String getPackagePattern() {
            if (this.fPackageMatcher == null) {
                return null;
            }
            return this.fPackageMatcher.getPattern();
        }

        public int getPackageFlags() {
            if (this.fPackageMatcher == null) {
                return 1;
            }
            return this.fPackageMatcher.getMatchRule();
        }

        public boolean matchesRawNamePattern(TypeNameMatch type) {
            return Strings.startsWithIgnoreCase(type.getSimpleTypeName(), this.getPattern());
        }

        public boolean matchesCachedResult(TypeNameMatch type) {
            if (!this.matchesPackage(type) || !this.matchesFilterExtension(type)) {
                return false;
            }
            return this.matchesName(type);
        }

        public boolean matchesHistoryElement(TypeNameMatch type) {
            if (!(this.matchesPackage(type) && this.matchesModifiers(type) && this.matchesScope(type) && this.matchesFilterExtension(type))) {
                return false;
            }
            return this.matchesName(type);
        }

        public boolean matchesFilterExtension(TypeNameMatch type) {
            if (this.fFilterExt == null) {
                return true;
            }
            this.fAdapter.setMatch(type);
            return this.fFilterExt.select(this.fAdapter);
        }

        private boolean matchesName(TypeNameMatch type) {
            return this.matches(type.getSimpleTypeName());
        }

        private boolean matchesPackage(TypeNameMatch type) {
            if (this.fPackageMatcher == null) {
                return true;
            }
            return this.fPackageMatcher.matches(type.getPackageName());
        }

        private boolean matchesScope(TypeNameMatch type) {
            if (this.fIsWorkspaceScope) {
                return true;
            }
            return this.fScope.encloses((IJavaElement)type.getType());
        }

        private boolean matchesModifiers(TypeNameMatch type) {
            if (this.fElemKind == 0) {
                return true;
            }
            int modifiers = type.getModifiers() & 0x6200;
            switch (this.fElemKind) {
                case 5: {
                    return modifiers == 0;
                }
                case 8: {
                    return Flags.isAnnotation((int)modifiers);
                }
                case 6: {
                    return Flags.isInterface((int)modifiers);
                }
                case 7: {
                    return Flags.isEnum((int)modifiers);
                }
                case 10: {
                    return modifiers == 0 || Flags.isInterface((int)modifiers);
                }
                case 9: {
                    return modifiers == 0 || Flags.isEnum((int)modifiers);
                }
            }
            return false;
        }

        public void setMatchEverythingMode(boolean matchEverything) {
            this.fMatchEverything = matchEverything;
        }

        public boolean isConsistentItem(Object item) {
            return true;
        }

        public boolean matchItem(Object item) {
            if (this.fMatchEverything) {
                return true;
            }
            TypeNameMatch type = (TypeNameMatch)item;
            if (!(this.matchesPackage(type) && this.matchesModifiers(type) && this.matchesScope(type) && this.matchesFilterExtension(type))) {
                return false;
            }
            return this.matchesName(type);
        }

        public boolean matchesRawNamePattern(Object item) {
            TypeNameMatch type = (TypeNameMatch)item;
            return this.matchesRawNamePattern(type);
        }
    }

    private static class TypeSearchPattern
    extends SearchPattern {
        private String packagePattern;

        private TypeSearchPattern() {
        }

        public void setPattern(String stringPattern) {
            String pattern = stringPattern;
            String packPattern = null;
            int index = stringPattern.lastIndexOf(".");
            if (index != -1) {
                packPattern = this.evaluatePackagePattern(stringPattern.substring(0, index));
                pattern = stringPattern.substring(index + 1);
                if (pattern.length() == 0) {
                    pattern = "**";
                }
            }
            super.setPattern(pattern);
            this.packagePattern = packPattern;
        }

        private String evaluatePackagePattern(String s) {
            StringBuffer buf = new StringBuffer();
            boolean hasWildCard = false;
            int i = 0;
            while (i < s.length()) {
                char ch = s.charAt(i);
                if (ch == '.') {
                    if (!hasWildCard) {
                        buf.append('*');
                    }
                    hasWildCard = false;
                } else if (ch == '*' || ch == '?') {
                    hasWildCard = true;
                }
                buf.append(ch);
                ++i;
            }
            if (!hasWildCard) {
                buf.append('*');
            }
            return buf.toString();
        }

        protected boolean isNameCharAllowed(char nameChar) {
            return super.isNameCharAllowed(nameChar);
        }

        protected boolean isPatternCharAllowed(char patternChar) {
            return super.isPatternCharAllowed(patternChar);
        }

        protected boolean isValidCamelCaseChar(char ch) {
            return super.isValidCamelCaseChar(ch);
        }

        public String getPackagePattern() {
            return this.packagePattern;
        }
    }

    private static class TypeSearchRequestor
    extends TypeNameMatchRequestor {
        private volatile boolean fStop;
        private final FilteredItemsSelectionDialog.AbstractContentProvider fContentProvider;
        private final TypeItemsFilter fTypeItemsFilter;

        public TypeSearchRequestor(FilteredItemsSelectionDialog.AbstractContentProvider contentProvider, TypeItemsFilter typeItemsFilter) {
            this.fContentProvider = contentProvider;
            this.fTypeItemsFilter = typeItemsFilter;
        }

        public void cancel() {
            this.fStop = true;
        }

        public void acceptTypeNameMatch(TypeNameMatch match) {
            if (this.fStop) {
                return;
            }
            if (TypeFilter.isFiltered(match)) {
                return;
            }
            if (this.fTypeItemsFilter.matchesFilterExtension(match)) {
                this.fContentProvider.add((Object)match, (FilteredItemsSelectionDialog.ItemsFilter)this.fTypeItemsFilter);
            }
        }
    }

    protected class TypeSelectionHistory
    extends FilteredItemsSelectionDialog.SelectionHistory {
        public synchronized void accessed(Object object) {
            super.accessed(object);
        }

        public synchronized boolean remove(Object element) {
            OpenTypeHistory.getInstance().remove((TypeNameMatch)element);
            return super.remove(element);
        }

        public void load(IMemento memento) {
            TypeNameMatch[] types = OpenTypeHistory.getInstance().getTypeInfos();
            int i = 0;
            while (i < types.length) {
                TypeNameMatch type = types[i];
                this.accessed(type);
                ++i;
            }
        }

        public void save(IMemento memento) {
            this.persistHistory();
        }

        private synchronized void persistHistory() {
            if (FilteredTypesSelectionDialog.this.getReturnCode() == 0) {
                Object[] items = this.getHistoryItems();
                int i = 0;
                while (i < items.length) {
                    OpenTypeHistory.getInstance().accessed((TypeNameMatch)items[i]);
                    ++i;
                }
            }
        }

        protected Object restoreItemFromMemento(IMemento element) {
            return null;
        }

        protected void storeItemToMemento(Object item, IMemento element) {
        }
    }
}

