/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.filters;

import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.model.IWorkbenchAdapter;
import org.eclipse.wst.jsdt.core.IJavaElement;
import org.eclipse.wst.jsdt.internal.ui.util.StringMatcher;

public class NamePatternFilter
extends ViewerFilter {
    private String[] fPatterns;
    private StringMatcher[] fMatchers;
    static /* synthetic */ Class class$0;

    private StringMatcher[] getMatchers() {
        return this.fMatchers;
    }

    public String[] getPatterns() {
        return this.fPatterns;
    }

    public boolean select(Viewer viewer, Object parentElement, Object element) {
        if (this.fMatchers.length == 0) {
            return true;
        }
        String matchName = null;
        if (element instanceof IJavaElement) {
            matchName = ((IJavaElement)element).getElementName();
        } else if (element instanceof IResource) {
            matchName = ((IResource)element).getName();
        } else if (element instanceof IStorage) {
            matchName = ((IStorage)element).getName();
        } else if (element instanceof IWorkingSet) {
            matchName = ((IWorkingSet)element).getLabel();
        } else if (element instanceof IAdaptable) {
            IWorkbenchAdapter wbadapter;
            IAdaptable iAdaptable = (IAdaptable)element;
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.ui.model.IWorkbenchAdapter");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((wbadapter = (IWorkbenchAdapter)iAdaptable.getAdapter((Class)clazz)) != null) {
                matchName = wbadapter.getLabel(element);
            }
        }
        if (matchName != null && matchName.length() > 0) {
            StringMatcher[] testMatchers = this.getMatchers();
            int i = 0;
            while (i < testMatchers.length) {
                if (testMatchers[i].match(matchName)) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        return true;
    }

    public void setPatterns(String[] newPatterns) {
        this.fPatterns = newPatterns;
        this.fMatchers = new StringMatcher[newPatterns.length];
        int i = 0;
        while (i < newPatterns.length) {
            this.fMatchers[i] = new StringMatcher(newPatterns[i], true, false);
            ++i;
        }
    }
}

