/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.filters;

import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.wst.jsdt.core.IClasspathEntry;
import org.eclipse.wst.jsdt.core.IJavaProject;
import org.eclipse.wst.jsdt.core.JavaCore;

public class OutputFolderFilter
extends ViewerFilter {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean select(Viewer viewer, Object parent, Object element) {
        if (!(element instanceof IFolder)) return true;
        IFolder folder = (IFolder)element;
        IProject proj = folder.getProject();
        try {
            if (!proj.hasNature("org.eclipse.wst.jsdt.core.jsNature")) {
                return true;
            }
            IJavaProject jProject = JavaCore.create((IProject)folder.getProject());
            if (jProject == null) return true;
            if (!jProject.exists()) {
                return true;
            }
            IPath defaultOutputLocation = jProject.getOutputLocation();
            IPath folderPath = folder.getFullPath();
            if (defaultOutputLocation != null && defaultOutputLocation.equals((Object)folderPath)) {
                return false;
            }
            IClasspathEntry[] cpEntries = jProject.getRawClasspath();
            int i = 0;
            int length = cpEntries.length;
            while (true) {
                if (i >= length) {
                    return true;
                }
                IPath outputLocation = cpEntries[i].getOutputLocation();
                if (outputLocation != null && outputLocation.equals((Object)folderPath)) {
                    return false;
                }
                ++i;
            }
        }
        catch (CoreException coreException) {
            return true;
        }
    }
}

