/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.fix;

import java.util.ArrayList;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.wst.jsdt.core.ICompilationUnit;
import org.eclipse.wst.jsdt.core.dom.CompilationUnit;
import org.eclipse.wst.jsdt.internal.corext.fix.IFix;
import org.eclipse.wst.jsdt.internal.ui.fix.AbstractCleanUp;
import org.eclipse.wst.jsdt.internal.ui.fix.CodeFormatFix;
import org.eclipse.wst.jsdt.internal.ui.fix.MultiFixMessages;
import org.eclipse.wst.jsdt.ui.text.java.IProblemLocation;

public class CodeFormatCleanUp
extends AbstractCleanUp {
    public CodeFormatCleanUp() {
    }

    public CodeFormatCleanUp(Map options) {
        super(options);
    }

    public boolean requireAST(ICompilationUnit unit) throws CoreException {
        return false;
    }

    public IFix createFix(ICompilationUnit compilationUnit) throws CoreException {
        if (compilationUnit == null) {
            return null;
        }
        boolean removeWhitespaces = this.isEnabled("cleanup.remove_trailing_whitespaces");
        return CodeFormatFix.createCleanUp(compilationUnit, this.isEnabled("cleanup.format_source_code"), removeWhitespaces && this.isEnabled("cleanup.remove_trailing_whitespaces_all"), removeWhitespaces && this.isEnabled("cleanup.remove_trailing_whitespaces_ignore_empty"));
    }

    public IFix createFix(CompilationUnit compilationUnit) throws CoreException {
        return null;
    }

    public IFix createFix(CompilationUnit compilationUnit, IProblemLocation[] problems) throws CoreException {
        if (compilationUnit == null) {
            return null;
        }
        return null;
    }

    public Map getRequiredOptions() {
        return null;
    }

    public String[] getDescriptions() {
        ArrayList<String> result = new ArrayList<String>();
        if (this.isEnabled("cleanup.format_source_code")) {
            result.add(MultiFixMessages.CodeFormatCleanUp_description);
        }
        if (this.isEnabled("cleanup.remove_trailing_whitespaces")) {
            if (this.isEnabled("cleanup.remove_trailing_whitespaces_all")) {
                result.add(MultiFixMessages.CodeFormatCleanUp_RemoveTrailingAll_description);
            } else if (this.isEnabled("cleanup.remove_trailing_whitespaces_ignore_empty")) {
                result.add(MultiFixMessages.CodeFormatCleanUp_RemoveTrailingNoEmpty_description);
            }
        }
        return result.toArray(new String[result.size()]);
    }

    public String getPreview() {
        StringBuffer buf = new StringBuffer();
        buf.append("  function start() {}\n");
        if (this.isEnabled("cleanup.remove_trailing_whitespaces") && this.isEnabled("cleanup.remove_trailing_whitespaces_all")) {
            buf.append("\n");
        } else {
            buf.append("    \n");
        }
        if (this.isEnabled("cleanup.remove_trailing_whitespaces")) {
            buf.append("    function\n");
        } else {
            buf.append("    function \n");
        }
        buf.append("        stop() {\n");
        buf.append("    }\n");
        buf.append("}\n");
        return buf.toString();
    }

    public int maximalNumberOfFixes(CompilationUnit compilationUnit) {
        return -1;
    }

    public boolean canFix(CompilationUnit compilationUnit, IProblemLocation problem) throws CoreException {
        return false;
    }
}

