/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.fix;

import com.ibm.icu.text.MessageFormat;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.wst.jsdt.core.ICompilationUnit;
import org.eclipse.wst.jsdt.core.dom.CompilationUnit;
import org.eclipse.wst.jsdt.internal.corext.fix.IFix;
import org.eclipse.wst.jsdt.internal.corext.fix.SortMembersFix;
import org.eclipse.wst.jsdt.internal.ui.fix.AbstractCleanUp;
import org.eclipse.wst.jsdt.internal.ui.fix.MultiFixMessages;
import org.eclipse.wst.jsdt.ui.text.java.IProblemLocation;

public class SortMembersCleanUp
extends AbstractCleanUp {
    private HashSet fTouchedFiles;

    public SortMembersCleanUp() {
    }

    public SortMembersCleanUp(Map options) {
        super(options);
    }

    public IFix createFix(CompilationUnit compilationUnit) throws CoreException {
        boolean sortMembers;
        if (compilationUnit == null) {
            return null;
        }
        IFix fix = SortMembersFix.createCleanUp(compilationUnit, sortMembers, (sortMembers = this.isEnabled("cleanup.sort_members")) && this.isEnabled("cleanup.sort_members_all"));
        if (fix != null) {
            if (this.fTouchedFiles == null) {
                this.fTouchedFiles = new HashSet();
            }
            this.fTouchedFiles.add(((ICompilationUnit)compilationUnit.getJavaElement()).getResource());
        }
        return fix;
    }

    public RefactoringStatus checkPostConditions(IProgressMonitor monitor) throws CoreException {
        RefactoringStatus refactoringStatus;
        if (this.fTouchedFiles == null) {
            return super.checkPostConditions(monitor);
        }
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        monitor.beginTask("", this.fTouchedFiles.size());
        try {
            RefactoringStatus result = new RefactoringStatus();
            Iterator iterator = this.fTouchedFiles.iterator();
            while (iterator.hasNext()) {
                IFile file = (IFile)iterator.next();
                if (SortMembersCleanUp.containsRelevantMarkers(file)) {
                    String fileLocation = file.getProjectRelativePath().toOSString();
                    String projectName = file.getProject().getName();
                    result.addWarning(MessageFormat.format((String)MultiFixMessages.SortMembersCleanUp_RemoveMarkersWarning0, (Object[])new Object[]{fileLocation, projectName}));
                }
                monitor.worked(1);
            }
            refactoringStatus = result;
            Object var7_8 = null;
        }
        catch (Throwable throwable) {
            Object var7_9 = null;
            monitor.done();
            this.fTouchedFiles = null;
            throw throwable;
        }
        monitor.done();
        this.fTouchedFiles = null;
        return refactoringStatus;
    }

    public IFix createFix(CompilationUnit compilationUnit, IProblemLocation[] problems) throws CoreException {
        return null;
    }

    public Map getRequiredOptions() {
        return null;
    }

    public String[] getDescriptions() {
        if (this.isEnabled("cleanup.sort_members")) {
            if (this.isEnabled("cleanup.sort_members_all")) {
                return new String[]{MultiFixMessages.SortMembersCleanUp_AllMembers_description};
            }
            return new String[]{MultiFixMessages.SortMembersCleanUp_Excluding_description};
        }
        return null;
    }

    public String getPreview() {
        StringBuffer buf = new StringBuffer();
        buf.append("class SortExample {\n");
        if (this.isEnabled("cleanup.sort_members") && this.isEnabled("cleanup.sort_members_all")) {
            buf.append("  private String bar;\n");
            buf.append("  private String foo;\n");
        } else {
            buf.append("  private String foo;\n");
            buf.append("  private String bar;\n");
        }
        if (this.isEnabled("cleanup.sort_members")) {
            buf.append("  private void bar() {}\n");
            buf.append("  private void foo() {}\n");
        } else {
            buf.append("  private void foo() {}\n");
            buf.append("  private void bar() {}\n");
        }
        buf.append("}\n");
        return buf.toString();
    }

    public int maximalNumberOfFixes(CompilationUnit compilationUnit) {
        return -1;
    }

    public boolean canFix(CompilationUnit compilationUnit, IProblemLocation problem) throws CoreException {
        return false;
    }

    public boolean requireAST(ICompilationUnit unit) throws CoreException {
        return this.isEnabled("cleanup.sort_members");
    }

    private static boolean containsRelevantMarkers(IFile file) throws CoreException {
        IMarker[] bookmarks = file.findMarkers("org.eclipse.core.resources.bookmark", true, 2);
        if (bookmarks.length != 0) {
            return true;
        }
        IMarker[] tasks = file.findMarkers("org.eclipse.core.resources.taskmarker", true, 2);
        if (tasks.length != 0) {
            return true;
        }
        IMarker[] breakpoints = file.findMarkers(IBreakpoint.BREAKPOINT_MARKER, true, 2);
        return breakpoints.length != 0;
    }
}

