/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.javaeditor;

import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.ui.IElementFactory;
import org.eclipse.ui.IMemento;
import org.eclipse.wst.jsdt.core.IClassFile;
import org.eclipse.wst.jsdt.core.IJavaElement;
import org.eclipse.wst.jsdt.core.IJavaProject;
import org.eclipse.wst.jsdt.core.IType;
import org.eclipse.wst.jsdt.core.JavaCore;
import org.eclipse.wst.jsdt.core.JavaModelException;
import org.eclipse.wst.jsdt.internal.corext.util.JavaModelUtil;
import org.eclipse.wst.jsdt.internal.ui.javaeditor.EditorUtility;
import org.eclipse.wst.jsdt.internal.ui.javaeditor.InternalClassFileEditorInput;

public class ClassFileEditorInputFactory
implements IElementFactory {
    public static final String ID = "org.eclipse.wst.jsdt.ui.ClassFileEditorInputFactory";
    public static final String KEY = "org.eclipse.wst.jsdt.ui.ClassFileIdentifier";

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public IAdaptable createElement(IMemento memento) {
        IType type;
        IJavaElement element;
        block4: {
            String identifier = memento.getString(KEY);
            if (identifier == null) {
                return null;
            }
            element = JavaCore.create((String)identifier);
            try {
                if (element.exists() || !(element instanceof IClassFile)) return EditorUtility.getEditorInput((Object)element);
                IClassFile cf = (IClassFile)element;
                type = cf.getType();
                IJavaProject project = element.getJavaProject();
                if (project == null) return EditorUtility.getEditorInput((Object)element);
                if ((type = JavaModelUtil.findType(project, type.getFullyQualifiedName())) != null) break block4;
                return null;
            }
            catch (JavaModelException javaModelException) {
                return null;
            }
        }
        element = type.getParent();
        return EditorUtility.getEditorInput((Object)element);
    }

    public static void saveState(IMemento memento, InternalClassFileEditorInput input) {
        IClassFile c = input.getClassFile();
        memento.putString(KEY, c.getHandleIdentifier());
    }
}

