/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.javaeditor;

import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IMarkerDelta;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.ui.texteditor.AbstractMarkerAnnotationModel;
import org.eclipse.ui.texteditor.MarkerAnnotation;
import org.eclipse.wst.jsdt.core.IClassFile;
import org.eclipse.wst.jsdt.core.IJavaElement;
import org.eclipse.wst.jsdt.core.JavaCore;
import org.eclipse.wst.jsdt.internal.ui.javaeditor.JavaEditorMessages;
import org.eclipse.wst.jsdt.internal.ui.javaeditor.JavaMarkerAnnotation;

public class ClassFileMarkerAnnotationModel
extends AbstractMarkerAnnotationModel
implements IResourceChangeListener {
    protected IClassFile fClassFile;
    protected IWorkspace fWorkspace;
    protected IResource fMarkerResource;
    protected boolean fChangesApplied;

    public ClassFileMarkerAnnotationModel(IResource markerResource) {
        this.fMarkerResource = markerResource;
        this.fWorkspace = this.fMarkerResource.getWorkspace();
    }

    public void setClassFile(IClassFile classFile) {
        this.fClassFile = classFile;
    }

    protected boolean isAcceptable(IMarker marker) {
        try {
            return JavaCore.isReferencedBy((IJavaElement)this.fClassFile, (IMarker)marker);
        }
        catch (CoreException x) {
            this.handleCoreException(x, JavaEditorMessages.ClassFileMarkerAnnotationModel_error_isAcceptable);
            return false;
        }
    }

    protected boolean isAffected(IMarkerDelta markerDelta) {
        try {
            return JavaCore.isReferencedBy((IJavaElement)this.fClassFile, (IMarkerDelta)markerDelta);
        }
        catch (CoreException x) {
            this.handleCoreException(x, JavaEditorMessages.ClassFileMarkerAnnotationModel_error_isAffected);
            return false;
        }
    }

    protected MarkerAnnotation createMarkerAnnotation(IMarker marker) {
        return new JavaMarkerAnnotation(marker);
    }

    protected void listenToMarkerChanges(boolean listen) {
        if (listen) {
            this.fWorkspace.addResourceChangeListener((IResourceChangeListener)this);
        } else {
            this.fWorkspace.removeResourceChangeListener((IResourceChangeListener)this);
        }
    }

    protected void deleteMarkers(IMarker[] markers) throws CoreException {
    }

    protected IMarker[] retrieveMarkers() throws CoreException {
        if (this.fMarkerResource != null) {
            IMarker[] workspaceMarkers = this.fWorkspace.getRoot().findMarkers("org.eclipse.core.resources.marker", true, 0);
            IMarker[] resourceMarkers = this.fMarkerResource.findMarkers("org.eclipse.core.resources.marker", true, 0);
            int workspaceMarkersLength = workspaceMarkers.length;
            if (workspaceMarkersLength == 0) {
                return resourceMarkers;
            }
            int resourceMarkersLength = resourceMarkers.length;
            if (resourceMarkersLength == 0) {
                return workspaceMarkers;
            }
            IMarker[] result = new IMarker[resourceMarkersLength + workspaceMarkersLength];
            System.arraycopy(resourceMarkers, 0, result, 0, resourceMarkersLength);
            System.arraycopy(workspaceMarkers, 0, result, resourceMarkersLength, workspaceMarkersLength);
            return result;
        }
        return null;
    }

    private void checkDeltas(IMarkerDelta[] markerDeltas) throws CoreException {
        int i = 0;
        while (i < markerDeltas.length) {
            if (this.isAffected(markerDeltas[i])) {
                IMarker marker = markerDeltas[i].getMarker();
                switch (markerDeltas[i].getKind()) {
                    case 1: {
                        this.addMarkerAnnotation(marker);
                        this.fChangesApplied = true;
                        break;
                    }
                    case 2: {
                        this.removeMarkerAnnotation(marker);
                        this.fChangesApplied = true;
                        break;
                    }
                    case 4: {
                        this.modifyMarkerAnnotation(marker);
                        this.fChangesApplied = true;
                    }
                }
            }
            ++i;
        }
    }

    public void resourceChanged(IResourceChangeEvent e) {
        try {
            IMarkerDelta[] deltas = e.findMarkerDeltas(null, true);
            if (deltas != null) {
                this.fChangesApplied = false;
                this.checkDeltas(deltas);
                if (this.fChangesApplied) {
                    this.fireModelChanged();
                }
            }
        }
        catch (CoreException x) {
            this.handleCoreException(x, JavaEditorMessages.ClassFileMarkerAnnotationModel_error_resourceChanged);
        }
    }
}

