/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.model;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.mapping.ModelProvider;
import org.eclipse.core.runtime.Assert;
import org.eclipse.ltk.ui.refactoring.model.AbstractResourceMappingMerger;
import org.eclipse.wst.jsdt.core.IJavaModel;
import org.eclipse.wst.jsdt.core.IJavaProject;
import org.eclipse.wst.jsdt.core.JavaCore;
import org.eclipse.wst.jsdt.core.JavaModelException;
import org.eclipse.wst.jsdt.internal.ui.JavaPlugin;

public final class JavaModelMerger
extends AbstractResourceMappingMerger {
    public JavaModelMerger(ModelProvider provider) {
        super(provider);
    }

    protected IProject[] getDependencies(IProject[] projects) {
        Assert.isNotNull((Object)projects);
        HashSet set = new HashSet();
        int index = 0;
        while (index < projects.length) {
            this.getDependentProjects(set, projects[index]);
            ++index;
        }
        IProject[] result = new IProject[set.size()];
        set.toArray(result);
        return result;
    }

    private void getDependentProjects(Set set, IProject project) {
        Assert.isNotNull((Object)set);
        Assert.isNotNull((Object)project);
        IJavaModel model = JavaCore.create((IWorkspaceRoot)ResourcesPlugin.getWorkspace().getRoot());
        if (model != null) {
            try {
                String name = project.getName();
                IJavaProject[] projects = model.getJavaProjects();
                int index = 0;
                while (index < projects.length) {
                    String[] names = projects[index].getRequiredProjectNames();
                    int offset = 0;
                    while (offset < names.length) {
                        if (name.equals(names[offset])) {
                            set.add(projects[index].getProject());
                        }
                        ++offset;
                    }
                    ++index;
                }
            }
            catch (JavaModelException exception) {
                JavaPlugin.log(exception);
            }
        }
    }
}

