/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.packageview;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.wst.jsdt.core.ElementChangedEvent;
import org.eclipse.wst.jsdt.core.IClassFile;
import org.eclipse.wst.jsdt.core.IClasspathEntry;
import org.eclipse.wst.jsdt.core.ICompilationUnit;
import org.eclipse.wst.jsdt.core.IElementChangedListener;
import org.eclipse.wst.jsdt.core.IJavaElement;
import org.eclipse.wst.jsdt.core.IJavaElementDelta;
import org.eclipse.wst.jsdt.core.IJavaModel;
import org.eclipse.wst.jsdt.core.IJavaProject;
import org.eclipse.wst.jsdt.core.IPackageFragment;
import org.eclipse.wst.jsdt.core.IPackageFragmentRoot;
import org.eclipse.wst.jsdt.core.JavaCore;
import org.eclipse.wst.jsdt.core.JavaModelException;
import org.eclipse.wst.jsdt.internal.corext.util.JavaModelUtil;
import org.eclipse.wst.jsdt.internal.ui.JavaPlugin;
import org.eclipse.wst.jsdt.internal.ui.navigator.ContainerFolder;
import org.eclipse.wst.jsdt.internal.ui.packageview.ClassPathContainer;
import org.eclipse.wst.jsdt.internal.ui.packageview.LibraryContainer;
import org.eclipse.wst.jsdt.internal.ui.packageview.PackageFragmentRootContainer;
import org.eclipse.wst.jsdt.internal.ui.workingsets.WorkingSetModel;
import org.eclipse.wst.jsdt.ui.PreferenceConstants;
import org.eclipse.wst.jsdt.ui.StandardJavaElementContentProvider;

public class PackageExplorerContentProvider
extends StandardJavaElementContentProvider
implements ITreeContentProvider,
IElementChangedListener,
IPropertyChangeListener {
    protected static final int ORIGINAL = 0;
    protected static final int PARENT = 1;
    protected static final int GRANT_PARENT = 2;
    protected static final int PROJECT = 4;
    private TreeViewer fViewer;
    private Object fInput;
    private boolean fIsFlatLayout = false;
    private boolean fShowLibrariesNode = false;
    private boolean fFoldPackages = this.arePackagesFoldedInHierarchicalLayout();
    private Collection fPendingUpdates = null;

    public PackageExplorerContentProvider(boolean provideMembers) {
        super(provideMembers);
        JavaPlugin.getDefault().getPreferenceStore().addPropertyChangeListener((IPropertyChangeListener)this);
    }

    private boolean arePackagesFoldedInHierarchicalLayout() {
        return PreferenceConstants.getPreferenceStore().getBoolean("org.eclipse.wst.jsdt.ui.flatPackagesInPackageExplorer");
    }

    protected Object getViewerInput() {
        return this.fInput;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void elementChanged(ElementChangedEvent event) {
        ArrayList runnables = new ArrayList();
        try {
            try {
                if (this.inputDeleted(runnables)) {
                    Object var4_3 = null;
                    this.executeRunnables(runnables);
                    return;
                }
                this.processDelta(event.getDelta(), runnables);
            }
            catch (JavaModelException e) {
                JavaPlugin.log(e);
            }
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.executeRunnables(runnables);
            throw throwable;
        }
        {
            Object var4_5 = null;
            this.executeRunnables(runnables);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void executeRunnables(Collection runnables) {
        Control ctrl = this.fViewer.getControl();
        if (ctrl != null && !ctrl.isDisposed()) {
            if (ctrl.getDisplay().getThread() == Thread.currentThread()) {
                this.runUpdates(runnables);
            } else {
                PackageExplorerContentProvider packageExplorerContentProvider = this;
                synchronized (packageExplorerContentProvider) {
                    if (this.fPendingUpdates == null) {
                        this.fPendingUpdates = runnables;
                    } else {
                        this.fPendingUpdates.addAll(runnables);
                    }
                }
                ctrl.getDisplay().asyncExec(new Runnable(){

                    public void run() {
                        PackageExplorerContentProvider.this.runPendingUpdates();
                    }
                });
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runPendingUpdates() {
        Control control;
        Collection pendingUpdates;
        PackageExplorerContentProvider packageExplorerContentProvider = this;
        synchronized (packageExplorerContentProvider) {
            pendingUpdates = this.fPendingUpdates;
            this.fPendingUpdates = null;
        }
        if (pendingUpdates != null && this.fViewer != null && (control = this.fViewer.getControl()) != null && !control.isDisposed()) {
            this.runUpdates(pendingUpdates);
        }
    }

    private void runUpdates(Collection runnables) {
        Iterator runnableIterator = runnables.iterator();
        while (runnableIterator.hasNext()) {
            ((Runnable)runnableIterator.next()).run();
        }
    }

    private boolean inputDeleted(Collection runnables) {
        if (this.fInput == null) {
            return false;
        }
        if (this.fInput instanceof IJavaElement && ((IJavaElement)this.fInput).exists()) {
            return false;
        }
        if (this.fInput instanceof IResource && ((IResource)this.fInput).exists()) {
            return false;
        }
        if (this.fInput instanceof WorkingSetModel) {
            return false;
        }
        if (this.fInput instanceof IWorkingSet) {
            return false;
        }
        this.postRefresh(this.fInput, 0, this.fInput, runnables);
        return true;
    }

    public void dispose() {
        super.dispose();
        JavaCore.removeElementChangedListener((IElementChangedListener)this);
        JavaPlugin.getDefault().getPreferenceStore().removePropertyChangeListener((IPropertyChangeListener)this);
    }

    protected Object[] getPackageFragmentRootContent(IPackageFragmentRoot root) throws JavaModelException {
        if (this.fIsFlatLayout) {
            return super.getPackageFragmentRootContent(root);
        }
        ArrayList<Object> result = new ArrayList<Object>();
        this.getHierarchicalPackageChildren(root, null, result);
        if (!this.isProjectPackageFragmentRoot(root)) {
            Object[] nonJavaResources = root.getNonJavaResources();
            int i = 0;
            while (i < nonJavaResources.length) {
                result.add(nonJavaResources[i]);
                ++i;
            }
        }
        return result.toArray();
    }

    protected Object[] getPackageContent(IPackageFragment fragment) throws JavaModelException {
        if (this.fIsFlatLayout) {
            return super.getPackageContent(fragment);
        }
        ArrayList<Object> result = new ArrayList<Object>();
        this.getHierarchicalPackageChildren((IPackageFragmentRoot)fragment.getParent(), fragment, result);
        Object[] nonPackages = super.getPackageContent(fragment);
        if (result.isEmpty()) {
            return nonPackages;
        }
        int i = 0;
        while (i < nonPackages.length) {
            result.add(nonPackages[i]);
            ++i;
        }
        return result.toArray();
    }

    protected Object[] getFolderContent(IFolder folder) throws CoreException {
        if (this.fIsFlatLayout) {
            return super.getFolderContent(folder);
        }
        ArrayList<Object> result = new ArrayList<Object>();
        this.getHierarchicalPackagesInFolder(folder, result);
        Object[] others = super.getFolderContent(folder);
        if (result.isEmpty()) {
            return others;
        }
        int i = 0;
        while (i < others.length) {
            result.add(others[i]);
            ++i;
        }
        return result.toArray();
    }

    public Object[] getChildren(Object parentElement) {
        try {
            if (parentElement instanceof IJavaModel) {
                return PackageExplorerContentProvider.concatenate(this.getJavaProjects((IJavaModel)parentElement), this.getNonJavaProjects((IJavaModel)parentElement));
            }
            if (parentElement instanceof ContainerFolder) {
                return this.getContainerPackageFragmentRoots((PackageFragmentRootContainer)((ContainerFolder)parentElement).getParentObject());
            }
            if (parentElement instanceof PackageFragmentRootContainer) {
                return this.getContainerPackageFragmentRoots((PackageFragmentRootContainer)parentElement, true);
            }
            if (parentElement instanceof IProject) {
                return ((IProject)parentElement).members();
            }
            if (parentElement instanceof IPackageFragmentRoot && ((IPackageFragmentRoot)parentElement).isVirtual()) {
                return this.getLibraryChildren((IPackageFragmentRoot)parentElement);
            }
            return super.getChildren(parentElement);
        }
        catch (CoreException coreException) {
            return NO_CHILDREN;
        }
    }

    private Object[] getLibraryChildren(IPackageFragmentRoot container) {
        Object[] children = null;
        try {
            children = container.getChildren();
        }
        catch (JavaModelException ex1) {
            ex1.printStackTrace();
        }
        if (children == null) {
            return null;
        }
        ArrayList<Object> allChildren = new ArrayList<Object>();
        boolean unique = false;
        try {
            while (!unique && children != null && children.length > 0) {
                int i = 0;
                while (i < children.length) {
                    String display2;
                    String display1 = ((IJavaElement)children[0]).getDisplayName();
                    if (display1 != (display2 = ((IJavaElement)children[i]).getDisplayName()) && (display1 == null || display1.compareTo(display2) != 0)) {
                        allChildren.addAll(Arrays.asList(children));
                        unique = true;
                        break;
                    }
                    ++i;
                }
                ArrayList<IJavaElement> more = new ArrayList<IJavaElement>();
                int i2 = 0;
                while (!unique && i2 < children.length) {
                    if (children[i2] instanceof IPackageFragment) {
                        more.addAll(Arrays.asList(((IPackageFragment)children[i2]).getChildren()));
                    } else if (children[i2] instanceof IPackageFragmentRoot) {
                        more.addAll(Arrays.asList(((IPackageFragmentRoot)children[i2]).getChildren()));
                    } else if (children[i2] instanceof IClassFile) {
                        more.addAll(Arrays.asList(this.filter(((IClassFile)children[i2]).getChildren())));
                    } else if (children[i2] instanceof ICompilationUnit) {
                        more.addAll(Arrays.asList(this.filter(((ICompilationUnit)children[i2]).getChildren())));
                    } else {
                        unique = true;
                        break;
                    }
                    ++i2;
                }
                if (unique) continue;
                children = more.toArray();
            }
        }
        catch (JavaModelException ex) {
            ex.printStackTrace();
        }
        return allChildren.toArray();
    }

    protected Object[] getPackageFragmentRoots(IJavaProject project) throws JavaModelException {
        IClasspathEntry classpathEntry;
        if (!project.getProject().isOpen()) {
            return NO_CHILDREN;
        }
        ArrayList<Object> result = new ArrayList<Object>();
        boolean addJARContainer = false;
        IPackageFragmentRoot[] roots = project.getPackageFragmentRoots();
        int i = 0;
        while (i < roots.length) {
            IPackageFragmentRoot root = roots[i];
            classpathEntry = root.getRawClasspathEntry();
            int entryKind = classpathEntry.getEntryKind();
            if (entryKind != 5) {
                if (this.fShowLibrariesNode && (entryKind == 1 || entryKind == 4)) {
                    addJARContainer = true;
                } else if (this.isProjectPackageFragmentRoot(root)) {
                    Object[] fragments = this.getPackageFragmentRootContent(root);
                    int j = 0;
                    while (j < fragments.length) {
                        result.add(fragments[j]);
                        ++j;
                    }
                } else {
                    result.add(root);
                }
            }
            ++i;
        }
        if (addJARContainer) {
            result.add(new LibraryContainer(project));
        }
        IClasspathEntry[] rawClasspath = project.getRawClasspath();
        int i2 = 0;
        while (i2 < rawClasspath.length) {
            classpathEntry = rawClasspath[i2];
            if (classpathEntry.getEntryKind() == 5) {
                result.add(new ClassPathContainer(project, classpathEntry));
            }
            ++i2;
        }
        Object[] resources = project.getNonJavaResources();
        int i3 = 0;
        while (i3 < resources.length) {
            result.add(resources[i3]);
            ++i3;
        }
        return result.toArray();
    }

    private Object[] getContainerPackageFragmentRoots(PackageFragmentRootContainer container) {
        return this.getContainerPackageFragmentRoots(container, false);
    }

    private Object[] getContainerPackageFragmentRoots(PackageFragmentRootContainer container, boolean createFolder) {
        if (container != null) {
            Object[] children = container.getChildren();
            if (children == null) {
                return null;
            }
            ArrayList<IAdaptable> allChildren = new ArrayList<IAdaptable>();
            boolean unique = false;
            while (!unique && children != null && children.length > 0) {
                String display1 = null;
                int i = 0;
                while (i < children.length) {
                    String display2;
                    display1 = ((IJavaElement)children[0]).getDisplayName();
                    if (display1 != (display2 = ((IJavaElement)children[i]).getDisplayName()) && (display1 == null || display1.compareTo(display2) != 0)) {
                        allChildren.addAll(Arrays.asList(children));
                        unique = true;
                        break;
                    }
                    ++i;
                }
                if (!unique && createFolder) {
                    ContainerFolder folder = new ContainerFolder(display1, container);
                    return new Object[]{folder};
                }
                ArrayList<IJavaElement> more = new ArrayList<IJavaElement>();
                int i2 = 0;
                while (!unique && i2 < children.length) {
                    block17: {
                        try {
                            if (children[i2] instanceof IPackageFragment) {
                                more.addAll(Arrays.asList(((IPackageFragment)children[i2]).getChildren()));
                                break block17;
                            }
                            if (children[i2] instanceof IPackageFragmentRoot) {
                                more.addAll(Arrays.asList(((IPackageFragmentRoot)children[i2]).getChildren()));
                                break block17;
                            }
                            if (children[i2] instanceof IClassFile) {
                                more.addAll(Arrays.asList(this.filter(((IClassFile)children[i2]).getChildren())));
                                break block17;
                            }
                            if (children[i2] instanceof ICompilationUnit) {
                                more.addAll(Arrays.asList(this.filter(((ICompilationUnit)children[i2]).getChildren())));
                                break block17;
                            }
                            unique = true;
                            break;
                        }
                        catch (JavaModelException ex) {
                            ex.printStackTrace();
                        }
                    }
                    ++i2;
                }
                if (unique) continue;
                children = more.toArray();
            }
            return allChildren.toArray();
        }
        IAdaptable[] children = container.getChildren();
        if (children == null) {
            return null;
        }
        ArrayList<IJavaElement> allChildren = new ArrayList<IJavaElement>();
        int i = 0;
        while (i < children.length) {
            try {
                allChildren.addAll(Arrays.asList(((IPackageFragmentRoot)children[i]).getChildren()));
            }
            catch (JavaModelException javaModelException) {}
            ++i;
        }
        return allChildren.toArray();
    }

    private Object[] getNonJavaProjects(IJavaModel model) throws JavaModelException {
        return model.getNonJavaResources();
    }

    protected Object internalGetParent(Object element) {
        if (!this.fIsFlatLayout && element instanceof IPackageFragment) {
            return this.getHierarchicalPackageParent((IPackageFragment)element);
        }
        if (element instanceof IPackageFragmentRoot) {
            IPackageFragmentRoot root = (IPackageFragmentRoot)element;
            try {
                IClasspathEntry entry = root.getRawClasspathEntry();
                int entryKind = entry.getEntryKind();
                if (entryKind == 5) {
                    return new ClassPathContainer(root.getJavaProject(), entry);
                }
                if (this.fShowLibrariesNode && (entryKind == 1 || entryKind == 4)) {
                    return new LibraryContainer(root.getJavaProject());
                }
            }
            catch (JavaModelException javaModelException) {}
        } else if (element instanceof PackageFragmentRootContainer) {
            return ((PackageFragmentRootContainer)element).getJavaProject();
        }
        return super.internalGetParent(element);
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        super.inputChanged(viewer, oldInput, newInput);
        this.fViewer = (TreeViewer)viewer;
        if (oldInput == null && newInput != null) {
            JavaCore.addElementChangedListener((IElementChangedListener)this);
        } else if (oldInput != null && newInput == null) {
            JavaCore.removeElementChangedListener((IElementChangedListener)this);
        }
        this.fInput = newInput;
    }

    private void getHierarchicalPackageChildren(IPackageFragmentRoot parent, IPackageFragment fragment, Collection result) throws JavaModelException {
        String prefix;
        IJavaElement[] children = parent.getChildren();
        String string = prefix = fragment != null ? String.valueOf(fragment.getElementName()) + '/' : "";
        if (prefix.length() == 1) {
            prefix = "";
        }
        int prefixLen = prefix.length();
        int i = 0;
        while (i < children.length) {
            IPackageFragment curr = (IPackageFragment)children[i];
            if (fragment == null) {
                if (curr.isDefaultPackage()) {
                    result.add(curr);
                }
            } else {
                String name = curr.getElementName();
                if (name.startsWith(prefix) && name.length() > prefixLen && name.indexOf(47, prefixLen) == -1) {
                    if (this.fFoldPackages) {
                        curr = PackageExplorerContentProvider.getFolded(children, curr);
                    }
                    result.add(curr);
                }
            }
            ++i;
        }
    }

    private void getHierarchicalPackagesInFolder(IFolder folder, Collection result) throws CoreException {
        IResource[] resources = folder.members();
        int i = 0;
        while (i < resources.length) {
            IFolder curr;
            IJavaElement element;
            IResource resource = resources[i];
            if (resource instanceof IFolder && (element = JavaCore.create((IFolder)(curr = (IFolder)resource))) instanceof IPackageFragment) {
                if (this.fFoldPackages) {
                    IPackageFragment fragment = (IPackageFragment)element;
                    IPackageFragmentRoot root = (IPackageFragmentRoot)fragment.getParent();
                    element = PackageExplorerContentProvider.getFolded(root.getChildren(), fragment);
                }
                result.add(element);
            }
            ++i;
        }
    }

    public Object getHierarchicalPackageParent(IPackageFragment child) {
        String name = child.getElementName();
        IPackageFragmentRoot parent = (IPackageFragmentRoot)child.getParent();
        int index = name.lastIndexOf(47);
        if (index != -1) {
            String realParentName = name.substring(0, index);
            IPackageFragment element = parent.getPackageFragment(realParentName);
            if (element.exists()) {
                try {
                    if (this.fFoldPackages && PackageExplorerContentProvider.isEmpty(element) && PackageExplorerContentProvider.findSinglePackageChild(element, parent.getChildren()) != null) {
                        return this.getHierarchicalPackageParent(element);
                    }
                }
                catch (JavaModelException javaModelException) {}
                return element;
            }
            IResource resource = element.getResource();
            if (resource != null) {
                return resource;
            }
        }
        if (parent.getResource() instanceof IProject) {
            return parent.getJavaProject();
        }
        return parent;
    }

    private static IPackageFragment getFolded(IJavaElement[] children, IPackageFragment pack) throws JavaModelException {
        while (PackageExplorerContentProvider.isEmpty(pack)) {
            IPackageFragment collapsed = PackageExplorerContentProvider.findSinglePackageChild(pack, children);
            if (collapsed == null) {
                return pack;
            }
            pack = collapsed;
        }
        return pack;
    }

    private static boolean isEmpty(IPackageFragment fragment) throws JavaModelException {
        return !fragment.containsJavaResources() && fragment.getNonJavaResources().length == 0;
    }

    private static IPackageFragment findSinglePackageChild(IPackageFragment fragment, IJavaElement[] children) {
        String prefix = String.valueOf(fragment.getElementName()) + '/';
        int prefixLen = prefix.length();
        IPackageFragment found = null;
        int i = 0;
        while (i < children.length) {
            IJavaElement element = children[i];
            String name = element.getElementName();
            if (name.startsWith(prefix) && name.length() > prefixLen && name.indexOf(47, prefixLen) == -1) {
                if (found == null) {
                    found = (IPackageFragment)element;
                } else {
                    return null;
                }
            }
            ++i;
        }
        return found;
    }

    private boolean processDelta(IJavaElementDelta delta, Collection runnables) throws JavaModelException {
        Object parent;
        IJavaProject proj;
        int kind = delta.getKind();
        int flags = delta.getFlags();
        IJavaElement element = delta.getElement();
        int elementType = element.getElementType();
        if (!(elementType == 1 || elementType == 2 || (proj = element.getJavaProject()) != null && proj.getProject().isOpen())) {
            return false;
        }
        if (!this.fIsFlatLayout && elementType == 4) {
            if (kind == 2) {
                parent = this.getHierarchicalPackageParent((IPackageFragment)element);
                if (parent instanceof IPackageFragmentRoot) {
                    this.postRemove(element, runnables);
                    return false;
                }
                this.postRefresh(this.internalGetParent(parent), 2, element, runnables);
                return true;
            }
            if (kind == 1) {
                parent = this.getHierarchicalPackageParent((IPackageFragment)element);
                if (parent instanceof IPackageFragmentRoot) {
                    this.postAdd(parent, element, runnables);
                    return false;
                }
                this.postRefresh(this.internalGetParent(parent), 2, element, runnables);
                return true;
            }
            this.handleAffectedChildren(delta, element, runnables);
            return false;
        }
        if (elementType == 5) {
            ICompilationUnit cu = (ICompilationUnit)element;
            if (!JavaModelUtil.isPrimary(cu)) {
                return false;
            }
            if (!this.getProvideMembers() && cu.isWorkingCopy() && kind == 4) {
                return false;
            }
            if (kind == 4 && !PackageExplorerContentProvider.isStructuralCUChange(flags)) {
                return false;
            }
            if (!this.isOnClassPath(cu)) {
                return false;
            }
        }
        if (elementType == 2) {
            if ((flags & 0x600) != 0) {
                this.postRefresh(element, 0, element, runnables);
                return false;
            }
            if ((flags & 0x20000) != 0) {
                this.postRefresh(element, 0, element, runnables);
                return false;
            }
            if (kind == 1) {
                this.postRemove(element.getResource(), runnables);
                this.postAdd(element.getParent(), element, runnables);
                return false;
            }
        }
        if (kind == 2) {
            parent = this.internalGetParent(element);
            if (element instanceof IPackageFragment) {
                if (this.fViewer.testFindItem(parent) != null) {
                    this.postRefresh(parent, 1, element, runnables);
                }
                return true;
            }
            this.postRemove(element, runnables);
            if (parent instanceof IPackageFragment) {
                this.postUpdateIcon((IJavaElement)((IPackageFragment)parent), runnables);
            }
            if (this.isPackageFragmentEmpty(element.getParent())) {
                if (this.fViewer.testFindItem(parent) != null) {
                    this.postRefresh(this.internalGetParent(parent), 2, element, runnables);
                }
                return true;
            }
            return false;
        }
        if (kind == 1) {
            parent = this.internalGetParent(element);
            if (parent instanceof IPackageFragment) {
                Object grandparent = this.internalGetParent(parent);
                if (parent.equals(this.fInput)) {
                    this.postRefresh(parent, 1, element, runnables);
                } else if (this.fViewer.testFindItem(parent) == null) {
                    this.postRefresh(grandparent, 2, element, runnables);
                } else {
                    this.postRefresh(parent, 1, element, runnables);
                }
                return true;
            }
            this.postAdd(parent, element, runnables);
        }
        if (elementType == 5) {
            if (kind == 4) {
                this.postRefresh(element, 0, element, runnables);
                this.updateSelection(delta, runnables);
            }
            return false;
        }
        if (elementType == 6) {
            return false;
        }
        if (elementType == 3) {
            if ((flags & 0x8000) != 0) {
                this.postRefresh(element, 0, element, runnables);
                return false;
            }
            if ((flags & 0x3000) != 0) {
                this.postUpdateIcon(element, runnables);
            }
            if (this.isClassPathChange(delta)) {
                this.postRefresh(element.getJavaProject(), 4, element, runnables);
                return true;
            }
        }
        this.handleAffectedChildren(delta, element, runnables);
        return false;
    }

    private static boolean isStructuralCUChange(int flags) {
        return (flags & 8) != 0 || (flags & 0x4001) == 1;
    }

    void handleAffectedChildren(IJavaElementDelta delta, IJavaElement element, Collection runnables) throws JavaModelException {
        int count = 0;
        IResourceDelta[] resourceDeltas = delta.getResourceDeltas();
        if (resourceDeltas != null) {
            int i = 0;
            while (i < resourceDeltas.length) {
                int kind = resourceDeltas[i].getKind();
                if (kind == 1 || kind == 2) {
                    ++count;
                }
                ++i;
            }
        }
        IJavaElementDelta[] affectedChildren = delta.getAffectedChildren();
        int i = 0;
        while (i < affectedChildren.length) {
            int kind = affectedChildren[i].getKind();
            if (kind == 1 || kind == 2) {
                ++count;
            }
            ++i;
        }
        if (count > 1) {
            if (element instanceof IPackageFragment) {
                IJavaElement parent = (IJavaElement)this.internalGetParent(element);
                if (element.equals(this.fInput)) {
                    this.postRefresh(element, 0, element, runnables);
                } else {
                    this.postRefresh(parent, 1, element, runnables);
                }
            } else if (element instanceof IPackageFragmentRoot) {
                Object toRefresh = this.internalGetParent(element);
                this.postRefresh(toRefresh, 0, toRefresh, runnables);
            } else {
                this.postRefresh(element, 0, element, runnables);
            }
            return;
        }
        if (resourceDeltas != null) {
            i = 0;
            while (i < resourceDeltas.length) {
                if (this.processResourceDelta(resourceDeltas[i], element, runnables)) {
                    return;
                }
                ++i;
            }
        }
        i = 0;
        while (i < affectedChildren.length) {
            if (this.processDelta(affectedChildren[i], runnables)) {
                return;
            }
            ++i;
        }
    }

    protected void processAffectedChildren(IJavaElementDelta[] affectedChildren, Collection runnables) throws JavaModelException {
        int i = 0;
        while (i < affectedChildren.length) {
            this.processDelta(affectedChildren[i], runnables);
            ++i;
        }
    }

    private boolean isOnClassPath(ICompilationUnit element) {
        IJavaProject project = element.getJavaProject();
        if (project == null || !project.exists()) {
            return false;
        }
        return project.isOnClasspath((IJavaElement)element);
    }

    private void updateSelection(IJavaElementDelta delta, Collection runnables) {
        final IJavaElement addedElement = this.findAddedElement(delta);
        if (addedElement != null) {
            final StructuredSelection selection = new StructuredSelection((Object)addedElement);
            runnables.add(new Runnable(){

                public void run() {
                    if (PackageExplorerContentProvider.this.fViewer.testFindItem((Object)addedElement) != null) {
                        PackageExplorerContentProvider.this.fViewer.setSelection((ISelection)selection);
                    }
                }
            });
        }
    }

    private IJavaElement findAddedElement(IJavaElementDelta delta) {
        if (delta.getKind() == 1) {
            return delta.getElement();
        }
        int i = 0;
        IJavaElementDelta[] affectedChildren = delta.getAffectedChildren();
        if (i < affectedChildren.length) {
            return this.findAddedElement(affectedChildren[i]);
        }
        return null;
    }

    private void postUpdateIcon(final IJavaElement element, Collection runnables) {
        runnables.add(new Runnable(){

            public void run() {
                PackageExplorerContentProvider.this.fViewer.update((Object)element, new String[]{"org.eclipse.jface.image"});
            }
        });
    }

    private boolean processResourceDelta(IResourceDelta delta, Object parent, Collection runnables) {
        int status = delta.getKind();
        int flags = delta.getFlags();
        IResource resource = delta.getResource();
        if (resource == null) {
            return false;
        }
        if ((status & 2) != 0) {
            if (parent instanceof IPackageFragment) {
                this.postRefresh(this.internalGetParent(parent), 1, parent, runnables);
                return true;
            }
            this.postRemove(resource, runnables);
        }
        if ((status & 1) != 0) {
            if (parent instanceof IPackageFragment) {
                this.postRefresh(this.internalGetParent(parent), 1, parent, runnables);
                return true;
            }
            this.postAdd(parent, resource, runnables);
        }
        if ((flags & 0x4000) != 0) {
            this.postProjectStateChanged(this.internalGetParent(parent), runnables);
            return true;
        }
        IResourceDelta[] resourceDeltas = delta.getAffectedChildren();
        int i = 0;
        while (i < resourceDeltas.length) {
            if (this.processResourceDelta(resourceDeltas[i], resource, runnables)) {
                return false;
            }
            ++i;
        }
        return false;
    }

    public void setIsFlatLayout(boolean state) {
        this.fIsFlatLayout = state;
    }

    public void setShowLibrariesNode(boolean state) {
        this.fShowLibrariesNode = state;
    }

    private void postRefresh(Object root, int relation, Object affectedElement, Collection runnables) {
        if (this.isParent(root, this.fInput)) {
            root = this.fInput;
        }
        ArrayList<Object> toRefresh = new ArrayList<Object>(1);
        toRefresh.add(root);
        this.augmentElementToRefresh(toRefresh, relation, affectedElement);
        this.postRefresh(toRefresh, true, runnables);
    }

    protected void augmentElementToRefresh(List toRefresh, int relation, Object affectedElement) {
    }

    private boolean isParent(Object root, Object child) {
        Object parent = this.getParent(child);
        if (parent == null) {
            return false;
        }
        if (parent.equals(root)) {
            return true;
        }
        return this.isParent(root, parent);
    }

    protected void postRefresh(final List toRefresh, final boolean updateLabels, Collection runnables) {
        runnables.add(new Runnable(){

            public void run() {
                Iterator iter = toRefresh.iterator();
                while (iter.hasNext()) {
                    PackageExplorerContentProvider.this.fViewer.refresh(iter.next(), updateLabels);
                }
            }
        });
    }

    protected void postAdd(final Object parent, final Object element, Collection runnables) {
        runnables.add(new Runnable(){

            public void run() {
                if (PackageExplorerContentProvider.this.fViewer.testFindItem(element) == null) {
                    PackageExplorerContentProvider.this.fViewer.add(parent, element);
                }
            }
        });
    }

    protected void postRemove(final Object element, Collection runnables) {
        runnables.add(new Runnable(){

            public void run() {
                PackageExplorerContentProvider.this.fViewer.remove(element);
            }
        });
    }

    protected void postProjectStateChanged(final Object root, Collection runnables) {
        runnables.add(new Runnable(){

            public void run() {
                PackageExplorerContentProvider.this.fViewer.refresh(root, true);
                PackageExplorerContentProvider.this.fViewer.setSelection(PackageExplorerContentProvider.this.fViewer.getSelection());
            }
        });
    }

    public void propertyChange(PropertyChangeEvent event) {
        if (this.arePackagesFoldedInHierarchicalLayout() != this.fFoldPackages) {
            this.fFoldPackages = this.arePackagesFoldedInHierarchicalLayout();
            if (this.fViewer != null && !this.fViewer.getControl().isDisposed()) {
                this.fViewer.getControl().setRedraw(false);
                Object[] expandedObjects = this.fViewer.getExpandedElements();
                this.fViewer.refresh();
                this.fViewer.setExpandedElements(expandedObjects);
                this.fViewer.getControl().setRedraw(true);
            }
        }
    }
}

