/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.preferences.formatter;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.wst.jsdt.internal.ui.JavaPlugin;
import org.eclipse.wst.jsdt.internal.ui.preferences.PreferencesAccess;
import org.eclipse.wst.jsdt.internal.ui.preferences.formatter.FormatterProfileManager;
import org.eclipse.wst.jsdt.internal.ui.preferences.formatter.IProfileVersioner;
import org.eclipse.wst.jsdt.internal.ui.preferences.formatter.ProfileManager;
import org.eclipse.wst.jsdt.internal.ui.preferences.formatter.ProfileStore;
import org.eclipse.wst.jsdt.internal.ui.preferences.formatter.ProfileVersioner;
import org.osgi.service.prefs.BackingStoreException;
import org.xml.sax.InputSource;

public class FormatterProfileStore
extends ProfileStore {
    private static final String PREF_FORMATTER_PROFILES = "org.eclipse.wst.jsdt.ui.formatterprofiles";
    private final IProfileVersioner fProfileVersioner;

    public FormatterProfileStore(IProfileVersioner profileVersioner) {
        super(PREF_FORMATTER_PROFILES, profileVersioner);
        this.fProfileVersioner = profileVersioner;
    }

    public List readProfiles(IScopeContext scope) throws CoreException {
        List profiles = super.readProfiles(scope);
        if (profiles == null) {
            profiles = this.readOldForCompatibility(scope);
        }
        return profiles;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private List readOldForCompatibility(IScopeContext instanceScope) {
        File file = JavaPlugin.getDefault().getStateLocation().append("code_formatter_profiles.xml").toFile();
        if (!file.exists()) {
            return null;
        }
        try {
            List list;
            FileReader reader = new FileReader(file);
            try {
                List res = FormatterProfileStore.readProfilesFromStream(new InputSource(reader));
                if (res != null) {
                    int i = 0;
                    while (true) {
                        if (i >= res.size()) {
                            this.writeProfiles(res, instanceScope);
                            break;
                        }
                        this.fProfileVersioner.update((ProfileManager.CustomProfile)res.get(i));
                        ++i;
                    }
                }
                file.delete();
                list = res;
                Object var6_9 = null;
            }
            catch (Throwable throwable) {
                Object var6_10 = null;
                reader.close();
                throw throwable;
            }
            reader.close();
            return list;
        }
        catch (CoreException e) {
            JavaPlugin.log(e);
            return null;
        }
        catch (IOException e) {
            JavaPlugin.log(e);
        }
        return null;
    }

    public static void checkCurrentOptionsVersion() {
        PreferencesAccess access = PreferencesAccess.getOriginalPreferences();
        ProfileVersioner profileVersioner = new ProfileVersioner();
        IScopeContext instanceScope = access.getInstanceScope();
        IEclipsePreferences uiPreferences = instanceScope.getNode("org.eclipse.wst.jsdt.ui");
        int version = uiPreferences.getInt("org.eclipse.wst.jsdt.ui.formatterprofiles.version", 0);
        if (version >= profileVersioner.getCurrentVersion()) {
            return;
        }
        try {
            FormatterProfileManager manager;
            ArrayList profiles = new FormatterProfileStore(profileVersioner).readProfiles(instanceScope);
            if (profiles == null) {
                profiles = new ArrayList();
            }
            if ((manager = new FormatterProfileManager(profiles, instanceScope, access, profileVersioner)).getSelected() instanceof ProfileManager.CustomProfile) {
                manager.commitChanges(instanceScope);
            }
            uiPreferences.putInt("org.eclipse.wst.jsdt.ui.formatterprofiles.version", profileVersioner.getCurrentVersion());
            FormatterProfileStore.savePreferences(instanceScope);
            IProject[] projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
            int i = 0;
            while (i < projects.length) {
                IScopeContext scope = access.getProjectScope(projects[i]);
                if (manager.hasProjectSpecificSettings(scope)) {
                    manager = new FormatterProfileManager(profiles, scope, access, profileVersioner);
                    manager.commitChanges(scope);
                    FormatterProfileStore.savePreferences(scope);
                }
                ++i;
            }
        }
        catch (CoreException e) {
            JavaPlugin.log(e);
        }
        catch (BackingStoreException e) {
            JavaPlugin.log(e);
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void savePreferences(IScopeContext context) throws BackingStoreException {
        try {
            context.getNode("org.eclipse.wst.jsdt.ui").flush();
        }
        catch (Throwable throwable) {
            Object var1_2 = null;
            context.getNode("org.eclipse.wst.jsdt.core").flush();
            throw throwable;
        }
        {
            Object var1_3 = null;
        }
        context.getNode("org.eclipse.wst.jsdt.core").flush();
    }
}

