/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.propertiesfileeditor;

import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.hyperlink.IHyperlink;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.wst.jsdt.internal.ui.propertiesfileeditor.PropertiesFileEditor;
import org.eclipse.wst.jsdt.internal.ui.propertiesfileeditor.PropertiesFileEditorMessages;
import org.eclipse.wst.jsdt.internal.ui.propertiesfileeditor.PropertyKeyHyperlinkDetector;
import org.eclipse.wst.jsdt.ui.actions.SelectionDispatchAction;

public class OpenAction
extends SelectionDispatchAction {
    private PropertiesFileEditor fEditor;

    public OpenAction(PropertiesFileEditor editor) {
        super((IWorkbenchSite)editor.getEditorSite());
        this.fEditor = editor;
        this.setText(PropertiesFileEditorMessages.OpenAction_label);
        this.setToolTipText(PropertiesFileEditorMessages.OpenAction_tooltip);
        this.setEnabled(this.fEditor.getEditorInput() instanceof IFileEditorInput);
    }

    public void selectionChanged(ITextSelection selection) {
        this.setEnabled(this.checkEnabled(selection));
    }

    private boolean checkEnabled(ITextSelection selection) {
        if (selection == null || selection.isEmpty()) {
            return false;
        }
        return this.fEditor.getEditorInput() instanceof IFileEditorInput;
    }

    public void run(ITextSelection selection) {
        if (!this.checkEnabled(selection)) {
            return;
        }
        Region region = new Region(selection.getOffset(), selection.getLength());
        PropertyKeyHyperlinkDetector detector = new PropertyKeyHyperlinkDetector();
        detector.setContext((IAdaptable)this.fEditor);
        IHyperlink[] hyperlinks = detector.detectHyperlinks((ITextViewer)this.fEditor.internalGetSourceViewer(), (IRegion)region, false);
        if (hyperlinks != null && hyperlinks.length == 1) {
            hyperlinks[0].open();
        }
    }
}

