/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.refactoring.actions;

import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.jsdt.core.IJavaElement;
import org.eclipse.wst.jsdt.core.IMethod;
import org.eclipse.wst.jsdt.core.ISourceRange;
import org.eclipse.wst.jsdt.core.ISourceReference;
import org.eclipse.wst.jsdt.core.ITypeRoot;
import org.eclipse.wst.jsdt.core.JavaModelException;
import org.eclipse.wst.jsdt.core.dom.CompilationUnit;
import org.eclipse.wst.jsdt.internal.corext.refactoring.RefactoringAvailabilityTester;
import org.eclipse.wst.jsdt.internal.corext.refactoring.RefactoringExecutionStarter;
import org.eclipse.wst.jsdt.internal.corext.refactoring.util.JavaElementUtil;
import org.eclipse.wst.jsdt.internal.corext.refactoring.util.RefactoringASTParser;
import org.eclipse.wst.jsdt.internal.corext.util.JavaModelUtil;
import org.eclipse.wst.jsdt.internal.ui.JavaPlugin;
import org.eclipse.wst.jsdt.internal.ui.actions.ActionUtil;
import org.eclipse.wst.jsdt.internal.ui.actions.SelectionConverter;
import org.eclipse.wst.jsdt.internal.ui.javaeditor.JavaEditor;
import org.eclipse.wst.jsdt.internal.ui.javaeditor.JavaTextSelection;
import org.eclipse.wst.jsdt.internal.ui.refactoring.RefactoringMessages;
import org.eclipse.wst.jsdt.internal.ui.util.ExceptionHandler;
import org.eclipse.wst.jsdt.ui.actions.SelectionDispatchAction;

public class InlineMethodAction
extends SelectionDispatchAction {
    private JavaEditor fEditor;

    public InlineMethodAction(JavaEditor editor) {
        this((IWorkbenchSite)editor.getEditorSite());
        this.fEditor = editor;
        this.setEnabled(SelectionConverter.canOperateOn(this.fEditor));
    }

    public InlineMethodAction(IWorkbenchSite site) {
        super(site);
        this.setText(RefactoringMessages.InlineMethodAction_inline_Method);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, "org.eclipse.wst.jsdt.ui.inline_action");
    }

    public void selectionChanged(IStructuredSelection selection) {
        block2: {
            try {
                this.setEnabled(RefactoringAvailabilityTester.isInlineMethodAvailable(selection));
            }
            catch (JavaModelException e) {
                if (!JavaModelUtil.isExceptionToBeLogged((CoreException)((Object)e))) break block2;
                JavaPlugin.log(e);
            }
        }
    }

    public void run(IStructuredSelection selection) {
        try {
            Assert.isTrue((boolean)RefactoringAvailabilityTester.isInlineMethodAvailable(selection));
            IMethod method = (IMethod)selection.getFirstElement();
            ISourceRange nameRange = method.getNameRange();
            this.run(nameRange.getOffset(), nameRange.getLength(), method.getTypeRoot());
        }
        catch (JavaModelException e) {
            ExceptionHandler.handle((CoreException)((Object)e), this.getShell(), RefactoringMessages.InlineMethodAction_dialog_title, RefactoringMessages.InlineMethodAction_unexpected_exception);
        }
    }

    public void selectionChanged(ITextSelection selection) {
        this.setEnabled(true);
    }

    public void selectionChanged(JavaTextSelection selection) {
        try {
            this.setEnabled(RefactoringAvailabilityTester.isInlineMethodAvailable(selection));
        }
        catch (JavaModelException javaModelException) {
            this.setEnabled(false);
        }
    }

    public void run(ITextSelection selection) {
        ITypeRoot typeRoot = SelectionConverter.getInputAsTypeRoot(this.fEditor);
        if (typeRoot == null) {
            return;
        }
        if (!JavaElementUtil.isSourceAvailable((ISourceReference)typeRoot)) {
            return;
        }
        this.run(selection.getOffset(), selection.getLength(), typeRoot);
    }

    private void run(int offset, int length, ITypeRoot typeRoot) {
        if (!ActionUtil.isEditable(this.fEditor, this.getShell(), (IJavaElement)typeRoot)) {
            return;
        }
        try {
            CompilationUnit compilationUnit = RefactoringASTParser.parseWithASTProvider(typeRoot, true, null);
            if (!RefactoringExecutionStarter.startInlineMethodRefactoring(typeRoot, compilationUnit, offset, length, this.getShell())) {
                MessageDialog.openInformation((Shell)this.getShell(), (String)RefactoringMessages.InlineMethodAction_dialog_title, (String)RefactoringMessages.InlineMethodAction_no_method_invocation_or_declaration_selected);
            }
        }
        catch (JavaModelException e) {
            ExceptionHandler.handle((CoreException)((Object)e), this.getShell(), RefactoringMessages.InlineMethodAction_dialog_title, RefactoringMessages.InlineMethodAction_unexpected_exception);
        }
    }

    public boolean tryInlineMethod(ITypeRoot typeRoot, CompilationUnit node, ITextSelection selection, Shell shell) {
        try {
            if (RefactoringExecutionStarter.startInlineMethodRefactoring(typeRoot, node, selection.getOffset(), selection.getLength(), shell)) {
                return true;
            }
        }
        catch (JavaModelException exception) {
            JavaPlugin.log(exception);
        }
        return false;
    }
}

