/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.refactoring.actions;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.wst.jsdt.core.Flags;
import org.eclipse.wst.jsdt.core.ICompilationUnit;
import org.eclipse.wst.jsdt.core.IField;
import org.eclipse.wst.jsdt.core.IJavaElement;
import org.eclipse.wst.jsdt.core.IJavaProject;
import org.eclipse.wst.jsdt.core.ILocalVariable;
import org.eclipse.wst.jsdt.core.IMethod;
import org.eclipse.wst.jsdt.core.IPackageFragment;
import org.eclipse.wst.jsdt.core.IPackageFragmentRoot;
import org.eclipse.wst.jsdt.core.ITypeParameter;
import org.eclipse.wst.jsdt.core.JavaModelException;
import org.eclipse.wst.jsdt.internal.corext.refactoring.RefactoringAvailabilityTester;
import org.eclipse.wst.jsdt.internal.corext.refactoring.RefactoringExecutionStarter;
import org.eclipse.wst.jsdt.internal.corext.util.JavaModelUtil;
import org.eclipse.wst.jsdt.internal.ui.JavaPlugin;
import org.eclipse.wst.jsdt.internal.ui.actions.ActionUtil;
import org.eclipse.wst.jsdt.internal.ui.actions.SelectionConverter;
import org.eclipse.wst.jsdt.internal.ui.javaeditor.CompilationUnitEditor;
import org.eclipse.wst.jsdt.internal.ui.javaeditor.JavaEditor;
import org.eclipse.wst.jsdt.internal.ui.javaeditor.JavaTextSelection;
import org.eclipse.wst.jsdt.internal.ui.refactoring.RefactoringMessages;
import org.eclipse.wst.jsdt.internal.ui.refactoring.reorg.RenameLinkedMode;
import org.eclipse.wst.jsdt.internal.ui.util.ExceptionHandler;
import org.eclipse.wst.jsdt.ui.actions.SelectionDispatchAction;

public class RenameJavaElementAction
extends SelectionDispatchAction {
    private JavaEditor fEditor;

    public RenameJavaElementAction(IWorkbenchSite site) {
        super(site);
    }

    public RenameJavaElementAction(JavaEditor editor) {
        this((IWorkbenchSite)editor.getEditorSite());
        this.fEditor = editor;
        this.setEnabled(SelectionConverter.canOperateOn(this.fEditor));
    }

    public void selectionChanged(IStructuredSelection selection) {
        try {
            if (selection.size() == 1) {
                this.setEnabled(RenameJavaElementAction.canEnable(selection));
                return;
            }
        }
        catch (JavaModelException e) {
            if (JavaModelUtil.isExceptionToBeLogged((CoreException)((Object)e))) {
                JavaPlugin.log(e);
            }
        }
        catch (CoreException e) {
            JavaPlugin.log(e);
        }
        this.setEnabled(false);
    }

    private static boolean canEnable(IStructuredSelection selection) throws CoreException {
        IJavaElement element = RenameJavaElementAction.getJavaElement(selection);
        if (element == null) {
            return false;
        }
        return RenameJavaElementAction.isRenameAvailable(element);
    }

    private static IJavaElement getJavaElement(IStructuredSelection selection) {
        if (selection.size() != 1) {
            return null;
        }
        Object first = selection.getFirstElement();
        if (!(first instanceof IJavaElement)) {
            return null;
        }
        return (IJavaElement)first;
    }

    public void run(IStructuredSelection selection) {
        IJavaElement element = RenameJavaElementAction.getJavaElement(selection);
        if (element == null) {
            return;
        }
        try {
            this.run(element, false);
        }
        catch (CoreException e) {
            ExceptionHandler.handle(e, RefactoringMessages.RenameJavaElementAction_name, RefactoringMessages.RenameJavaElementAction_exception);
        }
    }

    public void selectionChanged(ITextSelection selection) {
        block5: {
            if (selection instanceof JavaTextSelection) {
                try {
                    IJavaElement[] elements = ((JavaTextSelection)selection).resolveElementAtOffset();
                    if (elements.length == 1) {
                        this.setEnabled(RenameJavaElementAction.isRenameAvailable(elements[0]));
                        break block5;
                    }
                    this.setEnabled(false);
                }
                catch (CoreException coreException) {
                    this.setEnabled(false);
                }
            } else {
                this.setEnabled(true);
            }
        }
    }

    public void run(ITextSelection selection) {
        RenameLinkedMode activeLinkedMode = RenameLinkedMode.getActiveLinkedMode();
        if (activeLinkedMode != null) {
            if (activeLinkedMode.isCaretInLinkedPosition()) {
                activeLinkedMode.startFullDialog();
                return;
            }
            activeLinkedMode.cancel();
        }
        try {
            IJavaElement element = this.getJavaElementFromEditor();
            if (element != null && RenameJavaElementAction.isRenameAvailable(element)) {
                IPreferenceStore store = JavaPlugin.getDefault().getPreferenceStore();
                this.run(element, store.getBoolean("Refactor.lightweight"));
                return;
            }
        }
        catch (CoreException e) {
            ExceptionHandler.handle(e, RefactoringMessages.RenameJavaElementAction_name, RefactoringMessages.RenameJavaElementAction_exception);
        }
        MessageDialog.openInformation((Shell)this.getShell(), (String)RefactoringMessages.RenameJavaElementAction_name, (String)RefactoringMessages.RenameJavaElementAction_not_available);
    }

    public boolean canRunInEditor() {
        IJavaElement element;
        block6: {
            if (RenameLinkedMode.getActiveLinkedMode() != null) {
                return true;
            }
            element = this.getJavaElementFromEditor();
            if (element != null) break block6;
            return false;
        }
        try {
            return RenameJavaElementAction.isRenameAvailable(element);
        }
        catch (JavaModelException e) {
            if (JavaModelUtil.isExceptionToBeLogged((CoreException)((Object)e))) {
                JavaPlugin.log(e);
            }
        }
        catch (CoreException e) {
            JavaPlugin.log(e);
        }
        return false;
    }

    private IJavaElement getJavaElementFromEditor() throws JavaModelException {
        IJavaElement[] elements = SelectionConverter.codeResolve(this.fEditor);
        if (elements == null || elements.length != 1) {
            return null;
        }
        return elements[0];
    }

    private void run(IJavaElement element, boolean lightweight) throws CoreException {
        if (!ActionUtil.isEditable(this.fEditor, this.getShell(), element)) {
            return;
        }
        if (ActionUtil.mustDisableJavaModelAction(this.getShell(), element)) {
            return;
        }
        if (lightweight && this.fEditor instanceof CompilationUnitEditor && !(element instanceof IPackageFragment)) {
            new RenameLinkedMode(element, (CompilationUnitEditor)this.fEditor).start();
        } else {
            RefactoringExecutionStarter.startRenameRefactoring(element, this.getShell());
        }
    }

    private static boolean isRenameAvailable(IJavaElement element) throws CoreException {
        switch (element.getElementType()) {
            case 2: {
                return RefactoringAvailabilityTester.isRenameAvailable((IJavaProject)element);
            }
            case 3: {
                return RefactoringAvailabilityTester.isRenameAvailable((IPackageFragmentRoot)element);
            }
            case 4: {
                return RefactoringAvailabilityTester.isRenameAvailable((IPackageFragment)element);
            }
            case 5: {
                return RefactoringAvailabilityTester.isRenameAvailable((ICompilationUnit)element);
            }
            case 7: {
                return false;
            }
            case 9: {
                IMethod method = (IMethod)element;
                if (method.isConstructor()) {
                    return RefactoringAvailabilityTester.isRenameAvailable(method.getDeclaringType());
                }
                return RefactoringAvailabilityTester.isRenameAvailable(method);
            }
            case 8: {
                IField field = (IField)element;
                if (Flags.isEnum((int)field.getFlags())) {
                    return RefactoringAvailabilityTester.isRenameEnumConstAvailable(field);
                }
                return RefactoringAvailabilityTester.isRenameFieldAvailable(field);
            }
            case 15: {
                return RefactoringAvailabilityTester.isRenameAvailable((ITypeParameter)element);
            }
            case 14: {
                return RefactoringAvailabilityTester.isRenameAvailable((ILocalVariable)element);
            }
        }
        return false;
    }
}

