/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.refactoring.nls;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;
import org.eclipse.wst.jsdt.core.ICompilationUnit;
import org.eclipse.wst.jsdt.core.IJavaElement;
import org.eclipse.wst.jsdt.core.IJavaProject;
import org.eclipse.wst.jsdt.core.IPackageFragment;
import org.eclipse.wst.jsdt.core.IPackageFragmentRoot;
import org.eclipse.wst.jsdt.core.JavaModelException;
import org.eclipse.wst.jsdt.internal.ui.JavaPlugin;
import org.eclipse.wst.jsdt.internal.ui.refactoring.nls.NLSUIMessages;
import org.eclipse.wst.jsdt.internal.ui.refactoring.nls.PackageSelectionDialogButtonField;
import org.eclipse.wst.jsdt.internal.ui.wizards.dialogfields.DialogField;
import org.eclipse.wst.jsdt.internal.ui.wizards.dialogfields.IStringButtonAdapter;
import org.eclipse.wst.jsdt.ui.JavaElementLabelProvider;

public class PackageBrowseAdapter
implements IStringButtonAdapter {
    PackageSelectionDialogButtonField fReceiver;
    private ICompilationUnit fCu;

    public PackageBrowseAdapter(ICompilationUnit unit) {
        this.fCu = unit;
    }

    public void setReceiver(PackageSelectionDialogButtonField receiver) {
        this.fReceiver = receiver;
    }

    public void changeControlPressed(DialogField field) {
        IPackageFragment selectedPackage;
        ElementListSelectionDialog dialog = new ElementListSelectionDialog(Display.getCurrent().getActiveShell(), (ILabelProvider)new JavaElementLabelProvider());
        dialog.setIgnoreCase(false);
        dialog.setTitle(NLSUIMessages.PackageBrowseAdapter_package_selection);
        dialog.setMessage(NLSUIMessages.PackageBrowseAdapter_choose_package);
        dialog.setElements(PackageBrowseAdapter.createPackageListInput(this.fCu, null));
        if (dialog.open() == 0 && (selectedPackage = (IPackageFragment)dialog.getFirstResult()) != null) {
            this.fReceiver.setPackage(selectedPackage);
        }
    }

    public static Object[] createPackageListInput(ICompilationUnit cu, String elementNameMatch) {
        try {
            IJavaProject project = cu.getJavaProject();
            IPackageFragmentRoot[] roots = project.getPackageFragmentRoots();
            ArrayList result = new ArrayList();
            HashMap entered = new HashMap();
            int i = 0;
            while (i < roots.length) {
                if (PackageBrowseAdapter.canAddPackageRoot(roots[i])) {
                    PackageBrowseAdapter.getValidPackages(roots[i], result, entered, elementNameMatch);
                }
                ++i;
            }
            return result.toArray();
        }
        catch (JavaModelException e) {
            JavaPlugin.log(e);
            return new Object[0];
        }
    }

    static boolean canAddPackageRoot(IPackageFragmentRoot root) throws JavaModelException {
        if (!root.exists()) {
            return false;
        }
        if (root.isArchive()) {
            return false;
        }
        if (root.isExternal()) {
            return false;
        }
        if (root.isReadOnly()) {
            return false;
        }
        return root.isStructureKnown();
    }

    static void getValidPackages(IPackageFragmentRoot root, List result, HashMap entered, String elementNameMatch) throws JavaModelException {
        IJavaElement[] children = null;
        try {
            children = root.getChildren();
        }
        catch (JavaModelException javaModelException) {
            return;
        }
        int i = 0;
        while (i < children.length) {
            if (children[i] instanceof IPackageFragment) {
                IPackageFragment packageFragment = (IPackageFragment)children[i];
                String packageName = packageFragment.getElementName();
                if (!(entered != null && entered.containsKey(packageName) || !PackageBrowseAdapter.canAddPackage(packageFragment) || elementNameMatch != null && !elementNameMatch.equals(packageName))) {
                    result.add(packageFragment);
                    if (entered != null) {
                        entered.put(packageName, null);
                    }
                }
            }
            ++i;
        }
    }

    static boolean canAddPackage(IPackageFragment p) throws JavaModelException {
        if (!p.exists()) {
            return false;
        }
        if (p.isReadOnly()) {
            return false;
        }
        return p.isStructureKnown();
    }

    public static List searchAllPackages(IJavaProject project, String matcher) {
        try {
            IPackageFragmentRoot[] roots = project.getPackageFragmentRoots();
            ArrayList result = new ArrayList();
            int i = 0;
            while (i < roots.length) {
                if (PackageBrowseAdapter.canAddPackageRoot(roots[i])) {
                    PackageBrowseAdapter.getValidPackages(roots[i], result, null, matcher);
                }
                ++i;
            }
            return result;
        }
        catch (JavaModelException e) {
            JavaPlugin.log(e);
            return new ArrayList(0);
        }
    }
}

