/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.refactoring.nls.search;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.core.filebuffers.FileBuffers;
import org.eclipse.core.filebuffers.ITextFileBuffer;
import org.eclipse.core.filebuffers.ITextFileBufferManager;
import org.eclipse.core.filebuffers.LocationKind;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.text.Position;
import org.eclipse.search.ui.text.Match;
import org.eclipse.wst.jsdt.core.ICompilationUnit;
import org.eclipse.wst.jsdt.core.IField;
import org.eclipse.wst.jsdt.core.IJavaElement;
import org.eclipse.wst.jsdt.core.ISourceReference;
import org.eclipse.wst.jsdt.core.ToolFactory;
import org.eclipse.wst.jsdt.core.compiler.IScanner;
import org.eclipse.wst.jsdt.core.compiler.InvalidInputException;
import org.eclipse.wst.jsdt.core.search.SearchMatch;
import org.eclipse.wst.jsdt.core.search.SearchRequestor;
import org.eclipse.wst.jsdt.internal.corext.refactoring.nls.PropertyFileDocumentModel;
import org.eclipse.wst.jsdt.internal.corext.util.JavaModelUtil;
import org.eclipse.wst.jsdt.internal.corext.util.Messages;
import org.eclipse.wst.jsdt.internal.ui.JavaPlugin;
import org.eclipse.wst.jsdt.internal.ui.refactoring.nls.search.FileEntry;
import org.eclipse.wst.jsdt.internal.ui.refactoring.nls.search.LineReader;
import org.eclipse.wst.jsdt.internal.ui.refactoring.nls.search.NLSSearchMessages;
import org.eclipse.wst.jsdt.internal.ui.refactoring.nls.search.NLSSearchResult;
import org.eclipse.wst.jsdt.internal.ui.refactoring.nls.search.Properties;
import org.eclipse.wst.jsdt.internal.ui.util.StringMatcher;

class NLSSearchResultRequestor
extends SearchRequestor {
    private static final StringMatcher fgGetClassNameMatcher = new StringMatcher("*.class.getName()*", false, false);
    private NLSSearchResult fResult;
    private IFile fPropertiesFile;
    private Properties fProperties;
    private HashSet fUsedPropertyNames;

    public NLSSearchResultRequestor(IFile propertiesFile, NLSSearchResult result) {
        this.fPropertiesFile = propertiesFile;
        this.fResult = result;
    }

    public void beginReporting() {
        this.loadProperties();
        this.fUsedPropertyNames = new HashSet(this.fProperties.size());
    }

    public void acceptSearchMatch(SearchMatch match) throws CoreException {
        String source;
        IField field;
        String source2;
        if (match.getAccuracy() == 1) {
            return;
        }
        int offset = match.getOffset();
        int length = match.getLength();
        if (offset == -1 || length == -1) {
            return;
        }
        if (!(match.getElement() instanceof IJavaElement)) {
            return;
        }
        IJavaElement javaElement = (IJavaElement)match.getElement();
        if (javaElement.getElementType() == 13) {
            return;
        }
        if (javaElement.getElementType() == 6) {
            return;
        }
        if (javaElement.getElementType() == 7) {
            return;
        }
        if (javaElement.getElementType() == 8 && (source2 = (field = (IField)javaElement).getSource()) != null && fgGetClassNameMatcher.match(source2)) {
            return;
        }
        if (javaElement instanceof ISourceReference && (source = ((ISourceReference)javaElement).getSource()) != null && source.indexOf("NLS.initializeMessages") != -1) {
            return;
        }
        Position mutableKeyPosition = new Position(offset, length);
        String key = this.findKey(mutableKeyPosition, javaElement);
        if (key != null && this.isKeyDefined(key)) {
            return;
        }
        ICompilationUnit[] allCompilationUnits = JavaModelUtil.getAllCompilationUnits(new IJavaElement[]{javaElement});
        IJavaElement element = javaElement;
        if (allCompilationUnits != null && allCompilationUnits.length == 1) {
            element = allCompilationUnits[0];
        }
        this.fResult.addMatch(new Match((Object)element, mutableKeyPosition.getOffset(), mutableKeyPosition.getLength()));
    }

    public void reportUnusedPropertyNames(IProgressMonitor pm) {
        pm.beginTask("", this.fProperties.size());
        boolean hasUnused = false;
        pm.setTaskName(NLSSearchMessages.NLSSearchResultRequestor_searching);
        String message = Messages.format(NLSSearchMessages.NLSSearchResultCollector_unusedKeys, this.getPropertiesName(this.fPropertiesFile));
        FileEntry groupElement = new FileEntry(this.fPropertiesFile, message);
        Enumeration<?> enumeration = this.fProperties.propertyNames();
        while (enumeration.hasMoreElements()) {
            String propertyName = (String)enumeration.nextElement();
            if (!this.fUsedPropertyNames.contains(propertyName)) {
                this.addMatch(groupElement, propertyName);
                hasUnused = true;
            }
            pm.worked(1);
        }
        if (hasUnused) {
            this.fResult.addFileEntryGroup(groupElement);
        }
        pm.done();
    }

    private String getPropertiesName(IFile propertiesFile) {
        String path = propertiesFile.getFullPath().removeLastSegments(1).toOSString();
        return String.valueOf(propertiesFile.getName()) + " - " + path;
    }

    private void addMatch(FileEntry groupElement, String propertyName) {
        int length;
        String escapedPropertyName = PropertyFileDocumentModel.unwindEscapeChars(propertyName);
        int start = this.findPropertyNameStartPosition(escapedPropertyName);
        if (start == -1) {
            start = 0;
            length = 0;
        } else {
            length = escapedPropertyName.length();
        }
        this.fResult.addMatch(new Match((Object)groupElement, start, length));
    }

    private boolean isKeyDefined(String key) {
        if (key == null) {
            return true;
        }
        this.fUsedPropertyNames.add(key);
        return this.fProperties.getProperty(key) != null;
    }

    public boolean hasPropertyKey(String key) {
        return this.fProperties.containsKey(key);
    }

    public boolean isUsedPropertyKey(String key) {
        return this.fUsedPropertyNames.contains(key);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String findKey(Position keyPositionResult, IJavaElement enclosingElement) throws CoreException {
        ICompilationUnit unit = (ICompilationUnit)enclosingElement.getAncestor(5);
        if (unit == null) {
            return null;
        }
        String source = unit.getSource();
        if (source == null) {
            return null;
        }
        IScanner scanner = ToolFactory.createScanner((boolean)false, (boolean)false, (boolean)false, (boolean)false);
        scanner.setSource(source.toCharArray());
        scanner.resetTo(keyPositionResult.getOffset() + keyPositionResult.getLength(), source.length());
        try {
            if (scanner.getNextToken() != 6) {
                return null;
            }
            if (scanner.getNextToken() != 5) {
                return null;
            }
            String src = new String(scanner.getCurrentTokenSource());
            int keyStart = scanner.getCurrentTokenStartPosition();
            int keyEnd = scanner.getCurrentTokenEndPosition();
            if (scanner.getNextToken() != 7) {
                keyPositionResult.setOffset(keyStart);
                keyPositionResult.setLength(keyEnd - keyStart + 1);
                return src;
            }
            if (scanner.getNextToken() != 45) {
                return null;
            }
            keyStart = scanner.getCurrentTokenStartPosition() + 1;
            keyEnd = scanner.getCurrentTokenEndPosition();
            keyPositionResult.setOffset(keyStart);
            keyPositionResult.setLength(keyEnd - keyStart);
            return source.substring(keyStart, keyEnd);
        }
        catch (InvalidInputException invalidInputException) {
            return null;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private int findPropertyNameStartPosition(String propertyName) {
        stream = null;
        lineReader = null;
        try {
            encoding = this.fPropertiesFile.getCharset();
        }
        catch (CoreException v0) {
            encoding = "ISO-8859-1";
        }
        try {
            stream = this.createInputStream(this.fPropertiesFile);
            lineReader = new LineReader(stream, encoding);
        }
        catch (CoreException cex) {
            JavaPlugin.log(cex);
            return -1;
        }
        catch (IOException v1) {
            if (stream == null) return -1;
            try {
                stream.close();
                return -1;
            }
            catch (IOException ce) {
                JavaPlugin.log(ce);
            }
            return -1;
        }
        start = 0;
        try {
            try {
                buf = new StringBuffer(80);
                eols = lineReader.readLine(buf);
                keyLength = propertyName.length();
                while (true) {
                    block20: {
                        if (eols > 0) break block20;
                        if (eols != -17) {
                            start = -1;
                        }
                        break;
                    }
                    line = buf.toString();
                    i = line.indexOf(propertyName);
                    charPos = i + keyLength;
                    terminatorChar = '\u0000';
                    v2 = hasNoValue = charPos >= line.length();
                    if (i > -1 && !hasNoValue) {
                        terminatorChar = line.charAt(charPos);
                    }
                    if (line.trim().startsWith(propertyName) && (hasNoValue || Character.isWhitespace(terminatorChar) || terminatorChar == '=')) {
                        start += line.indexOf(propertyName);
                        eols = -17;
                        continue;
                    }
                    start += line.length() + eols;
                    buf.setLength(0);
                    eols = lineReader.readLine(buf);
                }
            }
            catch (IOException ex) {
                JavaPlugin.log(ex);
                var14_17 = null;
                try {
                    lineReader.close();
                    return -1;
                }
                catch (IOException ex) {
                    JavaPlugin.log(ex);
                }
                return -1;
            }
        }
        catch (Throwable var15_23) {
            var14_18 = null;
            ** try [egrp 5[TRYBLOCK] [7 : 287->294)] { 
lbl64:
            // 1 sources

            lineReader.close();
            throw var15_23;
lbl66:
            // 1 sources

            catch (IOException ex) {
                JavaPlugin.log(ex);
            }
            throw var15_23;
        }
        {
            var14_19 = null;
        }
        try {}
        catch (IOException ex) {
            JavaPlugin.log(ex);
            return start;
        }
        lineReader.close();
        return start;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void loadProperties() {
        BufferedInputStream stream;
        HashSet duplicateKeys = new HashSet();
        this.fProperties = new Properties(duplicateKeys);
        try {
            stream = new BufferedInputStream(this.createInputStream(this.fPropertiesFile));
        }
        catch (CoreException coreException) {
            this.fProperties = new Properties();
            return;
        }
        try {
            try {
                this.fProperties.load(stream);
            }
            catch (IOException iOException) {
                this.fProperties = new Properties();
                Object var3_3 = null;
                try {
                    ((InputStream)stream).close();
                }
                catch (IOException iOException2) {}
                this.reportDuplicateKeys(duplicateKeys);
                return;
            }
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            try {}
            catch (IOException iOException) {}
            ((InputStream)stream).close();
            this.reportDuplicateKeys(duplicateKeys);
            throw throwable;
        }
        {
            Object var3_5 = null;
        }
        try {}
        catch (IOException iOException) {}
        ((InputStream)stream).close();
        this.reportDuplicateKeys(duplicateKeys);
    }

    private InputStream createInputStream(IFile propertiesFile) throws CoreException {
        ITextFileBuffer buffer;
        ITextFileBufferManager manager = FileBuffers.getTextFileBufferManager();
        if (manager != null && (buffer = manager.getTextFileBuffer(propertiesFile.getFullPath(), LocationKind.IFILE)) != null) {
            return new ByteArrayInputStream(buffer.getDocument().get().getBytes());
        }
        return propertiesFile.getContents();
    }

    private void reportDuplicateKeys(Set duplicateKeys) {
        if (duplicateKeys.size() == 0) {
            return;
        }
        String message = Messages.format(NLSSearchMessages.NLSSearchResultCollector_duplicateKeys, this.getPropertiesName(this.fPropertiesFile));
        FileEntry groupElement = new FileEntry(this.fPropertiesFile, message);
        Iterator iter = duplicateKeys.iterator();
        while (iter.hasNext()) {
            String propertyName = (String)iter.next();
            this.addMatch(groupElement, propertyName);
        }
        this.fResult.addFileEntryGroup(groupElement);
    }
}

