/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.refactoring.reorg;

import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWizard;
import org.eclipse.wst.jsdt.internal.corext.refactoring.reorg.ICreateTargetQueries;
import org.eclipse.wst.jsdt.internal.corext.refactoring.reorg.ICreateTargetQuery;
import org.eclipse.wst.jsdt.internal.ui.JavaPlugin;
import org.eclipse.wst.jsdt.internal.ui.refactoring.reorg.ReorgMessages;
import org.eclipse.wst.jsdt.internal.ui.util.PixelConverter;
import org.eclipse.wst.jsdt.internal.ui.wizards.NewPackageCreationWizard;
import org.eclipse.wst.jsdt.ui.wizards.NewPackageWizardPage;

public class CreateTargetQueries
implements ICreateTargetQueries {
    private final Wizard fWizard;
    private final Shell fShell;

    public CreateTargetQueries(Wizard wizard) {
        this.fWizard = wizard;
        this.fShell = null;
    }

    public CreateTargetQueries(Shell shell) {
        this.fShell = shell;
        this.fWizard = null;
    }

    private Shell getShell() {
        Assert.isTrue((this.fWizard == null || this.fShell == null ? 1 : 0) != 0);
        if (this.fWizard != null) {
            return this.fWizard.getContainer().getShell();
        }
        if (this.fShell != null) {
            return this.fShell;
        }
        return JavaPlugin.getActiveWorkbenchShell();
    }

    public ICreateTargetQuery createNewPackageQuery() {
        return new ICreateTargetQuery(){

            public Object getCreatedTarget(Object selection) {
                NewPackageCreationWizard packageCreationWizard = new NewPackageCreationWizard();
                IWizardPage[] pages = CreateTargetQueries.this.openNewElementWizard((IWorkbenchWizard)packageCreationWizard, CreateTargetQueries.this.getShell(), selection);
                NewPackageWizardPage page = (NewPackageWizardPage)pages[0];
                return page.getNewPackageFragment();
            }

            public String getNewButtonLabel() {
                return ReorgMessages.ReorgMoveWizard_newPackage;
            }
        };
    }

    private IWizardPage[] openNewElementWizard(IWorkbenchWizard wizard, Shell shell, Object selection) {
        wizard.init(JavaPlugin.getDefault().getWorkbench(), (IStructuredSelection)new StructuredSelection(selection));
        WizardDialog dialog = new WizardDialog(shell, (IWizard)wizard);
        PixelConverter converter = new PixelConverter(JFaceResources.getDialogFont());
        dialog.setMinimumPageSize(converter.convertWidthInCharsToPixels(70), converter.convertHeightInCharsToPixels(20));
        dialog.create();
        dialog.open();
        IWizardPage[] pages = wizard.getPages();
        return pages;
    }
}

