/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.refactoring.reorg;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.eclipse.core.filebuffers.ITextFileBuffer;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.Refactoring;
import org.eclipse.ltk.core.refactoring.RefactoringCore;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.TextChange;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.CopyFilesAndFoldersOperation;
import org.eclipse.ui.actions.CopyProjectOperation;
import org.eclipse.ui.part.ResourceTransfer;
import org.eclipse.wst.jsdt.core.IClasspathEntry;
import org.eclipse.wst.jsdt.core.ICompilationUnit;
import org.eclipse.wst.jsdt.core.IJavaElement;
import org.eclipse.wst.jsdt.core.IJavaProject;
import org.eclipse.wst.jsdt.core.IPackageFragment;
import org.eclipse.wst.jsdt.core.IPackageFragmentRoot;
import org.eclipse.wst.jsdt.core.IType;
import org.eclipse.wst.jsdt.core.JavaCore;
import org.eclipse.wst.jsdt.core.JavaModelException;
import org.eclipse.wst.jsdt.core.ToolFactory;
import org.eclipse.wst.jsdt.core.compiler.IScanner;
import org.eclipse.wst.jsdt.core.compiler.InvalidInputException;
import org.eclipse.wst.jsdt.core.dom.AST;
import org.eclipse.wst.jsdt.core.dom.ASTNode;
import org.eclipse.wst.jsdt.core.dom.ASTParser;
import org.eclipse.wst.jsdt.core.dom.AbstractTypeDeclaration;
import org.eclipse.wst.jsdt.core.dom.BodyDeclaration;
import org.eclipse.wst.jsdt.core.dom.CompilationUnit;
import org.eclipse.wst.jsdt.core.dom.PackageDeclaration;
import org.eclipse.wst.jsdt.core.dom.StructuralPropertyDescriptor;
import org.eclipse.wst.jsdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.wst.jsdt.internal.corext.dom.ASTNodes;
import org.eclipse.wst.jsdt.internal.corext.refactoring.Checks;
import org.eclipse.wst.jsdt.internal.corext.refactoring.TypedSource;
import org.eclipse.wst.jsdt.internal.corext.refactoring.changes.CompilationUnitChange;
import org.eclipse.wst.jsdt.internal.corext.refactoring.changes.TextChangeCompatibility;
import org.eclipse.wst.jsdt.internal.corext.refactoring.reorg.IConfirmQuery;
import org.eclipse.wst.jsdt.internal.corext.refactoring.reorg.JavaElementTransfer;
import org.eclipse.wst.jsdt.internal.corext.refactoring.reorg.ParentChecker;
import org.eclipse.wst.jsdt.internal.corext.refactoring.reorg.ReorgUtils;
import org.eclipse.wst.jsdt.internal.corext.refactoring.structure.ASTNodeSearchUtil;
import org.eclipse.wst.jsdt.internal.corext.refactoring.util.RefactoringFileBuffers;
import org.eclipse.wst.jsdt.internal.corext.refactoring.util.ResourceUtil;
import org.eclipse.wst.jsdt.internal.corext.util.JavaModelUtil;
import org.eclipse.wst.jsdt.internal.corext.util.JdtFlags;
import org.eclipse.wst.jsdt.internal.corext.util.Messages;
import org.eclipse.wst.jsdt.internal.ui.JavaPlugin;
import org.eclipse.wst.jsdt.internal.ui.refactoring.RefactoringExecutionHelper;
import org.eclipse.wst.jsdt.internal.ui.refactoring.RefactoringMessages;
import org.eclipse.wst.jsdt.internal.ui.refactoring.reorg.PasteAction;
import org.eclipse.wst.jsdt.internal.ui.refactoring.reorg.ReorgCopyStarter;
import org.eclipse.wst.jsdt.internal.ui.refactoring.reorg.ReorgMessages;
import org.eclipse.wst.jsdt.internal.ui.refactoring.reorg.ReorgQueries;
import org.eclipse.wst.jsdt.internal.ui.refactoring.reorg.TypedSourceTransfer;
import org.eclipse.wst.jsdt.internal.ui.util.BusyIndicatorRunnableContext;
import org.eclipse.wst.jsdt.internal.ui.util.ExceptionHandler;
import org.eclipse.wst.jsdt.internal.ui.util.SelectionUtil;
import org.eclipse.wst.jsdt.internal.ui.wizards.buildpaths.BuildPathsBlock;
import org.eclipse.wst.jsdt.ui.JavaUI;
import org.eclipse.wst.jsdt.ui.PreferenceConstants;
import org.eclipse.wst.jsdt.ui.actions.SelectionDispatchAction;

public class PasteAction
extends SelectionDispatchAction {
    private final Clipboard fClipboard;

    public PasteAction(IWorkbenchSite site, Clipboard clipboard) {
        super(site);
        Assert.isNotNull((Object)clipboard);
        this.fClipboard = clipboard;
        this.setText(ReorgMessages.PasteAction_4);
        this.setDescription(ReorgMessages.PasteAction_5);
        ISharedImages workbenchImages = JavaPlugin.getDefault().getWorkbench().getSharedImages();
        this.setDisabledImageDescriptor(workbenchImages.getImageDescriptor("IMG_TOOL_PASTE_DISABLED"));
        this.setImageDescriptor(workbenchImages.getImageDescriptor("IMG_TOOL_PASTE"));
        this.setHoverImageDescriptor(workbenchImages.getImageDescriptor("IMG_TOOL_PASTE"));
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, "org.eclipse.wst.jsdt.ui.paste_action");
    }

    public void selectionChanged(IStructuredSelection selection) {
    }

    private Paster[] createEnabledPasters(TransferData[] availableDataTypes) throws JavaModelException {
        Shell shell = this.getShell();
        ArrayList<Paster> result = new ArrayList<Paster>(2);
        Paster paster = new ProjectPaster(shell, this.fClipboard);
        if (paster.canEnable(availableDataTypes)) {
            result.add(paster);
        }
        if ((paster = new JavaElementAndResourcePaster(shell, this.fClipboard)).canEnable(availableDataTypes)) {
            result.add(paster);
        }
        if ((paster = new TypedSourcePaster(shell, this.fClipboard)).canEnable(availableDataTypes)) {
            result.add(paster);
        }
        if ((paster = new FilePaster(shell, this.fClipboard)).canEnable(availableDataTypes)) {
            result.add(paster);
        }
        if ((paster = new WorkingSetPaster(shell, this.fClipboard)).canEnable(availableDataTypes)) {
            result.add(paster);
        }
        if ((paster = new TextPaster(shell, this.fClipboard)).canEnable(availableDataTypes)) {
            result.add(paster);
        }
        return result.toArray(new Paster[result.size()]);
    }

    private static Object getContents(final Clipboard clipboard, final Transfer transfer, Shell shell) {
        final Object[] result = new Object[1];
        shell.getDisplay().syncExec(new Runnable(){

            public void run() {
                result[0] = clipboard.getContents(transfer);
            }
        });
        return result[0];
    }

    private static boolean isAvailable(Transfer transfer, TransferData[] availableDataTypes) {
        int i = 0;
        while (i < availableDataTypes.length) {
            if (transfer.isSupportedType(availableDataTypes[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public void run(IStructuredSelection selection) {
        try {
            TransferData[] availableTypes = this.fClipboard.getAvailableTypes();
            List elements = selection.toList();
            IResource[] resources = ReorgUtils.getResources(elements);
            IJavaElement[] javaElements = ReorgUtils.getJavaElements(elements);
            IWorkingSet[] workingSets = ReorgUtils.getWorkingSets(elements);
            Paster[] pasters = this.createEnabledPasters(availableTypes);
            int i = 0;
            while (i < pasters.length) {
                if (pasters[i].canPasteOn(javaElements, resources, workingSets)) {
                    pasters[i].paste(javaElements, resources, workingSets, availableTypes);
                    return;
                }
                ++i;
            }
            String msg = resources.length + javaElements.length + workingSets.length == 0 ? ReorgMessages.PasteAction_cannot_no_selection : ReorgMessages.PasteAction_cannot_selection;
            MessageDialog.openError((Shell)JavaPlugin.getActiveWorkbenchShell(), (String)ReorgMessages.PasteAction_name, (String)msg);
        }
        catch (JavaModelException e) {
            ExceptionHandler.handle((CoreException)((Object)e), RefactoringMessages.OpenRefactoringWizardAction_refactoring, RefactoringMessages.OpenRefactoringWizardAction_exception);
        }
        catch (InvocationTargetException e) {
            ExceptionHandler.handle(e, RefactoringMessages.OpenRefactoringWizardAction_refactoring, RefactoringMessages.OpenRefactoringWizardAction_exception);
        }
        catch (InterruptedException interruptedException) {}
    }

    private static class FilePaster
    extends Paster {
        protected FilePaster(Shell shell, Clipboard clipboard) {
            super(shell, clipboard);
        }

        public void paste(IJavaElement[] javaElements, IResource[] resources, IWorkingSet[] selectedWorkingSets, TransferData[] availableTypes) throws JavaModelException {
            String[] fileData = this.getClipboardFiles(availableTypes);
            if (fileData == null) {
                return;
            }
            IContainer container = this.getAsContainer(this.getTarget(javaElements, resources));
            if (container == null) {
                return;
            }
            new CopyFilesAndFoldersOperation(this.getShell()).copyFiles(fileData, container);
        }

        private Object getTarget(IJavaElement[] javaElements, IResource[] resources) {
            if (javaElements.length + resources.length == 1) {
                if (javaElements.length == 1) {
                    return javaElements[0];
                }
                return resources[0];
            }
            return this.getCommonParent(javaElements, resources);
        }

        public boolean canPasteOn(IJavaElement[] javaElements, IResource[] resources, IWorkingSet[] selectedWorkingSets) throws JavaModelException {
            Object target = this.getTarget(javaElements, resources);
            return target != null && this.canPasteFilesOn(this.getAsContainer(target)) && selectedWorkingSets.length == 0;
        }

        public boolean canEnable(TransferData[] availableDataTypes) throws JavaModelException {
            return PasteAction.isAvailable((Transfer)FileTransfer.getInstance(), availableDataTypes);
        }

        private boolean canPasteFilesOn(Object target) {
            boolean isPackageFragment = target instanceof IPackageFragment;
            boolean isJavaProject = target instanceof IJavaProject;
            boolean isPackageFragmentRoot = target instanceof IPackageFragmentRoot;
            boolean isContainer = target instanceof IContainer;
            if (!(isPackageFragment || isJavaProject || isPackageFragmentRoot || isContainer)) {
                return false;
            }
            if (isContainer) {
                return true;
            }
            IJavaElement element = (IJavaElement)target;
            return !element.isReadOnly();
        }

        private IContainer getAsContainer(Object target) throws JavaModelException {
            if (target == null) {
                return null;
            }
            if (target instanceof IContainer) {
                return (IContainer)target;
            }
            if (target instanceof IFile) {
                return ((IFile)target).getParent();
            }
            return this.getAsContainer(((IJavaElement)target).getCorrespondingResource());
        }

        private String[] getClipboardFiles(TransferData[] availableDataTypes) {
            FileTransfer transfer = FileTransfer.getInstance();
            if (PasteAction.isAvailable((Transfer)transfer, availableDataTypes)) {
                return (String[])PasteAction.getContents(this.getClipboard(), (Transfer)transfer, this.getShell());
            }
            return null;
        }

        private Object getCommonParent(IJavaElement[] javaElements, IResource[] resources) {
            return new ParentChecker(resources, javaElements).getCommonParent();
        }
    }

    private static class JavaElementAndResourcePaster
    extends Paster {
        private TransferData[] fAvailableTypes;

        protected JavaElementAndResourcePaster(Shell shell, Clipboard clipboard) {
            super(shell, clipboard);
        }

        public void paste(IJavaElement[] javaElements, IResource[] resources, IWorkingSet[] selectedWorkingSets, TransferData[] availableTypes) throws JavaModelException, InterruptedException, InvocationTargetException {
            Object destination;
            IJavaElement[] clipboardJavaElements;
            IResource[] clipboardResources = this.getClipboardResources(availableTypes);
            if (clipboardResources == null) {
                clipboardResources = new IResource[]{};
            }
            if ((clipboardJavaElements = this.getClipboardJavaElements(availableTypes)) == null) {
                clipboardJavaElements = new IJavaElement[]{};
            }
            if ((destination = this.getTarget(javaElements, resources)) instanceof IJavaElement) {
                ReorgCopyStarter.create(clipboardJavaElements, clipboardResources, (IJavaElement)destination).run(this.getShell());
            } else if (destination instanceof IResource) {
                ReorgCopyStarter.create(clipboardJavaElements, clipboardResources, (IResource)destination).run(this.getShell());
            }
        }

        private Object getTarget(IJavaElement[] javaElements, IResource[] resources) {
            if (javaElements.length + resources.length == 1) {
                if (javaElements.length == 1) {
                    return javaElements[0];
                }
                return resources[0];
            }
            return this.getCommonParent(javaElements, resources);
        }

        private Object getCommonParent(IJavaElement[] javaElements, IResource[] resources) {
            return new ParentChecker(resources, javaElements).getCommonParent();
        }

        public boolean canPasteOn(IJavaElement[] javaElements, IResource[] resources, IWorkingSet[] selectedWorkingSets) throws JavaModelException {
            Object destination;
            IJavaElement[] clipboardJavaElements;
            if (selectedWorkingSets.length != 0) {
                return false;
            }
            IResource[] clipboardResources = this.getClipboardResources(this.fAvailableTypes);
            if (clipboardResources == null) {
                clipboardResources = new IResource[]{};
            }
            if ((clipboardJavaElements = this.getClipboardJavaElements(this.fAvailableTypes)) == null) {
                clipboardJavaElements = new IJavaElement[]{};
            }
            if ((destination = this.getTarget(javaElements, resources)) instanceof IJavaElement) {
                return ReorgCopyStarter.create(clipboardJavaElements, clipboardResources, (IJavaElement)destination) != null;
            }
            if (destination instanceof IResource) {
                return ReorgCopyStarter.create(clipboardJavaElements, clipboardResources, (IResource)destination) != null;
            }
            return false;
        }

        public boolean canEnable(TransferData[] availableTypes) {
            this.fAvailableTypes = availableTypes;
            return PasteAction.isAvailable((Transfer)JavaElementTransfer.getInstance(), availableTypes) || PasteAction.isAvailable((Transfer)ResourceTransfer.getInstance(), availableTypes);
        }
    }

    private static abstract class Paster {
        private final Shell fShell;
        private final Clipboard fClipboard2;

        protected Paster(Shell shell, Clipboard clipboard) {
            this.fShell = shell;
            this.fClipboard2 = clipboard;
        }

        protected final Shell getShell() {
            return this.fShell;
        }

        protected final Clipboard getClipboard() {
            return this.fClipboard2;
        }

        protected final IResource[] getClipboardResources(TransferData[] availableDataTypes) {
            ResourceTransfer transfer = ResourceTransfer.getInstance();
            if (PasteAction.isAvailable((Transfer)transfer, availableDataTypes)) {
                return (IResource[])PasteAction.getContents(this.fClipboard2, (Transfer)transfer, this.getShell());
            }
            return null;
        }

        protected final IJavaElement[] getClipboardJavaElements(TransferData[] availableDataTypes) {
            JavaElementTransfer transfer = JavaElementTransfer.getInstance();
            if (PasteAction.isAvailable((Transfer)transfer, availableDataTypes)) {
                return (IJavaElement[])PasteAction.getContents(this.fClipboard2, (Transfer)transfer, this.getShell());
            }
            return null;
        }

        protected final TypedSource[] getClipboardTypedSources(TransferData[] availableDataTypes) {
            TypedSourceTransfer transfer = TypedSourceTransfer.getInstance();
            if (PasteAction.isAvailable((Transfer)transfer, availableDataTypes)) {
                return (TypedSource[])PasteAction.getContents(this.fClipboard2, (Transfer)transfer, this.getShell());
            }
            return null;
        }

        protected final String getClipboardText(TransferData[] availableDataTypes) {
            TextTransfer transfer = TextTransfer.getInstance();
            if (PasteAction.isAvailable((Transfer)transfer, availableDataTypes)) {
                return (String)PasteAction.getContents(this.fClipboard2, (Transfer)transfer, this.getShell());
            }
            return null;
        }

        public abstract boolean canEnable(TransferData[] var1) throws JavaModelException;

        public abstract boolean canPasteOn(IJavaElement[] var1, IResource[] var2, IWorkingSet[] var3) throws JavaModelException;

        public abstract void paste(IJavaElement[] var1, IResource[] var2, IWorkingSet[] var3, TransferData[] var4) throws JavaModelException, InterruptedException, InvocationTargetException;
    }

    private static class ProjectPaster
    extends Paster {
        protected ProjectPaster(Shell shell, Clipboard clipboard) {
            super(shell, clipboard);
        }

        public boolean canEnable(TransferData[] availableDataTypes) {
            boolean resourceTransfer = PasteAction.isAvailable((Transfer)ResourceTransfer.getInstance(), availableDataTypes);
            boolean javaElementTransfer = PasteAction.isAvailable((Transfer)JavaElementTransfer.getInstance(), availableDataTypes);
            if (!javaElementTransfer) {
                return this.canPasteSimpleProjects(availableDataTypes);
            }
            if (!resourceTransfer) {
                return this.canPasteJavaProjects(availableDataTypes);
            }
            return this.canPasteJavaProjects(availableDataTypes) && this.canPasteSimpleProjects(availableDataTypes);
        }

        public void paste(IJavaElement[] javaElements, IResource[] resources, IWorkingSet[] selectedWorkingSets, TransferData[] availableTypes) {
            this.pasteProjects(availableTypes);
        }

        private void pasteProjects(TransferData[] availableTypes) {
            this.pasteProjects(this.getProjectsToPaste(availableTypes));
        }

        private void pasteProjects(IProject[] projects) {
            Shell shell = this.getShell();
            int i = 0;
            while (i < projects.length) {
                new CopyProjectOperation(shell).copyProject(projects[i]);
                ++i;
            }
        }

        private IProject[] getProjectsToPaste(TransferData[] availableTypes) {
            IResource[] resources = this.getClipboardResources(availableTypes);
            IJavaElement[] javaElements = this.getClipboardJavaElements(availableTypes);
            HashSet<IResource> result = new HashSet<IResource>();
            if (resources != null) {
                result.addAll(Arrays.asList(resources));
            }
            if (javaElements != null) {
                result.addAll(Arrays.asList(ReorgUtils.getNotNulls(ReorgUtils.getResources(javaElements))));
            }
            Assert.isTrue((result.size() > 0 ? 1 : 0) != 0);
            return result.toArray(new IProject[result.size()]);
        }

        public boolean canPasteOn(IJavaElement[] javaElements, IResource[] resources, IWorkingSet[] selectedWorkingSets) {
            return selectedWorkingSets.length == 0;
        }

        private boolean canPasteJavaProjects(TransferData[] availableDataTypes) {
            IJavaElement[] javaElements = this.getClipboardJavaElements(availableDataTypes);
            return javaElements != null && javaElements.length != 0 && !ReorgUtils.hasElementsNotOfType(javaElements, 2);
        }

        private boolean canPasteSimpleProjects(TransferData[] availableDataTypes) {
            IResource[] resources = this.getClipboardResources(availableDataTypes);
            if (resources == null || resources.length == 0) {
                return false;
            }
            int i = 0;
            while (i < resources.length) {
                if (resources[i].getType() != 4 || !((IProject)resources[i]).isOpen()) {
                    return false;
                }
                ++i;
            }
            return true;
        }
    }

    private static class TextPaster
    extends Paster {
        private IPackageFragmentRoot fDestination;
        private IPackageFragment fDestinationPack;
        private ParsedCu[] fParsedCus;
        private TransferData[] fAvailableTypes;

        protected TextPaster(Shell shell, Clipboard clipboard) {
            super(shell, clipboard);
        }

        public boolean canEnable(TransferData[] availableTypes) {
            this.fAvailableTypes = availableTypes;
            return PasteAction.isAvailable((Transfer)TextTransfer.getInstance(), availableTypes);
        }

        public boolean canPasteOn(IJavaElement[] javaElements, IResource[] resources, IWorkingSet[] selectedWorkingSets) throws JavaModelException {
            if (selectedWorkingSets.length != 0) {
                return false;
            }
            if (resources.length != 0) {
                return false;
            }
            if (javaElements.length > 1) {
                return false;
            }
            String text = this.getClipboardText(this.fAvailableTypes);
            IJavaProject javaProject = null;
            IJavaElement destination = null;
            if (javaElements.length == 1) {
                destination = javaElements[0];
                javaProject = destination.getJavaProject();
            }
            this.fParsedCus = ParsedCu.parse(javaProject, text);
            if (this.fParsedCus.length == 0) {
                return false;
            }
            if (destination == null) {
                return true;
            }
            switch (destination.getElementType()) {
                case 2: {
                    IPackageFragmentRoot[] packageFragmentRoots = ((IJavaProject)destination).getPackageFragmentRoots();
                    int i = 0;
                    while (i < packageFragmentRoots.length) {
                        IPackageFragmentRoot packageFragmentRoot = packageFragmentRoots[i];
                        if (this.isWritable(packageFragmentRoot)) {
                            this.fDestination = packageFragmentRoot;
                            return true;
                        }
                        ++i;
                    }
                    return false;
                }
                case 3: {
                    IPackageFragmentRoot packageFragmentRoot = (IPackageFragmentRoot)destination;
                    if (this.isWritable(packageFragmentRoot)) {
                        this.fDestination = packageFragmentRoot;
                        return true;
                    }
                    return false;
                }
                case 4: {
                    IPackageFragment destinationPack = (IPackageFragment)destination;
                    IPackageFragmentRoot packageFragmentRoot = (IPackageFragmentRoot)destinationPack.getParent();
                    if (this.isWritable(packageFragmentRoot)) {
                        this.fDestination = packageFragmentRoot;
                        if (this.fParsedCus.length == 1) {
                            this.fDestinationPack = destinationPack;
                        }
                        return true;
                    }
                    return false;
                }
                case 5: {
                    IPackageFragment destinationPack = (IPackageFragment)destination.getParent();
                    IPackageFragmentRoot packageFragmentRoot = (IPackageFragmentRoot)destinationPack.getParent();
                    if (this.isWritable(packageFragmentRoot)) {
                        this.fDestination = packageFragmentRoot;
                        if (this.fParsedCus.length == 1) {
                            this.fDestinationPack = destinationPack;
                        }
                        return true;
                    }
                    return false;
                }
            }
            return false;
        }

        private boolean isWritable(IPackageFragmentRoot packageFragmentRoot) {
            try {
                return packageFragmentRoot.exists() && !packageFragmentRoot.isArchive() && !packageFragmentRoot.isReadOnly() && packageFragmentRoot.getKind() == 1;
            }
            catch (JavaModelException javaModelException) {
                return false;
            }
        }

        public void paste(IJavaElement[] javaElements, IResource[] resources, IWorkingSet[] selectedWorkingSets, TransferData[] availableTypes) throws JavaModelException, InterruptedException, InvocationTargetException {
            IEditorPart[] editorPart = new IEditorPart[1];
            IRunnableWithProgress op = new IRunnableWithProgress(this, editorPart){
                private IPath fVMPath;
                private String fCompilerCompliance;
                final /* synthetic */ TextPaster this$1;
                private final /* synthetic */ IEditorPart[] val$editorPart;
                {
                    this.this$1 = textPaster;
                    this.val$editorPart = iEditorPartArray;
                }

                /*
                 * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
                 * Enabled aggressive block sorting
                 * Enabled unnecessary exception pruning
                 * Enabled aggressive exception aggregation
                 */
                public void run(IProgressMonitor monitor) throws InvocationTargetException {
                    ArrayList<E> cus = new ArrayList<E>();
                    try {
                        try {
                            JavaCore.run((IWorkspaceRunnable)new IWorkspaceRunnable(this, cus){
                                final /* synthetic */ 1 this$2;
                                private final /* synthetic */ ArrayList val$cus;
                                {
                                    this.this$2 = var1_1;
                                    this.val$cus = arrayList;
                                }

                                public void run(IProgressMonitor pm) throws CoreException {
                                    pm.beginTask("", 1 + TextPaster.access$0(1.access$2(this.this$2)).length);
                                    if (TextPaster.access$1(1.access$2(this.this$2)) == null) {
                                        TextPaster.access$2(1.access$2(this.this$2), 1.access$0(this.this$2, new SubProgressMonitor(pm, 1)));
                                    } else {
                                        pm.worked(1);
                                    }
                                    IConfirmQuery confirmQuery = new ReorgQueries(1.access$2(this.this$2).getShell()).createYesYesToAllNoNoToAllQuery(ReorgMessages.PasteAction_TextPaster_confirmOverwriting, true, 6);
                                    int i = 0;
                                    while (i < TextPaster.access$0(1.access$2(this.this$2)).length) {
                                        if (pm.isCanceled()) break;
                                        ICompilationUnit cu = 1.access$1(this.this$2, TextPaster.access$0(1.access$2(this.this$2))[i], new SubProgressMonitor(pm, 1), confirmQuery);
                                        if (cu != null) {
                                            this.val$cus.add(cu);
                                        }
                                        ++i;
                                    }
                                }
                            }, (IProgressMonitor)monitor);
                        }
                        catch (OperationCanceledException operationCanceledException) {
                        }
                        catch (CoreException e) {
                            throw new InvocationTargetException(e);
                        }
                    }
                    catch (Throwable throwable) {
                        Object var4_6 = null;
                        monitor.done();
                        throw throwable;
                    }
                    {
                        Object var4_7 = null;
                    }
                    monitor.done();
                    IFile[] cuResources = ResourceUtil.getFiles(cus.toArray(new ICompilationUnit[cus.size()]));
                    SelectionUtil.selectAndReveal((IResource[])cuResources, PlatformUI.getWorkbench().getActiveWorkbenchWindow());
                }

                /*
                 * Enabled aggressive block sorting
                 * Enabled unnecessary exception pruning
                 * Enabled aggressive exception aggregation
                 */
                private ICompilationUnit pasteCU(ParsedCu parsedCu, SubProgressMonitor pm, IConfirmQuery confirmQuery) throws CoreException, OperationCanceledException {
                    ICompilationUnit iCompilationUnit;
                    block17: {
                        block15: {
                            pm.beginTask("", 4);
                            try {
                                IPackageFragment destinationPack;
                                if (TextPaster.access$3(this.this$1) != null) {
                                    destinationPack = TextPaster.access$3(this.this$1);
                                    pm.worked(1);
                                } else {
                                    String packageName = parsedCu.getPackageName();
                                    destinationPack = TextPaster.access$1(this.this$1).getPackageFragment(packageName);
                                    if (!destinationPack.exists()) {
                                        JavaModelUtil.getPackageFragmentRoot((IJavaElement)destinationPack).createPackageFragment(packageName, true, (IProgressMonitor)new SubProgressMonitor((IProgressMonitor)pm, 1));
                                    } else {
                                        pm.worked(1);
                                    }
                                }
                                String cuName = String.valueOf(parsedCu.getTypeName()) + ".js";
                                ICompilationUnit cu = destinationPack.getCompilationUnit(cuName);
                                boolean alreadyExists = cu.exists();
                                if (alreadyExists) {
                                    String msg = Messages.format(ReorgMessages.PasteAction_TextPaster_exists, new Object[]{cuName});
                                    boolean overwrite = confirmQuery.confirm(msg);
                                    if (!overwrite) {
                                        Object var10_10 = null;
                                        break block15;
                                    }
                                    this.val$editorPart[0] = TextPaster.access$4(this.this$1, cu);
                                }
                                destinationPack.createCompilationUnit(cuName, parsedCu.getText(), true, (IProgressMonitor)new SubProgressMonitor((IProgressMonitor)pm, 1));
                                if (!alreadyExists) {
                                    this.val$editorPart[0] = TextPaster.access$4(this.this$1, cu);
                                }
                                if (TextPaster.access$3(this.this$1) != null && !TextPaster.access$3(this.this$1).getElementName().equals(parsedCu.getPackageName())) {
                                    if (TextPaster.access$3(this.this$1).getElementName().length() == 0) {
                                        this.removePackageDeclaration(cu);
                                    } else {
                                        cu.createPackageDeclaration(TextPaster.access$3(this.this$1).getElementName(), (IProgressMonitor)new SubProgressMonitor((IProgressMonitor)pm, 1));
                                    }
                                    if (!alreadyExists && this.val$editorPart[0] != null) {
                                        this.val$editorPart[0].doSave((IProgressMonitor)new SubProgressMonitor((IProgressMonitor)pm, 1));
                                    } else {
                                        pm.worked(1);
                                    }
                                } else {
                                    pm.worked(1);
                                }
                                iCompilationUnit = cu;
                                break block17;
                            }
                            catch (Throwable throwable) {
                                Object var10_12 = null;
                                pm.done();
                                throw throwable;
                            }
                        }
                        pm.done();
                        return null;
                    }
                    Object var10_11 = null;
                    pm.done();
                    return iCompilationUnit;
                }

                private IPackageFragmentRoot createNewProject(SubProgressMonitor pm) throws CoreException {
                    IProject srcFolder;
                    IProject project;
                    pm.beginTask("", 10);
                    int i = 1;
                    do {
                        String name = Messages.format(ReorgMessages.PasteAction_projectName, i == 1 ? "" : new Integer(i));
                        project = JavaPlugin.getWorkspace().getRoot().getProject(name);
                        ++i;
                    } while (project.exists());
                    BuildPathsBlock.createProject(project, null, (IProgressMonitor)new SubProgressMonitor((IProgressMonitor)pm, 3));
                    BuildPathsBlock.addJavaNature(project, (IProgressMonitor)new SubProgressMonitor((IProgressMonitor)pm, 1));
                    IJavaProject javaProject = JavaCore.create((IProject)project);
                    IPreferenceStore store = PreferenceConstants.getPreferenceStore();
                    String sourceFolderName = store.getString("org.eclipse.wst.jsdt.ui.wizards.srcBinFoldersSrcName");
                    if (store.getBoolean("org.eclipse.wst.jsdt.ui.wizards.srcBinFoldersInNewProjects") && sourceFolderName.length() > 0) {
                        IFolder folder = project.getFolder(sourceFolderName);
                        if (!folder.exists()) {
                            folder.create(false, true, (IProgressMonitor)new SubProgressMonitor((IProgressMonitor)pm, 1));
                        }
                        srcFolder = folder;
                    } else {
                        srcFolder = project;
                    }
                    this.computeLatestVM();
                    if (this.fCompilerCompliance != null) {
                        Map options = javaProject.getOptions(false);
                        JavaModelUtil.setCompilanceOptions(options, this.fCompilerCompliance);
                        JavaModelUtil.setDefaultClassfileOptions(options, this.fCompilerCompliance);
                        javaProject.setOptions(options);
                    }
                    IClasspathEntry srcEntry = JavaCore.newSourceEntry((IPath)srcFolder.getFullPath());
                    IClasspathEntry jreEntry = JavaCore.newContainerEntry((IPath)this.fVMPath);
                    IClasspathEntry[] cpes = new IClasspathEntry[]{srcEntry, jreEntry};
                    javaProject.setRawClasspath(cpes, null, (IProgressMonitor)new SubProgressMonitor((IProgressMonitor)pm, 1));
                    return javaProject.getPackageFragmentRoot((IResource)srcFolder);
                }

                private void computeLatestVM() {
                }

                /*
                 * Exception decompiling
                 */
                private void removePackageDeclaration(ICompilationUnit cu) throws JavaModelException, CoreException {
                    /*
                     * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
                     * 
                     * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 2[TRYBLOCK] [2 : 89->93)] java.lang.Throwable
                     *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
                     *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
                     *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
                     *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
                     *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
                     *     at org.benf.cfr.reader.entities.Method.dump(Method.java:598)
                     *     at org.benf.cfr.reader.entities.classfilehelpers.ClassFileDumperAnonymousInner.dumpWithArgs(ClassFileDumperAnonymousInner.java:87)
                     *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.ConstructorInvokationAnonymousInner.dumpInner(ConstructorInvokationAnonymousInner.java:82)
                     *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractExpression.dumpWithOuterPrecedence(AbstractExpression.java:142)
                     *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractExpression.dump(AbstractExpression.java:98)
                     *     at org.benf.cfr.reader.state.TypeUsageCollectingDumper.dump(TypeUsageCollectingDumper.java:194)
                     *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredAssignment.dump(StructuredAssignment.java:69)
                     *     at org.benf.cfr.reader.state.TypeUsageCollectingDumper.dump(TypeUsageCollectingDumper.java:194)
                     *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.dump(Op04StructuredStatement.java:220)
                     *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.Block.dump(Block.java:564)
                     *     at org.benf.cfr.reader.state.TypeUsageCollectingDumper.dump(TypeUsageCollectingDumper.java:194)
                     *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.dump(Op04StructuredStatement.java:220)
                     *     at org.benf.cfr.reader.entities.attributes.AttributeCode.dump(AttributeCode.java:135)
                     *     at org.benf.cfr.reader.state.TypeUsageCollectingDumper.dump(TypeUsageCollectingDumper.java:194)
                     *     at org.benf.cfr.reader.entities.Method.dump(Method.java:627)
                     *     at org.benf.cfr.reader.entities.classfilehelpers.AbstractClassFileDumper.dumpMethods(AbstractClassFileDumper.java:211)
                     *     at org.benf.cfr.reader.entities.classfilehelpers.ClassFileDumperNormal.dump(ClassFileDumperNormal.java:70)
                     *     at org.benf.cfr.reader.entities.ClassFile.dumpNamedInnerClasses(ClassFile.java:1161)
                     *     at org.benf.cfr.reader.entities.classfilehelpers.ClassFileDumperNormal.dump(ClassFileDumperNormal.java:71)
                     *     at org.benf.cfr.reader.entities.ClassFile.dump(ClassFile.java:1167)
                     *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:952)
                     *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
                     *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
                     *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
                     *     at org.benf.cfr.reader.Main.main(Main.java:54)
                     */
                    throw new IllegalStateException("Decompilation failed");
                }

                static /* synthetic */ IPackageFragmentRoot access$0(1 var0, SubProgressMonitor subProgressMonitor) throws CoreException {
                    return var0.createNewProject(subProgressMonitor);
                }

                static /* synthetic */ ICompilationUnit access$1(1 var0, ParsedCu parsedCu, SubProgressMonitor subProgressMonitor, IConfirmQuery iConfirmQuery) throws CoreException, OperationCanceledException {
                    return var0.pasteCU(parsedCu, subProgressMonitor, iConfirmQuery);
                }

                static /* synthetic */ TextPaster access$2(1 var0) {
                    return var0.this$1;
                }
            };
            Object context = JavaPlugin.getActiveWorkbenchWindow();
            if (context == null) {
                context = new BusyIndicatorRunnableContext();
            }
            PlatformUI.getWorkbench().getProgressService().runInUI((IRunnableContext)context, op, (ISchedulingRule)JavaPlugin.getWorkspace().getRoot());
            if (editorPart[0] != null) {
                editorPart[0].getEditorSite().getPage().activate((IWorkbenchPart)editorPart[0]);
            }
        }

        private IEditorPart openCu(ICompilationUnit cu) {
            try {
                return JavaUI.openInEditor((IJavaElement)cu, true, true);
            }
            catch (PartInitException e) {
                JavaPlugin.log(e);
                return null;
            }
            catch (JavaModelException e) {
                JavaPlugin.log(e);
                return null;
            }
        }

        static /* synthetic */ ParsedCu[] access$0(TextPaster textPaster) {
            return textPaster.fParsedCus;
        }

        static /* synthetic */ IPackageFragmentRoot access$1(TextPaster textPaster) {
            return textPaster.fDestination;
        }

        static /* synthetic */ void access$2(TextPaster textPaster, IPackageFragmentRoot iPackageFragmentRoot) {
            textPaster.fDestination = iPackageFragmentRoot;
        }

        static /* synthetic */ IPackageFragment access$3(TextPaster textPaster) {
            return textPaster.fDestinationPack;
        }

        static /* synthetic */ IEditorPart access$4(TextPaster textPaster, ICompilationUnit iCompilationUnit) {
            return textPaster.openCu(iCompilationUnit);
        }

        private static class ParsedCu {
            private final String fText;
            private final String fTypeName;
            private final String fPackageName;

            public static ParsedCu[] parse(IJavaProject javaProject, String text) {
                IScanner scanner = ToolFactory.createScanner((boolean)false, (boolean)false, (boolean)false, (boolean)false);
                scanner.setSource(text.toCharArray());
                ArrayList<ParsedCu> cus = new ArrayList<ParsedCu>();
                int start = 0;
                boolean tokensScanned = false;
                while (true) {
                    int tok;
                    try {
                        tok = scanner.getNextToken();
                    }
                    catch (InvalidInputException invalidInputException) {
                        tok = 158;
                    }
                    if (tok == 214 && tokensScanned) {
                        int packageStart = scanner.getCurrentTokenStartPosition();
                        ParsedCu cu = ParsedCu.parseCu(javaProject, text.substring(start, packageStart));
                        if (cu != null) {
                            cus.add(cu);
                            start = packageStart;
                        }
                    } else if (tok == 158) {
                        ParsedCu cu = ParsedCu.parseCu(javaProject, text.substring(start, text.length()));
                        if (cu == null) break;
                        cus.add(cu);
                        break;
                    }
                    tokensScanned = true;
                }
                return cus.toArray(new ParsedCu[cus.size()]);
            }

            private static ParsedCu parseCu(IJavaProject javaProject, String text) {
                String packageName = "";
                ASTParser parser = ASTParser.newParser((int)3);
                parser.setProject(javaProject);
                parser.setSource(text.toCharArray());
                parser.setStatementsRecovery(true);
                CompilationUnit unit = (CompilationUnit)parser.createAST(null);
                if (unit == null) {
                    return null;
                }
                int typesCount = unit.types().size();
                String typeName = null;
                if (typesCount > 0) {
                    int maxVisibility = 2;
                    ListIterator iter = unit.types().listIterator(typesCount);
                    while (iter.hasPrevious()) {
                        AbstractTypeDeclaration type = (AbstractTypeDeclaration)iter.previous();
                        int visibility = JdtFlags.getVisibilityCode((BodyDeclaration)type);
                        if (JdtFlags.isHigherVisibility(maxVisibility, visibility)) continue;
                        maxVisibility = visibility;
                        typeName = type.getName().getIdentifier();
                    }
                }
                if (typeName == null) {
                    return null;
                }
                PackageDeclaration pack = unit.getPackage();
                if (pack != null) {
                    packageName = pack.getName().getFullyQualifiedName();
                }
                return new ParsedCu(text, typeName, packageName);
            }

            private ParsedCu(String text, String typeName, String packageName) {
                this.fText = text;
                this.fTypeName = typeName;
                this.fPackageName = packageName;
            }

            public String getTypeName() {
                return this.fTypeName;
            }

            public String getPackageName() {
                return this.fPackageName;
            }

            public String getText() {
                return this.fText;
            }
        }
    }

    private static class TypedSourcePaster
    extends Paster {
        private TransferData[] fAvailableTypes;

        protected TypedSourcePaster(Shell shell, Clipboard clipboard) {
            super(shell, clipboard);
        }

        public boolean canEnable(TransferData[] availableTypes) throws JavaModelException {
            this.fAvailableTypes = availableTypes;
            return PasteAction.isAvailable((Transfer)TypedSourceTransfer.getInstance(), availableTypes);
        }

        public boolean canPasteOn(IJavaElement[] selectedJavaElements, IResource[] selectedResources, IWorkingSet[] selectedWorkingSets) throws JavaModelException {
            if (selectedResources.length != 0 || selectedWorkingSets.length != 0) {
                return false;
            }
            TypedSource[] typedSources = this.getClipboardTypedSources(this.fAvailableTypes);
            IJavaElement destination = TypedSourcePaster.getTarget(selectedJavaElements, selectedResources);
            if (destination instanceof IJavaElement) {
                return ReorgTypedSourcePasteStarter.create(typedSources, destination) != null;
            }
            return false;
        }

        public void paste(IJavaElement[] selectedJavaElements, IResource[] selectedResources, IWorkingSet[] selectedWorkingSets, TransferData[] availableTypes) throws JavaModelException, InterruptedException, InvocationTargetException {
            TypedSource[] typedSources = this.getClipboardTypedSources(availableTypes);
            IJavaElement destination = TypedSourcePaster.getTarget(selectedJavaElements, selectedResources);
            ReorgTypedSourcePasteStarter.create(typedSources, destination).run(this.getShell());
        }

        private static IJavaElement getTarget(IJavaElement[] selectedJavaElements, IResource[] selectedResources) {
            Assert.isTrue((selectedResources.length == 0 ? 1 : 0) != 0);
            if (selectedJavaElements.length == 1) {
                return TypedSourcePaster.getAsTypeOrCu(selectedJavaElements[0]);
            }
            Object parent = new ParentChecker(selectedResources, selectedJavaElements).getCommonParent();
            if (parent instanceof IJavaElement) {
                return TypedSourcePaster.getAsTypeOrCu((IJavaElement)parent);
            }
            return null;
        }

        private static IJavaElement getAsTypeOrCu(IJavaElement element) {
            if (element.getElementType() == 5 || element.getElementType() == 7) {
                return element;
            }
            IJavaElement ancestorType = element.getAncestor(7);
            if (ancestorType != null) {
                return ancestorType;
            }
            return ReorgUtils.getCompilationUnit(element);
        }

        private static class PasteTypedSourcesRefactoring
        extends Refactoring {
            private final TypedSource[] fSources;
            private IJavaElement fDestination;

            static PasteTypedSourcesRefactoring create(TypedSource[] sources) {
                if (!PasteTypedSourcesRefactoring.isAvailable(sources)) {
                    return null;
                }
                return new PasteTypedSourcesRefactoring(sources);
            }

            public RefactoringStatus setDestination(IJavaElement destination) {
                this.fDestination = destination;
                if (ReorgUtils.getCompilationUnit(destination) == null) {
                    return RefactoringStatus.createFatalErrorStatus((String)ReorgMessages.PasteAction_wrong_destination);
                }
                if (!destination.exists()) {
                    return RefactoringStatus.createFatalErrorStatus((String)ReorgMessages.PasteAction_element_doesnot_exist);
                }
                if (!this.canPasteAll(destination)) {
                    return RefactoringStatus.createFatalErrorStatus((String)ReorgMessages.PasteAction_invalid_destination);
                }
                return new RefactoringStatus();
            }

            private boolean canPasteAll(IJavaElement destination) {
                int i = 0;
                while (i < this.fSources.length) {
                    if (!PasteTypedSourcesRefactoring.canPaste(this.fSources[i].getType(), destination)) {
                        return false;
                    }
                    ++i;
                }
                return true;
            }

            private static boolean canPaste(int elementType, IJavaElement destination) {
                IType ancestorType = PasteTypedSourcesRefactoring.getAncestorType(destination);
                if (ancestorType != null) {
                    return PasteTypedSourcesRefactoring.canPasteToType(elementType);
                }
                return PasteTypedSourcesRefactoring.canPasteToCu(elementType);
            }

            private static boolean canPasteToType(int elementType) {
                return elementType == 7 || elementType == 8 || elementType == 10 || elementType == 9;
            }

            private static boolean canPasteToCu(int elementType) {
                return elementType == 11 || elementType == 7 || elementType == 13;
            }

            PasteTypedSourcesRefactoring(TypedSource[] sources) {
                Assert.isNotNull((Object)sources);
                Assert.isTrue((sources.length != 0 ? 1 : 0) != 0);
                this.fSources = sources;
            }

            private static boolean isAvailable(TypedSource[] sources) {
                return sources != null && sources.length > 0;
            }

            public RefactoringStatus checkInitialConditions(IProgressMonitor pm) throws CoreException {
                return new RefactoringStatus();
            }

            public RefactoringStatus checkFinalConditions(IProgressMonitor pm) throws CoreException {
                RefactoringStatus result = Checks.validateModifiesFiles(ResourceUtil.getFiles(new ICompilationUnit[]{this.getDestinationCu()}), this.getValidationContext());
                return result;
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public Change createChange(IProgressMonitor pm) throws CoreException {
                ASTParser p = ASTParser.newParser((int)3);
                p.setSource(this.getDestinationCu());
                CompilationUnit cuNode = (CompilationUnit)p.createAST(pm);
                ASTRewrite rewrite = ASTRewrite.create((AST)cuNode.getAST());
                TypedSource source = null;
                int i = this.fSources.length - 1;
                while (i >= 0) {
                    source = this.fSources[i];
                    ASTNode destination = this.getDestinationNodeForSourceElement(this.fDestination, source.getType(), cuNode);
                    if (destination != null) {
                        if (destination instanceof CompilationUnit) {
                            PasteTypedSourcesRefactoring.insertToCu(rewrite, this.createNewNodeToInsertToCu(source, rewrite), (CompilationUnit)destination);
                        } else if (destination instanceof AbstractTypeDeclaration) {
                            PasteTypedSourcesRefactoring.insertToType(rewrite, this.createNewNodeToInsertToType(source, rewrite), (AbstractTypeDeclaration)destination);
                        }
                    }
                    --i;
                }
                CompilationUnitChange result = new CompilationUnitChange(ReorgMessages.PasteAction_change_name, this.getDestinationCu());
                try {
                    ITextFileBuffer buffer = RefactoringFileBuffers.acquire(this.getDestinationCu());
                    TextEdit rootEdit = rewrite.rewriteAST(buffer.getDocument(), this.fDestination.getJavaProject().getOptions(true));
                    if (this.getDestinationCu().isWorkingCopy()) {
                        result.setSaveMode(4);
                    }
                    TextChangeCompatibility.addTextEdit((TextChange)result, ReorgMessages.PasteAction_edit_name, rootEdit);
                    Object var9_12 = null;
                }
                catch (Throwable throwable) {
                    Object var9_11 = null;
                    RefactoringFileBuffers.release(this.getDestinationCu());
                    throw throwable;
                }
                RefactoringFileBuffers.release(this.getDestinationCu());
                return result;
            }

            private static void insertToType(ASTRewrite rewrite, ASTNode node, AbstractTypeDeclaration typeDeclaration) {
                switch (node.getNodeType()) {
                    case 23: 
                    case 28: 
                    case 31: 
                    case 55: 
                    case 71: 
                    case 81: {
                        rewrite.getListRewrite((ASTNode)typeDeclaration, typeDeclaration.getBodyDeclarationsProperty()).insertAt(node, ASTNodes.getInsertionIndex((BodyDeclaration)node, typeDeclaration.bodyDeclarations()), null);
                        break;
                    }
                    default: {
                        Assert.isTrue((boolean)false, (String)String.valueOf(node.getNodeType()));
                    }
                }
            }

            private static void insertToCu(ASTRewrite rewrite, ASTNode node, CompilationUnit cuNode) {
                switch (node.getNodeType()) {
                    case 55: 
                    case 71: 
                    case 81: {
                        rewrite.getListRewrite((ASTNode)cuNode, CompilationUnit.TYPES_PROPERTY).insertAt(node, ASTNodes.getInsertionIndex((BodyDeclaration)((AbstractTypeDeclaration)node), cuNode.types()), null);
                        break;
                    }
                    case 26: {
                        rewrite.getListRewrite((ASTNode)cuNode, CompilationUnit.IMPORTS_PROPERTY).insertLast(node, null);
                        break;
                    }
                    case 35: {
                        if (cuNode.getPackage() != null) break;
                        rewrite.set((ASTNode)cuNode, (StructuralPropertyDescriptor)CompilationUnit.PACKAGE_PROPERTY, (Object)node, null);
                        break;
                    }
                    default: {
                        Assert.isTrue((boolean)false, (String)String.valueOf(node.getNodeType()));
                    }
                }
            }

            private ASTNode getDestinationNodeForSourceElement(IJavaElement destination, int kind, CompilationUnit unit) throws JavaModelException {
                IType ancestor = PasteTypedSourcesRefactoring.getAncestorType(destination);
                if (ancestor != null) {
                    return ASTNodeSearchUtil.getAbstractTypeDeclarationNode(ancestor, unit);
                }
                if (kind == 7 || kind == 11 || kind == 13 || kind == 12) {
                    return unit;
                }
                return null;
            }

            private static IType getAncestorType(IJavaElement destinationElement) {
                return destinationElement.getElementType() == 7 ? (IType)destinationElement : (IType)destinationElement.getAncestor(7);
            }

            private ASTNode createNewNodeToInsertToCu(TypedSource source, ASTRewrite rewrite) {
                switch (source.getType()) {
                    case 7: {
                        return rewrite.createStringPlaceholder(source.getSource(), 55);
                    }
                    case 11: {
                        return rewrite.createStringPlaceholder(source.getSource(), 35);
                    }
                    case 13: {
                        return rewrite.createStringPlaceholder(source.getSource(), 26);
                    }
                }
                Assert.isTrue((boolean)false, (String)String.valueOf(source.getType()));
                return null;
            }

            private ASTNode createNewNodeToInsertToType(TypedSource source, ASTRewrite rewrite) {
                switch (source.getType()) {
                    case 7: {
                        return rewrite.createStringPlaceholder(source.getSource(), 55);
                    }
                    case 9: {
                        return rewrite.createStringPlaceholder(source.getSource(), 31);
                    }
                    case 8: {
                        return rewrite.createStringPlaceholder(source.getSource(), 23);
                    }
                    case 10: {
                        return rewrite.createStringPlaceholder(source.getSource(), 28);
                    }
                }
                Assert.isTrue((boolean)false);
                return null;
            }

            private ICompilationUnit getDestinationCu() {
                return ReorgUtils.getCompilationUnit(this.fDestination);
            }

            public String getName() {
                return ReorgMessages.PasteAction_name;
            }
        }

        private static class ReorgTypedSourcePasteStarter {
            private final PasteTypedSourcesRefactoring fPasteRefactoring;

            private ReorgTypedSourcePasteStarter(PasteTypedSourcesRefactoring pasteRefactoring) {
                Assert.isNotNull((Object)((Object)pasteRefactoring));
                this.fPasteRefactoring = pasteRefactoring;
            }

            public static ReorgTypedSourcePasteStarter create(TypedSource[] typedSources, IJavaElement destination) {
                Assert.isNotNull((Object)typedSources);
                Assert.isNotNull((Object)destination);
                PasteTypedSourcesRefactoring pasteRefactoring = PasteTypedSourcesRefactoring.create(typedSources);
                if (pasteRefactoring == null) {
                    return null;
                }
                if (!pasteRefactoring.setDestination(destination).isOK()) {
                    return null;
                }
                return new ReorgTypedSourcePasteStarter(pasteRefactoring);
            }

            public void run(Shell parent) throws InterruptedException, InvocationTargetException {
                ProgressMonitorDialog context = new ProgressMonitorDialog(parent);
                new RefactoringExecutionHelper(this.fPasteRefactoring, RefactoringCore.getConditionCheckingFailedSeverity(), 5, parent, (IRunnableContext)context).perform(false, false);
            }
        }
    }

    private static class WorkingSetPaster
    extends Paster {
        protected WorkingSetPaster(Shell shell, Clipboard clipboard) {
            super(shell, clipboard);
        }

        public void paste(IJavaElement[] selectedJavaElements, IResource[] selectedResources, IWorkingSet[] selectedWorkingSets, TransferData[] availableTypes) throws JavaModelException, InterruptedException, InvocationTargetException {
            Object[] resources;
            IWorkingSet workingSet = selectedWorkingSets[0];
            HashSet<IAdaptable> elements = new HashSet<IAdaptable>(Arrays.asList(workingSet.getElements()));
            IJavaElement[] javaElements = this.getClipboardJavaElements(availableTypes);
            if (javaElements != null) {
                int i = 0;
                while (i < javaElements.length) {
                    if (!ReorgUtils.containsElementOrParent(elements, javaElements[i])) {
                        elements.add((IAdaptable)javaElements[i]);
                    }
                    ++i;
                }
            }
            if ((resources = this.getClipboardResources(availableTypes)) != null) {
                IJavaElement element;
                ArrayList realJavaElements = new ArrayList();
                ArrayList realResource = new ArrayList();
                ReorgUtils.splitIntoJavaElementsAndResources(resources, realJavaElements, realResource);
                Iterator iter = realJavaElements.iterator();
                while (iter.hasNext()) {
                    element = (IJavaElement)iter.next();
                    if (ReorgUtils.containsElementOrParent(elements, element)) continue;
                    elements.add((IAdaptable)element);
                }
                iter = realResource.iterator();
                while (iter.hasNext()) {
                    element = (IResource)iter.next();
                    if (ReorgUtils.containsElementOrParent(elements, (IResource)element)) continue;
                    elements.add((IAdaptable)element);
                }
            }
            workingSet.setElements(elements.toArray(new IAdaptable[elements.size()]));
        }

        public boolean canEnable(TransferData[] availableTypes) throws JavaModelException {
            return PasteAction.isAvailable((Transfer)ResourceTransfer.getInstance(), availableTypes) || PasteAction.isAvailable((Transfer)JavaElementTransfer.getInstance(), availableTypes);
        }

        public boolean canPasteOn(IJavaElement[] selectedJavaElements, IResource[] selectedResources, IWorkingSet[] selectedWorkingSets) throws JavaModelException {
            if (selectedResources.length != 0 || selectedJavaElements.length != 0 || selectedWorkingSets.length != 1) {
                return false;
            }
            IWorkingSet ws = selectedWorkingSets[0];
            return !"org.eclipse.wst.jsdt.internal.ui.OthersWorkingSet".equals(ws.getId());
        }
    }
}

