/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.search;

import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.search.ui.ISearchQuery;
import org.eclipse.search.ui.NewSearchUI;
import org.eclipse.wst.jsdt.core.IClassFile;
import org.eclipse.wst.jsdt.core.ICompilationUnit;
import org.eclipse.wst.jsdt.core.IJavaElement;
import org.eclipse.wst.jsdt.core.ISourceReference;
import org.eclipse.wst.jsdt.core.JavaModelException;
import org.eclipse.wst.jsdt.core.dom.CompilationUnit;
import org.eclipse.wst.jsdt.internal.ui.JavaPlugin;
import org.eclipse.wst.jsdt.internal.ui.javaeditor.ASTProvider;
import org.eclipse.wst.jsdt.internal.ui.search.IOccurrencesFinder;
import org.eclipse.wst.jsdt.internal.ui.search.OccurrencesSearchQuery;
import org.eclipse.wst.jsdt.internal.ui.search.SearchMessages;

public abstract class FindOccurrencesEngine {
    private IOccurrencesFinder fFinder;

    protected FindOccurrencesEngine(IOccurrencesFinder finder) {
        this.fFinder = finder;
    }

    public static FindOccurrencesEngine create(IJavaElement root, IOccurrencesFinder finder) {
        if (root == null || finder == null) {
            return null;
        }
        ICompilationUnit unit = (ICompilationUnit)root.getAncestor(5);
        if (unit != null) {
            return new FindOccurencesCUEngine(unit, finder);
        }
        IClassFile cf = (IClassFile)root.getAncestor(6);
        if (cf != null) {
            return new FindOccurencesClassFileEngine(cf, finder);
        }
        return null;
    }

    protected abstract CompilationUnit createAST();

    protected abstract IJavaElement getInput();

    protected abstract ISourceReference getSourceReference();

    protected IOccurrencesFinder getOccurrencesFinder() {
        return this.fFinder;
    }

    public String run(int offset, int length) throws JavaModelException {
        ISourceReference sr = this.getSourceReference();
        if (sr.getSourceRange() == null) {
            return SearchMessages.FindOccurrencesEngine_noSource_text;
        }
        CompilationUnit root = this.createAST();
        if (root == null) {
            return SearchMessages.FindOccurrencesEngine_cannotParse_text;
        }
        String message = this.fFinder.initialize(root, offset, length);
        if (message != null) {
            return message;
        }
        Document document = new Document(this.getSourceReference().getSource());
        this.performNewSearch(this.fFinder, (IDocument)document, this.getInput());
        return null;
    }

    private void performNewSearch(IOccurrencesFinder finder, IDocument document, IJavaElement element) {
        NewSearchUI.runQueryInBackground((ISearchQuery)new OccurrencesSearchQuery(finder, document, element));
    }

    private static class FindOccurencesCUEngine
    extends FindOccurrencesEngine {
        private ICompilationUnit fCUnit;

        public FindOccurencesCUEngine(ICompilationUnit unit, IOccurrencesFinder finder) {
            super(finder);
            this.fCUnit = unit;
        }

        protected CompilationUnit createAST() {
            return JavaPlugin.getDefault().getASTProvider().getAST((IJavaElement)this.fCUnit, ASTProvider.WAIT_YES, null);
        }

        protected IJavaElement getInput() {
            return this.fCUnit;
        }

        protected ISourceReference getSourceReference() {
            return this.fCUnit;
        }
    }

    private static class FindOccurencesClassFileEngine
    extends FindOccurrencesEngine {
        private IClassFile fClassFile;

        public FindOccurencesClassFileEngine(IClassFile file, IOccurrencesFinder finder) {
            super(finder);
            this.fClassFile = file;
        }

        protected CompilationUnit createAST() {
            return JavaPlugin.getDefault().getASTProvider().getAST((IJavaElement)this.fClassFile, ASTProvider.WAIT_YES, null);
        }

        protected IJavaElement getInput() {
            return this.fClassFile;
        }

        protected ISourceReference getSourceReference() {
            return this.fClassFile;
        }
    }
}

